/*
 * Decompiled with CFR 0.152.
 */
package zio.test.diff;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import zio.internal.ansi;
import zio.internal.ansi$;
import zio.test.ConsoleUtils$;
import zio.test.PrettyPrint$;
import zio.test.diff.DiffResult$;
import zio.test.diff.DiffResult$Added$;
import zio.test.diff.DiffResult$Different$;
import zio.test.diff.DiffResult$Identical$;
import zio.test.diff.DiffResult$Nested$;
import zio.test.diff.DiffResult$Removed$;

public interface DiffResult {
    public static String indent(String string, int n) {
        return DiffResult$.MODULE$.indent(string, n);
    }

    public static int ordinal(DiffResult diffResult) {
        return DiffResult$.MODULE$.ordinal(diffResult);
    }

    public static int indent$default$2() {
        return DiffResult$.MODULE$.indent$default$2();
    }

    public static boolean noDiff$(DiffResult $this) {
        return $this.noDiff();
    }

    default public boolean noDiff() {
        return !this.hasDiff();
    }

    public static boolean hasDiff$(DiffResult $this) {
        return $this.hasDiff();
    }

    default public boolean hasDiff() {
        boolean bl;
        DiffResult diffResult = this;
        if (diffResult instanceof Nested) {
            List<Tuple2<Option<String>, DiffResult>> list;
            Nested nested = DiffResult$Nested$.MODULE$.unapply((Nested)diffResult);
            String string = nested._1();
            List<Tuple2<Option<String>, DiffResult>> fields = list = nested._2();
            bl = fields.exists((Function1 & Serializable)_$1 -> ((DiffResult)_$1._2()).hasDiff());
        } else if (diffResult instanceof Different) {
            Different different = DiffResult$Different$.MODULE$.unapply((Different)diffResult);
            Object object = different._1();
            Object object2 = different._2();
            Option<String> option = different._3();
            bl = true;
        } else if (diffResult instanceof Removed) {
            Removed removed = DiffResult$Removed$.MODULE$.unapply((Removed)diffResult);
            Object object = removed._1();
            bl = true;
        } else if (diffResult instanceof Added) {
            Added added = DiffResult$Added$.MODULE$.unapply((Added)diffResult);
            Object object = added._1();
            bl = true;
        } else if (diffResult instanceof Identical) {
            Identical identical = DiffResult$Identical$.MODULE$.unapply((Identical)diffResult);
            Object object = identical._1();
            bl = false;
        } else {
            throw new MatchError((Object)diffResult);
        }
        return bl;
    }

    public static String render$(DiffResult $this) {
        return $this.render();
    }

    /*
     * Enabled aggressive block sorting
     */
    default public String render() {
        Object object;
        String string;
        DiffResult diffResult = this;
        if (diffResult instanceof Nested) {
            Nested nested = DiffResult$Nested$.MODULE$.unapply((Nested)diffResult);
            String string2 = nested._1();
            List<Tuple2<Option<String>, DiffResult>> list = nested._2();
            String label = string2;
            List<Tuple2<Option<String>, DiffResult>> fields = list;
            string = new StringBuilder(17).append("\n").append(label).append("(\n  ").append(DiffResult$.MODULE$.indent(fields.filter((Function1 & Serializable)_$2 -> ((DiffResult)_$2._2()).hasDiff()).map((Function1 & Serializable)x$1 -> {
                String string;
                String string2;
                String string3;
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                Option option = (Option)tuple2._1();
                DiffResult diffResult = (DiffResult)tuple2._2();
                if (!(option instanceof Some)) {
                    if (!None$.MODULE$.equals(option)) throw new MatchError((Object)tuple2);
                    DiffResult diff = diffResult;
                    string3 = diff.render();
                    return string3;
                }
                String label = string2 = (String)((Some)option).value();
                if (diffResult instanceof Different) {
                    Different different = DiffResult$Different$.MODULE$.unapply((Different)diffResult);
                    Object object = different._1();
                    Object object2 = different._2();
                    Option<String> option2 = different._3();
                    if (option2 instanceof Some) {
                        String custom = (String)((Some)option2).value();
                        string3 = new StringBuilder(0).append(ConsoleUtils$.MODULE$.dim(new StringBuilder(3).append(label).append(" = ").toString())).append(DiffResult$.MODULE$.indent(custom, label.length() + 3)).toString();
                        return string3;
                    }
                }
                String label2 = string2;
                DiffResult diff = diffResult;
                DiffResult diffResult2 = diff;
                if (diffResult2 instanceof Removed) {
                    Removed removed = DiffResult$Removed$.MODULE$.unapply((Removed)diffResult2);
                    Object object = removed._1();
                    string = "\u001b[31m";
                } else if (diffResult2 instanceof Added) {
                    Added added = DiffResult$Added$.MODULE$.unapply((Added)diffResult2);
                    Object object = added._1();
                    string = "\u001b[32m";
                } else {
                    string = "";
                }
                String color = string;
                string3 = new StringBuilder(0).append(ConsoleUtils$.MODULE$.dim(new StringBuilder(3).append(color).append(label2).append(" = ").toString())).append(diff.render()).toString();
                return string3;
            }).mkString(",\n"), DiffResult$.MODULE$.indent$default$2())).append("\n)\n         ").toString().trim();
            return string;
        }
        if (diffResult instanceof Different) {
            Different different = DiffResult$Different$.MODULE$.unapply((Different)diffResult);
            Object object2 = different._1();
            Object object3 = different._2();
            Option<String> option = different._3();
            if (option instanceof Some) {
                String custom;
                string = custom = (String)((Some)option).value();
                return string;
            }
            Object oldValue = object2;
            Object newValue = object3;
            if (None$.MODULE$.equals(option)) {
                string = new StringBuilder(3).append(ansi.AnsiStringOps$.MODULE$.red$extension(ansi$.MODULE$.AnsiStringOps(PrettyPrint$.MODULE$.apply(oldValue)))).append(" \u2192 ").append(ansi.AnsiStringOps$.MODULE$.green$extension(ansi$.MODULE$.AnsiStringOps(PrettyPrint$.MODULE$.apply(newValue)))).toString();
                return string;
            }
        }
        if (diffResult instanceof Removed) {
            Object object4;
            Removed removed = DiffResult$Removed$.MODULE$.unapply((Removed)diffResult);
            Object oldValue = object4 = removed._1();
            string = ansi.AnsiStringOps$.MODULE$.red$extension(ansi$.MODULE$.AnsiStringOps(PrettyPrint$.MODULE$.apply(oldValue)));
            return string;
        }
        if (diffResult instanceof Added) {
            Object object5;
            Added added = DiffResult$Added$.MODULE$.unapply((Added)diffResult);
            Object newValue = object5 = added._1();
            string = ansi.AnsiStringOps$.MODULE$.green$extension(ansi$.MODULE$.AnsiStringOps(PrettyPrint$.MODULE$.apply(newValue)));
            return string;
        }
        if (!(diffResult instanceof Identical)) throw new MatchError((Object)diffResult);
        Identical identical = DiffResult$Identical$.MODULE$.unapply((Identical)diffResult);
        Object value = object = identical._1();
        string = PrettyPrint$.MODULE$.apply(value);
        return string;
    }

    public static class Added
    implements DiffResult,
    Product,
    Serializable {
        private final Object newValue;

        public static Added apply(Object object) {
            return DiffResult$Added$.MODULE$.apply(object);
        }

        public static Added fromProduct(Product product) {
            return DiffResult$Added$.MODULE$.fromProduct(product);
        }

        public static Added unapply(Added added) {
            return DiffResult$Added$.MODULE$.unapply(added);
        }

        public Added(Object newValue) {
            this.newValue = newValue;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Added)) return false;
            Added added = (Added)object;
            if (!BoxesRunTime.equals((Object)this.newValue(), (Object)added.newValue())) return false;
            if (!added.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Added;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Added";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "newValue";
        }

        public Object newValue() {
            return this.newValue;
        }

        public Added copy(Object newValue) {
            return new Added(newValue);
        }

        public Object copy$default$1() {
            return this.newValue();
        }

        public Object _1() {
            return this.newValue();
        }
    }

    public static class Different
    implements DiffResult,
    Product,
    Serializable {
        private final Object oldValue;
        private final Object newValue;
        private final Option customRender;

        public static Different apply(Object object, Object object2, Option<String> option) {
            return DiffResult$Different$.MODULE$.apply(object, object2, option);
        }

        public static Different fromProduct(Product product) {
            return DiffResult$Different$.MODULE$.fromProduct(product);
        }

        public static Different unapply(Different different) {
            return DiffResult$Different$.MODULE$.unapply(different);
        }

        public static Option<String> $lessinit$greater$default$3() {
            return DiffResult$Different$.MODULE$.$lessinit$greater$default$3();
        }

        public Different(Object oldValue, Object newValue, Option<String> customRender) {
            this.oldValue = oldValue;
            this.newValue = newValue;
            this.customRender = customRender;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Different)) return false;
            Different different = (Different)object;
            if (!BoxesRunTime.equals((Object)this.oldValue(), (Object)different.oldValue())) return false;
            if (!BoxesRunTime.equals((Object)this.newValue(), (Object)different.newValue())) return false;
            Option<String> option = this.customRender();
            Option<String> option2 = different.customRender();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!different.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Different;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Different";
        }

        public Object productElement(int n) {
            Option<String> option;
            int n2 = n;
            switch (n2) {
                case 0: {
                    option = this._1();
                    break;
                }
                case 1: {
                    option = this._2();
                    break;
                }
                case 2: {
                    option = this._3();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return option;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "oldValue";
                    break;
                }
                case 1: {
                    string = "newValue";
                    break;
                }
                case 2: {
                    string = "customRender";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public Object oldValue() {
            return this.oldValue;
        }

        public Object newValue() {
            return this.newValue;
        }

        public Option<String> customRender() {
            return this.customRender;
        }

        public Different copy(Object oldValue, Object newValue, Option<String> customRender) {
            return new Different(oldValue, newValue, customRender);
        }

        public Object copy$default$1() {
            return this.oldValue();
        }

        public Object copy$default$2() {
            return this.newValue();
        }

        public Option<String> copy$default$3() {
            return this.customRender();
        }

        public Object _1() {
            return this.oldValue();
        }

        public Object _2() {
            return this.newValue();
        }

        public Option<String> _3() {
            return this.customRender();
        }
    }

    public static class Identical
    implements DiffResult,
    Product,
    Serializable {
        private final Object value;

        public static Identical apply(Object object) {
            return DiffResult$Identical$.MODULE$.apply(object);
        }

        public static Identical fromProduct(Product product) {
            return DiffResult$Identical$.MODULE$.fromProduct(product);
        }

        public static Identical unapply(Identical identical) {
            return DiffResult$Identical$.MODULE$.unapply(identical);
        }

        public Identical(Object value) {
            this.value = value;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Identical)) return false;
            Identical identical = (Identical)object;
            if (!BoxesRunTime.equals((Object)this.value(), (Object)identical.value())) return false;
            if (!identical.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Identical;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Identical";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "value";
        }

        public Object value() {
            return this.value;
        }

        public Identical copy(Object value) {
            return new Identical(value);
        }

        public Object copy$default$1() {
            return this.value();
        }

        public Object _1() {
            return this.value();
        }
    }

    public static class Nested
    implements DiffResult,
    Product,
    Serializable {
        private final String label;
        private final List fields;

        public static Nested apply(String string, List<Tuple2<Option<String>, DiffResult>> list) {
            return DiffResult$Nested$.MODULE$.apply(string, list);
        }

        public static Nested fromProduct(Product product) {
            return DiffResult$Nested$.MODULE$.fromProduct(product);
        }

        public static Nested unapply(Nested nested) {
            return DiffResult$Nested$.MODULE$.unapply(nested);
        }

        public Nested(String label, List<Tuple2<Option<String>, DiffResult>> fields) {
            this.label = label;
            this.fields = fields;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Nested)) return false;
            Nested nested = (Nested)object;
            String string = this.label();
            String string2 = nested.label();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            List<Tuple2<Option<String>, DiffResult>> list = this.fields();
            List<Tuple2<Option<String>, DiffResult>> list2 = nested.fields();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            if (!nested.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Nested;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Nested";
        }

        public Object productElement(int n) {
            List<Tuple2<Option<String>, DiffResult>> list;
            int n2 = n;
            if (0 == n2) {
                list = this._1();
            } else if (1 == n2) {
                list = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return list;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "label";
            } else if (1 == n2) {
                string = "fields";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public String label() {
            return this.label;
        }

        public List<Tuple2<Option<String>, DiffResult>> fields() {
            return this.fields;
        }

        public Nested copy(String label, List<Tuple2<Option<String>, DiffResult>> fields) {
            return new Nested(label, fields);
        }

        public String copy$default$1() {
            return this.label();
        }

        public List<Tuple2<Option<String>, DiffResult>> copy$default$2() {
            return this.fields();
        }

        public String _1() {
            return this.label();
        }

        public List<Tuple2<Option<String>, DiffResult>> _2() {
            return this.fields();
        }
    }

    public static class Removed
    implements DiffResult,
    Product,
    Serializable {
        private final Object oldValue;

        public static Removed apply(Object object) {
            return DiffResult$Removed$.MODULE$.apply(object);
        }

        public static Removed fromProduct(Product product) {
            return DiffResult$Removed$.MODULE$.fromProduct(product);
        }

        public static Removed unapply(Removed removed) {
            return DiffResult$Removed$.MODULE$.unapply(removed);
        }

        public Removed(Object oldValue) {
            this.oldValue = oldValue;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Removed)) return false;
            Removed removed = (Removed)object;
            if (!BoxesRunTime.equals((Object)this.oldValue(), (Object)removed.oldValue())) return false;
            if (!removed.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Removed;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Removed";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "oldValue";
        }

        public Object oldValue() {
            return this.oldValue;
        }

        public Removed copy(Object oldValue) {
            return new Removed(oldValue);
        }

        public Object copy$default$1() {
            return this.oldValue();
        }

        public Object _1() {
            return this.oldValue();
        }
    }
}

