/*
 * Decompiled with CFR 0.152.
 */
package zio.test;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.deriving.Mirror;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Try;
import zio.Cause;
import zio.Exit;
import zio.FiberId;
import zio.StackTrace;
import zio.ZIO;
import zio.internal.ansi;
import zio.internal.ansi$;
import zio.internal.stacktracer.SourceLocation;
import zio.test.Assertion;
import zio.test.AssertionVariants;
import zio.test.ErrorMessage$;
import zio.test.PrettyPrint$;
import zio.test.TestArrow;
import zio.test.TestArrow$;
import zio.test.TestResult;
import zio.test.TestResult$;
import zio.test.TestTrace;
import zio.test.TestTrace$;
import zio.test.internal.SmartAssertions$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Assertion$
implements AssertionVariants,
Mirror.Product,
Serializable {
    private static final Assertion anything;
    private static final Assertion isRight;
    private static final Assertion isLeft;
    private static final Assertion isSome;
    private static final Assertion isFailure;
    private static final Assertion isSuccess;
    private static final Assertion isNone;
    private static final Assertion isNonEmpty;
    private static final Assertion isUnit;
    private static final Assertion isEmpty;
    private static final Assertion isEmptyString;
    private static final Assertion isDistinct;
    private static final Assertion isNonEmptyString;
    private static final Assertion isNull;
    private static final Assertion nothing;
    public static final Assertion$ MODULE$;

    private Assertion$() {
    }

    static {
        MODULE$ = new Assertion$();
        anything = MODULE$.apply(SmartAssertions$.MODULE$.anything().withCode("anything"));
        isRight = MODULE$.isRight(MODULE$.anything());
        isLeft = MODULE$.isLeft(MODULE$.anything());
        isSome = MODULE$.isSome(MODULE$.anything());
        isFailure = MODULE$.isFailure(MODULE$.anything());
        isSuccess = MODULE$.isSuccess(MODULE$.anything());
        isNone = MODULE$.apply(SmartAssertions$.MODULE$.isEmptyOption().withCode("isNone"));
        isNonEmpty = MODULE$.apply(SmartAssertions$.MODULE$.isNonEmptyIterable().withCode("isNonEmpty"));
        isUnit = MODULE$.apply(TestArrow$.MODULE$.make((Function1 & Serializable)value -> TestTrace$.MODULE$.boolean(true, ErrorMessage$.MODULE$.value(value).$plus(ErrorMessage$.MODULE$.was()).$plus(ErrorMessage$.MODULE$.value("unit")))).withCode("isUnit"));
        isEmpty = MODULE$.apply(SmartAssertions$.MODULE$.isEmptyIterable().withCode("isEmpty"));
        isEmptyString = MODULE$.apply(SmartAssertions$.MODULE$.isEmptyString().withCode("isEmptyString"));
        isDistinct = MODULE$.apply(TestArrow$.MODULE$.make((Function1 & Serializable)as -> TestTrace$.MODULE$.boolean(this.loop$1(as.iterator(), Predef$.MODULE$.Set().empty()), ErrorMessage$.MODULE$.pretty(as).$plus(ErrorMessage$.MODULE$.was()).$plus("distinct"))).withCode("isDistinct"));
        isNonEmptyString = MODULE$.apply(SmartAssertions$.MODULE$.isNonEmptyString().withCode("isNonEmptyString"));
        isNull = MODULE$.apply(TestArrow$.MODULE$.make((Function1 & Serializable)x -> TestTrace$.MODULE$.boolean(x == null, ErrorMessage$.MODULE$.pretty(x).$plus(ErrorMessage$.MODULE$.was()).$plus("null"))).withCode("isNull"));
        nothing = MODULE$.apply(TestArrow$.MODULE$.make((Function1 & Serializable)input -> TestTrace$.MODULE$.succeed(BoxesRunTime.boxToBoolean((boolean)false))).withCode("nothing"));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Assertion$.class);
    }

    public <A> Assertion<A> apply(TestArrow<A, Object> arrow) {
        return new Assertion<A>(arrow);
    }

    public <A> Assertion<A> unapply(Assertion<A> x$1) {
        return x$1;
    }

    public String toString() {
        return "Assertion";
    }

    public <A> TestResult smartAssert(Function0<A> expr, Option<String> codeString, Option<String> assertionString, Assertion<A> assertion, SourceLocation sourceLocation) {
        LazyRef lazyRef = new LazyRef();
        Option completeString = codeString.flatMap((Function1 & Serializable)code -> assertionString.map((Function1 & Serializable)assertion -> new StringBuilder(17).append(ansi.AnsiStringOps$.MODULE$.blue$extension(ansi$.MODULE$.AnsiStringOps(code))).append(" did not satisfy ").append(ansi.AnsiStringOps$.MODULE$.cyan$extension(ansi$.MODULE$.AnsiStringOps(assertion))).toString()));
        return TestResult$.MODULE$.apply(TestArrow$.MODULE$.succeed(() -> this.smartAssert$$anonfun$1(expr, lazyRef)).withCode((String)codeString.getOrElse(this::smartAssert$$anonfun$2)).$greater$greater$greater(assertion.arrow()).withLocation(sourceLocation).withCompleteCode((String)completeString.getOrElse(this::smartAssert$$anonfun$3)));
    }

    public <A> Option<String> smartAssert$default$2() {
        return None$.MODULE$;
    }

    public <A> Option<String> smartAssert$default$3() {
        return None$.MODULE$;
    }

    public <R, E, A> ZIO<R, E, TestResult> smartAssertZIO(Function0<ZIO<R, E, A>> expr, Assertion<A> assertion, Object trace, SourceLocation sourceLocation) {
        LazyRef lazyRef = new LazyRef();
        return this.value0$2(expr, lazyRef).map((Function1 & Serializable)_$1 -> this.smartAssert(() -> this.smartAssertZIO$$anonfun$1$$anonfun$1(_$1), this.smartAssert$default$2(), this.smartAssert$default$3(), assertion, sourceLocation), trace);
    }

    public <A> Assertion<A> assertion(String name, Function1<A, Object> run) {
        return this.apply(TestArrow$.MODULE$.make((Function1 & Serializable)a -> {
            boolean result = BoxesRunTime.unboxToBoolean((Object)run.apply(() -> this.$anonfun$2(a)));
            return TestTrace$.MODULE$.boolean(result, ErrorMessage$.MODULE$.text("Custom Assertion").$plus(ErrorMessage$.MODULE$.value(name)).$plus(ErrorMessage$.MODULE$.choice("succeeded", "failed")));
        }).withCode(name));
    }

    public <A, B> Assertion<A> assertionRec(String name, Assertion<B> assertion, Function1<A, Option<B>> get) {
        return this.apply(TestArrow$.MODULE$.make((Function1 & Serializable)a -> (TestTrace)((Option)get.apply(a)).fold(() -> this.assertionRec$$anonfun$1$$anonfun$1(name), (Function1 & Serializable)b -> TestTrace$.MODULE$.succeed(b))).withCode(name).$greater$greater$greater(assertion.arrow()));
    }

    public Assertion<Object> anything() {
        return anything;
    }

    public <A> Assertion<scala.collection.immutable.Seq<A>> hasAt(int pos, Assertion<A> assertion) {
        return this.apply(SmartAssertions$.MODULE$.hasAt(pos).withCode(new StringBuilder(7).append("hasAt(").append(pos).append(")").toString()).$greater$greater$greater(assertion.arrow()));
    }

    public <A> Assertion<A> approximatelyEquals(A reference, A tolerance, Numeric<A> evidence$1) {
        return this.apply(SmartAssertions$.MODULE$.approximatelyEquals(reference, tolerance, evidence$1).withCode(new StringBuilder(23).append("approximatelyEquals(").append(reference).append(", ").append(tolerance).append(")").toString()));
    }

    public <A> Assertion<Iterable<A>> contains(A element) {
        return this.apply(SmartAssertions$.MODULE$.containsIterable(element).withCode("contains"));
    }

    public <E> Assertion<Cause<E>> containsCause(Cause<E> cause) {
        return this.apply(SmartAssertions$.MODULE$.containsCause(cause).withCode("containsCause"));
    }

    public Assertion<String> containsString(String element) {
        return this.apply(SmartAssertions$.MODULE$.containsString(element).withCode(new StringBuilder(16).append("containsString(").append(PrettyPrint$.MODULE$.apply(element)).append(")").toString()));
    }

    public Assertion<Exit<Object, Object>> dies(Assertion<Throwable> assertion) {
        return this.apply(SmartAssertions$.MODULE$.asExitDie().withCode("dies").$greater$greater$greater(assertion.arrow()));
    }

    public <E> Assertion<Exit<Object, Object>> diesWithA(ClassTag<E> evidence$2) {
        return this.dies(this.isSubtype(this.anything(), evidence$2));
    }

    public <A> Assertion<scala.collection.immutable.Seq<A>> endsWith(scala.collection.immutable.Seq<A> suffix) {
        return this.apply(SmartAssertions$.MODULE$.endsWithSeq(suffix).withCode("endsWith"));
    }

    public Assertion<String> endsWithString(String suffix) {
        return this.apply(SmartAssertions$.MODULE$.endsWithString(suffix).withCode("endsWithString"));
    }

    public Assertion<String> equalsIgnoreCase(String other) {
        return this.apply(TestArrow$.MODULE$.make((Function1 & Serializable)string -> TestTrace$.MODULE$.boolean(string.equalsIgnoreCase(other), ErrorMessage$.MODULE$.pretty(string).$plus(ErrorMessage$.MODULE$.equals()).$plus(ErrorMessage$.MODULE$.pretty(other)).$plus("(ignoring case)"))).withCode("equalsIgnoreCase"));
    }

    public <A, B> Assertion<A> hasField(String name, Function1<A, B> proj, Assertion<B> assertion) {
        return this.apply(SmartAssertions$.MODULE$.hasField(name, proj).withCode("hasField").$greater$greater$greater(assertion.arrow()));
    }

    public <A> Assertion<Either<A, Object>> isLeft(Assertion<A> assertion) {
        return this.apply(SmartAssertions$.MODULE$.asLeft().withCode("isLeft").$greater$greater$greater(assertion.arrow()));
    }

    public <A> Assertion<Either<Object, A>> isRight(Assertion<A> assertion) {
        return this.apply(SmartAssertions$.MODULE$.asRight().withCode("isRight").$greater$greater$greater(assertion.arrow()));
    }

    public Assertion<Either<Object, Object>> isRight() {
        return isRight;
    }

    public Assertion<Either<Object, Object>> isLeft() {
        return isLeft;
    }

    public <A> Assertion<Option<A>> isSome(Assertion<A> assertion) {
        return this.apply(SmartAssertions$.MODULE$.isSome().withCode("isSome").$greater$greater$greater(assertion.arrow()));
    }

    public Assertion<Option<Object>> isSome() {
        return isSome;
    }

    public <A> Assertion<Iterable<A>> isSorted(Ordering<A> ord) {
        return this.apply(TestArrow$.MODULE$.make((Function1 & Serializable)iterable -> TestTrace$.MODULE$.boolean(this.loop$2(ord, iterable.iterator()), ErrorMessage$.MODULE$.pretty(iterable).$plus(ErrorMessage$.MODULE$.was()).$plus("sorted"))).withCode("isSorted"));
    }

    public <A> Assertion<Iterable<A>> isSortedReverse(Ordering<A> ord) {
        return this.isSorted(ord.reverse()).withCode("isSortedReverse");
    }

    public <A> Assertion<Object> isSubtype(Assertion<A> assertion, ClassTag<A> C) {
        return this.apply(SmartAssertions$.MODULE$.as(C).withCode("isSubtype").$greater$greater$greater(assertion.arrow()));
    }

    public Assertion<Object> isTrue() {
        return this.apply(TestArrow$.MODULE$.make((Function1 & Serializable)object -> this.isTrue$$anonfun$1(BoxesRunTime.unboxToBoolean((Object)object))).withCode("isTrue"));
    }

    public Assertion<Object> isFalse() {
        return this.apply(TestArrow$.MODULE$.make((Function1 & Serializable)object -> this.isFalse$$anonfun$1(BoxesRunTime.unboxToBoolean((Object)object))).withCode("isFalse"));
    }

    public Assertion<Try<Object>> isFailure(Assertion<Throwable> assertion) {
        return this.apply(TestArrow$.MODULE$.make((Function1 & Serializable)tryValue -> TestTrace$.MODULE$.option(tryValue.failed().toOption(), ErrorMessage$.MODULE$.pretty(tryValue).$plus(ErrorMessage$.MODULE$.was()).$plus("a Failure"))).withCode("isFailure").$greater$greater$greater(assertion.arrow()));
    }

    public Assertion<Try<Object>> isFailure() {
        return isFailure;
    }

    public <A> Assertion<Try<A>> isSuccess(Assertion<A> assertion) {
        return this.apply(TestArrow$.MODULE$.make((Function1 & Serializable)tryValue -> TestTrace$.MODULE$.option(tryValue.toOption(), ErrorMessage$.MODULE$.pretty(tryValue).$plus(ErrorMessage$.MODULE$.was()).$plus("a Success"))).withCode("isSuccess").$greater$greater$greater(assertion.arrow()));
    }

    public Assertion<Try<Object>> isSuccess() {
        return isSuccess;
    }

    public <A> Assertion<A> isOneOf(Iterable<A> values) {
        return this.apply(TestArrow$.MODULE$.make((Function1 & Serializable)value -> TestTrace$.MODULE$.boolean(values.exists((Function1 & Serializable)_$2 -> BoxesRunTime.equals((Object)_$2, (Object)value)), ErrorMessage$.MODULE$.value(value).$plus(ErrorMessage$.MODULE$.was()).$plus(ErrorMessage$.MODULE$.value(values)))).withCode("isOneOf"));
    }

    public Assertion<Throwable> hasMessage(Assertion<String> message) {
        return this.apply(TestArrow$.MODULE$.make((Function1 & Serializable)throwable -> {
            Option option = Option$.MODULE$.apply((Object)throwable.getMessage());
            if (option instanceof Some) {
                String value = (String)((Some)option).value();
                return TestTrace$.MODULE$.succeed(value);
            }
            if (None$.MODULE$.equals(option)) {
                return TestTrace$.MODULE$.fail(new StringBuilder(15).append(throwable.getClass().getName()).append(" had no message").toString());
            }
            throw new MatchError((Object)option);
        }).withCode("hasMessage").$greater$greater$greater(message.arrow()));
    }

    public Assertion<Throwable> hasSuppressed(Assertion<Iterable<Throwable>> cause) {
        return this.apply(TestArrow$.MODULE$.fromFunction((Function1 & Serializable)_$3 -> Predef$.MODULE$.wrapRefArray((Object[])_$3.getSuppressed())).withCode("hasSuppressed").$greater$greater$greater(cause.arrow()));
    }

    public Assertion<Throwable> hasThrowableCause(Assertion<Throwable> cause) {
        return this.apply(TestArrow$.MODULE$.make((Function1 & Serializable)throwable -> {
            Option option = Option$.MODULE$.apply((Object)throwable.getCause());
            if (option instanceof Some) {
                Throwable value = (Throwable)((Some)option).value();
                return TestTrace$.MODULE$.succeed(value);
            }
            if (None$.MODULE$.equals(option)) {
                return TestTrace$.MODULE$.fail(new StringBuilder(13).append(throwable.getClass().getName()).append(" had no cause").toString());
            }
            throw new MatchError((Object)option);
        }).withCode("hasThrowableCause").$greater$greater$greater(cause.arrow()));
    }

    public Assertion<Option<Object>> isNone() {
        return isNone;
    }

    public Assertion<Iterable<Object>> isNonEmpty() {
        return isNonEmpty;
    }

    public Assertion<BoxedUnit> isUnit() {
        return isUnit;
    }

    public <A> Assertion<A> isLessThan(A reference, Ordering<A> ord) {
        return this.apply(SmartAssertions$.MODULE$.lessThan(reference, ord).withCode("isLessThan"));
    }

    public <A> Assertion<A> isLessThanEqualTo(A reference, Ordering<A> ord) {
        return this.apply(SmartAssertions$.MODULE$.lessThanOrEqualTo(reference, ord).withCode("isLessThanEqualTo"));
    }

    public <A> Assertion<A> isGreaterThan(A reference, Ordering<A> ord) {
        return this.apply(SmartAssertions$.MODULE$.greaterThan(reference, ord).withCode("isGreaterThan"));
    }

    public <A> Assertion<A> isGreaterThanEqualTo(A reference, Ordering<A> ord) {
        return this.apply(SmartAssertions$.MODULE$.greaterThanOrEqualTo(reference, ord).withCode("isGreaterThanEqualTo"));
    }

    public <A> Assertion<A> isNegative(Numeric<A> num) {
        return this.apply(TestArrow$.MODULE$.make((Function1 & Serializable)value -> TestTrace$.MODULE$.boolean(num.lt(value, num.zero()), ErrorMessage$.MODULE$.pretty(value).$plus(ErrorMessage$.MODULE$.was()).$plus(ErrorMessage$.MODULE$.value("negative")))).withCode("isNegative"));
    }

    public <A> Assertion<A> isPositive(Numeric<A> num) {
        return this.apply(TestArrow$.MODULE$.make((Function1 & Serializable)value -> TestTrace$.MODULE$.boolean(num.gt(value, num.zero()), ErrorMessage$.MODULE$.pretty(value).$plus(ErrorMessage$.MODULE$.was()).$plus("positive"))).withCode("isPositive"));
    }

    public <A> Assertion<Iterable<A>> exists(Assertion<A> assertion) {
        return this.apply(SmartAssertions$.MODULE$.existsIterable(assertion.arrow()).withCode("exists"));
    }

    public <A> Assertion<A> isWithin(A min, A max, Ordering<A> ord) {
        return this.apply(TestArrow$.MODULE$.make((Function1 & Serializable)value -> TestTrace$.MODULE$.boolean(ord.gteq(value, min) && ord.lteq(value, max), ErrorMessage$.MODULE$.pretty(value).$plus(ErrorMessage$.MODULE$.was()).$plus("within").$plus(ErrorMessage$.MODULE$.pretty(min)).$plus("and").$plus(ErrorMessage$.MODULE$.pretty(max)))).withCode("isWithin"));
    }

    public <E> Assertion<Exit<E, Object>> fails(Assertion<E> assertion) {
        return this.apply(SmartAssertions$.MODULE$.asExitFailure().withCode("fails").$greater$greater$greater(assertion.arrow()));
    }

    public <E> Assertion<Exit<Object, Object>> failsWithA(ClassTag<E> evidence$3) {
        return this.fails(this.isSubtype(this.anything(), evidence$3)).withCode("failsWithA");
    }

    public <E> Assertion<Exit<E, Object>> failsCause(Assertion<Cause<E>> assertion) {
        return this.apply(SmartAssertions$.MODULE$.asExitCause().withCode("failsCause").$greater$greater$greater(assertion.arrow()));
    }

    public <A> Assertion<Iterable<A>> forall(Assertion<A> assertion) {
        return this.apply(SmartAssertions$.MODULE$.forallIterable(assertion.arrow()).withCode("forall"));
    }

    public <A> Assertion<Iterable<A>> hasSameElementsDistinct(Iterable<A> other) {
        return this.apply(TestArrow$.MODULE$.make((Function1 & Serializable)value -> {
            Set set = value.toSet();
            Set set2 = other.toSet();
            return TestTrace$.MODULE$.boolean(!(set != null ? !set.equals(set2) : set2 != null), ErrorMessage$.MODULE$.pretty(value).$plus(ErrorMessage$.MODULE$.had()).$plus("the same distinct elements as").$plus(ErrorMessage$.MODULE$.pretty(other)));
        }).withCode("hasSameElementsDistinct"));
    }

    public <A> Assertion<Iterable<A>> hasSize(Assertion<Object> assertion) {
        return this.apply(TestArrow$.MODULE$.fromFunction((Function1 & Serializable)_$4 -> _$4.size()).withCode("hasSize").$greater$greater$greater(assertion.arrow()));
    }

    public Assertion<String> hasSizeString(Assertion<Object> assertion) {
        return this.apply(TestArrow$.MODULE$.fromFunction((Function1 & Serializable)_$5 -> _$5.length()).withCode("hasSizeString").$greater$greater$greater(assertion.arrow()));
    }

    public <A> Assertion<Iterable<A>> hasIntersection(Iterable<A> other, Assertion<Iterable<A>> assertion) {
        return this.apply(TestArrow$.MODULE$.fromFunction((Function1 & Serializable)value -> (Iterable)value.toSeq().intersect((Seq)other.toSeq())).withCode("hasIntersection").$greater$greater$greater(assertion.arrow()));
    }

    public <A> Assertion<Iterable<A>> hasAtLeastOneOf(Iterable<A> other) {
        return this.hasIntersection(other, this.hasSize(this.isGreaterThanEqualTo((A)BoxesRunTime.boxToInteger((int)1), (Ordering<A>)Ordering.Int$.MODULE$))).withCode("hasAtLeastOneOf");
    }

    public <A> Assertion<Iterable<A>> hasAtMostOneOf(Iterable<A> other) {
        return this.hasIntersection(other, this.hasSize(this.isLessThanEqualTo((A)BoxesRunTime.boxToInteger((int)1), (Ordering<A>)Ordering.Int$.MODULE$))).withCode("hasAtMostOneOf");
    }

    public <A> Assertion<Iterable<A>> hasFirst(Assertion<A> assertion) {
        return this.apply(SmartAssertions$.MODULE$.head().withCode("hasFirst").$greater$greater$greater(assertion.arrow()));
    }

    public <A> Assertion<Iterable<A>> hasLast(Assertion<A> assertion) {
        return this.apply(SmartAssertions$.MODULE$.last().withCode("hasLast").$greater$greater$greater(assertion.arrow()));
    }

    public Assertion<Iterable<Object>> isEmpty() {
        return isEmpty;
    }

    public Assertion<String> isEmptyString() {
        return isEmptyString;
    }

    public <K, V> Assertion<Map<K, V>> hasKey(K key, Assertion<V> assertion) {
        return this.apply(SmartAssertions$.MODULE$.hasKey(key).withCode("hasKey").$greater$greater$greater(assertion.arrow()));
    }

    public <K, V> Assertion<Map<K, V>> hasKey(K key) {
        return this.hasKey(key, this.anything());
    }

    public <K, V> Assertion<Map<K, V>> hasKeys(Assertion<Iterable<K>> assertion) {
        return this.apply(TestArrow$.MODULE$.make((Function1 & Serializable)map -> TestTrace$.MODULE$.succeed(map.keys())).withCode("hasKeys").$greater$greater$greater(assertion.arrow()));
    }

    public <A> Assertion<Iterable<A>> hasNoneOf(Iterable<A> other) {
        return this.hasIntersection(other, this.isEmpty()).withCode("hasNoneOf");
    }

    public <A> Assertion<Iterable<A>> hasOneOf(Iterable<A> other) {
        return this.hasIntersection(other, this.hasSize(this.equalTo(BoxesRunTime.boxToInteger((int)1)))).withCode("hasOneOf");
    }

    public <A> Assertion<Iterable<A>> hasSameElements(Iterable<A> other) {
        return this.apply(TestArrow$.MODULE$.make((Function1 & Serializable)actual -> {
            scala.collection.immutable.Seq otherSeq;
            scala.collection.immutable.Seq actualSeq = actual.toSeq();
            boolean result = ((SeqOps)actualSeq.diff((Seq)(otherSeq = other.toSeq()))).isEmpty() && ((SeqOps)otherSeq.diff((Seq)actualSeq)).isEmpty();
            return TestTrace$.MODULE$.boolean(result, ErrorMessage$.MODULE$.pretty(actualSeq).$plus(ErrorMessage$.MODULE$.had()).$plus("the same elements as ").$plus(ErrorMessage$.MODULE$.pretty(otherSeq)));
        }).withCode("hasSameElements"));
    }

    public <A> Assertion<Iterable<A>> hasSubset(Iterable<A> other) {
        return this.hasIntersection(other, this.hasSameElements(other)).withCode("hasSubset");
    }

    public <K, V> Assertion<Map<K, V>> hasValues(Assertion<Iterable<V>> assertion) {
        return this.apply(TestArrow$.MODULE$.fromFunction((Function1 & Serializable)_$6 -> _$6.values()).withCode("hasValues").$greater$greater$greater(assertion.arrow()));
    }

    public <Sum, Proj> Assertion<Sum> isCase(String termName, Function1<Sum, Option<Proj>> term, Assertion<Proj> assertion) {
        return this.apply(TestArrow$.MODULE$.make((Function1 & Serializable)sum -> TestTrace$.MODULE$.option((Option)term.apply(sum), ErrorMessage$.MODULE$.pretty(sum).$plus(ErrorMessage$.MODULE$.was()).$plus("a case of ").$plus(termName))).withCode("isCase").$greater$greater$greater(assertion.arrow()));
    }

    public Assertion<Iterable<Object>> isDistinct() {
        return isDistinct;
    }

    public Assertion<String> isNonEmptyString() {
        return isNonEmptyString;
    }

    public Assertion<Object> isNull() {
        return isNull;
    }

    public <A> Assertion<A> isZero(Numeric<A> num) {
        return this.apply(TestArrow$.MODULE$.make((Function1 & Serializable)x -> TestTrace$.MODULE$.boolean(BoxesRunTime.equals((Object)num.zero(), (Object)x), ErrorMessage$.MODULE$.pretty(x).$plus(ErrorMessage$.MODULE$.was()).$plus("zero"))).withCode("isZero"));
    }

    public Assertion<String> matchesRegex(String regex) {
        return this.apply(TestArrow$.MODULE$.make((Function1 & Serializable)s -> TestTrace$.MODULE$.boolean(s.matches(regex), ErrorMessage$.MODULE$.pretty(s).$plus(ErrorMessage$.MODULE$.did()).$plus("match").$plus(ErrorMessage$.MODULE$.pretty(regex)))).withCode("matchesRegex"));
    }

    public <A> Assertion<A> nonNegative(Numeric<A> num) {
        return this.isGreaterThanEqualTo((A)num.zero(), (Ordering<A>)num).withCode("nonNegative");
    }

    public <A> Assertion<A> nonPositive(Numeric<A> num) {
        return this.isLessThanEqualTo((A)num.zero(), (Ordering<A>)num).withCode("nonPositive");
    }

    public <A> Assertion<A> not(Assertion<A> assertion) {
        return assertion.negate();
    }

    public Assertion<Object> nothing() {
        return nothing;
    }

    public <A> Assertion<scala.collection.immutable.Seq<A>> startsWith(scala.collection.immutable.Seq<A> prefix) {
        return this.apply(SmartAssertions$.MODULE$.startsWithSeq(prefix).withCode("startsWith"));
    }

    public Assertion<String> startsWithString(String prefix) {
        return this.apply(SmartAssertions$.MODULE$.startsWithString(prefix).withCode("startsWithString"));
    }

    public <A> Assertion<Exit<Object, A>> succeeds(Assertion<A> assertion) {
        return this.apply(SmartAssertions$.MODULE$.asExitSuccess().withCode("succeeds").$greater$greater$greater(assertion.arrow()));
    }

    public <A> Assertion<A> throws(Assertion<Throwable> assertion) {
        return this.apply(SmartAssertions$.MODULE$.throws().withCode("throws").$greater$greater$greater(assertion.arrow()));
    }

    public <E> Assertion<Object> throwsA(ClassTag<E> evidence$4) {
        return this.throws(this.isSubtype(this.anything(), evidence$4));
    }

    public Assertion<Exit<Object, Object>> isInterrupted() {
        return this.apply(TestArrow$.MODULE$.make((Function1 & Serializable)x$1 -> {
            Exit exit = x$1;
            if (exit instanceof Exit.Failure) {
                Cause cause;
                Exit.Failure failure = Exit.Failure$.MODULE$.unapply((Exit.Failure)exit);
                Cause cause2 = cause = failure._1();
                return TestTrace$.MODULE$.boolean(cause2.isInterrupted(), ErrorMessage$.MODULE$.value("Exit").$plus(ErrorMessage$.MODULE$.was()).$plus("interrupted"));
            }
            return TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Exit").$plus(ErrorMessage$.MODULE$.was()).$plus("interrupted"));
        }).withCode("isInterrupted"));
    }

    public Assertion<Exit<Object, Object>> isJustInterrupted() {
        return this.apply(TestArrow$.MODULE$.make((Function1 & Serializable)x$1 -> {
            Exit.Failure failure;
            Cause cause;
            Exit exit = x$1;
            if (exit instanceof Exit.Failure && (cause = (failure = Exit.Failure$.MODULE$.unapply((Exit.Failure)exit))._1()) instanceof Cause.Interrupt) {
                Cause.Interrupt interrupt = Cause.Interrupt$.MODULE$.unapply((Cause.Interrupt)cause);
                FiberId fiberId = interrupt._1();
                StackTrace stackTrace = interrupt._2();
                return TestTrace$.MODULE$.succeed(BoxesRunTime.boxToBoolean((boolean)true));
            }
            return TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Exit").$plus(ErrorMessage$.MODULE$.was()).$plus("just interrupted"));
        }).withCode("isJustInterrupted"));
    }

    public Assertion<?> fromProduct(Product x$0) {
        return new Assertion((TestArrow)x$0.productElement(0));
    }

    private final boolean loop$1(Iterator iterator, Set seen) {
        boolean bl;
        while (true) {
            if (!(bl = iterator.hasNext())) {
                return true;
            }
            if (!bl) break;
            Object x = iterator.next();
            if (seen.contains(x)) {
                return false;
            }
            seen = (Set)seen.$plus(x);
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    private final Object value0$lzyINIT1$1(Function0 expr$1, LazyRef value0$lzy1$1) {
        Object object;
        LazyRef lazyRef = value0$lzy1$1;
        synchronized (lazyRef) {
            object = value0$lzy1$1.initialized() ? value0$lzy1$1.value() : value0$lzy1$1.initialize(expr$1.apply());
        }
        return object;
    }

    private final Object value0$1(Function0 expr$2, LazyRef value0$lzy1$2) {
        if (value0$lzy1$2.initialized()) {
            return value0$lzy1$2.value();
        }
        return this.value0$lzyINIT1$1(expr$2, value0$lzy1$2);
    }

    private final Object smartAssert$$anonfun$1(Function0 expr$5, LazyRef value0$lzy1$3) {
        return this.value0$1(expr$5, value0$lzy1$3);
    }

    private final String smartAssert$$anonfun$2() {
        return "input";
    }

    private final String smartAssert$$anonfun$3() {
        return "<CODE>";
    }

    private final ZIO value0$lzyINIT2$1(Function0 expr$3, LazyRef value0$lzy2$1) {
        ZIO zIO;
        LazyRef lazyRef = value0$lzy2$1;
        synchronized (lazyRef) {
            zIO = (ZIO)(value0$lzy2$1.initialized() ? value0$lzy2$1.value() : value0$lzy2$1.initialize((Object)((ZIO)expr$3.apply())));
        }
        return zIO;
    }

    private final ZIO value0$2(Function0 expr$4, LazyRef value0$lzy2$2) {
        return (ZIO)(value0$lzy2$2.initialized() ? value0$lzy2$2.value() : this.value0$lzyINIT2$1(expr$4, value0$lzy2$2));
    }

    private final Object smartAssertZIO$$anonfun$1$$anonfun$1(Object _$1$1) {
        return _$1$1;
    }

    private final Object $anonfun$2(Object a$1) {
        return a$1;
    }

    private final TestTrace assertionRec$$anonfun$1$$anonfun$1(String name$3) {
        return TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.text("Custom Assertion").$plus(ErrorMessage$.MODULE$.value(name$3)).$plus(ErrorMessage$.MODULE$.choice("succeeded", "failed")));
    }

    private final IterableOnce loop$2$$anonfun$1(Iterator iterator$tailLocal1$1) {
        return iterator$tailLocal1$1;
    }

    private final boolean loop$2(Ordering ord$1, Iterator iterator) {
        boolean bl;
        block2: {
            block3: {
                while (true) {
                    if (!(bl = iterator.hasNext())) {
                        return true;
                    }
                    if (!bl) break block2;
                    Object x = iterator.next();
                    if (!iterator.hasNext()) break block3;
                    Object y = iterator.next();
                    if (!ord$1.lteq(x, y)) break;
                    iterator = package$.MODULE$.Iterator().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{y})).$plus$plus(() -> this.loop$2$$anonfun$1(iterator));
                }
                return false;
            }
            return true;
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    private final /* synthetic */ TestTrace isTrue$$anonfun$1(boolean bl) {
        return TestTrace$.MODULE$.boolean(bl, ErrorMessage$.MODULE$.value(BoxesRunTime.boxToBoolean((boolean)bl)).$plus(ErrorMessage$.MODULE$.was()).$plus(ErrorMessage$.MODULE$.value(BoxesRunTime.boxToBoolean((boolean)true))));
    }

    private final /* synthetic */ TestTrace isFalse$$anonfun$1(boolean bl) {
        return TestTrace$.MODULE$.boolean(!bl, ErrorMessage$.MODULE$.value(BoxesRunTime.boxToBoolean((boolean)bl)).$plus(ErrorMessage$.MODULE$.was()).$plus(ErrorMessage$.MODULE$.value(BoxesRunTime.boxToBoolean((boolean)false))));
    }
}

