/*
 * Decompiled with CFR 0.152.
 */
package zio.test;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.function.JProcedure1;
import scala.util.NotGiven$;
import zio.CanFail$;
import zio.IsSubtypeOfError$;
import zio.ZIO;
import zio.ZIO$;
import zio.test.ExecutionEvent;
import zio.test.TestDebugFileLock;

public final class TestDebug$
implements Serializable {
    private static final String outputDirectory;
    public static final TestDebug$ MODULE$;

    private TestDebug$() {
    }

    static {
        MODULE$ = new TestDebug$();
        outputDirectory = "target/test-reports-zio";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TestDebug$.class);
    }

    private String outputFileForTask(String task) {
        return new StringBuilder(11).append(outputDirectory).append("/").append(task).append("_debug.txt").toString();
    }

    public ZIO<Object, Nothing$, BoxedUnit> createDebugFile(String fullyQualifiedTaskName) {
        return ZIO$.MODULE$.succeed((Function1)(JProcedure1 & Serializable)evidence$1 -> {
            this.makeOutputDirectory();
            File file = new File(this.outputFileForTask(fullyQualifiedTaskName));
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
        }, (Object)"zio.test.TestDebug.createDebugFile(TestDebug.scala:17)");
    }

    private Path makeOutputDirectory() {
        Path fp = Paths.get(outputDirectory, new String[0]);
        return Files.createDirectories(fp.getParent(), new FileAttribute[0]);
    }

    public ZIO<Object, Nothing$, BoxedUnit> deleteIfEmpty(String fullyQualifiedTaskName) {
        return ZIO$.MODULE$.succeed((Function1)(JProcedure1 & Serializable)evidence$2 -> {
            File file = new File(this.outputFileForTask(fullyQualifiedTaskName));
            if (file.exists()) {
                BufferedSource source = Source$.MODULE$.fromFile(file, Codec$.MODULE$.fallbackSystemCodec());
                List nonBlankLines = source.getLines().filterNot((Function1 & Serializable)input -> this.isBlank((String)input)).toList();
                source.close();
                if (nonBlankLines.isEmpty()) {
                    file.delete();
                    return;
                }
                return;
            }
        }, (Object)"zio.test.TestDebug.deleteIfEmpty(TestDebug.scala:34)");
    }

    private boolean isBlank(String input) {
        Object object = Predef$.MODULE$.charArrayOps(input.toCharArray());
        return ArrayOps$.MODULE$.forall$extension(object, (Function1 & Serializable)_$1 -> this.isBlank$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$1)));
    }

    public ZIO<Object, Nothing$, BoxedUnit> print(ExecutionEvent executionEvent, TestDebugFileLock lock) {
        ExecutionEvent executionEvent2 = executionEvent;
        if (executionEvent2 instanceof ExecutionEvent.TestStarted) {
            ExecutionEvent.TestStarted t = (ExecutionEvent.TestStarted)executionEvent2;
            return this.write(t.fullyQualifiedName(), new StringBuilder(9).append(t.labels().mkString(" - ")).append(" STARTED\n").toString(), true, lock);
        }
        if (executionEvent2 instanceof ExecutionEvent.Test) {
            ExecutionEvent.Test t = (ExecutionEvent.Test)executionEvent2;
            return this.removeLine(t.fullyQualifiedName(), new StringBuilder(8).append(t.labels().mkString(" - ")).append(" STARTED").toString(), lock);
        }
        return ZIO$.MODULE$.unit();
    }

    private ZIO<Object, Nothing$, BoxedUnit> write(String fullyQualifiedTaskName, String content, boolean append, TestDebugFileLock lock) {
        Function0 function0 = ZIO$.MODULE$.acquireReleaseWith(() -> this.write$$anonfun$1(fullyQualifiedTaskName, append));
        return lock.updateFile((ZIO<Object, Nothing$, BoxedUnit>)ZIO.Acquire$.MODULE$.apply$extension(function0, (Function1 & Serializable)f -> ZIO$.MODULE$.attemptBlocking((Function1)(JProcedure1 & Serializable)evidence$5 -> f.close(), (Object)"zio.test.TestDebug.write(TestDebug.scala:60)").orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (Object)"zio.test.TestDebug.write(TestDebug.scala:60)")).apply((Function1 & Serializable)f -> ZIO$.MODULE$.attemptBlockingIO((Function1 & Serializable)evidence$6 -> f.append(content), (Object)"zio.test.TestDebug.write(TestDebug.scala:61)"), (Object)"zio.test.TestDebug.write(TestDebug.scala:62)").ignore((Object)"zio.test.TestDebug.write(TestDebug.scala:63)"));
    }

    private ZIO<Object, Nothing$, BoxedUnit> removeLine(String fullyQualifiedTaskName, String searchString, TestDebugFileLock lock) {
        return lock.updateFile((ZIO<Object, Nothing$, BoxedUnit>)ZIO$.MODULE$.succeed((Function1)(JProcedure1 & Serializable)evidence$3 -> {
            BufferedSource source = Source$.MODULE$.fromFile(this.outputFileForTask(fullyQualifiedTaskName), Codec$.MODULE$.fallbackSystemCodec());
            List remainingLines = source.getLines().filterNot((Function1 & Serializable)_$2 -> _$2.contains(searchString)).toList();
            PrintWriter pw = new PrintWriter(this.outputFileForTask(fullyQualifiedTaskName));
            pw.write(new StringBuilder(1).append(remainingLines.mkString("\n")).append("\n").toString());
            pw.close();
            source.close();
        }, (Object)"zio.test.TestDebug.removeLine(TestDebug.scala:78)"));
    }

    private final /* synthetic */ boolean isBlank$$anonfun$1(char _$1) {
        return Character.isWhitespace(_$1);
    }

    private final ZIO write$$anonfun$1(String fullyQualifiedTaskName$3, boolean append$1) {
        return ZIO$.MODULE$.attemptBlockingIO((Function1 & Serializable)evidence$4 -> new FileWriter(this.outputFileForTask(fullyQualifiedTaskName$3), append$1), (Object)"zio.test.TestDebug.write(TestDebug.scala:59)");
    }
}

