/*
 * Decompiled with CFR 0.152.
 */
package zio.test.internal;

import java.io.Serializable;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.math.Integral;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import zio.Cause;
import zio.Exit;
import zio.internal.ansi;
import zio.internal.ansi$;
import zio.test.ConsoleUtils$;
import zio.test.CustomAssertion;
import zio.test.ErrorMessage;
import zio.test.ErrorMessage$;
import zio.test.PrettyPrint$;
import zio.test.Result$;
import zio.test.TestArrow;
import zio.test.TestArrow$;
import zio.test.TestTrace;
import zio.test.TestTrace$;
import zio.test.TestTrace$Node$;
import zio.test.diff.Diff;
import zio.test.diff.DiffResult;
import zio.test.diff.DiffResult$Different$;
import zio.test.internal.OptionalImplicit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class SmartAssertions$
implements Serializable {
    private static final TestArrow anything;
    private static final TestArrow throws;
    public static final SmartAssertions$ MODULE$;

    private SmartAssertions$() {
    }

    static {
        MODULE$ = new SmartAssertions$();
        anything = TestArrow$.MODULE$.make((Function1 & Serializable)_$1 -> TestTrace$.MODULE$.boolean(true, ErrorMessage$.MODULE$.was().$plus("anything")));
        throws = TestArrow$.MODULE$.makeEither((Function1 & Serializable)value -> TestTrace$.MODULE$.succeed(value), (Function1 & Serializable)_$8 -> TestTrace$.MODULE$.fail("Expected failure"));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SmartAssertions$.class);
    }

    public TestArrow<Object, Object> anything() {
        return anything;
    }

    public <A> TestArrow<A, Object> approximatelyEquals(A reference, A tolerance, Numeric<A> evidence$1) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)actual -> {
            Numeric referenceType = (Numeric)Predef$.MODULE$.implicitly((Object)evidence$1);
            Object max = referenceType.plus(reference, tolerance);
            Object min = referenceType.minus(reference, tolerance);
            boolean result = referenceType.gteq(actual, min) && referenceType.lteq(actual, max);
            return TestTrace$.MODULE$.boolean(result, ErrorMessage$.MODULE$.pretty(actual).$plus(ErrorMessage$.MODULE$.did()).$plus("approximately equal").$plus(ErrorMessage$.MODULE$.pretty(reference)).$plus("with a tolerance of").$plus(ErrorMessage$.MODULE$.pretty(tolerance)));
        });
    }

    public <A, B> TestArrow<A, B> custom(CustomAssertion<A, B> customAssertion) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)a -> {
            Either either = (Either)customAssertion.run().apply(a);
            if (either instanceof Left) {
                String error = (String)((Left)either).value();
                return TestTrace$.MODULE$.fail(error);
            }
            if (either instanceof Right) {
                Object value = ((Right)either).value();
                return TestTrace$.MODULE$.succeed(value);
            }
            throw new MatchError((Object)either);
        });
    }

    public <A> TestArrow<Option<A>, A> isSome() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Object value = ((Some)option).value();
                return TestTrace$.MODULE$.succeed(value);
            }
            if (None$.MODULE$.equals(option)) {
                return TestTrace$.MODULE$.fail("Option was None");
            }
            throw new MatchError((Object)option);
        });
    }

    public <A> TestArrow<Either<?, A>, A> asRight() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                Object value = ((Right)either).value();
                return TestTrace$.MODULE$.succeed(value);
            }
            if (either instanceof Left) {
                return TestTrace$.MODULE$.fail("Either was Left");
            }
            throw new MatchError((Object)either);
        });
    }

    public <A> TestArrow<Either<A, ?>, A> asLeft() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                Object value = ((Left)either).value();
                return TestTrace$.MODULE$.succeed(value);
            }
            if (either instanceof Right) {
                return TestTrace$.MODULE$.fail("Either was Right");
            }
            throw new MatchError((Object)either);
        });
    }

    public <A> TestArrow<Iterable<A>, Object> isEmptyIterable() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)as -> TestTrace$.MODULE$.boolean(as.isEmpty(), this.className((Iterable)as).$plus(ErrorMessage$.MODULE$.was()).$plus("empty").$plus(ErrorMessage$.MODULE$.text(new StringBuilder(7).append("(size ").append(as.size()).append(")").toString()))));
    }

    public TestArrow<String, Object> isEmptyString() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)string -> TestTrace$.MODULE$.boolean(string.isEmpty(), ErrorMessage$.MODULE$.pretty(string).$plus(ErrorMessage$.MODULE$.was()).$plus("empty").$plus(ErrorMessage$.MODULE$.text(new StringBuilder(9).append("(length ").append(string.length()).append(")").toString()))));
    }

    public TestArrow<Iterable<Object>, Object> isNonEmptyIterable() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)as -> TestTrace$.MODULE$.boolean(as.nonEmpty(), this.className((Iterable)as).$plus(ErrorMessage$.MODULE$.choice("was not", "was")).$plus("empty")));
    }

    public TestArrow<String, Object> isNonEmptyString() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)string -> TestTrace$.MODULE$.boolean(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(string)), ErrorMessage$.MODULE$.pretty(string).$plus(ErrorMessage$.MODULE$.choice("was not", "was")).$plus("empty")));
    }

    public TestArrow<Option<Object>, Object> isEmptyOption() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)option -> TestTrace$.MODULE$.boolean(option.isEmpty(), this.className((Option)option).$plus(ErrorMessage$.MODULE$.was()).$plus("empty")));
    }

    public TestArrow<Option<Object>, Object> isDefinedOption() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)option -> TestTrace$.MODULE$.boolean(option.isDefined(), this.className((Option)option).$plus(ErrorMessage$.MODULE$.was()).$plus("defined")));
    }

    public <A> TestArrow<Iterable<A>, Object> forallIterable(TestArrow<A, Object> predicate) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)seq -> {
            Iterable results = (Iterable)seq.map((Function1 & Serializable)a -> TestArrow$.MODULE$.run(predicate, package$.MODULE$.Right().apply(a)));
            Iterable failures = (Iterable)results.filter((Function1 & Serializable)_$2 -> _$2.isFailure($less$colon$less$.MODULE$.refl()));
            String elements = failures.size() == 1 ? "element" : "elements";
            return TestTrace$Node$.MODULE$.apply(Result$.MODULE$.succeed(BoxesRunTime.boxToBoolean((boolean)failures.isEmpty())), ErrorMessage$.MODULE$.pretty(BoxesRunTime.boxToInteger((int)failures.size())).$plus(ErrorMessage$.MODULE$.text(new StringBuilder(21).append(elements).append(" failed the predicate").toString())), (Option<TestTrace<Object>>)(failures.isEmpty() ? None$.MODULE$ : Some$.MODULE$.apply(failures.reduce((Function2 & Serializable)(_$3, _$4) -> _$3.$amp$amp((TestTrace<Object>)_$4, $less$colon$less$.MODULE$.refl())))), TestTrace$Node$.MODULE$.$lessinit$greater$default$4(), TestTrace$Node$.MODULE$.$lessinit$greater$default$5(), TestTrace$Node$.MODULE$.$lessinit$greater$default$6(), TestTrace$Node$.MODULE$.$lessinit$greater$default$7(), TestTrace$Node$.MODULE$.$lessinit$greater$default$8(), TestTrace$Node$.MODULE$.$lessinit$greater$default$9(), TestTrace$Node$.MODULE$.$lessinit$greater$default$10(), TestTrace$Node$.MODULE$.$lessinit$greater$default$11());
        });
    }

    public <A> TestArrow<Iterable<A>, Object> existsIterable(TestArrow<A, Object> predicate) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)seq -> {
            Option result = ((IterableOnceOps)seq.view().map((Function1 & Serializable)a -> TestArrow$.MODULE$.run(predicate, package$.MODULE$.Right().apply(a)))).find((Function1 & Serializable)tt -> tt.isSuccess($less$colon$less$.MODULE$.refl()) || tt.isDie());
            Option success = result.filter((Function1 & Serializable)_$5 -> _$5.isSuccess($less$colon$less$.MODULE$.refl()));
            String elements = success.nonEmpty() ? "element" : "elements";
            ErrorMessage elementsSatisfiedPredicateMsg = result.exists((Function1 & Serializable)_$6 -> _$6.isDie()) ? ErrorMessage$.MODULE$.text(new StringBuilder(53).append(elements).append(" satisfied the predicate before it threw an exception").toString()) : ErrorMessage$.MODULE$.text(new StringBuilder(24).append(elements).append(" satisfied the predicate").toString());
            return TestTrace$Node$.MODULE$.apply(Result$.MODULE$.succeed(BoxesRunTime.boxToBoolean((boolean)success.nonEmpty())), ErrorMessage$.MODULE$.pretty(BoxesRunTime.boxToInteger((int)Option$.MODULE$.option2Iterable(success).size())).$plus(elementsSatisfiedPredicateMsg), (Option<TestTrace<Object>>)result, TestTrace$Node$.MODULE$.$lessinit$greater$default$4(), TestTrace$Node$.MODULE$.$lessinit$greater$default$5(), TestTrace$Node$.MODULE$.$lessinit$greater$default$6(), TestTrace$Node$.MODULE$.$lessinit$greater$default$7(), TestTrace$Node$.MODULE$.$lessinit$greater$default$8(), TestTrace$Node$.MODULE$.$lessinit$greater$default$9(), TestTrace$Node$.MODULE$.$lessinit$greater$default$10(), TestTrace$Node$.MODULE$.$lessinit$greater$default$11());
        });
    }

    public <A> TestArrow<Seq<A>, Object> containsSeq(A value) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)seq -> TestTrace$.MODULE$.boolean(seq.contains(value), this.className((Iterable)seq).$plus(ErrorMessage$.MODULE$.did()).$plus("contain").$plus(ErrorMessage$.MODULE$.pretty(value))));
    }

    public <A> TestArrow<Iterable<A>, Object> containsIterable(A value) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)seq -> TestTrace$.MODULE$.boolean(seq.exists((Function1 & Serializable)_$7 -> BoxesRunTime.equals((Object)_$7, (Object)value)), this.className((Iterable)seq).$plus(ErrorMessage$.MODULE$.did()).$plus("contain").$plus(ErrorMessage$.MODULE$.pretty(value))));
    }

    public <E> TestArrow<Cause<E>, Object> containsCause(Cause<E> expected) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)cause -> TestTrace$.MODULE$.boolean(cause.contains(expected), ErrorMessage$.MODULE$.pretty(cause).$plus(ErrorMessage$.MODULE$.did()).$plus("contain").$plus(ErrorMessage$.MODULE$.pretty(expected))));
    }

    public <A> TestArrow<Option<A>, Object> containsOption(A value) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)option -> TestTrace$.MODULE$.boolean(option.contains(value), this.className((Option)option).$plus(ErrorMessage$.MODULE$.did()).$plus("contain").$plus(ErrorMessage$.MODULE$.pretty(value))));
    }

    public TestArrow<String, Object> containsString(String value) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)str -> TestTrace$.MODULE$.boolean(str.contains(value), ErrorMessage$.MODULE$.pretty(str).$plus(ErrorMessage$.MODULE$.did()).$plus("contain").$plus(ErrorMessage$.MODULE$.pretty(value))));
    }

    public <A> TestArrow<Seq<A>, A> hasAt(int index) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)as -> {
            Option option = Try$.MODULE$.apply(() -> this.hasAt$$anonfun$1$$anonfun$1(index, as)).toOption();
            if (option instanceof Some) {
                Object value = ((Some)option).value();
                return TestTrace$.MODULE$.succeed(value);
            }
            if (None$.MODULE$.equals(option)) {
                return TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.text("Invalid index").$plus(ErrorMessage$.MODULE$.value(BoxesRunTime.boxToInteger((int)index))).$plus("for").$plus(this.className((Iterable)as)).$plus("of size").$plus(ErrorMessage$.MODULE$.value(BoxesRunTime.boxToInteger((int)as.length()))));
            }
            throw new MatchError((Object)option);
        });
    }

    public <A, B> TestArrow<A, B> hasField(String name, Function1<A, B> proj) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)a -> TestTrace$.MODULE$.succeed(proj.apply(a)));
    }

    public <K, V> TestArrow<Map<K, V>, V> hasKey(K key) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)mapKV -> {
            Option option = Try$.MODULE$.apply(() -> this.hasKey$$anonfun$1$$anonfun$1(key, mapKV)).toOption();
            if (option instanceof Some) {
                Object value = ((Some)option).value();
                return TestTrace$.MODULE$.succeed(value);
            }
            if (None$.MODULE$.equals(option)) {
                return TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.text("Missing key").$plus(ErrorMessage$.MODULE$.pretty(key)));
            }
            throw new MatchError((Object)option);
        });
    }

    public <A> TestArrow<Iterable<A>, A> head() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)as -> {
            Option option = as.headOption();
            if (option instanceof Some) {
                Object value = ((Some)option).value();
                return TestTrace$.MODULE$.succeed(value);
            }
            if (None$.MODULE$.equals(option)) {
                return TestTrace$.MODULE$.fail(this.className((Iterable)as).$plus("was empty"));
            }
            throw new MatchError((Object)option);
        });
    }

    public <A> TestArrow<Iterable<A>, A> last() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)as -> {
            Option option = as.lastOption();
            if (option instanceof Some) {
                Object value = ((Some)option).value();
                return TestTrace$.MODULE$.succeed(value);
            }
            if (None$.MODULE$.equals(option)) {
                return TestTrace$.MODULE$.fail(this.className((Iterable)as).$plus("was empty"));
            }
            throw new MatchError((Object)option);
        });
    }

    public <A> TestArrow<A, Object> isEven(Integral<A> integral) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)a -> TestTrace$.MODULE$.boolean(BoxesRunTime.equals((Object)integral.rem(a, integral.fromInt(2)), (Object)integral.fromInt(0)), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("even")));
    }

    public <A> TestArrow<A, Object> isOdd(Integral<A> integral) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)a -> TestTrace$.MODULE$.boolean(BoxesRunTime.equals((Object)integral.rem(a, integral.fromInt(2)), (Object)integral.fromInt(1)), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("odd")));
    }

    public <A> TestArrow<A, Object> greaterThan(A that, Ordering<A> ordering) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)a -> TestTrace$.MODULE$.boolean(ordering.gt(a, that), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("greater than").$plus(ErrorMessage$.MODULE$.pretty(that))));
    }

    public <A> TestArrow<A, Object> greaterThanOrEqualTo(A that, Ordering<A> ordering) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)a -> TestTrace$.MODULE$.boolean(ordering.gteq(a, that), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("greater than or equal to").$plus(ErrorMessage$.MODULE$.pretty(that))));
    }

    public <A> TestArrow<A, Object> lessThan(A that, Ordering<A> ordering) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)a -> TestTrace$.MODULE$.boolean(ordering.lt(a, that), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("less than").$plus(ErrorMessage$.MODULE$.pretty(that))));
    }

    public <A> TestArrow<A, Object> lessThanOrEqualTo(A that, Ordering<A> ordering) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)a -> TestTrace$.MODULE$.boolean(ordering.lteq(a, that), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("less than or equal to").$plus(ErrorMessage$.MODULE$.pretty(that))));
    }

    public <A> TestArrow<A, Object> equalTo(A that, OptionalImplicit<Diff<A>> diff) {
        return TestArrow$.MODULE$.make(arg_0 -> this.equalTo$$anonfun$1(that, diff, arg_0));
    }

    public <E> TestArrow<Cause<E>, Throwable> asCauseDie() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)x$1 -> {
            Cause cause = x$1;
            Cause cause2 = cause;
            if (cause2.dieOption().isDefined()) {
                return TestTrace$.MODULE$.succeed(cause2.dieOption().get());
            }
            return TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Cause").$plus(ErrorMessage$.MODULE$.did()).$plus("contain a").$plus(ErrorMessage$.MODULE$.value("Die")));
        });
    }

    public <E> TestArrow<Cause<E>, E> asCauseFailure() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)x$1 -> {
            Cause cause = x$1;
            Cause cause2 = cause;
            if (cause2.failureOption().isDefined()) {
                return TestTrace$.MODULE$.succeed(cause2.failureOption().get());
            }
            return TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Cause").$plus(ErrorMessage$.MODULE$.did()).$plus("contain a").$plus(ErrorMessage$.MODULE$.value("Fail")));
        });
    }

    public <E> TestArrow<Cause<E>, Object> asCauseInterrupted() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)x$1 -> {
            Cause cause = x$1;
            Cause cause2 = cause;
            if (cause2.isInterrupted()) {
                return TestTrace$.MODULE$.succeed(BoxesRunTime.boxToBoolean((boolean)true));
            }
            return TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Cause").$plus(ErrorMessage$.MODULE$.did()).$plus("contain a").$plus(ErrorMessage$.MODULE$.value("Interrupt")));
        });
    }

    public <E, A> TestArrow<Exit<E, A>, Throwable> asExitDie() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)x$1 -> {
            Exit.Failure failure;
            Cause cause;
            Cause cause2;
            Exit exit = x$1;
            if (exit instanceof Exit.Failure && (cause2 = (cause = (failure = Exit.Failure$.MODULE$.unapply((Exit.Failure)exit))._1())).dieOption().isDefined()) {
                return TestTrace$.MODULE$.succeed(cause2.dieOption().get());
            }
            if (exit instanceof Exit.Success) {
                Exit.Success success = Exit.Success$.MODULE$.unapply((Exit.Success)exit);
                Object object = success._1();
                return TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Exit.Success").$plus(ErrorMessage$.MODULE$.was()).$plus("a").$plus(ErrorMessage$.MODULE$.value("Cause.Die")));
            }
            if (exit instanceof Exit.Failure) {
                Exit.Failure failure2 = Exit.Failure$.MODULE$.unapply((Exit.Failure)exit);
                Cause cause3 = failure2._1();
                return TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Exit.Failure").$plus(ErrorMessage$.MODULE$.did()).$plus("contain a").$plus(ErrorMessage$.MODULE$.value("Cause.Die")));
            }
            throw new MatchError((Object)exit);
        });
    }

    public <E> TestArrow<Exit<E, Object>, Cause<E>> asExitCause() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)x$1 -> {
            Exit exit = x$1;
            if (exit instanceof Exit.Failure) {
                Cause cause;
                Exit.Failure failure = Exit.Failure$.MODULE$.unapply((Exit.Failure)exit);
                Cause cause2 = cause = failure._1();
                return TestTrace$.MODULE$.succeed(cause2);
            }
            if (exit instanceof Exit.Success) {
                Exit.Success success = Exit.Success$.MODULE$.unapply((Exit.Success)exit);
                Object object = success._1();
                return TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Exit.Success").$plus(ErrorMessage$.MODULE$.did()).$plus("contain a").$plus(ErrorMessage$.MODULE$.value("Cause")));
            }
            throw new MatchError((Object)exit);
        });
    }

    public <E> TestArrow<Exit<E, Object>, E> asExitFailure() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)x$1 -> {
            Exit.Failure failure;
            Cause cause;
            Cause cause2;
            Exit exit = x$1;
            if (exit instanceof Exit.Failure && (cause2 = (cause = (failure = Exit.Failure$.MODULE$.unapply((Exit.Failure)exit))._1())).failureOption().isDefined()) {
                return TestTrace$.MODULE$.succeed(cause2.failureOption().get());
            }
            if (exit instanceof Exit.Success) {
                Exit.Success success = Exit.Success$.MODULE$.unapply((Exit.Success)exit);
                Object object = success._1();
                return TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Exit.Success").$plus(ErrorMessage$.MODULE$.was()).$plus("a").$plus(ErrorMessage$.MODULE$.value("Failure")));
            }
            if (exit instanceof Exit.Failure) {
                Exit.Failure failure2 = Exit.Failure$.MODULE$.unapply((Exit.Failure)exit);
                Cause cause3 = failure2._1();
                return TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Exit.Failure").$plus(ErrorMessage$.MODULE$.did()).$plus("contain a").$plus(ErrorMessage$.MODULE$.value("Cause.Fail")));
            }
            throw new MatchError((Object)exit);
        });
    }

    public <E, A> TestArrow<Exit<E, A>, Object> asExitInterrupted() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)x$1 -> {
            Exit.Failure failure;
            Cause cause;
            Cause cause2;
            Exit exit = x$1;
            if (exit instanceof Exit.Failure && (cause2 = (cause = (failure = Exit.Failure$.MODULE$.unapply((Exit.Failure)exit))._1())).isInterrupted()) {
                return TestTrace$.MODULE$.succeed(BoxesRunTime.boxToBoolean((boolean)true));
            }
            if (exit instanceof Exit.Success) {
                Exit.Success success = Exit.Success$.MODULE$.unapply((Exit.Success)exit);
                Object object = success._1();
                return TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Exit.Success").$plus(ErrorMessage$.MODULE$.was()).$plus("interrupted"));
            }
            if (exit instanceof Exit.Failure) {
                Exit.Failure failure2 = Exit.Failure$.MODULE$.unapply((Exit.Failure)exit);
                Cause cause3 = failure2._1();
                return TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Exit.Failure").$plus(ErrorMessage$.MODULE$.did()).$plus("contain a").$plus(ErrorMessage$.MODULE$.value("Cause.Interrupt")));
            }
            throw new MatchError((Object)exit);
        });
    }

    public <E, A> TestArrow<Exit<E, A>, A> asExitSuccess() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)x$1 -> {
            Exit exit = x$1;
            if (exit instanceof Exit.Success) {
                Object object;
                Exit.Success success = Exit.Success$.MODULE$.unapply((Exit.Success)exit);
                Object value = object = success._1();
                return TestTrace$.MODULE$.succeed(value);
            }
            if (exit instanceof Exit.Failure) {
                Exit.Failure failure = Exit.Failure$.MODULE$.unapply((Exit.Failure)exit);
                Cause cause = failure._1();
                return TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Exit").$plus(ErrorMessage$.MODULE$.was()).$plus("a").$plus(ErrorMessage$.MODULE$.value("Success")));
            }
            throw new MatchError((Object)exit);
        });
    }

    public TestArrow<Object, Throwable> throws() {
        return throws;
    }

    public <A, B> TestArrow<A, B> as(ClassTag<B> CB) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)a -> {
            Option option = CB.unapply(a);
            if (option instanceof Some) {
                Object value = ((Some)option).value();
                return TestTrace$.MODULE$.succeed(value);
            }
            if (None$.MODULE$.equals(option)) {
                return TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.value(a.getClass().getSimpleName()).$plus("is not an instance of").$plus(ErrorMessage$.MODULE$.value(this.className(CB))));
            }
            throw new MatchError((Object)option);
        });
    }

    public <A, B> TestArrow<A, Object> is(ClassTag<B> CB) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)a -> TestTrace$.MODULE$.boolean(CB.unapply(a).isDefined(), ErrorMessage$.MODULE$.value(a.getClass().getSimpleName()).$plus(ErrorMessage$.MODULE$.was()).$plus("an instance of").$plus(ErrorMessage$.MODULE$.value(this.className(CB)))));
    }

    public <A> TestArrow<Seq<A>, Object> startsWithSeq(Seq<A> prefix) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)seq -> TestTrace$.MODULE$.boolean(seq.startsWith((IterableOnce)prefix, seq.startsWith$default$2()), ErrorMessage$.MODULE$.pretty(seq).$plus(ErrorMessage$.MODULE$.did()).$plus("start with").$plus(ErrorMessage$.MODULE$.pretty(prefix))));
    }

    public TestArrow<String, Object> startsWithString(String prefix) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)string -> TestTrace$.MODULE$.boolean(string.startsWith(prefix), ErrorMessage$.MODULE$.value(string).$plus(ErrorMessage$.MODULE$.did()).$plus("start with").$plus(ErrorMessage$.MODULE$.value(prefix))));
    }

    public <A> TestArrow<Seq<A>, Object> endsWithSeq(Seq<A> postfix) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)seq -> TestTrace$.MODULE$.boolean(seq.endsWith((Iterable)postfix), ErrorMessage$.MODULE$.value(seq).$plus(ErrorMessage$.MODULE$.did()).$plus("end with").$plus(ErrorMessage$.MODULE$.value(seq))));
    }

    public TestArrow<String, Object> endsWithString(String postfix) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)string -> TestTrace$.MODULE$.boolean(string.endsWith(postfix), ErrorMessage$.MODULE$.value(string).$plus(ErrorMessage$.MODULE$.did()).$plus("end with").$plus(ErrorMessage$.MODULE$.value(postfix))));
    }

    private <A> String className(ClassTag<A> C) {
        String string;
        try {
            string = C.runtimeClass().getSimpleName();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof InternalError) {
                InternalError t = (InternalError)throwable2;
                String string2 = t.getMessage();
                String string3 = "Malformed class name";
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    string = C.runtimeClass().getName();
                }
            }
            throw throwable;
        }
        return string;
    }

    private <A> ErrorMessage className(Iterable<A> a) {
        return ErrorMessage$.MODULE$.value(StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(a.toString()), (Function1 & Serializable)_$9 -> this.className$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$9))));
    }

    private <A> ErrorMessage className(Option<A> a) {
        return ErrorMessage$.MODULE$.value(StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(a.toString()), (Function1 & Serializable)_$10 -> this.className$$anonfun$2(BoxesRunTime.unboxToChar((Object)_$10))));
    }

    private final Object hasAt$$anonfun$1$$anonfun$1(int index$1, Seq as$1) {
        return as$1.apply(index$1);
    }

    private final Object hasKey$$anonfun$1$$anonfun$1(Object key$1, Map mapKV$1) {
        return mapKV$1.apply(key$1);
    }

    /*
     * Unable to fully structure code
     */
    private final /* synthetic */ TestTrace equalTo$$anonfun$1(Object that$5, OptionalImplicit diff$1, Object a) {
        block5: {
            block4: {
                var5_4 = Tuple2$.MODULE$.apply(a, that$5);
                if (var5_4 == null) ** GOTO lbl-1000
                var6_5 = var5_4._1();
                var7_6 = var5_4._2();
                if (!ScalaRunTime$.MODULE$.isArray(var6_5, 1)) ** GOTO lbl-1000
                a = var6_5;
                if (ScalaRunTime$.MODULE$.isArray(var7_6, 1)) {
                    that = var7_6;
                    v0 = Predef$.MODULE$.genericWrapArray(a).sameElements((IterableOnce)Predef$.MODULE$.genericWrapArray(that));
                } else lbl-1000:
                // 3 sources

                {
                    v0 = BoxesRunTime.equals((Object)a, (Object)that$5) != false;
                }
                result = v0;
                var10_10 = diff$1.value();
                if (!(var10_10 instanceof Some) || (diff = (Diff)((Some)var10_10).value()).isLowPriority() || result) break block4;
                diffResult = diff.diff(that$5, a);
                var13_13 = diffResult;
                if (!(var13_13 instanceof DiffResult.Different)) ** GOTO lbl-1000
                var14_14 = DiffResult$Different$.MODULE$.unapply((DiffResult.Different)var13_13);
                var15_15 = var14_14._1();
                var16_16 = var14_14._2();
                var17_17 = var14_14._3();
                if (None$.MODULE$.equals(var17_17)) {
                    v1 = ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.equals()).$plus(ErrorMessage$.MODULE$.pretty(that$5));
                } else lbl-1000:
                // 2 sources

                {
                    diffResult = var13_13;
                    v1 = ErrorMessage$.MODULE$.choice("There was no difference", "There was a difference").$plus$plus(ErrorMessage$.MODULE$.custom(ConsoleUtils$.MODULE$.underlined("Expected"))).$plus$plus(ErrorMessage$.MODULE$.custom(PrettyPrint$.MODULE$.apply(that$5))).$plus$plus(ErrorMessage$.MODULE$.custom(new StringBuilder(0).append(ConsoleUtils$.MODULE$.underlined("Diff")).append(ansi.AnsiStringOps$.MODULE$.faint$extension(ansi$.MODULE$.AnsiStringOps(new StringBuilder(30).append(" ").append("\u001b[31m").append("-expected ").append("\u001b[32m").append("+obtained").toString()))).toString())).$plus$plus(ErrorMessage$.MODULE$.custom(new StringBuilder(4).append("\u001b[0m").append(diffResult.render()).toString()));
                }
                break block5;
            }
            v1 = ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.equals()).$plus(ErrorMessage$.MODULE$.pretty(that$5));
        }
        return TestTrace$.MODULE$.boolean(result, v1);
    }

    private final /* synthetic */ boolean className$$anonfun$1(char _$9) {
        return _$9 != '(';
    }

    private final /* synthetic */ boolean className$$anonfun$2(char _$10) {
        return _$10 != '(';
    }
}

