/*
 * Decompiled with CFR 0.152.
 */
package zio.test.render;

import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Vector;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import zio.Cause;
import zio.DurationOps$;
import zio.internal.ansi;
import zio.internal.ansi$;
import zio.test.ConsoleIO;
import zio.test.ConsoleIO$Input$;
import zio.test.ConsoleIO$Output$;
import zio.test.ConsoleUtils$;
import zio.test.ExecutionEvent;
import zio.test.ExecutionEvent$RuntimeFailure$;
import zio.test.ExecutionEvent$SectionEnd$;
import zio.test.ExecutionEvent$SectionStart$;
import zio.test.ExecutionEvent$Test$;
import zio.test.ExecutionEvent$TopLevelFlush$;
import zio.test.SuiteId;
import zio.test.Summary;
import zio.test.TestAnnotation$;
import zio.test.TestAnnotationMap;
import zio.test.TestAnnotationMap$;
import zio.test.TestAnnotationRenderer;
import zio.test.TestAnnotationRenderer$;
import zio.test.TestFailure;
import zio.test.TestFailure$Assertion$;
import zio.test.TestFailure$Runtime$;
import zio.test.TestResult;
import zio.test.TestSuccess;
import zio.test.TestSuccess$Ignored$;
import zio.test.TestSuccess$Succeeded$;
import zio.test.TestTrace;
import zio.test.render.ConsoleRenderer$;
import zio.test.render.ExecutionResult;
import zio.test.render.ExecutionResult$;
import zio.test.render.ExecutionResult$ResultType$Other$;
import zio.test.render.ExecutionResult$ResultType$Suite$;
import zio.test.render.ExecutionResult$ResultType$Test$;
import zio.test.render.ExecutionResult$Status$Failed$;
import zio.test.render.ExecutionResult$Status$Ignored$;
import zio.test.render.ExecutionResult$Status$Passed$;
import zio.test.render.LogLine;
import zio.test.render.LogLine$Fragment$;
import zio.test.render.LogLine$Fragment$Style$Ansi$;
import zio.test.render.LogLine$Fragment$Style$Bold$;
import zio.test.render.LogLine$Fragment$Style$Default$;
import zio.test.render.LogLine$Fragment$Style$Detail$;
import zio.test.render.LogLine$Fragment$Style$Dimmed$;
import zio.test.render.LogLine$Fragment$Style$Error$;
import zio.test.render.LogLine$Fragment$Style$Info$;
import zio.test.render.LogLine$Fragment$Style$Primary$;
import zio.test.render.LogLine$Fragment$Style$Underlined$;
import zio.test.render.LogLine$Fragment$Style$Warning$;
import zio.test.render.LogLine$Line$;
import zio.test.render.LogLine$Message$;
import zio.test.render.TestRenderer;
import zio.test.render.package$;

public interface ConsoleRenderer
extends TestRenderer {
    public static void $init$(ConsoleRenderer $this) {
        $this.zio$test$render$ConsoleRenderer$_setter_$zio$test$render$ConsoleRenderer$$tabSize_$eq(2);
    }

    public int zio$test$render$ConsoleRenderer$$tabSize();

    public void zio$test$render$ConsoleRenderer$_setter_$zio$test$render$ConsoleRenderer$$tabSize_$eq(int var1);

    public static Seq renderEvent$(ConsoleRenderer $this, ExecutionEvent event, boolean includeCause, Object trace) {
        return $this.renderEvent(event, includeCause, trace);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    default public Seq<ExecutionResult> renderEvent(ExecutionEvent event, boolean includeCause, Object trace) {
        ExecutionEvent executionEvent = event;
        if (executionEvent instanceof ExecutionEvent.TestStarted) {
            return scala.package$.MODULE$.Nil();
        }
        if (executionEvent instanceof ExecutionEvent.SectionStart) {
            ExecutionEvent.SectionStart sectionStart = ExecutionEvent$SectionStart$.MODULE$.unapply((ExecutionEvent.SectionStart)executionEvent);
            List<String> list = sectionStart._1();
            SuiteId suiteId = sectionStart._2();
            List<SuiteId> list2 = sectionStart._3();
            List<String> labelsReversed = list;
            int depth = labelsReversed.length() - 1;
            List list3 = labelsReversed.reverse();
            Nil$ nil$ = scala.package$.MODULE$.Nil();
            List list4 = list3;
            if (!(nil$ != null ? !nil$.equals(list4) : list4 != null)) {
                return (Seq)scala.package$.MODULE$.Seq().empty();
            }
            List nonEmptyList = list3;
            return (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ExecutionResult[]{ExecutionResult$.MODULE$.withoutSummarySpecificOutput(ExecutionResult$ResultType$Suite$.MODULE$, (String)nonEmptyList.last(), ExecutionResult$Status$Passed$.MODULE$, depth, (List<TestAnnotationMap>)((List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TestAnnotationMap[]{TestAnnotationMap$.MODULE$.empty()}))), (List<LogLine.Line>)((List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogLine.Line[]{package$.MODULE$.fr((String)nonEmptyList.last()).toLine()}))), (Option<Object>)None$.MODULE$)}));
        }
        if (executionEvent instanceof ExecutionEvent.Test) {
            ExecutionResult.Status status;
            ExecutionEvent.Test test = ExecutionEvent$Test$.MODULE$.unapply((ExecutionEvent.Test)executionEvent);
            List<String> list = test._1();
            Either either = test._2();
            TestAnnotationMap testAnnotationMap = test._3();
            List<SuiteId> list5 = test._4();
            long l = test._5();
            SuiteId suiteId = test._6();
            String string = test._7();
            List<String> labelsReversed = list;
            Either results = either;
            TestAnnotationMap annotations = testAnnotationMap;
            List labels = labelsReversed.reverse();
            int initialDepth = labels.length() - 1;
            Tuple2<List<LogLine.Line>, List<LogLine.Line>> tuple2 = this.testCaseOutput((List<String>)labels, results, includeCause, annotations, trace);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            List streamingOutput = (List)tuple2._1();
            List summaryOutput = (List)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)streamingOutput, (Object)summaryOutput);
            List streamingOutput2 = (List)tuple22._1();
            List summaryOutput2 = (List)tuple22._2();
            Seq$ seq$ = scala.package$.MODULE$.Seq();
            Object[] objectArray = new ExecutionResult[1];
            String string2 = (String)labels.headOption().getOrElse(ConsoleRenderer::renderEvent$$anonfun$1);
            Either either2 = results;
            if (either2 instanceof Left) {
                status = ExecutionResult$Status$Failed$.MODULE$;
            } else {
                TestSuccess testSuccess;
                if (!(either2 instanceof Right) || (testSuccess = (TestSuccess)((Right)either2).value()) == null) throw new MatchError(either2);
                TestSuccess value = testSuccess;
                TestSuccess testSuccess2 = value;
                if (testSuccess2 instanceof TestSuccess.Succeeded) {
                    TestSuccess.Succeeded succeeded = TestSuccess$Succeeded$.MODULE$.unapply((TestSuccess.Succeeded)testSuccess2);
                    TestAnnotationMap testAnnotationMap2 = succeeded._1();
                    status = ExecutionResult$Status$Passed$.MODULE$;
                } else {
                    if (!(testSuccess2 instanceof TestSuccess.Ignored)) throw new MatchError((Object)testSuccess2);
                    TestSuccess.Ignored ignored = TestSuccess$Ignored$.MODULE$.unapply((TestSuccess.Ignored)testSuccess2);
                    TestAnnotationMap testAnnotationMap3 = ignored._1();
                    status = ExecutionResult$Status$Ignored$.MODULE$;
                }
            }
            objectArray[0] = ExecutionResult$.MODULE$.apply(ExecutionResult$ResultType$Test$.MODULE$, string2, status, initialDepth, (List<TestAnnotationMap>)((List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TestAnnotationMap[]{annotations}))), (List<LogLine.Line>)streamingOutput2, (List<LogLine.Line>)summaryOutput2, (Option<Object>)None$.MODULE$);
            return (Seq)seq$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }
        if (executionEvent instanceof ExecutionEvent.RuntimeFailure) {
            ExecutionEvent.RuntimeFailure runtimeFailure = (ExecutionEvent.RuntimeFailure)executionEvent;
            ExecutionEvent.RuntimeFailure runtimeFailure2 = ExecutionEvent$RuntimeFailure$.MODULE$.unapply(runtimeFailure);
            SuiteId suiteId = runtimeFailure2._1();
            List<String> list = runtimeFailure2._2();
            TestFailure testFailure = runtimeFailure2._3();
            List<SuiteId> list6 = runtimeFailure2._4();
            TestFailure failure = testFailure;
            ExecutionEvent.RuntimeFailure runtimeFailure3 = runtimeFailure;
            int depth = event.labels().length();
            TestFailure testFailure2 = failure;
            if (testFailure2 instanceof TestFailure.Assertion) {
                TestFailure.Assertion assertion = TestFailure$Assertion$.MODULE$.unapply((TestFailure.Assertion)testFailure2);
                TestResult testResult = assertion._1();
                TestAnnotationMap testAnnotationMap = assertion._2();
                TestResult result = testResult;
                TestAnnotationMap annotations = testAnnotationMap;
                return (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ExecutionResult[]{this.renderAssertFailure(result, runtimeFailure3.labels(), depth, annotations)}));
            }
            if (!(testFailure2 instanceof TestFailure.Runtime)) throw new MatchError(testFailure2);
            TestFailure.Runtime runtime = TestFailure$Runtime$.MODULE$.unapply((TestFailure.Runtime)testFailure2);
            Cause cause = runtime._1();
            TestAnnotationMap testAnnotationMap = runtime._2();
            Cause cause2 = cause;
            TestAnnotationMap annotations = testAnnotationMap;
            return (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ExecutionResult[]{this.renderRuntimeCause(cause2, runtimeFailure3.labels(), depth, includeCause, trace)}));
        }
        if (executionEvent instanceof ExecutionEvent.SectionEnd) {
            ExecutionEvent.SectionEnd sectionEnd = ExecutionEvent$SectionEnd$.MODULE$.unapply((ExecutionEvent.SectionEnd)executionEvent);
            List<String> list = sectionEnd._1();
            SuiteId suiteId = sectionEnd._2();
            List<SuiteId> list7 = sectionEnd._3();
            return scala.package$.MODULE$.Nil();
        }
        if (!(executionEvent instanceof ExecutionEvent.TopLevelFlush)) throw new MatchError((Object)executionEvent);
        ExecutionEvent.TopLevelFlush topLevelFlush = ExecutionEvent$TopLevelFlush$.MODULE$.unapply((ExecutionEvent.TopLevelFlush)executionEvent);
        SuiteId suiteId = topLevelFlush._1();
        return scala.package$.MODULE$.Nil();
    }

    public static Seq renderOutput$(ConsoleRenderer $this, Seq results, Object trace) {
        return $this.renderOutput((Seq<ExecutionResult>)results, trace);
    }

    @Override
    default public Seq<String> renderOutput(Seq<ExecutionResult> results, Object trace) {
        return (Seq)results.map((Function1 & Serializable)result -> {
            LogLine.Message message;
            LogLine.Message message2 = LogLine$Message$.MODULE$.apply((Seq<LogLine.Line>)result.streamingLines()).intersperse(LogLine$Line$.MODULE$.fromString("\n", LogLine$Line$.MODULE$.fromString$default$2()));
            ExecutionResult.ResultType resultType = result.resultType();
            if (ExecutionResult$ResultType$Suite$.MODULE$.equals(resultType)) {
                message = this.renderSuite(result.status(), result.offset(), message2);
            } else if (ExecutionResult$ResultType$Test$.MODULE$.equals(resultType)) {
                message = this.renderTest(result.status(), result.offset(), message2);
            } else if (ExecutionResult$ResultType$Other$.MODULE$.equals(resultType)) {
                message = LogLine$Message$.MODULE$.apply((Seq<LogLine.Line>)result.streamingLines());
            } else {
                throw new MatchError((Object)resultType);
            }
            LogLine.Message output = message;
            return this.renderToStringLines(output).mkString();
        });
    }

    private LogLine.Message renderOutput(List<ConsoleIO> output) {
        if (output.isEmpty()) {
            return LogLine$Message$.MODULE$.empty();
        }
        LogLine.Line line = LogLine$Line$.MODULE$.fromString(ansi.AnsiStringOps$.MODULE$.underlined$extension(ansi$.MODULE$.AnsiStringOps(ansi.AnsiStringOps$.MODULE$.red$extension(ansi$.MODULE$.AnsiStringOps("          Console IO Produced by Test         ")))), 2);
        return LogLine$Message$.MODULE$.apply((Seq<LogLine.Line>)((Seq)((SeqOps)output.map((Function1 & Serializable)s -> LogLine$Line$.MODULE$.fromString(new StringBuilder(0).append(ansi.AnsiStringOps$.MODULE$.red$extension(ansi$.MODULE$.AnsiStringOps("| "))).append(this.renderConsoleIO((ConsoleIO)s)).toString(), 2)).$plus$colon((Object)line)).$colon$plus((Object)LogLine$Line$.MODULE$.fromString(ansi.AnsiStringOps$.MODULE$.red$extension(ansi$.MODULE$.AnsiStringOps("==============================================\n")), 2))));
    }

    private String renderConsoleIO(ConsoleIO s) {
        ConsoleIO consoleIO = s;
        if (consoleIO instanceof ConsoleIO.Input) {
            String string;
            ConsoleIO.Input input = ConsoleIO$Input$.MODULE$.unapply((ConsoleIO.Input)consoleIO);
            String line = string = input._1();
            return ansi.AnsiStringOps$.MODULE$.magenta$extension(ansi$.MODULE$.AnsiStringOps(line));
        }
        if (consoleIO instanceof ConsoleIO.Output) {
            String string;
            ConsoleIO.Output output = ConsoleIO$Output$.MODULE$.unapply((ConsoleIO.Output)consoleIO);
            String line = string = output._1();
            return ansi.AnsiStringOps$.MODULE$.yellow$extension(ansi$.MODULE$.AnsiStringOps(line));
        }
        throw new MatchError((Object)consoleIO);
    }

    public static Seq renderForSummary$(ConsoleRenderer $this, Seq results, TestAnnotationRenderer testAnnotationRenderer) {
        return $this.renderForSummary((Seq<ExecutionResult>)results, testAnnotationRenderer);
    }

    default public Seq<String> renderForSummary(Seq<ExecutionResult> results, TestAnnotationRenderer testAnnotationRenderer) {
        return (Seq)results.map((Function1 & Serializable)result -> {
            LogLine.Message message;
            List testOutput = result.annotations().flatMap((Function1 & Serializable)_$1 -> (IterableOnce)_$1.get(TestAnnotation$.MODULE$.output()));
            LogLine.Message renderedAnnotations = this.renderAnnotations(result.annotations(), testAnnotationRenderer);
            LogLine.Message message2 = LogLine$Message$.MODULE$.apply((Seq<LogLine.Line>)result.summaryLines()).$plus$plus(renderedAnnotations).$plus$plus(this.renderOutput((List<ConsoleIO>)testOutput)).intersperse(LogLine$Line$.MODULE$.fromString("\n", LogLine$Line$.MODULE$.fromString$default$2()));
            ExecutionResult.ResultType resultType = result.resultType();
            if (ExecutionResult$ResultType$Suite$.MODULE$.equals(resultType)) {
                message = this.renderSuite(result.status(), result.offset(), message2);
            } else if (ExecutionResult$ResultType$Test$.MODULE$.equals(resultType)) {
                message = this.renderTest(result.status(), result.offset(), message2);
            } else if (ExecutionResult$ResultType$Other$.MODULE$.equals(resultType)) {
                message = LogLine$Message$.MODULE$.apply((Seq<LogLine.Line>)result.streamingLines());
            } else {
                throw new MatchError((Object)resultType);
            }
            LogLine.Message output = message;
            return this.renderToStringLines(output).mkString();
        });
    }

    private LogLine.Message renderFailure(String label, int offset, TestTrace<Object> details, TestAnnotationMap annotations) {
        LogLine.Line line = this.renderFailureLabel(label, offset);
        return this.renderAnnotations((List<TestAnnotationMap>)((List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TestAnnotationMap[]{annotations}))), TestAnnotationRenderer$.MODULE$.default()).$plus$plus(this.renderAssertionResult(details, offset)).$plus$colon(line).$colon$plus(LogLine$Line$.MODULE$.empty());
    }

    private LogLine.Message renderSuite(ExecutionResult.Status status, int offset, LogLine.Message message) {
        ExecutionResult.Status status2 = status;
        if (ExecutionResult$Status$Passed$.MODULE$.equals(status2)) {
            LogLine.Line line = package$.MODULE$.withOffset(offset, package$.MODULE$.info("+").$plus(package$.MODULE$.sp()));
            return message.$plus$colon(line);
        }
        if (ExecutionResult$Status$Failed$.MODULE$.equals(status2)) {
            LogLine.Line line = package$.MODULE$.withOffset(offset, LogLine$Line$.MODULE$.empty());
            return message.$plus$colon(line);
        }
        if (ExecutionResult$Status$Ignored$.MODULE$.equals(status2)) {
            LogLine.Line line = package$.MODULE$.withOffset(offset, LogLine$Line$.MODULE$.empty());
            return message.$plus$colon(line).$colon$plus(package$.MODULE$.fr(new StringBuilder(9).append(" - ").append(TestAnnotation$.MODULE$.ignored().identifier()).append(" suite").toString()).toLine());
        }
        throw new MatchError((Object)status2);
    }

    private LogLine.Message renderTest(ExecutionResult.Status status, int offset, LogLine.Message message) {
        ExecutionResult.Status status2 = status;
        if (ExecutionResult$Status$Passed$.MODULE$.equals(status2)) {
            LogLine.Line line = package$.MODULE$.withOffset(offset, package$.MODULE$.info("+").$plus(package$.MODULE$.sp()));
            return message.$plus$colon(line);
        }
        if (ExecutionResult$Status$Ignored$.MODULE$.equals(status2)) {
            LogLine.Line line = package$.MODULE$.withOffset(offset, package$.MODULE$.warn("-").$plus(package$.MODULE$.sp()));
            return message.$plus$colon(line);
        }
        if (ExecutionResult$Status$Failed$.MODULE$.equals(status2)) {
            return message;
        }
        throw new MatchError((Object)status2);
    }

    public static Seq renderToStringLines$(ConsoleRenderer $this, LogLine.Message message) {
        return $this.renderToStringLines(message);
    }

    default public Seq<String> renderToStringLines(LogLine.Message message) {
        return (Seq)message.lines().map((Function1 & Serializable)line -> this.renderOffset(line.offset(), (String)line.optimized().fragments().foldLeft((Object)"", (Function2 & Serializable)(str, f) -> new StringBuilder(0).append((String)str).append(ConsoleRenderer.renderFragment$1(f)).toString())));
    }

    private LogLine.Message renderAnnotations(List<TestAnnotationMap> annotations, TestAnnotationRenderer annotationRenderer) {
        List<TestAnnotationMap> list = annotations;
        if (list instanceof .colon.colon) {
            TestAnnotationMap annotations2;
            .colon.colon colon2 = (.colon.colon)list;
            List list2 = colon2.next$access$1();
            List ancestors = list2;
            List<String> rendered = annotationRenderer.run((List<TestAnnotationMap>)ancestors, annotations2 = (TestAnnotationMap)colon2.head());
            if (rendered.isEmpty()) {
                return LogLine$Message$.MODULE$.empty();
            }
            return LogLine$Message$.MODULE$.apply(rendered.mkString(" - ", ", ", ""));
        }
        Nil$ nil$ = scala.package$.MODULE$.Nil();
        List<TestAnnotationMap> list3 = list;
        if (!(nil$ != null ? !nil$.equals(list3) : list3 != null)) {
            return LogLine$Message$.MODULE$.empty();
        }
        throw new MatchError(list);
    }

    private String renderOffset(int n, String s) {
        return new StringBuilder(0).append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), n * this.zio$test$render$ConsoleRenderer$$tabSize())).append(s).toString();
    }

    public static String renderSummary$(ConsoleRenderer $this, Summary summary) {
        return $this.renderSummary(summary);
    }

    @Override
    default public String renderSummary(Summary summary) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(84).append(summary.success()).append(" tests passed. ").append(summary.fail()).append(" tests failed. ").append(summary.ignore()).append(" tests ignored.\n       |").append(summary.failureDetails()).append("\n       |Executed in ").append(DurationOps$.MODULE$.render$extension(zio.package$.MODULE$.duration2DurationOps(summary.duration()))).append("\n       |").toString()));
    }

    public static Option render$(ConsoleRenderer $this, Cause cause, List labels) {
        return $this.render(cause, (List<String>)labels);
    }

    default public Option<String> render(Cause<?> cause, List<String> labels) {
        Cause<?> cause2 = cause;
        if (cause2 instanceof Cause.Interrupt) {
            Seq renderedInterruption = ConsoleRenderer$.MODULE$.renderToStringLines(LogLine$Message$.MODULE$.apply((Seq<LogLine.Line>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogLine.Line[]{LogLine$Line$.MODULE$.apply((Vector<LogLine.Fragment>)((Vector)scala.package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogLine.Fragment[]{LogLine$Fragment$.MODULE$.apply(labels.mkString(" - "), LogLine$Fragment$Style$Error$.MODULE$)}))), LogLine$Line$.MODULE$.$lessinit$greater$default$2())})))));
            return Some$.MODULE$.apply((Object)new StringBuilder(30).append("Interrupted during execution: ").append(renderedInterruption.mkString("\n")).toString());
        }
        return None$.MODULE$;
    }

    private static String renderEvent$$anonfun$1() {
        return "";
    }

    private static String renderFragment$1(LogLine.Fragment f) {
        LogLine.Fragment.Style style = f.style();
        if (LogLine$Fragment$Style$Default$.MODULE$.equals(style)) {
            return f.text();
        }
        if (LogLine$Fragment$Style$Primary$.MODULE$.equals(style)) {
            return ConsoleUtils$.MODULE$.blue(f.text());
        }
        if (LogLine$Fragment$Style$Warning$.MODULE$.equals(style)) {
            return ConsoleUtils$.MODULE$.yellow(f.text());
        }
        if (LogLine$Fragment$Style$Error$.MODULE$.equals(style)) {
            return ConsoleUtils$.MODULE$.red(f.text());
        }
        if (LogLine$Fragment$Style$Info$.MODULE$.equals(style)) {
            return ConsoleUtils$.MODULE$.green(f.text());
        }
        if (LogLine$Fragment$Style$Detail$.MODULE$.equals(style)) {
            return ConsoleUtils$.MODULE$.cyan(f.text());
        }
        if (LogLine$Fragment$Style$Dimmed$.MODULE$.equals(style)) {
            return ConsoleUtils$.MODULE$.dim(f.text());
        }
        if (style instanceof LogLine.Fragment.Style.Bold) {
            LogLine.Fragment fragment;
            LogLine.Fragment.Style.Bold bold = LogLine$Fragment$Style$Bold$.MODULE$.unapply((LogLine.Fragment.Style.Bold)style);
            LogLine.Fragment fr = fragment = bold._1();
            return ConsoleUtils$.MODULE$.bold(ConsoleRenderer.renderFragment$1(fr));
        }
        if (style instanceof LogLine.Fragment.Style.Underlined) {
            LogLine.Fragment fragment;
            LogLine.Fragment.Style.Underlined underlined = LogLine$Fragment$Style$Underlined$.MODULE$.unapply((LogLine.Fragment.Style.Underlined)style);
            LogLine.Fragment fr = fragment = underlined._1();
            return ConsoleUtils$.MODULE$.underlined(ConsoleRenderer.renderFragment$1(fr));
        }
        if (style instanceof LogLine.Fragment.Style.Ansi) {
            LogLine.Fragment.Style.Ansi ansi2 = LogLine$Fragment$Style$Ansi$.MODULE$.unapply((LogLine.Fragment.Style.Ansi)style);
            LogLine.Fragment fragment = ansi2._1();
            String string = ansi2._2();
            LogLine.Fragment fr = fragment;
            String ansiColor = string;
            return ConsoleUtils$.MODULE$.ansi(ansiColor, ConsoleRenderer.renderFragment$1(fr));
        }
        throw new MatchError((Object)style);
    }
}

