/*
 * Decompiled with CFR 0.152.
 */
package zio.test;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import zio.Chunk;
import zio.NonEmptyChunk;
import zio.NonEmptyChunk$;
import zio.internal.ansi;
import zio.internal.ansi$;
import zio.test.PrettyPrintVersionSpecific;

public final class PrettyPrint$
implements PrettyPrintVersionSpecific,
Serializable {
    private static final int maxListLength;
    public static final PrettyPrint$ MODULE$;

    private PrettyPrint$() {
    }

    static {
        MODULE$ = new PrettyPrint$();
        maxListLength = 10;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PrettyPrint$.class);
    }

    public String apply(Object any) {
        Object object = any;
        if (object instanceof NonEmptyChunk) {
            NonEmptyChunk nonEmptyChunk = (NonEmptyChunk)object;
            return this.prettyPrintIterator(NonEmptyChunk$.MODULE$.toChunk(nonEmptyChunk).iterator(), NonEmptyChunk$.MODULE$.toChunk(nonEmptyChunk).size(), "NonEmptyChunk");
        }
        if (object instanceof Chunk) {
            Chunk chunk = (Chunk)object;
            return this.prettyPrintIterator(chunk.iterator(), chunk.size(), "Chunk");
        }
        if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
            Object array = object;
            Object object2 = Predef$.MODULE$.genericArrayOps(array);
            return this.prettyPrintIterator(ArrayOps$.MODULE$.iterator$extension(object2), ScalaRunTime$.MODULE$.array_length(array), "Array");
        }
        if (object instanceof Some) {
            Object a = ((Some)object).value();
            return new StringBuilder(6).append("Some(").append(this.apply(a)).append(")").toString();
        }
        if (None$.MODULE$.equals(object)) {
            return "None";
        }
        Nil$ nil$ = package$.MODULE$.Nil();
        Object object3 = object;
        if (!(nil$ != null ? !nil$.equals(object3) : object3 != null)) {
            return "Nil";
        }
        if (object instanceof Set) {
            Set set = (Set)object;
            return this.prettyPrintIterator(set.iterator(), set.size(), this.className(set));
        }
        if (object instanceof Seq) {
            Seq iterable = (Seq)object;
            return this.prettyPrintIterator(iterable.iterator(), iterable.size(), this.className(iterable));
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            Iterable body = (Iterable)map.map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Object key = tuple2._1();
                    Object value = tuple2._2();
                    return new StringBuilder(4).append(this.apply(key)).append(" -> ").append(this.apply(value)).toString();
                }
                throw new MatchError((Object)tuple2);
            });
            return new StringBuilder(7).append("Map(\n").append(this.indent(body.mkString(",\n"), this.indent$default$2())).append("\n)").toString();
        }
        if (object instanceof Product) {
            Product product = (Product)object;
            String name = product.productPrefix();
            Iterator labels0 = this.labels(product);
            String body = labels0.zip((IterableOnce)product.productIterator()).map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    Object value = tuple2._2();
                    return new StringBuilder(1).append(ansi.AnsiStringOps$.MODULE$.faint$extension(ansi$.MODULE$.AnsiStringOps(new StringBuilder(2).append(key).append(" =").toString()))).append(" ").append(this.apply(value)).toString();
                }
                throw new MatchError((Object)tuple2);
            }).toList().mkString(",\n");
            boolean isMultiline = body.split("\n").length > 1;
            String indentedBody = this.indent(body, isMultiline ? 2 : 0);
            String spacer = isMultiline ? "\n" : "";
            return new StringBuilder(2).append(name).append("(").append(spacer).append(indentedBody).append(spacer).append(")").toString();
        }
        if (object instanceof String) {
            String string = (String)object;
            String surround = string.split("\n").length > 1 ? "\"\"\"" : "\"";
            return StringOps$.MODULE$.mkString$extension(Predef$.MODULE$.augmentString(string.replace("\"", "\\\"")), surround, "", surround);
        }
        if (object instanceof Character) {
            char c = BoxesRunTime.unboxToChar((Object)object);
            return new StringBuilder(2).append("'").append(BoxesRunTime.boxToCharacter((char)c).toString()).append("'").toString();
        }
        if (object == null) {
            return "<null>";
        }
        Object other = object;
        return other.toString();
    }

    private String prettyPrintIterator(Iterator<?> iterator, int length, String className) {
        String suffix = length > maxListLength ? new StringBuilder(9).append(" + ").append(length - maxListLength).append(" more)").toString() : ")";
        return iterator.take(maxListLength).map((Function1 & Serializable)any -> this.apply(any)).mkString(new StringBuilder(1).append(className).append("(").toString(), ", ", suffix);
    }

    private String indent(String string, int n) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])string.split("\n"));
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$1 -> new StringBuilder(0).append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), n)).append((String)_$1).toString(), ClassTag$.MODULE$.apply(String.class))).mkString("\n");
    }

    private int indent$default$2() {
        return 2;
    }

    private String className(Object any) {
        Object object = any;
        if (object instanceof List) {
            return "List";
        }
        Object other = object;
        return other.getClass().getSimpleName();
    }
}

