/*
 * Decompiled with CFR 0.152.
 */
package zio.test;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import zio.CanFail$;
import zio.IsSubtypeOfError$;
import zio.Unsafe$;
import zio.ZIO;
import zio.ZIO$;
import zio.internal.Platform$;
import zio.test.ExecutionEvent;
import zio.test.TestDebugFileLock;

public final class TestDebug$ {
    public static TestDebug$ MODULE$;
    private final String outputDirectory;
    private final Set<String> tasks;

    static {
        new TestDebug$();
    }

    private String outputDirectory() {
        return this.outputDirectory;
    }

    private String outputFileForTask(String task) {
        return new StringBuilder(11).append(this.outputDirectory()).append("/").append(task).append("_debug.txt").toString();
    }

    private Set<String> tasks() {
        return this.tasks;
    }

    private ZIO<Object, Nothing$, BoxedUnit> createDebugFile(String fullyQualifiedTaskName) {
        return ZIO$.MODULE$.succeed((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (MODULE$.tasks().add(fullyQualifiedTaskName)) {
                MODULE$.makeOutputDirectory();
                File file = new File(MODULE$.outputFileForTask(fullyQualifiedTaskName));
                if (file.exists()) {
                    file.delete();
                }
                file.createNewFile();
                return;
            }
        }, (Object)"zio.test.TestDebug.createDebugFile(TestDebug.scala:14)");
    }

    private Path makeOutputDirectory() {
        return Files.createDirectories(Paths.get(this.outputDirectory(), new String[0]).getParent(), new FileAttribute[0]);
    }

    public ZIO<Object, Nothing$, BoxedUnit> deleteIfEmpty(String fullyQualifiedTaskName) {
        return ZIO$.MODULE$.succeed((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (MODULE$.tasks().remove(fullyQualifiedTaskName)) {
                File file = new File(MODULE$.outputFileForTask(fullyQualifiedTaskName));
                if (file.exists()) {
                    BufferedSource source = Source$.MODULE$.fromFile(file, Codec$.MODULE$.fallbackSystemCodec());
                    List nonBlankLines = source.getLines().filterNot((Function1 & Serializable & scala.Serializable)input -> BoxesRunTime.boxToBoolean((boolean)TestDebug$.MODULE$.isBlank(input))).toList();
                    source.close();
                    if (nonBlankLines.isEmpty()) {
                        file.delete();
                        return;
                    }
                    return;
                }
                return;
            }
        }, (Object)"zio.test.TestDebug.deleteIfEmpty(TestDebug.scala:28)");
    }

    private boolean isBlank(String input) {
        return new ArrayOps.ofChar(Predef$.MODULE$.charArrayOps(input.toCharArray())).forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TestDebug$.$anonfun$isBlank$1(BoxesRunTime.unboxToChar((Object)x$1))));
    }

    public ZIO<Object, Nothing$, BoxedUnit> print(ExecutionEvent executionEvent, TestDebugFileLock lock) {
        if (executionEvent instanceof ExecutionEvent.TestStarted) {
            ExecutionEvent.TestStarted testStarted = (ExecutionEvent.TestStarted)executionEvent;
            return this.createDebugFile(testStarted.fullyQualifiedName()).$times$greater((Function0 & Serializable & scala.Serializable)() -> MODULE$.write(testStarted.fullyQualifiedName(), new StringBuilder(9).append(testStarted.labels().mkString(" - ")).append(" STARTED\n").toString(), true, lock), (Object)"zio.test.TestDebug.print(TestDebug.scala:48)");
        }
        if (executionEvent instanceof ExecutionEvent.Test) {
            ExecutionEvent.Test test = (ExecutionEvent.Test)executionEvent;
            return this.createDebugFile(test.fullyQualifiedName()).$times$greater((Function0 & Serializable & scala.Serializable)() -> MODULE$.removeLine(test.fullyQualifiedName(), new StringBuilder(8).append(test.labels().mkString(" - ")).append(" STARTED").toString(), lock), (Object)"zio.test.TestDebug.print(TestDebug.scala:52)");
        }
        return ZIO$.MODULE$.unit();
    }

    private ZIO<Object, Nothing$, BoxedUnit> write(String fullyQualifiedTaskName, String content, boolean append, TestDebugFileLock lock) {
        return lock.updateFile((ZIO<Object, Nothing$, BoxedUnit>)ZIO.Acquire$.MODULE$.apply$extension(ZIO$.MODULE$.acquireReleaseWith((Function0 & Serializable & scala.Serializable)() -> ZIO$.MODULE$.attemptBlockingIO((Function0 & Serializable & scala.Serializable)() -> new FileWriter(MODULE$.outputFileForTask(fullyQualifiedTaskName), append), (Object)"zio.test.TestDebug.write(TestDebug.scala:67)")), (Function1 & Serializable & scala.Serializable)f -> ZIO$.MODULE$.attemptBlocking((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> f.close(), (Object)"zio.test.TestDebug.write(TestDebug.scala:68)").orDie(IsSubtypeOfError$.MODULE$.impl(Predef$.MODULE$.$conforms()), CanFail$.MODULE$.canFail(), (Object)"zio.test.TestDebug.write(TestDebug.scala:68)")).apply((Function1 & Serializable & scala.Serializable)f -> ZIO$.MODULE$.attemptBlockingIO((Function0 & Serializable & scala.Serializable)() -> f.append(content), (Object)"zio.test.TestDebug.write(TestDebug.scala:69)"), (Object)"zio.test.TestDebug.write(TestDebug.scala:68)").ignore((Object)"zio.test.TestDebug.write(TestDebug.scala:71)"));
    }

    private ZIO<Object, Nothing$, BoxedUnit> removeLine(String fullyQualifiedTaskName, String searchString, TestDebugFileLock lock) {
        return lock.updateFile((ZIO<Object, Nothing$, BoxedUnit>)ZIO$.MODULE$.succeed((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            File file = new File(MODULE$.outputFileForTask(fullyQualifiedTaskName));
            if (file.exists()) {
                BufferedSource source = Source$.MODULE$.fromFile(file, Codec$.MODULE$.fallbackSystemCodec());
                List remainingLines = source.getLines().filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.contains(searchString))).toList();
                PrintWriter pw = new PrintWriter(MODULE$.outputFileForTask(fullyQualifiedTaskName));
                pw.write(new StringBuilder(1).append(remainingLines.mkString("\n")).append("\n").toString());
                pw.close();
                source.close();
                return;
            }
        }, (Object)"zio.test.TestDebug.removeLine(TestDebug.scala:76)"));
    }

    public static final /* synthetic */ boolean $anonfun$isBlank$1(char x$1) {
        return Character.isWhitespace(x$1);
    }

    private TestDebug$() {
        MODULE$ = this;
        this.outputDirectory = "target/test-reports-zio";
        this.tasks = Platform$.MODULE$.newConcurrentSet(Unsafe$.MODULE$.unsafe());
    }
}

