/*
 * Decompiled with CFR 0.152.
 */
package zio.test.internal;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.math.Integral;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import zio.Cause;
import zio.Exit;
import zio.test.ConsoleUtils$;
import zio.test.CustomAssertion;
import zio.test.ErrorMessage;
import zio.test.ErrorMessage$;
import zio.test.Result$;
import zio.test.TestArrow;
import zio.test.TestArrow$;
import zio.test.Trace;
import zio.test.Trace$;
import zio.test.Trace$Node$;
import zio.test.diff.Diff;
import zio.test.internal.OptionalImplicit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class SmartAssertions$ {
    public static SmartAssertions$ MODULE$;
    private final TestArrow<Object, Throwable> throws;

    static {
        new SmartAssertions$();
    }

    public TestArrow<Object, Object> anything() {
        return TestArrow$.MODULE$.make((Function1 & Serializable & scala.Serializable)x$1 -> Trace$.MODULE$.succeed(BoxesRunTime.boxToBoolean((boolean)true)));
    }

    public <A, B> TestArrow<A, B> custom(CustomAssertion<A, B> customAssertion) {
        return TestArrow$.MODULE$.make((Function1 & Serializable & scala.Serializable)a -> {
            Either either = (Either)customAssertion.run().apply(a);
            if (either instanceof Left) {
                String error = (String)((Left)either).value();
                return Trace$.MODULE$.fail(error);
            }
            if (either instanceof Right) {
                Object value = ((Right)either).value();
                return Trace$.MODULE$.succeed(value);
            }
            throw new MatchError((Object)either);
        });
    }

    public <A> TestArrow<Option<A>, A> isSome() {
        return TestArrow$.MODULE$.make((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 instanceof Some) {
                Object value = ((Some)x0$1).value();
                return Trace$.MODULE$.succeed(value);
            }
            if (None$.MODULE$.equals(x0$1)) {
                return Trace$.MODULE$.fail("Option was None");
            }
            throw new MatchError(x0$1);
        });
    }

    public <A> TestArrow<Either<?, A>, A> asRight() {
        return TestArrow$.MODULE$.make((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 instanceof Right) {
                Object value = ((Right)x0$1).value();
                return Trace$.MODULE$.succeed(value);
            }
            if (x0$1 instanceof Left) {
                return Trace$.MODULE$.fail("Either was Left");
            }
            throw new MatchError(x0$1);
        });
    }

    public <A> TestArrow<Either<A, ?>, A> asLeft() {
        return TestArrow$.MODULE$.make((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 instanceof Left) {
                Object value = ((Left)x0$1).value();
                return Trace$.MODULE$.succeed(value);
            }
            if (x0$1 instanceof Right) {
                return Trace$.MODULE$.fail("Either was Right");
            }
            throw new MatchError(x0$1);
        });
    }

    public <A> TestArrow<Iterable<A>, Object> isEmptyIterable() {
        return TestArrow$.MODULE$.make((Function1 & Serializable & scala.Serializable)as -> Trace$.MODULE$.boolean(as.isEmpty(), MODULE$.className((Iterable)as).$plus(ErrorMessage$.MODULE$.was()).$plus("empty").$plus(ErrorMessage$.MODULE$.text(new StringBuilder(7).append("(size ").append(as.size()).append(")").toString()))));
    }

    public <A> TestArrow<Iterable<A>, Object> isNonEmptyIterable() {
        return TestArrow$.MODULE$.make((Function1 & Serializable & scala.Serializable)as -> Trace$.MODULE$.boolean(as.nonEmpty(), MODULE$.className((Iterable)as).$plus(ErrorMessage$.MODULE$.choice("was not", "was")).$plus("empty")));
    }

    public <A> TestArrow<Option<A>, Object> isEmptyOption() {
        return TestArrow$.MODULE$.make((Function1 & Serializable & scala.Serializable)option -> Trace$.MODULE$.boolean(option.isEmpty(), MODULE$.className((Option)option).$plus(ErrorMessage$.MODULE$.was()).$plus("empty")));
    }

    public <A> TestArrow<Option<A>, Object> isDefinedOption() {
        return TestArrow$.MODULE$.make((Function1 & Serializable & scala.Serializable)option -> Trace$.MODULE$.boolean(option.isDefined(), MODULE$.className((Option)option).$plus(ErrorMessage$.MODULE$.was()).$plus("defined")));
    }

    public <A> TestArrow<Iterable<A>, Object> forallIterable(TestArrow<A, Object> predicate) {
        return TestArrow$.MODULE$.make((Function1 & Serializable & scala.Serializable)seq -> {
            Iterable failures = (Iterable)((Iterable)seq.map((Function1 & Serializable & scala.Serializable)a -> TestArrow$.MODULE$.run(predicate, package$.MODULE$.Right().apply(a)), Iterable$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isFailure()));
            String elements = failures.size() == 1 ? "element" : "elements";
            return new Trace.Node<Boolean>(Result$.MODULE$.succeed(BoxesRunTime.boxToBoolean((boolean)failures.isEmpty())), ErrorMessage$.MODULE$.value(BoxesRunTime.boxToInteger((int)failures.size())).$plus(ErrorMessage$.MODULE$.choice(new StringBuilder(21).append(elements).append(" failed the predicate").toString(), new StringBuilder(21).append(elements).append(" failed the predicate").toString())), (Option<Trace<Object>>)(failures.isEmpty() ? None$.MODULE$ : new Some(failures.reduce((Function2 & Serializable & scala.Serializable)(x$3, x$4) -> x$3.$amp$amp((Trace<Object>)x$4, Predef$.MODULE$.$conforms())))), Trace$Node$.MODULE$.apply$default$4(), Trace$Node$.MODULE$.apply$default$5(), Trace$Node$.MODULE$.apply$default$6(), Trace$Node$.MODULE$.apply$default$7(), Trace$Node$.MODULE$.apply$default$8());
        });
    }

    public <A> TestArrow<Iterable<A>, Object> existsIterable(TestArrow<A, Object> predicate) {
        return TestArrow$.MODULE$.make((Function1 & Serializable & scala.Serializable)seq -> {
            Iterable successes = (Iterable)((Iterable)seq.map((Function1 & Serializable & scala.Serializable)a -> TestArrow$.MODULE$.run(predicate, package$.MODULE$.Right().apply(a)), Iterable$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isSuccess()));
            String elements = successes.size() == 1 ? "element" : "elements";
            return new Trace.Node<Boolean>(Result$.MODULE$.succeed(BoxesRunTime.boxToBoolean((boolean)successes.nonEmpty())), ErrorMessage$.MODULE$.value(BoxesRunTime.boxToInteger((int)successes.size())).$plus(ErrorMessage$.MODULE$.choice(new StringBuilder(24).append(elements).append(" satisfied the predicate").toString(), new StringBuilder(24).append(elements).append(" satisfied the predicate").toString())), (Option<Trace<Object>>)(successes.isEmpty() ? None$.MODULE$ : new Some(successes.reduce((Function2 & Serializable & scala.Serializable)(x$6, x$7) -> x$6.$amp$amp((Trace<Object>)x$7, Predef$.MODULE$.$conforms())))), Trace$Node$.MODULE$.apply$default$4(), Trace$Node$.MODULE$.apply$default$5(), Trace$Node$.MODULE$.apply$default$6(), Trace$Node$.MODULE$.apply$default$7(), Trace$Node$.MODULE$.apply$default$8());
        });
    }

    public <A> TestArrow<Seq<A>, Object> containsSeq(A value) {
        return TestArrow$.MODULE$.make((Function1 & Serializable & scala.Serializable)seq -> Trace$.MODULE$.boolean(seq.contains(value), MODULE$.className((Iterable)seq).$plus(ErrorMessage$.MODULE$.did()).$plus("contain").$plus(ErrorMessage$.MODULE$.pretty(value))));
    }

    public <A> TestArrow<Option<A>, Object> containsOption(A value) {
        return TestArrow$.MODULE$.make((Function1 & Serializable & scala.Serializable)option -> Trace$.MODULE$.boolean(option.contains(value), MODULE$.className((Option)option).$plus(ErrorMessage$.MODULE$.did()).$plus("contain").$plus(ErrorMessage$.MODULE$.pretty(value))));
    }

    public TestArrow<String, Object> containsString(String value) {
        return TestArrow$.MODULE$.make((Function1 & Serializable & scala.Serializable)str -> Trace$.MODULE$.boolean(str.contains(value), ErrorMessage$.MODULE$.pretty(str).$plus(ErrorMessage$.MODULE$.did()).$plus("contain").$plus(ErrorMessage$.MODULE$.pretty(value))));
    }

    public <A> TestArrow<Seq<A>, A> hasAt(int index) {
        return TestArrow$.MODULE$.make((Function1 & Serializable & scala.Serializable)as -> {
            Option option = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> as.apply(index)).toOption();
            if (option instanceof Some) {
                Object value = ((Some)option).value();
                return Trace$.MODULE$.succeed(value);
            }
            if (None$.MODULE$.equals(option)) {
                return Trace$.MODULE$.fail(ErrorMessage$.MODULE$.text("Invalid index").$plus(ErrorMessage$.MODULE$.value(BoxesRunTime.boxToInteger((int)index))).$plus("for").$plus(MODULE$.className((Iterable)as)).$plus("of size").$plus(ErrorMessage$.MODULE$.value(BoxesRunTime.boxToInteger((int)as.length()))));
            }
            throw new MatchError((Object)option);
        });
    }

    public <K, V> TestArrow<Map<K, V>, V> hasKey(K key) {
        return TestArrow$.MODULE$.make((Function1 & Serializable & scala.Serializable)mapKV -> {
            Option option = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> mapKV.apply(key)).toOption();
            if (option instanceof Some) {
                Object value = ((Some)option).value();
                return Trace$.MODULE$.succeed(value);
            }
            if (None$.MODULE$.equals(option)) {
                return Trace$.MODULE$.fail(ErrorMessage$.MODULE$.text("Missing key").$plus(ErrorMessage$.MODULE$.pretty(key)));
            }
            throw new MatchError((Object)option);
        });
    }

    public <A> TestArrow<Iterable<A>, A> head() {
        return TestArrow$.MODULE$.make((Function1 & Serializable & scala.Serializable)as -> {
            Option option = as.headOption();
            if (option instanceof Some) {
                Object value = ((Some)option).value();
                return Trace$.MODULE$.succeed(value);
            }
            if (None$.MODULE$.equals(option)) {
                return Trace$.MODULE$.fail(MODULE$.className((Iterable)as).$plus("was empty"));
            }
            throw new MatchError((Object)option);
        });
    }

    public <A> TestArrow<A, Object> isEven(Integral<A> integral) {
        return TestArrow$.MODULE$.make((Function1 & Serializable & scala.Serializable)a -> Trace$.MODULE$.boolean(BoxesRunTime.equals((Object)integral.rem(a, integral.fromInt(2)), (Object)integral.fromInt(0)), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("even")));
    }

    public <A> TestArrow<A, Object> isOdd(Integral<A> integral) {
        return TestArrow$.MODULE$.make((Function1 & Serializable & scala.Serializable)a -> Trace$.MODULE$.boolean(BoxesRunTime.equals((Object)integral.rem(a, integral.fromInt(2)), (Object)integral.fromInt(1)), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("odd")));
    }

    public <A> TestArrow<A, Object> greaterThan(A that, Ordering<A> ordering) {
        return TestArrow$.MODULE$.make((Function1 & Serializable & scala.Serializable)a -> Trace$.MODULE$.boolean(ordering.gt(a, that), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("greater than").$plus(ErrorMessage$.MODULE$.pretty(that))));
    }

    public <A> TestArrow<A, Object> greaterThanOrEqualTo(A that, Ordering<A> ordering) {
        return TestArrow$.MODULE$.make((Function1 & Serializable & scala.Serializable)a -> Trace$.MODULE$.boolean(ordering.gteq(a, that), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("greater than or equal to").$plus(ErrorMessage$.MODULE$.pretty(that))));
    }

    public <A> TestArrow<A, Object> lessThan(A that, Ordering<A> ordering) {
        return TestArrow$.MODULE$.make((Function1 & Serializable & scala.Serializable)a -> Trace$.MODULE$.boolean(ordering.lt(a, that), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("less than").$plus(ErrorMessage$.MODULE$.pretty(that))));
    }

    public <A> TestArrow<A, Object> lessThanOrEqualTo(A that, Ordering<A> ordering) {
        return TestArrow$.MODULE$.make((Function1 & Serializable & scala.Serializable)a -> Trace$.MODULE$.boolean(ordering.lteq(a, that), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("less than or equal to").$plus(ErrorMessage$.MODULE$.pretty(that))));
    }

    public <A> TestArrow<A, Object> equalTo(A that, OptionalImplicit<Diff<A>> diff) {
        return TestArrow$.MODULE$.make((Function1 & Serializable & scala.Serializable)a -> {
            Diff diff;
            boolean result = ScalaRunTime$.MODULE$.isArray(a, 1) && ScalaRunTime$.MODULE$.isArray(that, 1) ? Predef$.MODULE$.genericArrayOps(a).sameElements((GenIterable)Predef$.MODULE$.genericWrapArray(that)) : BoxesRunTime.equals((Object)a, (Object)that);
            Option option = diff.value();
            return Trace$.MODULE$.boolean(result, option instanceof Some && !(diff = (Diff)((Some)option).value()).isLowPriority() && !result ? ErrorMessage$.MODULE$.custom(ConsoleUtils$.MODULE$.underlined("Expected")).$plus("\n").$plus$div(ErrorMessage$.MODULE$.pretty(that)).$plus("\n").$plus$div(ErrorMessage$.MODULE$.custom(ConsoleUtils$.MODULE$.underlined("Diff"))).$plus("\n").$plus$div(ErrorMessage$.MODULE$.custom(ConsoleUtils$.MODULE$.red(diff.diff(that, a).render()))) : ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.equals()).$plus(ErrorMessage$.MODULE$.pretty(that)));
        });
    }

    public <E> TestArrow<Cause<E>, Throwable> asCauseDie() {
        return TestArrow$.MODULE$.make((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1.dieOption().isDefined()) {
                return Trace$.MODULE$.succeed(x0$1.dieOption().get());
            }
            return Trace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Cause").$plus(ErrorMessage$.MODULE$.did()).$plus("contain a").$plus(ErrorMessage$.MODULE$.value("Die")));
        });
    }

    public <E> TestArrow<Cause<E>, E> asCauseFailure() {
        return TestArrow$.MODULE$.make((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1.failureOption().isDefined()) {
                return Trace$.MODULE$.succeed(x0$1.failureOption().get());
            }
            return Trace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Cause").$plus(ErrorMessage$.MODULE$.did()).$plus("contain a").$plus(ErrorMessage$.MODULE$.value("Fail")));
        });
    }

    public <E> TestArrow<Cause<E>, Object> asCauseInterrupted() {
        return TestArrow$.MODULE$.make((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1.interrupted()) {
                return Trace$.MODULE$.succeed(BoxesRunTime.boxToBoolean((boolean)true));
            }
            return Trace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Cause").$plus(ErrorMessage$.MODULE$.did()).$plus("contain a").$plus(ErrorMessage$.MODULE$.value("Interrupt")));
        });
    }

    public <E, A> TestArrow<Exit<E, A>, Throwable> asExitDie() {
        return TestArrow$.MODULE$.make((Function1 & Serializable & scala.Serializable)x0$1 -> {
            boolean bl = false;
            if (x0$1 instanceof Exit.Failure) {
                bl = true;
                Cause cause = ((Exit.Failure)x0$1).cause();
                if (cause.dieOption().isDefined()) {
                    return Trace$.MODULE$.succeed(cause.dieOption().get());
                }
            }
            if (x0$1 instanceof Exit.Success) {
                return Trace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Exit.Success").$plus(ErrorMessage$.MODULE$.was()).$plus("a").$plus(ErrorMessage$.MODULE$.value("Cause.Die")));
            }
            if (bl) {
                return Trace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Exit.Failure").$plus(ErrorMessage$.MODULE$.did()).$plus("contain a").$plus(ErrorMessage$.MODULE$.value("Cause.Die")));
            }
            throw new MatchError(x0$1);
        });
    }

    public <E, A> TestArrow<Exit<E, A>, Cause<E>> asExitCause() {
        return TestArrow$.MODULE$.make((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 instanceof Exit.Failure) {
                Cause cause = ((Exit.Failure)x0$1).cause();
                return Trace$.MODULE$.succeed(cause);
            }
            if (x0$1 instanceof Exit.Success) {
                return Trace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Exit.Success").$plus(ErrorMessage$.MODULE$.did()).$plus("contain a").$plus(ErrorMessage$.MODULE$.value("Cause")));
            }
            throw new MatchError(x0$1);
        });
    }

    public <E, A> TestArrow<Exit<E, A>, E> asExitFailure() {
        return TestArrow$.MODULE$.make((Function1 & Serializable & scala.Serializable)x0$1 -> {
            boolean bl = false;
            if (x0$1 instanceof Exit.Failure) {
                bl = true;
                Cause cause = ((Exit.Failure)x0$1).cause();
                if (cause.failureOption().isDefined()) {
                    return Trace$.MODULE$.succeed(cause.failureOption().get());
                }
            }
            if (x0$1 instanceof Exit.Success) {
                return Trace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Exit.Success").$plus(ErrorMessage$.MODULE$.was()).$plus("a").$plus(ErrorMessage$.MODULE$.value("Failure")));
            }
            if (bl) {
                return Trace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Exit.Failure").$plus(ErrorMessage$.MODULE$.did()).$plus("contain a").$plus(ErrorMessage$.MODULE$.value("Cause.Fail")));
            }
            throw new MatchError(x0$1);
        });
    }

    public <E, A> TestArrow<Exit<E, A>, Object> asExitInterrupted() {
        return TestArrow$.MODULE$.make((Function1 & Serializable & scala.Serializable)x0$1 -> {
            boolean bl = false;
            if (x0$1 instanceof Exit.Failure) {
                bl = true;
                if (((Exit.Failure)x0$1).cause().interrupted()) {
                    return Trace$.MODULE$.succeed(BoxesRunTime.boxToBoolean((boolean)true));
                }
            }
            if (x0$1 instanceof Exit.Success) {
                return Trace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Exit.Success").$plus(ErrorMessage$.MODULE$.was()).$plus("interrupted"));
            }
            if (bl) {
                return Trace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Exit.Failure").$plus(ErrorMessage$.MODULE$.did()).$plus("contain a").$plus(ErrorMessage$.MODULE$.value("Cause.Interrupt")));
            }
            throw new MatchError(x0$1);
        });
    }

    public <E, A> TestArrow<Exit<E, A>, A> asExitSuccess() {
        return TestArrow$.MODULE$.make((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 instanceof Exit.Success) {
                Object value = ((Exit.Success)x0$1).value();
                return Trace$.MODULE$.succeed(value);
            }
            if (x0$1 instanceof Exit.Failure) {
                return Trace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Exit").$plus(ErrorMessage$.MODULE$.was()).$plus("a").$plus(ErrorMessage$.MODULE$.value("Success")));
            }
            throw new MatchError(x0$1);
        });
    }

    public TestArrow<Object, Throwable> throws() {
        return this.throws;
    }

    public <A, B> TestArrow<A, B> as(ClassTag<B> CB) {
        return TestArrow$.MODULE$.make((Function1 & Serializable & scala.Serializable)a -> {
            Option option = CB.unapply(a);
            if (option instanceof Some) {
                Object value = ((Some)option).value();
                return Trace$.MODULE$.succeed(value);
            }
            if (None$.MODULE$.equals(option)) {
                return Trace$.MODULE$.fail(ErrorMessage$.MODULE$.value(a.getClass().getSimpleName()).$plus("is not an instance of").$plus(ErrorMessage$.MODULE$.value(MODULE$.className(CB))));
            }
            throw new MatchError((Object)option);
        });
    }

    public <A, B> TestArrow<A, Object> is(ClassTag<B> CB) {
        return TestArrow$.MODULE$.make((Function1 & Serializable & scala.Serializable)a -> Trace$.MODULE$.boolean(CB.unapply(a).isDefined(), ErrorMessage$.MODULE$.value(a.getClass().getSimpleName()).$plus(ErrorMessage$.MODULE$.is()).$plus("an instance of").$plus(ErrorMessage$.MODULE$.value(MODULE$.className(CB)))));
    }

    private <A> String className(ClassTag<A> C) {
        try {
            return C.runtimeClass().getSimpleName();
        }
        catch (Throwable throwable) {
            if (throwable instanceof InternalError) {
                String string = ((InternalError)throwable).getMessage();
                String string2 = "Malformed class name";
                if (string != null && string.equals(string2)) {
                    return C.runtimeClass().getName();
                }
            }
            throw throwable;
        }
    }

    private <A> ErrorMessage className(Iterable<A> a) {
        return ErrorMessage$.MODULE$.value(new StringOps(Predef$.MODULE$.augmentString(a.toString())).takeWhile((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)SmartAssertions$.$anonfun$className$1(BoxesRunTime.unboxToChar((Object)x$9)))));
    }

    private <A> ErrorMessage className(Option<A> a) {
        return ErrorMessage$.MODULE$.value(new StringOps(Predef$.MODULE$.augmentString(a.toString())).takeWhile((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)SmartAssertions$.$anonfun$className$2(BoxesRunTime.unboxToChar((Object)x$10)))));
    }

    public static final /* synthetic */ boolean $anonfun$className$1(char x$9) {
        return x$9 != '(';
    }

    public static final /* synthetic */ boolean $anonfun$className$2(char x$10) {
        return x$10 != '(';
    }

    private SmartAssertions$() {
        MODULE$ = this;
        this.throws = TestArrow$.MODULE$.makeEither((Function1 & Serializable & scala.Serializable)value -> Trace$.MODULE$.succeed(value), (Function1 & Serializable & scala.Serializable)x$8 -> Trace$.MODULE$.fail("Expected failure"));
    }
}

