/*
 * Decompiled with CFR 0.152.
 */
package zio;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import scala.Array$;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Vector;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import zio.Chunk;
import zio.Chunk$Empty$;
import zio.Chunk$Tags$;
import zio.ChunkBuilder;
import zio.ChunkBuilder$;

public final class Chunk$ {
    public static Chunk$ MODULE$;
    private final Chunk<Nothing$> empty;
    private final Chunk<BoxedUnit> unit;
    private final int zio$Chunk$$BufferSize;

    static {
        new Chunk$();
    }

    public Chunk<Nothing$> empty() {
        return this.empty;
    }

    public <A> Chunk<A> apply(Seq<A> as) {
        return this.fromIterable((Iterable<A>)as);
    }

    public <A> Chunk<A> fromArray(Object array) {
        Chunk<Nothing$> chunk;
        if (Predef$.MODULE$.genericArrayOps(array).isEmpty()) {
            chunk = Chunk$Empty$.MODULE$;
        } else {
            Chunk.Arr arr;
            if (array instanceof Object[]) {
                Object[] objectArray = (Object[])array;
                arr = new Chunk.AnyRefArray<Object>(objectArray);
            } else if (array instanceof int[]) {
                int[] nArray = (int[])array;
                arr = new Chunk.IntArray(nArray);
            } else if (array instanceof double[]) {
                double[] dArray = (double[])array;
                arr = new Chunk.DoubleArray(dArray);
            } else if (array instanceof long[]) {
                long[] lArray = (long[])array;
                arr = new Chunk.LongArray(lArray);
            } else if (array instanceof float[]) {
                float[] fArray = (float[])array;
                arr = new Chunk.FloatArray(fArray);
            } else if (array instanceof char[]) {
                char[] cArray = (char[])array;
                arr = new Chunk.CharArray(cArray);
            } else if (array instanceof byte[]) {
                byte[] byArray = (byte[])array;
                arr = new Chunk.ByteArray(byArray);
            } else if (array instanceof short[]) {
                short[] sArray = (short[])array;
                arr = new Chunk.ShortArray(sArray);
            } else if (array instanceof boolean[]) {
                boolean[] blArray = (boolean[])array;
                arr = new Chunk.BooleanArray(blArray);
            } else {
                throw new MatchError(array);
            }
            chunk = arr;
        }
        return chunk;
    }

    public Chunk<Object> fromByteBuffer(ByteBuffer buffer) {
        byte[] dest = (byte[])Array$.MODULE$.ofDim(buffer.remaining(), ClassTag$.MODULE$.Byte());
        int pos = buffer.position();
        buffer.get(dest);
        buffer.position(pos);
        return this.fromArray(dest);
    }

    public Chunk<Object> fromCharBuffer(CharBuffer buffer) {
        char[] dest = (char[])Array$.MODULE$.ofDim(buffer.remaining(), ClassTag$.MODULE$.Char());
        int pos = buffer.position();
        buffer.get(dest);
        buffer.position(pos);
        return this.fromArray(dest);
    }

    public Chunk<Object> fromDoubleBuffer(DoubleBuffer buffer) {
        double[] dest = (double[])Array$.MODULE$.ofDim(buffer.remaining(), ClassTag$.MODULE$.Double());
        int pos = buffer.position();
        buffer.get(dest);
        buffer.position(pos);
        return this.fromArray(dest);
    }

    public Chunk<Object> fromFloatBuffer(FloatBuffer buffer) {
        float[] dest = (float[])Array$.MODULE$.ofDim(buffer.remaining(), ClassTag$.MODULE$.Float());
        int pos = buffer.position();
        buffer.get(dest);
        buffer.position(pos);
        return this.fromArray(dest);
    }

    public Chunk<Object> fromIntBuffer(IntBuffer buffer) {
        int[] dest = (int[])Array$.MODULE$.ofDim(buffer.remaining(), ClassTag$.MODULE$.Int());
        int pos = buffer.position();
        buffer.get(dest);
        buffer.position(pos);
        return this.fromArray(dest);
    }

    public Chunk<Object> fromLongBuffer(LongBuffer buffer) {
        long[] dest = (long[])Array$.MODULE$.ofDim(buffer.remaining(), ClassTag$.MODULE$.Long());
        int pos = buffer.position();
        buffer.get(dest);
        buffer.position(pos);
        return this.fromArray(dest);
    }

    public Chunk<Object> fromShortBuffer(ShortBuffer buffer) {
        short[] dest = (short[])Array$.MODULE$.ofDim(buffer.remaining(), ClassTag$.MODULE$.Short());
        int pos = buffer.position();
        buffer.get(dest);
        buffer.position(pos);
        return this.fromArray(dest);
    }

    public <A> Chunk<A> fromIterable(Iterable<A> it) {
        Chunk chunk;
        if (it instanceof Chunk) {
            chunk = (Chunk.VectorChunk)it;
        } else if (it.isEmpty()) {
            chunk = Chunk$Empty$.MODULE$;
        } else if (it instanceof Vector) {
            Vector vector = (Vector)it;
            chunk = new Chunk.VectorChunk(vector);
        } else {
            Object first = it.head();
            ClassTag<Object> A = Chunk$Tags$.MODULE$.fromValue(first);
            chunk = this.fromArray(it.toArray(A));
        }
        return chunk;
    }

    public <A> Chunk<A> fill(int n, Function0<A> elem) {
        if (n <= 0) {
            return this.empty();
        }
        ChunkBuilder builder = ChunkBuilder$.MODULE$.make();
        builder.sizeHint(n);
        for (int i = 0; i < n; ++i) {
            builder.$plus$eq(elem.apply());
        }
        return (Chunk)builder.result();
    }

    public <A> Chunk<A> single(A a) {
        return new Chunk.Singleton<A>(a);
    }

    public <A> Chunk<A> succeed(A a) {
        return this.single(a);
    }

    public Chunk<BoxedUnit> unit() {
        return this.unit;
    }

    public <A> ClassTag<A> classTagOf(Chunk<A> chunk) {
        ClassTag classTag;
        if (chunk instanceof Chunk.AppendN) {
            classTag = ((Chunk.AppendN)chunk).classTag();
        } else if (chunk instanceof Chunk.Arr) {
            classTag = ((Chunk.Arr)chunk).classTag();
        } else if (chunk instanceof Chunk.Concat) {
            classTag = ((Chunk.Concat)chunk).classTag();
        } else if (((Object)Chunk$Empty$.MODULE$).equals(chunk)) {
            classTag = package$.MODULE$.classTag(ClassTag$.MODULE$.Object());
        } else if (chunk instanceof Chunk.PrependN) {
            classTag = ((Chunk.PrependN)chunk).classTag();
        } else if (chunk instanceof Chunk.Singleton) {
            classTag = ((Chunk.Singleton)chunk).classTag();
        } else if (chunk instanceof Chunk.Slice) {
            classTag = ((Chunk.Slice)chunk).classTag();
        } else if (chunk instanceof Chunk.VectorChunk) {
            classTag = ((Chunk.VectorChunk)chunk).classTag();
        } else if (chunk instanceof Chunk.BitChunk) {
            classTag = ClassTag$.MODULE$.Boolean();
        } else {
            throw new MatchError(chunk);
        }
        return classTag;
    }

    public int zio$Chunk$$BufferSize() {
        return this.zio$Chunk$$BufferSize;
    }

    private Chunk$() {
        MODULE$ = this;
        this.empty = Chunk$Empty$.MODULE$;
        this.unit = this.single(BoxedUnit.UNIT);
        this.zio$Chunk$$BufferSize = 64;
    }
}

