/*
 * Copyright 2017-2019 John A. De Goes and the ZIO Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package zio

package object stm extends EitherCompat {

  type RSTM[-R, +A]  = ZSTM[R, Throwable, A]
  type URSTM[-R, +A] = ZSTM[R, Nothing, A]
  type STM[+E, +A]   = ZSTM[Any, E, A]
  type USTM[+A]      = ZSTM[Any, Nothing, A]
  type TaskSTM[+A]   = ZSTM[Any, Throwable, A]
  type TRef[A]       = ZTRef[Nothing, Nothing, A, A]
  type ETRef[+E, A]  = ZTRef[E, E, A, A]
}
