/*
 * Decompiled with CFR 0.152.
 */
package zio;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.SortedSet;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import zio.Cause;
import zio.Chunk;
import zio.Chunk$;
import zio.Exit;
import zio.Fiber;
import zio.Supervisor;
import zio.Supervisor$;
import zio.UIO$;
import zio.ZIO;
import zio.ZIO$;
import zio.internal.FiniteHistogram;
import zio.internal.FiniteHistogram$;
import zio.internal.LongHistogram;
import zio.internal.LongHistogram$;
import zio.internal.Platform$;
import zio.internal.Sync$;

public final class Supervisor$ {
    public static Supervisor$ MODULE$;
    private final Supervisor<BoxedUnit> none;

    static {
        new Supervisor$();
    }

    public Supervisor<Supervisor.RuntimeStats> runtimeStats() {
        return new Supervisor<Supervisor.RuntimeStats>(){
            private final LongHistogram milliLifetimes;
            private final LongHistogram secondLifetimes;
            private final LongHistogram minuteLifetimes;
            private final FiniteHistogram<Class<?>> fiberFailures;
            private final LongAdder started;
            private final LongAdder ended;
            private final LongAdder successes;
            private final LongAdder failures;
            private final LongAdder defects;

            private LongHistogram milliLifetimes() {
                return this.milliLifetimes;
            }

            private LongHistogram secondLifetimes() {
                return this.secondLifetimes;
            }

            private LongHistogram minuteLifetimes() {
                return this.minuteLifetimes;
            }

            private FiniteHistogram<Class<?>> fiberFailures() {
                return this.fiberFailures;
            }

            private LongAdder started() {
                return this.started;
            }

            private LongAdder ended() {
                return this.ended;
            }

            private LongAdder successes() {
                return this.successes;
            }

            private LongAdder failures() {
                return this.failures;
            }

            private LongAdder defects() {
                return this.defects;
            }

            public ZIO<Object, Nothing$, Supervisor.RuntimeStats> value() {
                return UIO$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new Supervisor.RuntimeStats());
            }

            public <R, E, A> void unsafeOnStart(R environment, ZIO<R, E, A> effect, Option<Fiber.Runtime<Object, Object>> parent, Fiber.Runtime<E, A> fiber) {
                this.started().increment();
            }

            public <R, E, A> void unsafeOnEnd(Exit<E, A> value, Fiber.Runtime<E, A> fiber) {
                long startTime = fiber.id().startTimeMillis();
                long millis = System.currentTimeMillis() - startTime;
                long seconds = millis / 1000L;
                long minutes = seconds / 60L;
                this.ended().increment();
                this.milliLifetimes().add(millis);
                this.secondLifetimes().add(seconds);
                this.minuteLifetimes().add(minutes);
                if (value instanceof Exit.Success) {
                    this.successes().increment();
                    return;
                }
                if (value instanceof Exit.Failure) {
                    Cause<E> cause = ((Exit.Failure)value).cause();
                    this.failures().increment();
                    Option<E> option = cause.failureOption();
                    if (option instanceof Some) {
                        Object error2 = ((Some)option).value();
                        this.defects().increment();
                        this.fiberFailures().add(error2.getClass());
                        return;
                    }
                    if (None$.MODULE$.equals(option)) {
                        cause.defects().headOption().foreach((Function1 & Serializable & scala.Serializable)error -> {
                            anon.2.$anonfun$unsafeOnEnd$1(this, error);
                            return BoxedUnit.UNIT;
                        });
                        return;
                    }
                    throw new MatchError(option);
                }
                throw new MatchError(value);
            }

            public static final /* synthetic */ void $anonfun$unsafeOnEnd$1(anon.2 $this, Throwable error) {
                $this.fiberFailures().add(error.getClass());
            }
            {
                this.milliLifetimes = LongHistogram$.MODULE$.make(1, 1000L);
                this.secondLifetimes = LongHistogram$.MODULE$.make(1, 60L);
                this.minuteLifetimes = LongHistogram$.MODULE$.make(1, 60L);
                this.fiberFailures = FiniteHistogram$.MODULE$.make();
                this.started = new LongAdder();
                this.ended = new LongAdder();
                this.successes = new LongAdder();
                this.failures = new LongAdder();
                this.defects = new LongAdder();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$1(), $anonfun$unsafeOnEnd$1$adapted(zio.Supervisor$$anon$2 java.lang.Throwable )}, serializedLambda);
            }
        };
    }

    public ZIO<Object, Nothing$, Supervisor<Chunk<Fiber.Runtime<Object, Object>>>> track(boolean weak) {
        return UIO$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            HashSet set = weak ? Platform$.MODULE$.newWeakSet() : new HashSet();
            return new Supervisor<Chunk<Fiber.Runtime<Object, Object>>>(set){
                private final Set set$1;

                public ZIO<Object, Nothing$, Chunk<Fiber.Runtime<Object, Object>>> value() {
                    return UIO$.MODULE$.succeed((Function0 & Serializable & scala.Serializable)() -> {
                        Chunk chunk;
                        void apply_anyRef;
                        Set set = $this.set$1;
                        if (Sync$.MODULE$ == null) {
                            throw null;
                        }
                        synchronized (apply_anyRef) {
                            chunk = anon.3.$anonfun$value$3(this);
                        }
                        return chunk;
                    });
                }

                /*
                 * WARNING - void declaration
                 */
                public <R, E, A> void unsafeOnStart(R environment, ZIO<R, E, A> effect, Option<Fiber.Runtime<Object, Object>> parent, Fiber.Runtime<E, A> fiber) {
                    void apply_anyRef;
                    Set set = this.set$1;
                    if (Sync$.MODULE$ == null) {
                        throw null;
                    }
                    synchronized (apply_anyRef) {
                        anon.3.$anonfun$unsafeOnStart$1(this, fiber);
                        return;
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                public <R, E, A> void unsafeOnEnd(Exit<E, A> value, Fiber.Runtime<E, A> fiber) {
                    void apply_anyRef;
                    Set set = this.set$1;
                    if (Sync$.MODULE$ == null) {
                        throw null;
                    }
                    synchronized (apply_anyRef) {
                        anon.3.$anonfun$unsafeOnEnd$2(this, fiber);
                        return;
                    }
                }

                public static final /* synthetic */ Chunk $anonfun$value$3(anon.3 $this) {
                    return Chunk$.MODULE$.fromArray($this.set$1.toArray((Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(Fiber.Runtime.class))));
                }

                public static final /* synthetic */ boolean $anonfun$unsafeOnStart$1(anon.3 $this, Fiber.Runtime fiber$1) {
                    return $this.set$1.add(fiber$1);
                }

                public static final /* synthetic */ boolean $anonfun$unsafeOnEnd$2(anon.3 $this, Fiber.Runtime fiber$2) {
                    return $this.set$1.remove(fiber$2);
                }
                {
                    this.set$1 = set$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$2(zio.Supervisor$$anon$3 ), $anonfun$unsafeOnStart$1(zio.Supervisor$$anon$3 zio.Fiber$Runtime ), $anonfun$unsafeOnEnd$2(zio.Supervisor$$anon$3 zio.Fiber$Runtime ), $anonfun$value$3(zio.Supervisor$$anon$3 )}, serializedLambda);
                }
            };
        });
    }

    public <A> Supervisor<A> fromEffect(ZIO<Object, Nothing$, A> value) {
        return new Supervisor.ConstSupervisor<A>(value);
    }

    public ZIO<Object, Nothing$, Supervisor<SortedSet<Fiber.Runtime<Object, Object>>>> fibersIn(AtomicReference<SortedSet<Fiber.Runtime<Object, Object>>> ref) {
        return UIO$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new Supervisor<SortedSet<Fiber.Runtime<Object, Object>>>(ref){
            private final AtomicReference ref$1;

            public ZIO<Object, Nothing$, SortedSet<Fiber.Runtime<Object, Object>>> value() {
                return ZIO$.MODULE$.succeed((Function0 & Serializable & scala.Serializable)() -> (SortedSet)$this.ref$1.get());
            }

            public <R, E, A> void unsafeOnStart(R environment, ZIO<R, E, A> effect, Option<Fiber.Runtime<Object, Object>> parent, Fiber.Runtime<E, A> fiber) {
                boolean loop = true;
                while (loop) {
                    SortedSet set = (SortedSet)this.ref$1.get();
                    loop = !this.ref$1.compareAndSet(set, set.$plus(fiber));
                }
            }

            public <R, E, A> void unsafeOnEnd(Exit<E, A> value, Fiber.Runtime<E, A> fiber) {
                boolean loop = true;
                while (loop) {
                    SortedSet set = (SortedSet)this.ref$1.get();
                    loop = !this.ref$1.compareAndSet(set, set.$minus(fiber));
                }
            }
            {
                this.ref$1 = ref$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$4(zio.Supervisor$$anon$4 )}, serializedLambda);
            }
        });
    }

    public Supervisor<BoxedUnit> none() {
        return this.none;
    }

    private Supervisor$() {
        MODULE$ = this;
        this.none = new Supervisor.ConstSupervisor<BoxedUnit>(ZIO$.MODULE$.unit());
    }
}

