/*
 * Decompiled with CFR 0.152.
 */
package zio.internal;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import zio.Fiber;
import zio.Fiber$Id$;
import zio.Fiber$Status$Done$;
import zio.UIO$;
import zio.ZIO;
import zio.ZIO$;
import zio.internal.stacktracer.ZTraceElement;

public final class FiberRenderer$ {
    public static FiberRenderer$ MODULE$;

    static {
        new FiberRenderer$();
    }

    public ZIO<Object, Nothing$, String> dumpStr(Seq<Fiber.Runtime<?, ?>> fibers, boolean withTrace) {
        return ZIO$.MODULE$.foreach(fibers, (Function1 & Serializable & scala.Serializable)f -> f.dumpWith(withTrace), Seq$.MODULE$.canBuildFrom()).flatMap((Function1 & Serializable & scala.Serializable)dumps -> UIO$.MODULE$.apply((JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> System.currentTimeMillis()).map((Function1 & Serializable & scala.Serializable)now -> FiberRenderer$.$anonfun$dumpStr$4(dumps, withTrace, BoxesRunTime.unboxToLong((Object)now))));
    }

    public ZIO<Object, Nothing$, String> prettyPrintM(Fiber.Dump dump) {
        return UIO$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.prettyPrint(dump, System.currentTimeMillis()));
    }

    private <A> Iterable<Tuple2<A, Object>> zipWithHasNext(Iterable<A> it) {
        if (it.isEmpty()) {
            return Nil$.MODULE$;
        }
        return (Iterable)package$.MODULE$.Iterable().concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Traversable[]{(Traversable)((TraversableLike)it.dropRight(1)).map((Function1 & Serializable & scala.Serializable)x$2 -> new Tuple2(x$2, (Object)BoxesRunTime.boxToBoolean((boolean)true)), Iterable$.MODULE$.canBuildFrom()), new .colon.colon((Object)new Tuple2(it.last(), (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)Nil$.MODULE$)}));
    }

    private String prettyPrint(Fiber.Dump dump, long now) {
        Fiber.Id blockingOn;
        long millis = now - dump.fiberId().startTimeMillis();
        long seconds = millis / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        String name2 = (String)dump.fiberName().fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)name -> new StringBuilder(3).append("\"").append((String)name).append("\" ").toString());
        String lifeMsg = new StringBuilder(2).append(hours == 0L ? "" : new StringBuilder(1).append(hours).append("h").toString()).append((Object)(hours == 0L && minutes == 0L ? "" : new StringBuilder(1).append(minutes).append("m").toString())).append((Object)(hours == 0L && minutes == 0L && seconds == 0L ? "" : new StringBuilder(1).append(seconds).append("s").toString())).append(millis).append("ms").toString();
        Fiber.Status status = dump.status();
        String string = status instanceof Fiber.Status.Suspended ? ((blockingOn = ((Fiber.Status.Suspended)status).blockingOn()) != Fiber$Id$.MODULE$.None() ? new StringBuilder(12).append("waiting on ").append("#").append(blockingOn.seqNumber()).toString() : "") : "";
        String statMsg = this.renderStatus(dump.status());
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(52).append("\n       |").append(name2).append("#").append(dump.fiberId().seqNumber()).append(" (").append(lifeMsg).append(") ").append(string).append("\n       |   Status: ").append(statMsg).append("\n       |").append(dump.trace().fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)x$3 -> x$3.prettyPrint())).append("\n       |").toString())).stripMargin();
    }

    private String renderStatus(Fiber.Status status) {
        String string;
        if (Fiber$Status$Done$.MODULE$.equals(status)) {
            string = "Done";
        } else if (status instanceof Fiber.Status.Finishing) {
            boolean b = ((Fiber.Status.Finishing)status).interrupting();
            string = new StringBuilder(11).append("Finishing(").append((Object)(b ? "interrupting" : "")).append(")").toString();
        } else if (status instanceof Fiber.Status.Running) {
            boolean b = ((Fiber.Status.Running)status).interrupting();
            string = new StringBuilder(9).append("Running(").append((Object)(b ? "interrupting" : "")).append(")").toString();
        } else if (status instanceof Fiber.Status.Suspended) {
            Fiber.Status.Suspended suspended = (Fiber.Status.Suspended)status;
            boolean interruptible = suspended.interruptible();
            long epoch = suspended.epoch();
            Option<ZTraceElement> asyncTrace = suspended.asyncTrace();
            String in = interruptible ? "interruptible" : "uninterruptible";
            String ep = new StringBuilder(7).append(epoch).append(" asyncs").toString();
            String as = (String)asyncTrace.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.prettyPrint()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
            string = new StringBuilder(15).append("Suspended(").append(in).append(", ").append(ep).append(", ").append(as).append(")").toString();
        } else {
            throw new MatchError((Object)status);
        }
        return string;
    }

    private String renderHierarchy(Iterable<Fiber.Dump> trees) {
        return ((TraversableOnce)this.zipWithHasNext(trees).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            Fiber.Dump tree = (Fiber.Dump)x0$1._1();
            String string = MODULE$.renderOne(tree);
            return string;
        }, Iterable$.MODULE$.canBuildFrom())).mkString();
    }

    private String renderOne(Fiber.Dump tree) {
        return this.go$1(tree, "");
    }

    private Vector<String> collectTraces(Iterable<Fiber.Dump> dumps, long now) {
        return ((TraversableOnce)dumps.map((Function1 & Serializable & scala.Serializable)x$5 -> MODULE$.prettyPrint((Fiber.Dump)x$5, now), Iterable$.MODULE$.canBuildFrom())).toVector();
    }

    public static final /* synthetic */ String $anonfun$dumpStr$4(Seq dumps$1, boolean withTrace$1, long now) {
        String treeString = MODULE$.renderHierarchy((Iterable<Fiber.Dump>)dumps$1);
        return ((TraversableOnce)(withTrace$1 ? MODULE$.collectTraces((Iterable<Fiber.Dump>)dumps$1, now) : Nil$.MODULE$).$plus$colon((Object)treeString, Seq$.MODULE$.canBuildFrom())).mkString("\n");
    }

    private final String go$1(Fiber.Dump t, String prefix) {
        String nameStr = (String)t.fiberName().fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)n -> new StringBuilder(3).append("\"").append((String)n).append("\" ").toString());
        String statusMsg = this.renderStatus(t.status());
        return new StringBuilder(15).append(prefix).append("+---").append(nameStr).append("#").append(t.fiberId().seqNumber()).append(" Status: ").append(statusMsg).append("\n").toString();
    }

    private FiberRenderer$() {
        MODULE$ = this;
    }
}

