/*
 * Decompiled with CFR 0.152.
 */
package zio.internal;

import java.io.Serializable;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import zio.Chunk;
import zio.ChunkCanBuildFrom$;
import zio.ChunkLike;
import zio.ChunkLike$;
import zio.internal.ExecutionMetrics;
import zio.internal.Executor;
import zio.internal.MutableConcurrentQueue;
import zio.internal.MutableConcurrentQueue$;

@ScalaSignature(bytes="\u0006\u0001\u00055b\u0001B\u000e\u001d\r\u0005B\u0001B\n\u0001\u0003\u0006\u0004%\ta\n\u0005\t]\u0001\u0011\t\u0011)A\u0005Q!)q\u0006\u0001C\u0001a!11\u0007\u0001Q\u0001\n!Ba\u0001\u000e\u0001!\u0002\u0013)\u0004B\u0002!\u0001A\u0003%\u0011\t\u0003\u0004|\u0001\u0001\u0006I\u0001 \u0005\t\u0003\u001b\u0001\u0001\u0015!\u0003\u0002\u0010!9\u0011Q\u0003\u0001\u0005\u0002\u0005]\u0001bBA\u0013\u0001\u0011\u0005\u0011qE\u0004\u0006\trA\t!\u0012\u0004\u00067qA\tA\u0012\u0005\u0006_1!\tA\u0013\u0004\u0006\u00172\tI\u0003\u0014\u0005\u0006_9!\t\u0001\u0015\u0005\b':\u0001\r\u0011\"\u0001U\u0011\u001dAf\u00021A\u0005\u0002eCaa\u0018\b!B\u0013)\u0006b\u00023\u000f\u0005\u0004%\t!\u001a\u0005\u0007M:\u0001\u000b\u0011B\u001b\t\u000f\u001dt\u0001\u0019!C\u0001Q\"9\u0011N\u0004a\u0001\n\u0003Q\u0007B\u00027\u000fA\u0003&\u0001\bC\u0004n\u001d\u0001\u0007I\u0011\u00018\t\u000fIt\u0001\u0019!C\u0001g\"1QO\u0004Q!\n=\u0014!BW*dQ\u0016$W\u000f\\3s\u0015\tib$\u0001\u0005j]R,'O\\1m\u0015\u0005y\u0012a\u0001>j_\u000e\u00011C\u0001\u0001#!\t\u0019C%D\u0001\u001d\u0013\t)CD\u0001\u0005Fq\u0016\u001cW\u000f^8s\u00031I\u0018.\u001a7e\u001fB\u001cu.\u001e8u+\u0005A\u0003CA\u0015-\u001b\u0005Q#\"A\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00055R#aA%oi\u0006i\u00110[3mI>\u00038i\\;oi\u0002\na\u0001P5oSRtDCA\u00193!\t\u0019\u0003\u0001C\u0003'\u0007\u0001\u0007\u0001&\u0001\u0005q_>d7+\u001b>f\u0003-9Gn\u001c2bYF+X-^3\u0011\u0007\r2\u0004(\u0003\u000289\t1R*\u001e;bE2,7i\u001c8dkJ\u0014XM\u001c;Rk\u0016,X\r\u0005\u0002:}5\t!H\u0003\u0002<y\u0005!A.\u00198h\u0015\u0005i\u0014\u0001\u00026bm\u0006L!a\u0010\u001e\u0003\u0011I+hN\\1cY\u0016\fA!\u001b3mKB\u00191E\u000e\"\u0011\u0005\rsaBA\u0012\f\u0003)Q6k\u00195fIVdWM\u001d\t\u0003G1\u0019\"\u0001D$\u0011\u0005%B\u0015BA%+\u0005\u0019\te.\u001f*fMR\tQI\u0001\u0004X_J\\WM]\n\u0003\u001d5\u0003\"!\u000f(\n\u0005=S$A\u0002+ie\u0016\fG\rF\u0001R!\t\u0011f\"D\u0001\r\u0003\u0019\t7\r^5wKV\tQ\u000b\u0005\u0002*-&\u0011qK\u000b\u0002\b\u0005>|G.Z1o\u0003)\t7\r^5wK~#S-\u001d\u000b\u00035v\u0003\"!K.\n\u0005qS#\u0001B+oSRDqAX\t\u0002\u0002\u0003\u0007Q+A\u0002yIE\nq!Y2uSZ,\u0007\u0005\u000b\u0002\u0013CB\u0011\u0011FY\u0005\u0003G*\u0012\u0001B^8mCRLG.Z\u0001\u000bY>\u001c\u0017\r\\)vKV,W#A\u001b\u0002\u00171|7-\u00197Rk\u0016,X\rI\u0001\r]\u0016DHOU;o]\u0006\u0014G.Z\u000b\u0002q\u0005\u0001b.\u001a=u%Vtg.\u00192mK~#S-\u001d\u000b\u00035.DqA\u0018\f\u0002\u0002\u0003\u0007\u0001(A\u0007oKb$(+\u001e8oC\ndW\rI\u0001\b_B\u001cu.\u001e8u+\u0005y\u0007CA\u0015q\u0013\t\t(F\u0001\u0003M_:<\u0017aC8q\u0007>,h\u000e^0%KF$\"A\u0017;\t\u000fyK\u0012\u0011!a\u0001_\u0006Aq\u000e]\"pk:$\b\u0005\u000b\u0002\u001bC&\u0012a\u0002\u001f\u0004\u0005s:\u0001!PA\u0007=Y>\u001c\u0017\r\u001c\u0011dQ&dGMP\n\u0003qF\u000bQa\u001d;bi\u0016\u00042!`A\u0005\u001b\u0005q(bA@\u0002\u0002\u00051\u0011\r^8nS\u000eTA!a\u0001\u0002\u0006\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0007\u0005\u001dA(\u0001\u0003vi&d\u0017bAA\u0006}\ni\u0011\t^8nS\u000eLe\u000e^3hKJ\fqa^8sW\u0016\u00148\u000f\u0005\u0003*\u0003#\u0011\u0015bAA\nU\t)\u0011I\u001d:bs\u00069Q.\u001a;sS\u000e\u001cXCAA\r!\u0015I\u00131DA\u0010\u0013\r\tiB\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007\r\n\t#C\u0002\u0002$q\u0011\u0001#\u0012=fGV$\u0018n\u001c8NKR\u0014\u0018nY:\u0002\rM,(-\\5u)\r)\u0016\u0011\u0006\u0005\u0007\u0003WQ\u0001\u0019\u0001\u001d\u0002\u0011I,hN\\1cY\u0016\u0004")
public final class ZScheduler
extends Executor {
    private final int yieldOpCount;
    public final int zio$internal$ZScheduler$$poolSize;
    public final MutableConcurrentQueue<Runnable> zio$internal$ZScheduler$$globalQueue;
    public final MutableConcurrentQueue<Worker> zio$internal$ZScheduler$$idle;
    public final AtomicInteger zio$internal$ZScheduler$$state;
    public final Worker[] zio$internal$ZScheduler$$workers;

    @Override
    public int yieldOpCount() {
        return this.yieldOpCount;
    }

    @Override
    public Option<ExecutionMetrics> metrics() {
        ExecutionMetrics metrics = new ExecutionMetrics(this){
            private final /* synthetic */ ZScheduler $outer;

            public int capacity() {
                return Integer.MAX_VALUE;
            }

            public int concurrency() {
                return this.$outer.zio$internal$ZScheduler$$poolSize;
            }

            /*
             * WARNING - void declaration
             */
            public long dequeuedCount() {
                void var1_1;
                long dequeued = 0L;
                for (int i = 0; i != this.$outer.zio$internal$ZScheduler$$poolSize; ++i) {
                    Worker worker = this.$outer.zio$internal$ZScheduler$$workers[i];
                    dequeued += worker.opCount();
                }
                return (long)var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public long enqueuedCount() {
                void var1_1;
                long enqueued = 0L;
                for (int i = 0; i != this.$outer.zio$internal$ZScheduler$$poolSize; ++i) {
                    Worker worker = this.$outer.zio$internal$ZScheduler$$workers[i];
                    enqueued += worker.opCount();
                    enqueued += (long)worker.localQueue().size();
                    if (worker.nextRunnable() == null) continue;
                    ++enqueued;
                }
                enqueued += (long)this.$outer.zio$internal$ZScheduler$$globalQueue.size();
                return (long)var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public int size() {
                void var2_2;
                int size = 0;
                for (int i = 0; i != this.$outer.zio$internal$ZScheduler$$poolSize; ++i) {
                    Worker worker = this.$outer.zio$internal$ZScheduler$$workers[i];
                    size += worker.localQueue().size();
                    if (worker.nextRunnable() == null) continue;
                    ++size;
                }
                size += this.$outer.zio$internal$ZScheduler$$globalQueue.size();
                return (int)var2_2;
            }

            public int workersCount() {
                return (this.$outer.zio$internal$ZScheduler$$state.get() & 0xFFFF0000) >> 16;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        return new Some((Object)metrics);
    }

    @Override
    public boolean submit(Runnable runnable) {
        Thread currentThread = Thread.currentThread();
        boolean notify = false;
        if (currentThread instanceof Worker) {
            Worker worker = (Worker)currentThread;
            if (worker.nextRunnable() == null && worker.localQueue().isEmpty()) {
                worker.nextRunnable_$eq(runnable);
            } else {
                if (!worker.localQueue().offer(runnable)) {
                    this.zio$internal$ZScheduler$$globalQueue.offerAll((Iterable<Runnable>)((Iterable)worker.localQueue().pollUpTo(128).$colon$plus(runnable, ChunkLike$.MODULE$.chunkCanBuildFrom(ChunkCanBuildFrom$.MODULE$.apply()))));
                }
                notify = true;
            }
        } else {
            this.zio$internal$ZScheduler$$globalQueue.offer(runnable);
            notify = true;
        }
        if (notify) {
            Worker worker;
            int currentState = this.zio$internal$ZScheduler$$state.get();
            int currentActive = (currentState & 0xFFFF0000) >> 16;
            int currentSearching = currentState & 0xFFFF;
            if (currentActive != this.zio$internal$ZScheduler$$poolSize && currentSearching == 0 && (worker = (Worker)this.zio$internal$ZScheduler$$idle.poll(null)) != null) {
                this.zio$internal$ZScheduler$$state.getAndAdd(65537);
                worker.active_$eq(true);
                LockSupport.unpark(worker);
            }
        }
        return true;
    }

    public ZScheduler(int yieldOpCount) {
        this.yieldOpCount = yieldOpCount;
        this.zio$internal$ZScheduler$$poolSize = Runtime.getRuntime().availableProcessors();
        this.zio$internal$ZScheduler$$globalQueue = MutableConcurrentQueue$.MODULE$.unbounded();
        this.zio$internal$ZScheduler$$idle = MutableConcurrentQueue$.MODULE$.bounded(this.zio$internal$ZScheduler$$poolSize);
        this.zio$internal$ZScheduler$$state = new AtomicInteger(this.zio$internal$ZScheduler$$poolSize << 16);
        this.zio$internal$ZScheduler$$workers = (Worker[])Array$.MODULE$.ofDim(this.zio$internal$ZScheduler$$poolSize, ClassTag$.MODULE$.apply(Worker.class));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.zio$internal$ZScheduler$$poolSize).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)workerId -> {
            Worker worker = new Worker(this, workerId){
                private final /* synthetic */ ZScheduler $outer;
                private final int workerId$1;

                public void run() {
                    long currentOpCount = 0L;
                    ThreadLocalRandom random = ThreadLocalRandom.current();
                    boolean searching = false;
                    while (!this.isInterrupted()) {
                        Runnable runnable;
                        if ((currentOpCount & 0x3FL) == 0L) {
                            runnable = this.$outer.zio$internal$ZScheduler$$globalQueue.poll(null);
                            if (runnable == null) {
                                if (this.nextRunnable() != null) {
                                    runnable = this.nextRunnable();
                                    this.nextRunnable_$eq(null);
                                } else {
                                    runnable = this.localQueue().poll(null);
                                }
                            }
                        } else if (this.nextRunnable() != null) {
                            runnable = this.nextRunnable();
                            this.nextRunnable_$eq(null);
                        } else {
                            runnable = this.localQueue().poll(null);
                            if (runnable == null) {
                                runnable = this.$outer.zio$internal$ZScheduler$$globalQueue.poll(null);
                            }
                        }
                        if (runnable == null) {
                            int currentActive;
                            if (!searching && 2 * (currentActive = this.$outer.zio$internal$ZScheduler$$state.get() & 0xFFFF) < this.$outer.zio$internal$ZScheduler$$poolSize) {
                                this.$outer.zio$internal$ZScheduler$$state.getAndIncrement();
                                searching = true;
                            }
                            if (searching) {
                                boolean loop = true;
                                int offset = random.nextInt(this.$outer.zio$internal$ZScheduler$$poolSize);
                                for (int i = 0; i != this.$outer.zio$internal$ZScheduler$$poolSize && loop; ++i) {
                                    Chunk<Runnable> runnables;
                                    Worker worker;
                                    int size;
                                    int index = (i + offset) % this.$outer.zio$internal$ZScheduler$$poolSize;
                                    if (index == this.workerId$1 || (size = (worker = this.$outer.zio$internal$ZScheduler$$workers[index]).localQueue().size()) <= 0 || !(runnables = worker.localQueue().pollUpTo(size - size / 2)).nonEmpty()) continue;
                                    runnable = runnables.head();
                                    if (((ChunkLike)runnables.tail()).nonEmpty()) {
                                        this.localQueue().offerAll((Iterable<Runnable>)((Iterable)runnables.tail()));
                                    }
                                    loop = false;
                                }
                                if (runnable == null) {
                                    runnable = this.$outer.zio$internal$ZScheduler$$globalQueue.poll(null);
                                }
                            }
                        }
                        if (runnable == null) {
                            int currentSearching = (searching ? this.$outer.zio$internal$ZScheduler$$state.addAndGet(-65537) : this.$outer.zio$internal$ZScheduler$$state.addAndGet(-65536)) & 0xFFFF;
                            this.active_$eq(false);
                            this.$outer.zio$internal$ZScheduler$$idle.offer(this);
                            if (currentSearching == 0 && searching) {
                                boolean notify = false;
                                for (int i = 0; i != this.$outer.zio$internal$ZScheduler$$poolSize && !notify; ++i) {
                                    notify = !this.$outer.zio$internal$ZScheduler$$workers[i].localQueue().isEmpty();
                                }
                                if (!notify) {
                                    boolean bl = notify = !this.$outer.zio$internal$ZScheduler$$globalQueue.isEmpty();
                                }
                                if (notify) {
                                    Worker worker;
                                    int currentState = this.$outer.zio$internal$ZScheduler$$state.get();
                                    int currentActive = (currentState & 0xFFFF0000) >> 16;
                                    int currentSearching2 = currentState & 0xFFFF;
                                    if (currentActive != this.$outer.zio$internal$ZScheduler$$poolSize && currentSearching2 == 0 && (worker = (Worker)this.$outer.zio$internal$ZScheduler$$idle.poll(null)) != null) {
                                        this.$outer.zio$internal$ZScheduler$$state.getAndAdd(65537);
                                        worker.active_$eq(true);
                                        LockSupport.unpark(worker);
                                    }
                                }
                            }
                            while (!this.active() && !this.isInterrupted()) {
                                LockSupport.park();
                            }
                            searching = true;
                            continue;
                        }
                        if (searching) {
                            Worker worker;
                            searching = false;
                            int currentState = this.$outer.zio$internal$ZScheduler$$state.decrementAndGet();
                            int currentSearching = currentState & 0xFFFF;
                            if ((currentState & 0xFFFF0000) >> 16 != this.$outer.zio$internal$ZScheduler$$poolSize && currentSearching == 0 && (worker = (Worker)this.$outer.zio$internal$ZScheduler$$idle.poll(null)) != null) {
                                this.$outer.zio$internal$ZScheduler$$state.getAndAdd(65537);
                                worker.active_$eq(true);
                                LockSupport.unpark(worker);
                            }
                        }
                        runnable.run();
                        runnable = null;
                        this.opCount_$eq(++currentOpCount);
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.workerId$1 = workerId$1;
                }
            };
            worker.setName(new StringBuilder(11).append("ZScheduler-").append(workerId).toString());
            worker.setDaemon(true);
            $this.zio$internal$ZScheduler$$workers[workerId] = worker;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.zio$internal$ZScheduler$$workers)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.start();
            return BoxedUnit.UNIT;
        });
    }

    private static abstract class Worker
    extends Thread {
        private volatile boolean active = true;
        private final MutableConcurrentQueue<Runnable> localQueue = MutableConcurrentQueue$.MODULE$.bounded(256);
        private Runnable nextRunnable = null;
        private volatile long opCount = 0L;

        public boolean active() {
            return this.active;
        }

        public void active_$eq(boolean x$1) {
            this.active = x$1;
        }

        public MutableConcurrentQueue<Runnable> localQueue() {
            return this.localQueue;
        }

        public Runnable nextRunnable() {
            return this.nextRunnable;
        }

        public void nextRunnable_$eq(Runnable x$1) {
            this.nextRunnable = x$1;
        }

        public long opCount() {
            return this.opCount;
        }

        public void opCount_$eq(long x$1) {
            this.opCount = x$1;
        }
    }
}

