/*
 * Decompiled with CFR 0.152.
 */
package zio.internal;

import java.io.Serializable;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import zio.Chunk;
import zio.ChunkCanBuildFrom$;
import zio.ChunkLike;
import zio.ChunkLike$;
import zio.Executor;
import zio.internal.ExecutionMetrics;
import zio.internal.MutableConcurrentQueue;
import zio.internal.MutableConcurrentQueue$;

@ScalaSignature(bytes="\u0006\u0001\u0005=b\u0001B\u000e\u001d\r\u0005B\u0001B\n\u0001\u0003\u0006\u0004%\ta\n\u0005\t]\u0001\u0011\t\u0011)A\u0005Q!)q\u0006\u0001C\u0001a!1A\u0007\u0001Q\u0001\n!Ba!\u000e\u0001!\u0002\u00131\u0004BB!\u0001A\u0003%!\t\u0003\u0004}\u0001\u0001\u0006I! \u0005\t\u0003\u001f\u0001\u0001\u0015!\u0003\u0002\u0012!9\u0011q\u0003\u0001\u0005\u0002\u0005e\u0001bBA\u0014\u0001\u0011\u0005\u0011\u0011F\u0004\u0006\u000brA\tA\u0012\u0004\u00067qA\ta\u0012\u0005\u0006_1!\ta\u0013\u0004\u0006\u00192\tI#\u0014\u0005\u0006_9!\t!\u0015\u0005\b):\u0001\r\u0011\"\u0001V\u0011\u001dIf\u00021A\u0005\u0002iCa\u0001\u0019\b!B\u00131\u0006bB3\u000f\u0005\u0004%\tA\u001a\u0005\u0007O:\u0001\u000b\u0011\u0002\u001c\t\u000f!t\u0001\u0019!C\u0001S\"9!N\u0004a\u0001\n\u0003Y\u0007BB7\u000fA\u0003&\u0011\bC\u0004o\u001d\u0001\u0007I\u0011A8\t\u000fMt\u0001\u0019!C\u0001i\"1aO\u0004Q!\nA\u0014!BW*dQ\u0016$W\u000f\\3s\u0015\tib$\u0001\u0005j]R,'O\\1m\u0015\u0005y\u0012a\u0001>j_\u000e\u00011C\u0001\u0001#!\t\u0019C%D\u0001\u001f\u0013\t)cD\u0001\u0005Fq\u0016\u001cW\u000f^8s\u00031I\u0018.\u001a7e\u001fB\u001cu.\u001e8u+\u0005A\u0003CA\u0015-\u001b\u0005Q#\"A\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00055R#aA%oi\u0006i\u00110[3mI>\u00038i\\;oi\u0002\na\u0001P5oSRtDCA\u00194!\t\u0011\u0004!D\u0001\u001d\u0011\u001513\u00011\u0001)\u0003!\u0001xn\u001c7TSj,\u0017aC4m_\n\fG.U;fk\u0016\u00042AM\u001c:\u0013\tADD\u0001\fNkR\f'\r\\3D_:\u001cWO\u001d:f]R\fV/Z;f!\tQt(D\u0001<\u0015\taT(\u0001\u0003mC:<'\"\u0001 \u0002\t)\fg/Y\u0005\u0003\u0001n\u0012\u0001BU;o]\u0006\u0014G.Z\u0001\u0005S\u0012dW\rE\u00023o\r\u0003\"\u0001\u0012\b\u000f\u0005IZ\u0011A\u0003.TG\",G-\u001e7feB\u0011!\u0007D\n\u0003\u0019!\u0003\"!K%\n\u0005)S#AB!osJ+g\rF\u0001G\u0005\u00199vN]6feN\u0011aB\u0014\t\u0003u=K!\u0001U\u001e\u0003\rQC'/Z1e)\u0005\u0011\u0006CA*\u000f\u001b\u0005a\u0011AB1di&4X-F\u0001W!\tIs+\u0003\u0002YU\t9!i\\8mK\u0006t\u0017AC1di&4Xm\u0018\u0013fcR\u00111L\u0018\t\u0003SqK!!\u0018\u0016\u0003\tUs\u0017\u000e\u001e\u0005\b?F\t\t\u00111\u0001W\u0003\rAH%M\u0001\bC\u000e$\u0018N^3!Q\t\u0011\"\r\u0005\u0002*G&\u0011AM\u000b\u0002\tm>d\u0017\r^5mK\u0006QAn\\2bYF+X-^3\u0016\u0003Y\n1\u0002\\8dC2\fV/Z;fA\u0005aa.\u001a=u%Vtg.\u00192mKV\t\u0011(\u0001\toKb$(+\u001e8oC\ndWm\u0018\u0013fcR\u00111\f\u001c\u0005\b?Z\t\t\u00111\u0001:\u00035qW\r\u001f;Sk:t\u0017M\u00197fA\u00059q\u000e]\"pk:$X#\u00019\u0011\u0005%\n\u0018B\u0001:+\u0005\u0011auN\\4\u0002\u0017=\u00048i\\;oi~#S-\u001d\u000b\u00037VDqaX\r\u0002\u0002\u0003\u0007\u0001/\u0001\u0005pa\u000e{WO\u001c;!Q\tQ\"-\u000b\u0002\u000fs\u001a!!P\u0004\u0001|\u00055aDn\\2bY\u0002\u001a\u0007.\u001b7e}M\u0011\u0011PU\u0001\u0006gR\fG/\u001a\t\u0004}\u0006-Q\"A@\u000b\t\u0005\u0005\u00111A\u0001\u0007CR|W.[2\u000b\t\u0005\u0015\u0011qA\u0001\u000bG>t7-\u001e:sK:$(bAA\u0005{\u0005!Q\u000f^5m\u0013\r\tia \u0002\u000e\u0003R|W.[2J]R,w-\u001a:\u0002\u000f]|'o[3sgB!\u0011&a\u0005D\u0013\r\t)B\u000b\u0002\u0006\u0003J\u0014\u0018-_\u0001\b[\u0016$(/[2t+\t\tY\u0002E\u0003*\u0003;\t\t#C\u0002\u0002 )\u0012aa\u00149uS>t\u0007c\u0001\u001a\u0002$%\u0019\u0011Q\u0005\u000f\u0003!\u0015CXmY;uS>tW*\u001a;sS\u000e\u001c\u0018AB:vE6LG\u000fF\u0002W\u0003WAa!!\f\u000b\u0001\u0004I\u0014\u0001\u0003:v]:\f'\r\\3")
public final class ZScheduler
extends Executor {
    private final int yieldOpCount;
    public final int zio$internal$ZScheduler$$poolSize;
    public final MutableConcurrentQueue<Runnable> zio$internal$ZScheduler$$globalQueue;
    public final MutableConcurrentQueue<Worker> zio$internal$ZScheduler$$idle;
    public final AtomicInteger zio$internal$ZScheduler$$state;
    public final Worker[] zio$internal$ZScheduler$$workers;

    @Override
    public int yieldOpCount() {
        return this.yieldOpCount;
    }

    @Override
    public Option<ExecutionMetrics> metrics() {
        ExecutionMetrics metrics = new ExecutionMetrics(this){
            private final /* synthetic */ ZScheduler $outer;

            public int capacity() {
                return Integer.MAX_VALUE;
            }

            public int concurrency() {
                return this.$outer.zio$internal$ZScheduler$$poolSize;
            }

            /*
             * WARNING - void declaration
             */
            public long dequeuedCount() {
                void var1_1;
                long dequeued = 0L;
                for (int i = 0; i != this.$outer.zio$internal$ZScheduler$$poolSize; ++i) {
                    Worker worker = this.$outer.zio$internal$ZScheduler$$workers[i];
                    dequeued += worker.opCount();
                }
                return (long)var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public long enqueuedCount() {
                void var1_1;
                long enqueued = 0L;
                for (int i = 0; i != this.$outer.zio$internal$ZScheduler$$poolSize; ++i) {
                    Worker worker = this.$outer.zio$internal$ZScheduler$$workers[i];
                    enqueued += worker.opCount();
                    enqueued += (long)worker.localQueue().size();
                    if (worker.nextRunnable() == null) continue;
                    ++enqueued;
                }
                enqueued += (long)this.$outer.zio$internal$ZScheduler$$globalQueue.size();
                return (long)var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public int size() {
                void var2_2;
                int size = 0;
                for (int i = 0; i != this.$outer.zio$internal$ZScheduler$$poolSize; ++i) {
                    Worker worker = this.$outer.zio$internal$ZScheduler$$workers[i];
                    size += worker.localQueue().size();
                    if (worker.nextRunnable() == null) continue;
                    ++size;
                }
                size += this.$outer.zio$internal$ZScheduler$$globalQueue.size();
                return (int)var2_2;
            }

            public int workersCount() {
                return (this.$outer.zio$internal$ZScheduler$$state.get() & 0xFFFF0000) >> 16;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        return new Some((Object)metrics);
    }

    @Override
    public boolean submit(Runnable runnable) {
        Thread currentThread = Thread.currentThread();
        boolean notify = false;
        if (currentThread instanceof Worker) {
            Worker worker = (Worker)currentThread;
            if (worker.nextRunnable() == null && worker.localQueue().isEmpty()) {
                worker.nextRunnable_$eq(runnable);
            } else {
                if (!worker.localQueue().offer(runnable)) {
                    this.zio$internal$ZScheduler$$globalQueue.offerAll((Iterable<Runnable>)((Iterable)worker.localQueue().pollUpTo(128).$colon$plus(runnable, ChunkLike$.MODULE$.chunkCanBuildFrom(ChunkCanBuildFrom$.MODULE$.apply()))));
                }
                notify = true;
            }
        } else {
            this.zio$internal$ZScheduler$$globalQueue.offer(runnable);
            notify = true;
        }
        if (notify) {
            Worker worker;
            int currentState = this.zio$internal$ZScheduler$$state.get();
            int currentActive = (currentState & 0xFFFF0000) >> 16;
            int currentSearching = currentState & 0xFFFF;
            if (currentActive != this.zio$internal$ZScheduler$$poolSize && currentSearching == 0 && (worker = (Worker)this.zio$internal$ZScheduler$$idle.poll(null)) != null) {
                this.zio$internal$ZScheduler$$state.getAndAdd(65537);
                worker.active_$eq(true);
                LockSupport.unpark(worker);
            }
        }
        return true;
    }

    public ZScheduler(int yieldOpCount) {
        this.yieldOpCount = yieldOpCount;
        this.zio$internal$ZScheduler$$poolSize = Runtime.getRuntime().availableProcessors();
        this.zio$internal$ZScheduler$$globalQueue = MutableConcurrentQueue$.MODULE$.unbounded();
        this.zio$internal$ZScheduler$$idle = MutableConcurrentQueue$.MODULE$.bounded(this.zio$internal$ZScheduler$$poolSize);
        this.zio$internal$ZScheduler$$state = new AtomicInteger(this.zio$internal$ZScheduler$$poolSize << 16);
        this.zio$internal$ZScheduler$$workers = (Worker[])Array$.MODULE$.ofDim(this.zio$internal$ZScheduler$$poolSize, ClassTag$.MODULE$.apply(Worker.class));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.zio$internal$ZScheduler$$poolSize).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)workerId -> {
            Worker worker = new Worker(this, workerId){
                private final /* synthetic */ ZScheduler $outer;
                private final int workerId$1;

                public void run() {
                    long currentOpCount = 0L;
                    ThreadLocalRandom random = ThreadLocalRandom.current();
                    boolean searching = false;
                    while (!this.isInterrupted()) {
                        Runnable runnable;
                        if ((currentOpCount & 0x3FL) == 0L) {
                            runnable = this.$outer.zio$internal$ZScheduler$$globalQueue.poll(null);
                            if (runnable == null) {
                                if (this.nextRunnable() != null) {
                                    runnable = this.nextRunnable();
                                    this.nextRunnable_$eq(null);
                                } else {
                                    runnable = this.localQueue().poll(null);
                                }
                            }
                        } else if (this.nextRunnable() != null) {
                            runnable = this.nextRunnable();
                            this.nextRunnable_$eq(null);
                        } else {
                            runnable = this.localQueue().poll(null);
                            if (runnable == null) {
                                runnable = this.$outer.zio$internal$ZScheduler$$globalQueue.poll(null);
                            }
                        }
                        if (runnable == null) {
                            int currentActive;
                            if (!searching && 2 * (currentActive = this.$outer.zio$internal$ZScheduler$$state.get() & 0xFFFF) < this.$outer.zio$internal$ZScheduler$$poolSize) {
                                this.$outer.zio$internal$ZScheduler$$state.getAndIncrement();
                                searching = true;
                            }
                            if (searching) {
                                boolean loop = true;
                                int offset = random.nextInt(this.$outer.zio$internal$ZScheduler$$poolSize);
                                for (int i = 0; i != this.$outer.zio$internal$ZScheduler$$poolSize && loop; ++i) {
                                    Chunk<Runnable> runnables;
                                    Worker worker;
                                    int size;
                                    int index = (i + offset) % this.$outer.zio$internal$ZScheduler$$poolSize;
                                    if (index == this.workerId$1 || (size = (worker = this.$outer.zio$internal$ZScheduler$$workers[index]).localQueue().size()) <= 0 || !(runnables = worker.localQueue().pollUpTo(size - size / 2)).nonEmpty()) continue;
                                    runnable = runnables.head();
                                    if (((ChunkLike)runnables.tail()).nonEmpty()) {
                                        this.localQueue().offerAll((Iterable<Runnable>)((Iterable)runnables.tail()));
                                    }
                                    loop = false;
                                }
                                if (runnable == null) {
                                    runnable = this.$outer.zio$internal$ZScheduler$$globalQueue.poll(null);
                                }
                            }
                        }
                        if (runnable == null) {
                            int currentSearching = (searching ? this.$outer.zio$internal$ZScheduler$$state.addAndGet(-65537) : this.$outer.zio$internal$ZScheduler$$state.addAndGet(-65536)) & 0xFFFF;
                            this.active_$eq(false);
                            this.$outer.zio$internal$ZScheduler$$idle.offer(this);
                            if (currentSearching == 0 && searching) {
                                boolean notify = false;
                                for (int i = 0; i != this.$outer.zio$internal$ZScheduler$$poolSize && !notify; ++i) {
                                    notify = !this.$outer.zio$internal$ZScheduler$$workers[i].localQueue().isEmpty();
                                }
                                if (!notify) {
                                    boolean bl = notify = !this.$outer.zio$internal$ZScheduler$$globalQueue.isEmpty();
                                }
                                if (notify) {
                                    Worker worker;
                                    int currentState = this.$outer.zio$internal$ZScheduler$$state.get();
                                    int currentActive = (currentState & 0xFFFF0000) >> 16;
                                    int currentSearching2 = currentState & 0xFFFF;
                                    if (currentActive != this.$outer.zio$internal$ZScheduler$$poolSize && currentSearching2 == 0 && (worker = (Worker)this.$outer.zio$internal$ZScheduler$$idle.poll(null)) != null) {
                                        this.$outer.zio$internal$ZScheduler$$state.getAndAdd(65537);
                                        worker.active_$eq(true);
                                        LockSupport.unpark(worker);
                                    }
                                }
                            }
                            while (!this.active() && !this.isInterrupted()) {
                                LockSupport.park();
                            }
                            searching = true;
                            continue;
                        }
                        if (searching) {
                            Worker worker;
                            searching = false;
                            int currentState = this.$outer.zio$internal$ZScheduler$$state.decrementAndGet();
                            int currentSearching = currentState & 0xFFFF;
                            if ((currentState & 0xFFFF0000) >> 16 != this.$outer.zio$internal$ZScheduler$$poolSize && currentSearching == 0 && (worker = (Worker)this.$outer.zio$internal$ZScheduler$$idle.poll(null)) != null) {
                                this.$outer.zio$internal$ZScheduler$$state.getAndAdd(65537);
                                worker.active_$eq(true);
                                LockSupport.unpark(worker);
                            }
                        }
                        runnable.run();
                        runnable = null;
                        this.opCount_$eq(++currentOpCount);
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.workerId$1 = workerId$1;
                }
            };
            worker.setName(new StringBuilder(11).append("ZScheduler-").append(workerId).toString());
            worker.setDaemon(true);
            $this.zio$internal$ZScheduler$$workers[workerId] = worker;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.zio$internal$ZScheduler$$workers)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.start();
            return BoxedUnit.UNIT;
        });
    }

    private static abstract class Worker
    extends Thread {
        private volatile boolean active = true;
        private final MutableConcurrentQueue<Runnable> localQueue = MutableConcurrentQueue$.MODULE$.bounded(256);
        private Runnable nextRunnable = null;
        private volatile long opCount = 0L;

        public boolean active() {
            return this.active;
        }

        public void active_$eq(boolean x$1) {
            this.active = x$1;
        }

        public MutableConcurrentQueue<Runnable> localQueue() {
            return this.localQueue;
        }

        public Runnable nextRunnable() {
            return this.nextRunnable;
        }

        public void nextRunnable_$eq(Runnable x$1) {
            this.nextRunnable = x$1;
        }

        public long opCount() {
            return this.opCount;
        }

        public void opCount_$eq(long x$1) {
            this.opCount = x$1;
        }
    }
}

