/*
 * Decompiled with CFR 0.152.
 */
package zio.internal;

import java.io.Serializable;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import zio.Chunk;
import zio.ChunkCanBuildFrom$;
import zio.ChunkLike;
import zio.ChunkLike$;
import zio.Executor;
import zio.internal.ExecutionMetrics;
import zio.internal.MutableConcurrentQueue;
import zio.internal.MutableConcurrentQueue$;

@ScalaSignature(bytes="\u0006\u0001\u0005]b\u0001\u0002\u000f\u001e\r\tB\u0001b\n\u0001\u0003\u0006\u0004%\t\u0001\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005S!)\u0001\u0007\u0001C\u0001c!1Q\u0007\u0001Q\u0001\n%BaA\u000e\u0001!\u0002\u00139\u0004B\u0002\"\u0001A\u0003%1\t\u0003\u0004~\u0001\u0001\u0006IA \u0005\t\u0003#\u0001\u0001\u0015!\u0003\u0002\u0014!9\u0011\u0011\u0004\u0001\u0005\u0002\u0005m\u0001bBA\u0015\u0001\u0011\u0005\u00111\u0006\u0005\b\u0003c\u0001A\u0011IA\u001a\u000f\u00151U\u0004#\u0001H\r\u0015aR\u0004#\u0001I\u0011\u0015\u0001T\u0002\"\u0001M\r\u0015iU\"!\u000bO\u0011\u0015\u0001t\u0002\"\u0001S\u0011\u001d)v\u00021A\u0005\u0002YCqAW\bA\u0002\u0013\u00051\f\u0003\u0004b\u001f\u0001\u0006Ka\u0016\u0005\bM>\u0011\r\u0011\"\u0001h\u0011\u0019Aw\u0002)A\u0005o!9\u0011n\u0004a\u0001\n\u0003Q\u0007bB6\u0010\u0001\u0004%\t\u0001\u001c\u0005\u0007]>\u0001\u000b\u0015\u0002\u001e\t\u000f=|\u0001\u0019!C\u0001a\"9Ao\u0004a\u0001\n\u0003)\bBB<\u0010A\u0003&\u0011O\u0001\u0006['\u000eDW\rZ;mKJT!AH\u0010\u0002\u0011%tG/\u001a:oC2T\u0011\u0001I\u0001\u0004u&|7\u0001A\n\u0003\u0001\r\u0002\"\u0001J\u0013\u000e\u0003}I!AJ\u0010\u0003\u0011\u0015CXmY;u_J\fA\"_5fY\u0012|\u0005oQ8v]R,\u0012!\u000b\t\u0003U5j\u0011a\u000b\u0006\u0002Y\u0005)1oY1mC&\u0011af\u000b\u0002\u0004\u0013:$\u0018!D=jK2$w\n]\"pk:$\b%\u0001\u0004=S:LGO\u0010\u000b\u0003eQ\u0002\"a\r\u0001\u000e\u0003uAQaJ\u0002A\u0002%\n\u0001\u0002]8pYNK'0Z\u0001\fO2|'-\u00197Rk\u0016,X\rE\u00024qiJ!!O\u000f\u0003-5+H/\u00192mK\u000e{gnY;se\u0016tG/U;fk\u0016\u0004\"a\u000f!\u000e\u0003qR!!\u0010 \u0002\t1\fgn\u001a\u0006\u0002\u007f\u0005!!.\u0019<b\u0013\t\tEH\u0001\u0005Sk:t\u0017M\u00197f\u0003\u0011IG\r\\3\u0011\u0007MBD\t\u0005\u0002F\u001f9\u00111\u0007D\u0001\u000b5N\u001b\u0007.\u001a3vY\u0016\u0014\bCA\u001a\u000e'\ti\u0011\n\u0005\u0002+\u0015&\u00111j\u000b\u0002\u0007\u0003:L(+\u001a4\u0015\u0003\u001d\u0013aaV8sW\u0016\u00148CA\bP!\tY\u0004+\u0003\u0002Ry\t1A\u000b\u001b:fC\u0012$\u0012a\u0015\t\u0003)>i\u0011!D\u0001\u0007C\u000e$\u0018N^3\u0016\u0003]\u0003\"A\u000b-\n\u0005e[#a\u0002\"p_2,\u0017M\\\u0001\u000bC\u000e$\u0018N^3`I\u0015\fHC\u0001/`!\tQS,\u0003\u0002_W\t!QK\\5u\u0011\u001d\u0001'#!AA\u0002]\u000b1\u0001\u001f\u00132\u0003\u001d\t7\r^5wK\u0002B#aE2\u0011\u0005)\"\u0017BA3,\u0005!1x\u000e\\1uS2,\u0017A\u00037pG\u0006d\u0017+^3vKV\tq'A\u0006m_\u000e\fG.U;fk\u0016\u0004\u0013\u0001\u00048fqR\u0014VO\u001c8bE2,W#\u0001\u001e\u0002!9,\u0007\u0010\u001e*v]:\f'\r\\3`I\u0015\fHC\u0001/n\u0011\u001d\u0001w#!AA\u0002i\nQB\\3yiJ+hN\\1cY\u0016\u0004\u0013aB8q\u0007>,h\u000e^\u000b\u0002cB\u0011!F]\u0005\u0003g.\u0012A\u0001T8oO\u0006Yq\u000e]\"pk:$x\fJ3r)\taf\u000fC\u0004a5\u0005\u0005\t\u0019A9\u0002\u0011=\u00048i\\;oi\u0002B#aG2*\u0005=Qh\u0001B>\u0010\u0001q\u0014Q\u0002\u00107pG\u0006d\u0007e\u00195jY\u0012t4C\u0001>T\u0003\u0015\u0019H/\u0019;f!\ry\u0018QB\u0007\u0003\u0003\u0003QA!a\u0001\u0002\u0006\u00051\u0011\r^8nS\u000eTA!a\u0002\u0002\n\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0007\u0005-a(\u0001\u0003vi&d\u0017\u0002BA\b\u0003\u0003\u0011Q\"\u0011;p[&\u001c\u0017J\u001c;fO\u0016\u0014\u0018aB<pe.,'o\u001d\t\u0005U\u0005UA)C\u0002\u0002\u0018-\u0012Q!\u0011:sCf\fQ\"\u001e8tC\u001a,W*\u001a;sS\u000e\u001cXCAA\u000f!\u0015Q\u0013qDA\u0012\u0013\r\t\tc\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007M\n)#C\u0002\u0002(u\u0011\u0001#\u0012=fGV$\u0018n\u001c8NKR\u0014\u0018nY:\u0002\u0019Ut7/\u00194f'V\u0014W.\u001b;\u0015\u0007]\u000bi\u0003\u0003\u0004\u00020)\u0001\rAO\u0001\teVtg.\u00192mK\u0006!RO\\:bM\u0016\u001cVOY7ji\u0006sG-W5fY\u0012$2aVA\u001b\u0011\u0019\tyc\u0003a\u0001u\u0001")
public final class ZScheduler
extends Executor {
    private final int yieldOpCount;
    public final int zio$internal$ZScheduler$$poolSize;
    public final MutableConcurrentQueue<Runnable> zio$internal$ZScheduler$$globalQueue;
    public final MutableConcurrentQueue<Worker> zio$internal$ZScheduler$$idle;
    public final AtomicInteger zio$internal$ZScheduler$$state;
    public final Worker[] zio$internal$ZScheduler$$workers;

    @Override
    public int yieldOpCount() {
        return this.yieldOpCount;
    }

    @Override
    public Option<ExecutionMetrics> unsafeMetrics() {
        ExecutionMetrics metrics = new ExecutionMetrics(this){
            private final /* synthetic */ ZScheduler $outer;

            public int capacity() {
                return Integer.MAX_VALUE;
            }

            public int concurrency() {
                return this.$outer.zio$internal$ZScheduler$$poolSize;
            }

            /*
             * WARNING - void declaration
             */
            public long dequeuedCount() {
                void var1_1;
                long dequeued = 0L;
                for (int i = 0; i != this.$outer.zio$internal$ZScheduler$$poolSize; ++i) {
                    Worker worker = this.$outer.zio$internal$ZScheduler$$workers[i];
                    dequeued += worker.opCount();
                }
                return (long)var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public long enqueuedCount() {
                void var1_1;
                long enqueued = 0L;
                for (int i = 0; i != this.$outer.zio$internal$ZScheduler$$poolSize; ++i) {
                    Worker worker = this.$outer.zio$internal$ZScheduler$$workers[i];
                    enqueued += worker.opCount();
                    enqueued += (long)worker.localQueue().size();
                    if (worker.nextRunnable() == null) continue;
                    ++enqueued;
                }
                enqueued += (long)this.$outer.zio$internal$ZScheduler$$globalQueue.size();
                return (long)var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public int size() {
                void var2_2;
                int size = 0;
                for (int i = 0; i != this.$outer.zio$internal$ZScheduler$$poolSize; ++i) {
                    Worker worker = this.$outer.zio$internal$ZScheduler$$workers[i];
                    size += worker.localQueue().size();
                    if (worker.nextRunnable() == null) continue;
                    ++size;
                }
                size += this.$outer.zio$internal$ZScheduler$$globalQueue.size();
                return (int)var2_2;
            }

            public int workersCount() {
                return (this.$outer.zio$internal$ZScheduler$$state.get() & 0xFFFF0000) >> 16;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        return new Some((Object)metrics);
    }

    @Override
    public boolean unsafeSubmit(Runnable runnable) {
        Worker worker;
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof Worker) {
            Worker worker2 = (Worker)currentThread;
            if (!worker2.localQueue().offer(runnable)) {
                this.zio$internal$ZScheduler$$globalQueue.offerAll((Iterable<Runnable>)((Iterable)worker2.localQueue().pollUpTo(128).$colon$plus(runnable, ChunkLike$.MODULE$.chunkCanBuildFrom(ChunkCanBuildFrom$.MODULE$.apply()))));
            }
        } else {
            this.zio$internal$ZScheduler$$globalQueue.offer(runnable);
        }
        int currentState = this.zio$internal$ZScheduler$$state.get();
        int currentActive = (currentState & 0xFFFF0000) >> 16;
        int currentSearching = currentState & 0xFFFF;
        if (currentActive != this.zio$internal$ZScheduler$$poolSize && currentSearching == 0 && (worker = (Worker)this.zio$internal$ZScheduler$$idle.poll(null)) != null) {
            this.zio$internal$ZScheduler$$state.getAndAdd(65537);
            worker.active_$eq(true);
            LockSupport.unpark(worker);
        }
        return true;
    }

    @Override
    public boolean unsafeSubmitAndYield(Runnable runnable) {
        Thread currentThread = Thread.currentThread();
        boolean notify = false;
        if (currentThread instanceof Worker) {
            Worker worker = (Worker)currentThread;
            if (worker.nextRunnable() == null && worker.localQueue().isEmpty()) {
                worker.nextRunnable_$eq(runnable);
            } else {
                if (!worker.localQueue().offer(runnable)) {
                    this.zio$internal$ZScheduler$$globalQueue.offerAll((Iterable<Runnable>)((Iterable)worker.localQueue().pollUpTo(128).$colon$plus(runnable, ChunkLike$.MODULE$.chunkCanBuildFrom(ChunkCanBuildFrom$.MODULE$.apply()))));
                }
                notify = true;
            }
        } else {
            this.zio$internal$ZScheduler$$globalQueue.offer(runnable);
            notify = true;
        }
        if (notify) {
            Worker worker;
            int currentState = this.zio$internal$ZScheduler$$state.get();
            int currentActive = (currentState & 0xFFFF0000) >> 16;
            int currentSearching = currentState & 0xFFFF;
            if (currentActive != this.zio$internal$ZScheduler$$poolSize && currentSearching == 0 && (worker = (Worker)this.zio$internal$ZScheduler$$idle.poll(null)) != null) {
                this.zio$internal$ZScheduler$$state.getAndAdd(65537);
                worker.active_$eq(true);
                LockSupport.unpark(worker);
            }
        }
        return true;
    }

    public ZScheduler(int yieldOpCount) {
        this.yieldOpCount = yieldOpCount;
        this.zio$internal$ZScheduler$$poolSize = Runtime.getRuntime().availableProcessors();
        this.zio$internal$ZScheduler$$globalQueue = MutableConcurrentQueue$.MODULE$.unbounded();
        this.zio$internal$ZScheduler$$idle = MutableConcurrentQueue$.MODULE$.bounded(this.zio$internal$ZScheduler$$poolSize);
        this.zio$internal$ZScheduler$$state = new AtomicInteger(this.zio$internal$ZScheduler$$poolSize << 16);
        this.zio$internal$ZScheduler$$workers = (Worker[])Array$.MODULE$.ofDim(this.zio$internal$ZScheduler$$poolSize, ClassTag$.MODULE$.apply(Worker.class));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.zio$internal$ZScheduler$$poolSize).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)workerId -> {
            Worker worker = new Worker(this, workerId){
                private final /* synthetic */ ZScheduler $outer;
                private final int workerId$1;

                public void run() {
                    long currentOpCount = 0L;
                    ThreadLocalRandom random = ThreadLocalRandom.current();
                    boolean searching = false;
                    while (!this.isInterrupted()) {
                        Runnable runnable;
                        if ((currentOpCount & 0x3FL) == 0L) {
                            runnable = this.$outer.zio$internal$ZScheduler$$globalQueue.poll(null);
                            if (runnable == null) {
                                if (this.nextRunnable() != null) {
                                    runnable = this.nextRunnable();
                                    this.nextRunnable_$eq(null);
                                } else {
                                    runnable = this.localQueue().poll(null);
                                }
                            }
                        } else if (this.nextRunnable() != null) {
                            runnable = this.nextRunnable();
                            this.nextRunnable_$eq(null);
                        } else {
                            runnable = this.localQueue().poll(null);
                            if (runnable == null) {
                                runnable = this.$outer.zio$internal$ZScheduler$$globalQueue.poll(null);
                            }
                        }
                        if (runnable == null) {
                            int currentActive;
                            if (!searching && 2 * (currentActive = this.$outer.zio$internal$ZScheduler$$state.get() & 0xFFFF) < this.$outer.zio$internal$ZScheduler$$poolSize) {
                                this.$outer.zio$internal$ZScheduler$$state.getAndIncrement();
                                searching = true;
                            }
                            if (searching) {
                                boolean loop = true;
                                int offset = random.nextInt(this.$outer.zio$internal$ZScheduler$$poolSize);
                                for (int i = 0; i != this.$outer.zio$internal$ZScheduler$$poolSize && loop; ++i) {
                                    Chunk<Runnable> runnables;
                                    Worker worker;
                                    int size;
                                    int index = (i + offset) % this.$outer.zio$internal$ZScheduler$$poolSize;
                                    if (index == this.workerId$1 || (size = (worker = this.$outer.zio$internal$ZScheduler$$workers[index]).localQueue().size()) <= 0 || !(runnables = worker.localQueue().pollUpTo(size - size / 2)).nonEmpty()) continue;
                                    runnable = runnables.head();
                                    if (((ChunkLike)runnables.tail()).nonEmpty()) {
                                        this.localQueue().offerAll((Iterable<Runnable>)((Iterable)runnables.tail()));
                                    }
                                    loop = false;
                                }
                                if (runnable == null) {
                                    runnable = this.$outer.zio$internal$ZScheduler$$globalQueue.poll(null);
                                }
                            }
                        }
                        if (runnable == null) {
                            int currentSearching = (searching ? this.$outer.zio$internal$ZScheduler$$state.addAndGet(-65537) : this.$outer.zio$internal$ZScheduler$$state.addAndGet(-65536)) & 0xFFFF;
                            this.active_$eq(false);
                            this.$outer.zio$internal$ZScheduler$$idle.offer(this);
                            if (currentSearching == 0 && searching) {
                                boolean notify = false;
                                for (int i = 0; i != this.$outer.zio$internal$ZScheduler$$poolSize && !notify; ++i) {
                                    notify = !this.$outer.zio$internal$ZScheduler$$workers[i].localQueue().isEmpty();
                                }
                                if (!notify) {
                                    boolean bl = notify = !this.$outer.zio$internal$ZScheduler$$globalQueue.isEmpty();
                                }
                                if (notify) {
                                    Worker worker;
                                    int currentState = this.$outer.zio$internal$ZScheduler$$state.get();
                                    int currentActive = (currentState & 0xFFFF0000) >> 16;
                                    int currentSearching2 = currentState & 0xFFFF;
                                    if (currentActive != this.$outer.zio$internal$ZScheduler$$poolSize && currentSearching2 == 0 && (worker = (Worker)this.$outer.zio$internal$ZScheduler$$idle.poll(null)) != null) {
                                        this.$outer.zio$internal$ZScheduler$$state.getAndAdd(65537);
                                        worker.active_$eq(true);
                                        LockSupport.unpark(worker);
                                    }
                                }
                            }
                            while (!this.active() && !this.isInterrupted()) {
                                LockSupport.park();
                            }
                            searching = true;
                            continue;
                        }
                        if (searching) {
                            Worker worker;
                            searching = false;
                            int currentState = this.$outer.zio$internal$ZScheduler$$state.decrementAndGet();
                            int currentSearching = currentState & 0xFFFF;
                            if ((currentState & 0xFFFF0000) >> 16 != this.$outer.zio$internal$ZScheduler$$poolSize && currentSearching == 0 && (worker = (Worker)this.$outer.zio$internal$ZScheduler$$idle.poll(null)) != null) {
                                this.$outer.zio$internal$ZScheduler$$state.getAndAdd(65537);
                                worker.active_$eq(true);
                                LockSupport.unpark(worker);
                            }
                        }
                        runnable.run();
                        runnable = null;
                        this.opCount_$eq(++currentOpCount);
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.workerId$1 = workerId$1;
                }
            };
            worker.setName(new StringBuilder(11).append("ZScheduler-").append(workerId).toString());
            worker.setDaemon(true);
            $this.zio$internal$ZScheduler$$workers[workerId] = worker;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.zio$internal$ZScheduler$$workers)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.start();
            return BoxedUnit.UNIT;
        });
    }

    private static abstract class Worker
    extends Thread {
        private volatile boolean active = true;
        private final MutableConcurrentQueue<Runnable> localQueue = MutableConcurrentQueue$.MODULE$.bounded(256);
        private Runnable nextRunnable = null;
        private volatile long opCount = 0L;

        public boolean active() {
            return this.active;
        }

        public void active_$eq(boolean x$1) {
            this.active = x$1;
        }

        public MutableConcurrentQueue<Runnable> localQueue() {
            return this.localQueue;
        }

        public Runnable nextRunnable() {
            return this.nextRunnable;
        }

        public void nextRunnable_$eq(Runnable x$1) {
            this.nextRunnable = x$1;
        }

        public long opCount() {
            return this.opCount;
        }

        public void opCount_$eq(long x$1) {
            this.opCount = x$1;
        }
    }
}

