/*
 * Decompiled with CFR 0.152.
 */
package zio.internal.metrics;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import zio.Chunk;
import zio.ChunkBuilder;
import zio.ChunkBuilder$;
import zio.ChunkLike;
import zio.internal.metrics.ConcurrentHistogram;
import zio.internal.metrics.ConcurrentHistogram$;

public final class ConcurrentHistogram$ {
    public static ConcurrentHistogram$ MODULE$;

    static {
        new ConcurrentHistogram$();
    }

    public ConcurrentHistogram manual(Chunk<Object> bounds) {
        return new ConcurrentHistogram(bounds){
            private final AtomicReferenceArray<Object> values;
            private final double[] boundaries;
            private final LongAdder count;
            private final DoubleAdder sum;
            private final int size;

            public long getCount() {
                return this.count.longValue();
            }

            public void observe(double value) {
                int from = 0;
                int to = this.size;
                while (from != to) {
                    int mid = from + (to - from) / 2;
                    double boundary = this.boundaries[mid];
                    if (value <= boundary) {
                        to = mid;
                    } else {
                        from = mid;
                    }
                    if (to != from + 1) continue;
                    if (value <= this.boundaries[from]) {
                        to = from;
                        continue;
                    }
                    from = to;
                }
                this.values.getAndUpdate(from, x$1 -> BoxesRunTime.boxToLong((long)anon.1.$anonfun$observe$1(BoxesRunTime.unboxToLong((Object)x$1))));
                this.count.increment();
                this.sum.add(value);
            }

            public Chunk<Tuple2<Object, Object>> snapshot() {
                ChunkBuilder<A> builder = ChunkBuilder$.MODULE$.make();
                long cumulated = 0L;
                for (int i = 0; i != this.size; ++i) {
                    double boundary = this.boundaries[i];
                    long value = BoxesRunTime.unboxToLong((Object)this.values.get(i));
                    builder.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)boundary)), (Object)BoxesRunTime.boxToLong((long)(cumulated += value))));
                }
                return (Chunk)builder.result();
            }

            public double getSum() {
                return this.sum.doubleValue();
            }

            public static final /* synthetic */ void $anonfun$new$1(anon.1 $this, Tuple2 x0$1) {
                if (x0$1 != null) {
                    double n = x0$1._1$mcD$sp();
                    int i = x0$1._2$mcI$sp();
                    $this.boundaries[i] = n;
                    return;
                }
                throw new MatchError(null);
            }

            public static final /* synthetic */ long $anonfun$observe$1(long x$1) {
                return x$1 + 1L;
            }
            {
                this.values = new AtomicReferenceArray<E>(bounds$1.length() + 1);
                this.boundaries = (double[])Array$.MODULE$.ofDim(bounds$1.length(), ClassTag$.MODULE$.Double());
                this.count = new LongAdder();
                this.sum = new DoubleAdder();
                this.size = bounds$1.length();
                ((ChunkLike)bounds$1.sorted((Ordering)Ordering.Double$.MODULE$)).zipWithIndex().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    anon.1.$anonfun$new$1(this, x0$1);
                    return BoxedUnit.UNIT;
                });
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$new$1$adapted(zio.internal.metrics.ConcurrentHistogram$$anon$1 scala.Tuple2 )}, serializedLambda);
            }
        };
    }

    private ConcurrentHistogram$() {
        MODULE$ = this;
    }
}

