/*
 * Decompiled with CFR 0.152.
 */
package zio.internal.metrics;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;
import scala.Array$;
import scala.Double$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import zio.Chunk;
import zio.ChunkBuilder;
import zio.ChunkBuilder$;
import zio.ChunkLike;
import zio.Duration$;
import zio.internal.metrics.ConcurrentMetricHooks;
import zio.internal.metrics.ConcurrentMetricHooksPlatformSpecific$AtomicDouble$;
import zio.internal.metrics.MetricHook;
import zio.internal.metrics.package$;
import zio.metrics.MetricKey;
import zio.metrics.MetricKeyType;
import zio.metrics.MetricKeyType$Counter$;
import zio.metrics.MetricKeyType$Frequency$;
import zio.metrics.MetricKeyType$Gauge$;
import zio.metrics.MetricState;

@ScalaSignature(bytes="\u0006\u0001\u0005%b!B\n\u0015\u0001aQ\u0002\"B\u0013\u0001\t\u00039\u0003\"B\u0015\u0001\t\u0003Q\u0003\"\u0002\u001f\u0001\t\u0003i\u0004\"B%\u0001\t\u0013Q\u0005\"B9\u0001\t\u0013\u0011\b\"B;\u0001\t\u00031\b\"B?\u0001\t\u0003q\bbBA\u0006\u0001\u0011\u0005\u0011Q\u0002\u0004\u0005%\u000211\u000b\u0003\u0005U\u0013\t\u0015\r\u0011\"\u0003V\u0011!\t\u0017B!A!\u0002\u00131\u0006\"B\u0013\n\t\u0013\u0011\u0007\"\u00023\n\t\u0003)\u0007\"\u00024\n\t\u00039waBA\u000e\u0001!%\u0011Q\u0004\u0004\u0007%\u0002AI!a\b\t\r\u0015\u0002B\u0011AA\u0011\u0011\u001d\t\u0019\u0003\u0005C\u0001\u0003K\u0011QeQ8oGV\u0014(/\u001a8u\u001b\u0016$(/[2I_>\\7\u000f\u00157bi\u001a|'/\\*qK\u000eLg-[2\u000b\u0005U1\u0012aB7fiJL7m\u001d\u0006\u0003/a\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u00023\u0005\u0019!0[8\u0014\u0007\u0001Y\u0012\u0005\u0005\u0002\u001d?5\tQDC\u0001\u001f\u0003\u0015\u00198-\u00197b\u0013\t\u0001SD\u0001\u0004B]f\u0014VM\u001a\t\u0003E\rj\u0011\u0001F\u0005\u0003IQ\u0011QcQ8oGV\u0014(/\u001a8u\u001b\u0016$(/[2I_>\\7/\u0001\u0004=S:LGOP\u0002\u0001)\u0005A\u0003C\u0001\u0012\u0001\u0003\u001d\u0019w.\u001e8uKJ$\"a\u000b\u001a\u0011\u00051zcB\u0001\u0012.\u0013\tqC#\u0001\u0006NKR\u0014\u0018n\u0019%p_.L!\u0001M\u0019\u0003\u000f\r{WO\u001c;fe*\u0011a\u0006\u0006\u0005\u0006g\t\u0001\r\u0001N\u0001\u0004W\u0016L\bCA\u001b;\u001d\t1\u0004(D\u00018\u0015\t)\u0002$\u0003\u0002:o\u0005IQ*\u001a;sS\u000e\\U-_\u0005\u0003amR!!O\u001c\u0002\u000b\u001d\fWoZ3\u0015\u0007y\nE\t\u0005\u0002-\u007f%\u0011\u0001)\r\u0002\u0006\u000f\u0006,x-\u001a\u0005\u0006g\r\u0001\rA\u0011\t\u0003k\rK!\u0001Q\u001e\t\u000b\u0015\u001b\u0001\u0019\u0001$\u0002\u000fM$\u0018M\u001d;BiB\u0011AdR\u0005\u0003\u0011v\u0011a\u0001R8vE2,\u0017!C;qI\u0006$X-T5o)\rYej\u001c\t\u000391K!!T\u000f\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u001f\u0012\u0001\r\u0001U\u0001\u0007CR|W.[2\u0011\u0005EKQ\"\u0001\u0001\u0003\u0019\u0005#x.\\5d\t>,(\r\\3\u0014\u0005%Y\u0012a\u0001:fMV\ta\u000b\u0005\u0002X?6\t\u0001L\u0003\u0002P3*\u0011!lW\u0001\u000bG>t7-\u001e:sK:$(B\u0001/^\u0003\u0011)H/\u001b7\u000b\u0003y\u000bAA[1wC&\u0011\u0001\r\u0017\u0002\u000b\u0003R|W.[2M_:<\u0017\u0001\u0002:fM\u0002\"\"\u0001U2\t\u000bQc\u0001\u0019\u0001,\u0002\u0007\u001d,G\u000fF\u0001G\u00035\u0019w.\u001c9be\u0016\fe\u000eZ*fiR\u0019\u0001n[7\u0011\u0005qI\u0017B\u00016\u001e\u0005\u001d\u0011un\u001c7fC:DQ\u0001\u001c\bA\u0002\u0019\u000b\u0001\"\u001a=qK\u000e$X\r\u001a\u0005\u0006]:\u0001\rAR\u0001\t]\u0016<h+\u00197vK\")\u0001\u000f\u0002a\u0001\r\u0006)a/\u00197vK\u0006IQ\u000f\u001d3bi\u0016l\u0015\r\u001f\u000b\u0004\u0017N$\b\"B(\u0006\u0001\u0004\u0001\u0006\"\u00029\u0006\u0001\u00041\u0015!\u00035jgR|wM]1n)\t9(\u0010\u0005\u0002-q&\u0011\u00110\r\u0002\n\u0011&\u001cHo\\4sC6DQa\r\u0004A\u0002m\u0004\"!\u000e?\n\u0005e\\\u0014aB:v[6\f'/\u001f\u000b\u0004\u007f\u0006\u0015\u0001c\u0001\u0017\u0002\u0002%\u0019\u00111A\u0019\u0003\u000fM+X.\\1ss\"11g\u0002a\u0001\u0003\u000f\u00012!NA\u0005\u0013\r\t\u0019aO\u0001\nMJ,\u0017/^3oGf$B!a\u0004\u0002\u0016A\u0019A&!\u0005\n\u0007\u0005M\u0011GA\u0005Ge\u0016\fX/\u001a8ds\"11\u0007\u0003a\u0001\u0003/\u00012!NA\r\u0013\r\t\u0019bO\u0001\r\u0003R|W.[2E_V\u0014G.\u001a\t\u0003#B\u0019\"\u0001E\u000e\u0015\u0005\u0005u\u0011\u0001B7bW\u0016$2\u0001UA\u0014\u0011\u0015\u0001(\u00031\u0001G\u0001")
public class ConcurrentMetricHooksPlatformSpecific
implements ConcurrentMetricHooks {
    private volatile ConcurrentMetricHooksPlatformSpecific$AtomicDouble$ AtomicDouble$module;

    private ConcurrentMetricHooksPlatformSpecific$AtomicDouble$ AtomicDouble() {
        if (this.AtomicDouble$module == null) {
            this.AtomicDouble$lzycompute$1();
        }
        return this.AtomicDouble$module;
    }

    @Override
    public MetricHook<Object, MetricState.Counter> counter(MetricKey<MetricKeyType$Counter$> key) {
        DoubleAdder adder = new DoubleAdder();
        return new MetricHook<Object, MetricState.Counter>((Function1<Object, BoxedUnit>)(JFunction1.mcVD.sp & Serializable & scala.Serializable)v -> adder.add(v), (Function0<MetricState.Counter>)(Function0 & Serializable & scala.Serializable)() -> new MetricState.Counter(adder.sum()));
    }

    @Override
    public MetricHook<Object, MetricState.Gauge> gauge(MetricKey<MetricKeyType$Gauge$> key, double startAt) {
        AtomicReference<Double> ref = new AtomicReference<Double>(BoxesRunTime.boxToDouble((double)startAt));
        return new MetricHook<Object, MetricState.Gauge>((Function1<Object, BoxedUnit>)(JFunction1.mcVD.sp & Serializable & scala.Serializable)v -> ref.set(BoxesRunTime.boxToDouble((double)v)), (Function0<MetricState.Gauge>)(Function0 & Serializable & scala.Serializable)() -> new MetricState.Gauge(BoxesRunTime.unboxToDouble(ref.get())));
    }

    private void updateMin(AtomicDouble atomic, double value) {
        boolean loop = true;
        while (loop) {
            double current = atomic.get();
            if (value < current) {
                loop = !atomic.compareAndSet(current, value);
                continue;
            }
            loop = false;
        }
    }

    private void updateMax(AtomicDouble atomic, double value) {
        boolean loop = true;
        while (loop) {
            double current = atomic.get();
            if (value > current) {
                loop = !atomic.compareAndSet(current, value);
                continue;
            }
            loop = false;
        }
    }

    @Override
    public MetricHook<Object, MetricState.Histogram> histogram(MetricKey<MetricKeyType.Histogram> key) {
        Chunk<Object> bounds = key.keyType().boundaries().values();
        AtomicLongArray values = new AtomicLongArray(bounds.length() + 1);
        double[] boundaries = (double[])Array$.MODULE$.ofDim(bounds.length(), ClassTag$.MODULE$.Double());
        LongAdder count = new LongAdder();
        DoubleAdder sum = new DoubleAdder();
        int size = bounds.length();
        AtomicDouble min = this.AtomicDouble().make(Double.MAX_VALUE);
        AtomicDouble max = this.AtomicDouble().make(Double$.MODULE$.MinValue());
        ((ChunkLike)bounds.sorted((Ordering)Ordering.Double$.MODULE$)).zipWithIndex().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ConcurrentMetricHooksPlatformSpecific.$anonfun$histogram$1(boundaries, x0$1);
            return BoxedUnit.UNIT;
        });
        JFunction1.mcVD.sp & Serializable & scala.Serializable update = (JFunction1.mcVD.sp & Serializable & scala.Serializable)value -> {
            int from = 0;
            int to = size;
            while (from != to) {
                int mid = from + (to - from) / 2;
                double boundary = boundaries[mid];
                if (value <= boundary) {
                    to = mid;
                } else {
                    from = mid;
                }
                if (to != from + 1) continue;
                if (value <= boundaries[from]) {
                    to = from;
                    continue;
                }
                from = to;
            }
            values.getAndIncrement(from);
            count.increment();
            sum.add(value);
            this.updateMin(min, value);
            this.updateMax(max, value);
        };
        return new MetricHook<Object, MetricState.Histogram>((Function1<Object, BoxedUnit>)update, (Function0<MetricState.Histogram>)(Function0 & Serializable & scala.Serializable)() -> new MetricState.Histogram(ConcurrentMetricHooksPlatformSpecific.getBuckets$1(size, boundaries, values), count.longValue(), min.get(), max.get(), sum.doubleValue()));
    }

    @Override
    public MetricHook<Tuple2<Object, Instant>, MetricState.Summary> summary(MetricKey<MetricKeyType.Summary> key) {
        AtomicReferenceArray values = new AtomicReferenceArray(key.keyType().maxSize());
        AtomicInteger head = new AtomicInteger(0);
        LongAdder count = new LongAdder();
        DoubleAdder sum = new DoubleAdder();
        AtomicDouble min = this.AtomicDouble().make(Double.MAX_VALUE);
        AtomicDouble max = this.AtomicDouble().make(Double$.MODULE$.MinValue());
        Chunk sortedQuantiles = (Chunk)key.keyType().quantiles().sorted(package$.MODULE$.DoubleOrdering());
        return new MetricHook<Tuple2<Object, Instant>, MetricState.Summary>((Function1 & Serializable & scala.Serializable)x$2 -> {
            this.observe$1(x$2, key, head, values, count, sum, min, max);
            return BoxedUnit.UNIT;
        }, (Function0 & Serializable & scala.Serializable)() -> new MetricState.Summary(((MetricKeyType.Summary)key.keyType()).error(), ConcurrentMetricHooksPlatformSpecific.snapshot$1(Instant.now(), key, values, sortedQuantiles), ConcurrentMetricHooksPlatformSpecific.getCount$1(count), ConcurrentMetricHooksPlatformSpecific.getMin$1(min), ConcurrentMetricHooksPlatformSpecific.getMax$1(max), ConcurrentMetricHooksPlatformSpecific.getSum$1(sum)));
    }

    @Override
    public MetricHook<String, MetricState.Frequency> frequency(MetricKey<MetricKeyType$Frequency$> key) {
        LongAdder count = new LongAdder();
        ConcurrentHashMap values = new ConcurrentHashMap();
        Function1 & Serializable & scala.Serializable update = (Function1 & Serializable & scala.Serializable)word -> {
            ConcurrentMetricHooksPlatformSpecific.$anonfun$frequency$1(count, values, word);
            return BoxedUnit.UNIT;
        };
        return new MetricHook<String, MetricState.Frequency>(update, (Function0 & Serializable & scala.Serializable)() -> new MetricState.Frequency((Map<String, Object>)ConcurrentMetricHooksPlatformSpecific.snapshot$2(values)));
    }

    private final void AtomicDouble$lzycompute$1() {
        synchronized (this) {
            if (this.AtomicDouble$module == null) {
                this.AtomicDouble$module = new ConcurrentMetricHooksPlatformSpecific$AtomicDouble$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$histogram$1(double[] boundaries$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            double n = x0$1._1$mcD$sp();
            int i = x0$1._2$mcI$sp();
            boundaries$1[i] = n;
            return;
        }
        throw new MatchError(null);
    }

    private static final Chunk getBuckets$1(int size$1, double[] boundaries$1, AtomicLongArray values$1) {
        ChunkBuilder builder = ChunkBuilder$.MODULE$.make();
        long cumulated = 0L;
        for (int i = 0; i != size$1; ++i) {
            double boundary = boundaries$1[i];
            long value = values$1.get(i);
            builder.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)boundary)), (Object)BoxesRunTime.boxToLong((long)(cumulated += value))));
        }
        return (Chunk)builder.result();
    }

    private static final long getCount$1(LongAdder count$2) {
        return count$2.longValue();
    }

    private static final double getMin$1(AtomicDouble min$2) {
        return min$2.get();
    }

    private static final double getMax$1(AtomicDouble max$2) {
        return max$2.get();
    }

    private static final double getSum$1(DoubleAdder sum$2) {
        return sum$2.doubleValue();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Object $anonfun$summary$1(AtomicReferenceArray values$2, Instant now$1, MetricKey key$1, ChunkBuilder builder$1, int idx) {
        Tuple2 item = (Tuple2)values$2.get(idx);
        if (item != null) {
            void var8_7;
            double v = item._1$mcD$sp();
            Instant t = (Instant)item._2();
            Duration age = Duration$.MODULE$.fromInterval((Instant)var8_7, now$1);
            if (!age.isNegative() && age.compareTo(((MetricKeyType.Summary)key$1.keyType()).maxAge()) <= 0) {
                void var6_6;
                return builder$1.$plus$eq(BoxesRunTime.boxToDouble((double)var6_6));
            }
            return BoxedUnit.UNIT;
        }
        return BoxedUnit.UNIT;
    }

    private static final Chunk snapshot$1(Instant now, MetricKey key$1, AtomicReferenceArray values$2, Chunk sortedQuantiles$1) {
        ChunkBuilder builder = ChunkBuilder$.MODULE$.make();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), ((MetricKeyType.Summary)key$1.keyType()).maxSize()).foreach((Function1 & Serializable & scala.Serializable)idx -> ConcurrentMetricHooksPlatformSpecific.$anonfun$summary$1(values$2, now, key$1, builder, BoxesRunTime.unboxToInt((Object)idx)));
        return package$.MODULE$.calculateQuantiles(((MetricKeyType.Summary)key$1.keyType()).error(), sortedQuantiles$1, (Chunk)((SeqLike)builder.result()).sorted(package$.MODULE$.DoubleOrdering()));
    }

    private final void observe$1(Tuple2 tuple, MetricKey key$1, AtomicInteger head$1, AtomicReferenceArray values$2, LongAdder count$2, DoubleAdder sum$2, AtomicDouble min$2, AtomicDouble max$2) {
        if (((MetricKeyType.Summary)key$1.keyType()).maxSize() > 0) {
            int target = head$1.incrementAndGet() % ((MetricKeyType.Summary)key$1.keyType()).maxSize();
            values$2.set(target, tuple);
        }
        double value = tuple._1$mcD$sp();
        count$2.increment();
        sum$2.add(value);
        this.updateMin(min$2, value);
        this.updateMax(max$2, value);
    }

    public static final /* synthetic */ void $anonfun$frequency$1(LongAdder count$3, ConcurrentHashMap values$3, String word) {
        count$3.increment();
        LongAdder slot = (LongAdder)values$3.get(word);
        if (slot == null) {
            LongAdder cnt = new LongAdder();
            values$3.putIfAbsent(word, cnt);
            slot = (LongAdder)values$3.get(word);
        }
        slot.increment();
    }

    private static final Map snapshot$2(ConcurrentHashMap values$3) {
        scala.collection.mutable.Map builder = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        for (Map.Entry e : values$3.entrySet()) {
            builder.update(e.getKey(), (Object)BoxesRunTime.boxToLong((long)((LongAdder)e.getValue()).longValue()));
        }
        return builder.toMap(Predef$.MODULE$.$conforms());
    }

    private final class AtomicDouble {
        private final AtomicLong ref;

        private AtomicLong ref() {
            return this.ref;
        }

        public double get() {
            return Double.longBitsToDouble(this.ref().get());
        }

        public boolean compareAndSet(double expected, double newValue) {
            return this.ref().compareAndSet(Double.doubleToLongBits(expected), Double.doubleToLongBits(newValue));
        }

        public AtomicDouble(ConcurrentMetricHooksPlatformSpecific $outer, AtomicLong ref) {
            this.ref = ref;
        }
    }
}

