/*
 * Decompiled with CFR 0.152.
 */
package zio.internal;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.HashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import zio.Chunk;
import zio.ChunkCanBuildFrom$;
import zio.ChunkLike;
import zio.ChunkLike$;
import zio.Executor;
import zio.Trace$;
import zio.Unsafe;
import zio.internal.Blocking$;
import zio.internal.ExecutionMetrics;
import zio.internal.FiberRunnable;
import zio.internal.MutableConcurrentQueue;
import zio.internal.MutableConcurrentQueue$;

@ScalaSignature(bytes="\u0006\u0001\u0005]g\u0001\u0002\u0016,\rABQ!\u000e\u0001\u0005\u0002YBa!\u000f\u0001!\u0002\u0013Q\u0004B\u0002!\u0001A\u0003%\u0011\t\u0003\u0005\u00024\u0001\u0001\u000b\u0011BA\u0006\u0011\u001d\t)\u0004\u0001Q\u0001\n\u0005C\u0001\"a\u000e\u0001A\u0003%\u0011\u0011\b\u0005\t\u0003\u001b\u0002\u0001\u0015!\u0003\u0002P!A\u0011q\u000e\u0001!\u0002\u0013\t\t\b\u0003\u0005\u0002x\u0001\u0001\u000b\u0015BA=\u0011!\tY\t\u0001Q\u0001\n\u00055\u0005bBAH\u0001\u0011\u0005\u0011\u0011\u0013\u0005\b\u0003S\u0003A\u0011AAV\u0011\u001d\t)\f\u0001C!\u0003oC\u0001\"a0\u0001A\u0013%\u0011\u0011\u0019\u0005\t\u0003\u000b\u0004\u0001\u0015\"\u0003\u0002H\"A\u0011\u0011\u001a\u0001!\n\u0013\tY\r\u0003\u0005\u0002N\u0002\u0001K\u0011BAh\u000f\u001915\u0006#\u0001.\u000f\u001a1!f\u000bE\u0001[!CQ!N\n\u0005\u000213Q!T\n\u0002*9CQ!N\u000b\u0005\u0002]3QAX\n\u0002*}CQ!N\f\u0005\u0002\u0001DqAY\fA\u0002\u0013\u00051\rC\u0004h/\u0001\u0007I\u0011\u00015\t\r9<\u0002\u0015)\u0003e\u0011\u001d\u0019x\u00031A\u0005\u0002\rDq\u0001^\fA\u0002\u0013\u0005Q\u000f\u0003\u0004x/\u0001\u0006K\u0001\u001a\u0005\bs^\u0001\r\u0011\"\u0001{\u0011\u001dqx\u00031A\u0005\u0002}Dq!a\u0001\u0018A\u0003&1\u0010C\u0005\u0002\b]\u0011\r\u0011\"\u0001\u0002\n!A\u0011QB\f!\u0002\u0013\tY\u0001\u0003\u0005\u0002\u0010]\u0001\r\u0011\"\u0001{\u0011%\t\tb\u0006a\u0001\n\u0003\t\u0019\u0002C\u0004\u0002\u0018]\u0001\u000b\u0015B>\t\u0013\u0005eq\u00031A\u0005\u0002\u0005m\u0001\"CA\u0012/\u0001\u0007I\u0011AA\u0013\u0011!\tIc\u0006Q!\n\u0005u!A\u0003.TG\",G-\u001e7fe*\u0011A&L\u0001\tS:$XM\u001d8bY*\ta&A\u0002{S>\u001c\u0001a\u0005\u0002\u0001cA\u0011!gM\u0007\u0002[%\u0011A'\f\u0002\t\u000bb,7-\u001e;pe\u00061A(\u001b8jiz\"\u0012a\u000e\t\u0003q\u0001i\u0011aK\u0001\ta>|GnU5{KB\u00111HP\u0007\u0002y)\tQ(A\u0003tG\u0006d\u0017-\u0003\u0002@y\t\u0019\u0011J\u001c;\u0002\u000b\r\f7\r[3\u0011\u0007a\u0012E)\u0003\u0002DW\t1R*\u001e;bE2,7i\u001c8dkJ\u0014XM\u001c;Rk\u0016,X\r\u0005\u0002F/9\u0011\u0001HE\u0001\u000b5N\u001b\u0007.\u001a3vY\u0016\u0014\bC\u0001\u001d\u0014'\t\u0019\u0012\n\u0005\u0002<\u0015&\u00111\n\u0010\u0002\u0007\u0003:L(+\u001a4\u0015\u0003\u001d\u0013!bU;qKJ4\u0018n]8s'\t)r\n\u0005\u0002Q+6\t\u0011K\u0003\u0002S'\u0006!A.\u00198h\u0015\u0005!\u0016\u0001\u00026bm\u0006L!AV)\u0003\rQC'/Z1e)\u0005A\u0006CA-\u0016\u001b\u0005\u0019\u0012FA\u000b\\\r\u0011aV\u0003A/\u0003\u001bqbwnY1mA\rD\u0017\u000e\u001c3?'\tY\u0006L\u0001\u0004X_J\\WM]\n\u0003/=#\u0012!\u0019\t\u00033^\ta!Y2uSZ,W#\u00013\u0011\u0005m*\u0017B\u00014=\u0005\u001d\u0011un\u001c7fC:\f!\"Y2uSZ,w\fJ3r)\tIG\u000e\u0005\u0002<U&\u00111\u000e\u0010\u0002\u0005+:LG\u000fC\u0004n5\u0005\u0005\t\u0019\u00013\u0002\u0007a$\u0013'A\u0004bGRLg/\u001a\u0011)\u0005m\u0001\bCA\u001er\u0013\t\u0011HH\u0001\u0005w_2\fG/\u001b7f\u0003!\u0011Gn\\2lS:<\u0017\u0001\u00042m_\u000e\\\u0017N\\4`I\u0015\fHCA5w\u0011\u001diW$!AA\u0002\u0011\f\u0011B\u00197pG.Lgn\u001a\u0011)\u0005y\u0001\u0018aD2veJ,g\u000e\u001e*v]:\f'\r\\3\u0016\u0003m\u0004\"\u0001\u0015?\n\u0005u\f&\u0001\u0003*v]:\f'\r\\3\u0002'\r,(O]3oiJ+hN\\1cY\u0016|F%Z9\u0015\u0007%\f\t\u0001C\u0004nA\u0005\u0005\t\u0019A>\u0002!\r,(O]3oiJ+hN\\1cY\u0016\u0004\u0003FA\u0011q\u0003)awnY1m#V,W/Z\u000b\u0003\u0003\u0017\u00012\u0001\u000f\"|\u0003-awnY1m#V,W/\u001a\u0011\u0002\u00199,\u0007\u0010\u001e*v]:\f'\r\\3\u0002!9,\u0007\u0010\u001e*v]:\f'\r\\3`I\u0015\fHcA5\u0002\u0016!9Q.JA\u0001\u0002\u0004Y\u0018!\u00048fqR\u0014VO\u001c8bE2,\u0007%A\u0004pa\u000e{WO\u001c;\u0016\u0005\u0005u\u0001cA\u001e\u0002 %\u0019\u0011\u0011\u0005\u001f\u0003\t1{gnZ\u0001\f_B\u001cu.\u001e8u?\u0012*\u0017\u000fF\u0002j\u0003OA\u0001\"\u001c\u0015\u0002\u0002\u0003\u0007\u0011QD\u0001\t_B\u001cu.\u001e8uA!\u0012\u0011\u0006]\u0015\u0004/\u0005=b!\u0002/\u0018\u0001\u0005E2cAA\u0018C\u0006Yq\r\\8cC2\fV/Z;f\u0003\u0011IG\r\\3\u0002\u000bM$\u0018\r^3\u0011\t\u0005m\u0012\u0011J\u0007\u0003\u0003{QA!a\u0010\u0002B\u00051\u0011\r^8nS\u000eTA!a\u0011\u0002F\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0007\u0005\u001d3+\u0001\u0003vi&d\u0017\u0002BA&\u0003{\u0011Q\"\u0011;p[&\u001c\u0017J\u001c;fO\u0016\u0014\u0018AE:vE6LG\u000f^3e\u0019>\u001c\u0017\r^5p]N\u0004\u0002\"!\u0015\u0002T\u0005]\u0013QD\u0007\u0003\u0003\u000bJA!!\u0016\u0002F\t9\u0001*Y:i\u001b\u0006\u0004\b\u0003BA-\u0003SrA!a\u0017\u0002f9!\u0011QLA2\u001b\t\tyFC\u0002\u0002b=\na\u0001\u0010:p_Rt\u0014\"\u0001\u0018\n\u0007\u0005\u001dT&A\u0004qC\u000e\\\u0017mZ3\n\t\u0005-\u0014Q\u000e\u0002\u0006)J\f7-\u001a\u0006\u0004\u0003Oj\u0013aB<pe.,'o\u001d\t\u0005w\u0005MD)C\u0002\u0002vq\u0012Q!\u0011:sCf\f\u0011C\u00197pG.Lgn\u001a'pG\u0006$\u0018n\u001c8t!\u0019\tY(a!\u0002X9!\u0011QPA@!\r\ti\u0006P\u0005\u0004\u0003\u0003c\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0006\u0006\u001d%aA*fi*\u0019\u0011\u0011\u0011\u001f)\u0005%\u0001\u0018AC:va\u0016\u0014h/[:peB\u0011Q)F\u0001\b[\u0016$(/[2t)\u0011\t\u0019*a(\u0011\u000bm\n)*!'\n\u0007\u0005]EH\u0001\u0004PaRLwN\u001c\t\u0004q\u0005m\u0015bAAOW\t\u0001R\t_3dkRLwN\\'fiJL7m\u001d\u0005\b\u0003C[\u00019AAR\u0003\u0019)hn]1gKB\u0019!'!*\n\u0007\u0005\u001dVF\u0001\u0004V]N\fg-Z\u0001\u0007gV\u0014W.\u001b;\u0015\t\u00055\u0016\u0011\u0017\u000b\u0004I\u0006=\u0006bBAQ\u0019\u0001\u000f\u00111\u0015\u0005\u0007\u0003gc\u0001\u0019A>\u0002\u0011I,hN\\1cY\u0016\fab];c[&$\u0018I\u001c3ZS\u0016dG\r\u0006\u0003\u0002:\u0006uFc\u00013\u0002<\"9\u0011\u0011U\u0007A\u0004\u0005\r\u0006BBAZ\u001b\u0001\u000710\u0001\u0006jg\ncwnY6j]\u001e$2\u0001ZAb\u0011\u0019\t\u0019L\u0004a\u0001w\u0006qQ.Y6f'V\u0004XM\u001d<jg>\u0014HCAAG\u0003)i\u0017m[3X_J\\WM\u001d\u000b\u0002\t\u0006q1/\u001e2nSR\u0014En\\2lS:<G\u0003BAi\u0003+$2\u0001ZAj\u0011\u001d\t\t+\u0005a\u0002\u0003GCa!a-\u0012\u0001\u0004Y\b")
public final class ZScheduler
extends Executor {
    public final int zio$internal$ZScheduler$$poolSize = Runtime.getRuntime().availableProcessors();
    public final MutableConcurrentQueue<Worker> zio$internal$ZScheduler$$cache = MutableConcurrentQueue$.MODULE$.unbounded();
    public final MutableConcurrentQueue<Runnable> zio$internal$ZScheduler$$globalQueue = MutableConcurrentQueue$.MODULE$.unbounded();
    public final MutableConcurrentQueue<Worker> zio$internal$ZScheduler$$idle = MutableConcurrentQueue$.MODULE$.bounded(this.zio$internal$ZScheduler$$poolSize);
    public final AtomicInteger zio$internal$ZScheduler$$state = new AtomicInteger(this.zio$internal$ZScheduler$$poolSize << 16);
    public final HashMap<Object, Object> zio$internal$ZScheduler$$submittedLocations = new HashMap();
    public final Worker[] zio$internal$ZScheduler$$workers = (Worker[])Array$.MODULE$.ofDim(this.zio$internal$ZScheduler$$poolSize, ClassTag$.MODULE$.apply(Worker.class));
    public volatile Set<Object> zio$internal$ZScheduler$$blockingLocations = Predef$.MODULE$.Set().empty();
    private final Supervisor supervisor;

    @Override
    public Option<ExecutionMetrics> metrics(Unsafe unsafe) {
        ExecutionMetrics metrics = new ExecutionMetrics(this){
            private final /* synthetic */ ZScheduler $outer;

            public int capacity() {
                return Integer.MAX_VALUE;
            }

            public int concurrency() {
                return this.$outer.zio$internal$ZScheduler$$poolSize;
            }

            public long dequeuedCount() {
                long dequeued = 0L;
                for (int i = 0; i != this.$outer.zio$internal$ZScheduler$$poolSize; ++i) {
                    Worker worker = this.$outer.zio$internal$ZScheduler$$workers[i];
                    dequeued += worker.opCount();
                }
                return dequeued;
            }

            public long enqueuedCount() {
                long enqueued = 0L;
                for (int i = 0; i != this.$outer.zio$internal$ZScheduler$$poolSize; ++i) {
                    Worker worker = this.$outer.zio$internal$ZScheduler$$workers[i];
                    enqueued += worker.opCount();
                    enqueued += (long)worker.localQueue().size();
                    if (worker.nextRunnable() == null) continue;
                    ++enqueued;
                }
                return enqueued += (long)this.$outer.zio$internal$ZScheduler$$globalQueue.size();
            }

            public int size() {
                int size = 0;
                for (int i = 0; i != this.$outer.zio$internal$ZScheduler$$poolSize; ++i) {
                    Worker worker = this.$outer.zio$internal$ZScheduler$$workers[i];
                    size += worker.localQueue().size();
                    if (worker.nextRunnable() == null) continue;
                    ++size;
                }
                return size += this.$outer.zio$internal$ZScheduler$$globalQueue.size();
            }

            public int workersCount() {
                return (this.$outer.zio$internal$ZScheduler$$state.get() & 0xFFFF0000) >> 16;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        return new Some((Object)metrics);
    }

    @Override
    public boolean submit(Runnable runnable, Unsafe unsafe) {
        boolean bl;
        if (runnable instanceof FiberRunnable) {
            Object isBlocking_location = ((FiberRunnable)runnable).location();
            long isBlocking_submittedCount = BoxesRunTime.unboxToLong((Object)this.zio$internal$ZScheduler$$submittedLocations.getOrDefault(isBlocking_location, BoxesRunTime.boxToLong((long)0L)));
            this.zio$internal$ZScheduler$$submittedLocations.put(isBlocking_location, BoxesRunTime.boxToLong((long)(isBlocking_submittedCount + 1L)));
            bl = this.zio$internal$ZScheduler$$blockingLocations.contains(isBlocking_location);
        } else {
            bl = false;
        }
        if (bl) {
            return Blocking$.MODULE$.blockingExecutor().submit(runnable, unsafe);
        }
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof Worker) {
            Worker worker = (Worker)currentThread;
            if (worker.blocking()) {
                this.zio$internal$ZScheduler$$globalQueue.offer(runnable);
            } else if (worker.localQueue().offer(runnable)) {
                Runnable runnable2;
                if (worker.blocking() && (runnable2 = (Runnable)worker.localQueue().poll(null)) != null) {
                    this.zio$internal$ZScheduler$$globalQueue.offer(runnable2);
                }
            } else {
                this.zio$internal$ZScheduler$$globalQueue.offerAll((Iterable)worker.localQueue().pollUpTo(128).$colon$plus(runnable, ChunkLike$.MODULE$.chunkCanBuildFrom(ChunkCanBuildFrom$.MODULE$.apply())));
            }
        } else {
            this.zio$internal$ZScheduler$$globalQueue.offer(runnable);
        }
        int currentState = this.zio$internal$ZScheduler$$state.get();
        int currentActive = (currentState & 0xFFFF0000) >> 16;
        int currentSearching = currentState & 0xFFFF;
        if (currentActive != this.zio$internal$ZScheduler$$poolSize && currentSearching == 0) {
            boolean loop = true;
            while (loop) {
                Worker worker = this.zio$internal$ZScheduler$$idle.poll(null);
                if (worker == null) {
                    loop = false;
                    continue;
                }
                this.zio$internal$ZScheduler$$state.getAndAdd(65537);
                worker.active_$eq(true);
                LockSupport.unpark(worker);
                loop = false;
            }
        }
        return true;
    }

    @Override
    public boolean submitAndYield(Runnable runnable, Unsafe unsafe) {
        boolean bl;
        if (runnable instanceof FiberRunnable) {
            Object isBlocking_location = ((FiberRunnable)runnable).location();
            long isBlocking_submittedCount = BoxesRunTime.unboxToLong((Object)this.zio$internal$ZScheduler$$submittedLocations.getOrDefault(isBlocking_location, BoxesRunTime.boxToLong((long)0L)));
            this.zio$internal$ZScheduler$$submittedLocations.put(isBlocking_location, BoxesRunTime.boxToLong((long)(isBlocking_submittedCount + 1L)));
            bl = this.zio$internal$ZScheduler$$blockingLocations.contains(isBlocking_location);
        } else {
            bl = false;
        }
        if (bl) {
            return Blocking$.MODULE$.blockingExecutor().submit(runnable, unsafe);
        }
        Thread currentThread = Thread.currentThread();
        boolean notify = false;
        if (currentThread instanceof Worker) {
            Worker worker = (Worker)currentThread;
            if (worker.blocking()) {
                this.zio$internal$ZScheduler$$globalQueue.offer(runnable);
                notify = true;
            } else if (worker.nextRunnable() == null && worker.localQueue().isEmpty()) {
                worker.nextRunnable_$eq(runnable);
            } else if (worker.localQueue().offer(runnable)) {
                Runnable runnable2;
                if (worker.blocking() && (runnable2 = (Runnable)worker.localQueue().poll(null)) != null) {
                    this.zio$internal$ZScheduler$$globalQueue.offer(runnable2);
                }
                notify = true;
            } else {
                this.zio$internal$ZScheduler$$globalQueue.offerAll((Iterable)worker.localQueue().pollUpTo(128).$colon$plus(runnable, ChunkLike$.MODULE$.chunkCanBuildFrom(ChunkCanBuildFrom$.MODULE$.apply())));
                notify = true;
            }
        } else {
            this.zio$internal$ZScheduler$$globalQueue.offer(runnable);
            notify = true;
        }
        if (notify) {
            int currentState = this.zio$internal$ZScheduler$$state.get();
            int currentActive = (currentState & 0xFFFF0000) >> 16;
            int currentSearching = currentState & 0xFFFF;
            if (currentActive != this.zio$internal$ZScheduler$$poolSize && currentSearching == 0) {
                boolean loop = true;
                while (loop) {
                    Worker worker = this.zio$internal$ZScheduler$$idle.poll(null);
                    if (worker == null) {
                        loop = false;
                        continue;
                    }
                    this.zio$internal$ZScheduler$$state.getAndAdd(65537);
                    worker.active_$eq(true);
                    LockSupport.unpark(worker);
                    loop = false;
                }
            }
        }
        return true;
    }

    private boolean isBlocking(Runnable runnable) {
        if (runnable instanceof FiberRunnable) {
            Object location = ((FiberRunnable)runnable).location();
            long submittedCount = BoxesRunTime.unboxToLong((Object)this.zio$internal$ZScheduler$$submittedLocations.getOrDefault(location, BoxesRunTime.boxToLong((long)0L)));
            this.zio$internal$ZScheduler$$submittedLocations.put(location, BoxesRunTime.boxToLong((long)(submittedCount + 1L)));
            return this.zio$internal$ZScheduler$$blockingLocations.contains(location);
        }
        return false;
    }

    private Supervisor makeSupervisor() {
        return new Supervisor(this){
            private final /* synthetic */ ZScheduler $outer;

            public void run() {
                long currentTime = System.currentTimeMillis();
                HashMap<Object, Long> identifiedLocations = new HashMap<Object, Long>();
                long[] previousOpCounts = (long[])Array$.MODULE$.fill(this.$outer.zio$internal$ZScheduler$$poolSize, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L, ClassTag$.MODULE$.Long());
                while (!this.isInterrupted()) {
                    for (int workerId = 0; workerId != this.$outer.zio$internal$ZScheduler$$poolSize; ++workerId) {
                        Worker currentWorker = this.$outer.zio$internal$ZScheduler$$workers[workerId];
                        if (currentWorker.active()) {
                            long previousOpCount;
                            long currentOpCount = currentWorker.opCount();
                            if (currentOpCount == (previousOpCount = previousOpCounts[workerId])) {
                                Object location;
                                Runnable currentRunnable = currentWorker.currentRunnable();
                                if (currentRunnable instanceof FiberRunnable && (location = ((FiberRunnable)currentRunnable).location()) != Trace$.MODULE$.empty()) {
                                    long identifiedCount = BoxesRunTime.unboxToLong((Object)identifiedLocations.getOrDefault(location, BoxesRunTime.boxToLong((long)0L)));
                                    identifiedLocations.put(location, BoxesRunTime.boxToLong((long)(identifiedCount + 1L)));
                                    long submittedCount = BoxesRunTime.unboxToLong((Object)this.$outer.zio$internal$ZScheduler$$submittedLocations.getOrDefault(location, BoxesRunTime.boxToLong((long)0L)));
                                    if (submittedCount > 64L && identifiedCount >= submittedCount / 2L) {
                                        this.$outer.zio$internal$ZScheduler$$blockingLocations = (Set)this.$outer.zio$internal$ZScheduler$$blockingLocations.$plus(location);
                                    }
                                }
                                previousOpCounts[workerId] = -1L;
                                currentWorker.blocking_$eq(true);
                                Chunk<Runnable> runnables = currentWorker.localQueue().pollUpTo(256);
                                this.$outer.zio$internal$ZScheduler$$globalQueue.offerAll(runnables);
                                Worker worker = this.$outer.zio$internal$ZScheduler$$cache.poll(null);
                                if (worker == null) {
                                    Worker worker2 = this.$outer.zio$internal$ZScheduler$$makeWorker();
                                    worker2.setName(new StringBuilder(11).append("ZScheduler-").append(workerId).toString());
                                    worker2.setDaemon(true);
                                    this.$outer.zio$internal$ZScheduler$$workers[workerId] = worker2;
                                    worker2.start();
                                    continue;
                                }
                                this.$outer.zio$internal$ZScheduler$$state.getAndIncrement();
                                worker.setName(new StringBuilder(11).append("ZScheduler-").append(workerId).toString());
                                this.$outer.zio$internal$ZScheduler$$workers[workerId] = worker;
                                worker.blocking_$eq(false);
                                worker.active_$eq(true);
                                LockSupport.unpark(worker);
                                continue;
                            }
                            previousOpCounts[workerId] = currentOpCount;
                            continue;
                        }
                        previousOpCounts[workerId] = -1L;
                    }
                    long deadline = currentTime + 100L;
                    boolean loop = true;
                    while (loop) {
                        LockSupport.parkUntil(deadline);
                        currentTime = System.currentTimeMillis();
                        loop = currentTime < deadline;
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1()}, serializedLambda);
            }
        };
    }

    public Worker zio$internal$ZScheduler$$makeWorker() {
        return new Worker(this){
            private final /* synthetic */ ZScheduler $outer;

            public void run() {
                long currentOpCount = 0L;
                ThreadLocalRandom random = ThreadLocalRandom.current();
                Runnable runnable = null;
                boolean searching = false;
                while (!this.isInterrupted()) {
                    boolean currentBlocking = this.blocking();
                    if (currentBlocking) {
                        if (this.nextRunnable() != null) {
                            runnable = this.nextRunnable();
                            this.nextRunnable_$eq(null);
                        }
                    } else {
                        if ((currentOpCount & 0x3FL) == 0L) {
                            runnable = this.$outer.zio$internal$ZScheduler$$globalQueue.poll(null);
                            if (runnable == null) {
                                if (this.nextRunnable() != null) {
                                    runnable = this.nextRunnable();
                                    this.nextRunnable_$eq(null);
                                } else {
                                    runnable = this.localQueue().poll(null);
                                }
                            }
                        } else if (this.nextRunnable() != null) {
                            runnable = this.nextRunnable();
                            this.nextRunnable_$eq(null);
                        } else {
                            runnable = this.localQueue().poll(null);
                            if (runnable == null) {
                                runnable = this.$outer.zio$internal$ZScheduler$$globalQueue.poll(null);
                            }
                        }
                        if (runnable == null) {
                            int currentActive;
                            if (!searching && 2 * (currentActive = this.$outer.zio$internal$ZScheduler$$state.get() & 0xFFFF) < this.$outer.zio$internal$ZScheduler$$poolSize) {
                                this.$outer.zio$internal$ZScheduler$$state.getAndIncrement();
                                searching = true;
                            }
                            if (searching) {
                                boolean loop = true;
                                int offset = random.nextInt(this.$outer.zio$internal$ZScheduler$$poolSize);
                                for (int i = 0; i != this.$outer.zio$internal$ZScheduler$$poolSize && loop; ++i) {
                                    Chunk<Runnable> runnables;
                                    Chunk<Runnable> runnables2;
                                    int size;
                                    int index = (i + offset) % this.$outer.zio$internal$ZScheduler$$poolSize;
                                    Worker worker = this.$outer.zio$internal$ZScheduler$$workers[index];
                                    if (worker == this || worker.blocking() || (size = worker.localQueue().size()) <= 0 || !(runnables2 = worker.localQueue().pollUpTo(size - size / 2)).nonEmpty()) continue;
                                    runnable = runnables2.head();
                                    if (((ChunkLike)runnables2.tail()).nonEmpty()) {
                                        this.localQueue().offerAll((Iterable)runnables2.tail());
                                    }
                                    if ((currentBlocking = this.blocking()) && (runnables = this.localQueue().pollUpTo(256)).nonEmpty()) {
                                        this.$outer.zio$internal$ZScheduler$$globalQueue.offerAll(runnables);
                                    }
                                    loop = false;
                                }
                                if (runnable == null) {
                                    runnable = this.$outer.zio$internal$ZScheduler$$globalQueue.poll(null);
                                }
                            }
                        }
                    }
                    if (runnable == null) {
                        int currentSearching = (currentBlocking && searching ? this.$outer.zio$internal$ZScheduler$$state.decrementAndGet() : (currentBlocking ? this.$outer.zio$internal$ZScheduler$$state.get() : (searching ? this.$outer.zio$internal$ZScheduler$$state.addAndGet(-65537) : this.$outer.zio$internal$ZScheduler$$state.addAndGet(-65536)))) & 0xFFFF;
                        this.active_$eq(false);
                        if (currentBlocking) {
                            this.$outer.zio$internal$ZScheduler$$cache.offer(this);
                        } else {
                            this.$outer.zio$internal$ZScheduler$$idle.offer(this);
                        }
                        if (currentSearching == 0 && searching) {
                            boolean notify = false;
                            for (int i = 0; i != this.$outer.zio$internal$ZScheduler$$poolSize && !notify; ++i) {
                                notify = !this.$outer.zio$internal$ZScheduler$$workers[i].localQueue().isEmpty();
                            }
                            if (!notify) {
                                boolean bl = notify = !this.$outer.zio$internal$ZScheduler$$globalQueue.isEmpty();
                            }
                            if (notify) {
                                int currentState = this.$outer.zio$internal$ZScheduler$$state.get();
                                int currentActive = (currentState & 0xFFFF0000) >> 16;
                                int currentSearching2 = currentState & 0xFFFF;
                                if (currentActive != this.$outer.zio$internal$ZScheduler$$poolSize && currentSearching2 == 0) {
                                    boolean loop = true;
                                    while (loop) {
                                        Worker worker = this.$outer.zio$internal$ZScheduler$$idle.poll(null);
                                        if (worker == null) {
                                            loop = false;
                                            continue;
                                        }
                                        this.$outer.zio$internal$ZScheduler$$state.getAndAdd(65537);
                                        worker.active_$eq(true);
                                        LockSupport.unpark(worker);
                                        loop = false;
                                    }
                                }
                            }
                        }
                        while (!this.active() && !this.isInterrupted()) {
                            LockSupport.park();
                        }
                        searching = true;
                        continue;
                    }
                    if (searching) {
                        searching = false;
                        int currentState = this.$outer.zio$internal$ZScheduler$$state.decrementAndGet();
                        int currentSearching = currentState & 0xFFFF;
                        if ((currentState & 0xFFFF0000) >> 16 != this.$outer.zio$internal$ZScheduler$$poolSize && currentSearching == 0) {
                            boolean loop = true;
                            while (loop) {
                                Worker worker = this.$outer.zio$internal$ZScheduler$$idle.poll(null);
                                if (worker == null) {
                                    loop = false;
                                    continue;
                                }
                                this.$outer.zio$internal$ZScheduler$$state.getAndAdd(65537);
                                worker.active_$eq(true);
                                LockSupport.unpark(worker);
                                loop = false;
                            }
                        }
                    }
                    this.currentRunnable_$eq(runnable);
                    runnable.run();
                    runnable = null;
                    this.currentRunnable_$eq(null);
                    this.opCount_$eq(++currentOpCount);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    private boolean submitBlocking(Runnable runnable, Unsafe unsafe) {
        return Blocking$.MODULE$.blockingExecutor().submit(runnable, unsafe);
    }

    public ZScheduler() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.zio$internal$ZScheduler$$poolSize).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)workerId -> {
            Worker worker = this.zio$internal$ZScheduler$$makeWorker();
            worker.setName(new StringBuilder(18).append("ZScheduler-Worker-").append(workerId).toString());
            worker.setDaemon(true);
            $this.zio$internal$ZScheduler$$workers[workerId] = worker;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.zio$internal$ZScheduler$$workers)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.start();
            return BoxedUnit.UNIT;
        });
        this.supervisor = this.makeSupervisor();
        this.supervisor.setName("ZScheduler-Supervisor");
        this.supervisor.setDaemon(true);
        this.supervisor.start();
    }

    private static abstract class Supervisor
    extends Thread {
    }

    private static abstract class Worker
    extends Thread {
        private volatile boolean active = true;
        private volatile boolean blocking = false;
        private volatile Runnable currentRunnable = null;
        private final MutableConcurrentQueue<Runnable> localQueue = MutableConcurrentQueue$.MODULE$.bounded(256);
        private Runnable nextRunnable = null;
        private volatile long opCount = 0L;

        public boolean active() {
            return this.active;
        }

        public void active_$eq(boolean x$1) {
            this.active = x$1;
        }

        public boolean blocking() {
            return this.blocking;
        }

        public void blocking_$eq(boolean x$1) {
            this.blocking = x$1;
        }

        public Runnable currentRunnable() {
            return this.currentRunnable;
        }

        public void currentRunnable_$eq(Runnable x$1) {
            this.currentRunnable = x$1;
        }

        public MutableConcurrentQueue<Runnable> localQueue() {
            return this.localQueue;
        }

        public Runnable nextRunnable() {
            return this.nextRunnable;
        }

        public void nextRunnable_$eq(Runnable x$1) {
            this.nextRunnable = x$1;
        }

        public long opCount() {
            return this.opCount;
        }

        public void opCount_$eq(long x$1) {
            this.opCount = x$1;
        }
    }
}

