/*
 * Decompiled with CFR 0.152.
 */
package zio.internal;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.HashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import zio.Chunk;
import zio.ChunkCanBuildFrom$;
import zio.ChunkLike;
import zio.ChunkLike$;
import zio.Executor;
import zio.Fiber$;
import zio.Trace$;
import zio.Unsafe;
import zio.internal.Blocking$;
import zio.internal.ExecutionMetrics;
import zio.internal.FiberRunnable;
import zio.internal.MutableConcurrentQueue;
import zio.internal.MutableConcurrentQueue$;

@ScalaSignature(bytes="\u0006\u0001\t-a\u0001\u0002\u00192\rYB\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\u0006\u0005\u0002!\ta\u0011\u0005\u0007\u000f\u0002\u0001\u000b\u0011\u0002%\t\r-\u0003\u0001\u0015!\u0003M\u0011!\t9\b\u0001Q\u0001\n\u0005U\u0003bBA=\u0001\u0001\u0006I\u0001\u0014\u0005\t\u0003w\u0002\u0001\u0015!\u0003\u0002~!A\u0011\u0011\u0013\u0001!\u0002\u0013\t\u0019\n\u0003\u0005\u0002\u0016\u0002\u0001\u000b\u0011BAL\u0011!\ti\n\u0001Q!\n\u0005}\u0005bBAY\u0001\u0011\u0005\u00111\u0017\u0005\b\u0003\u0017\u0004A\u0011IAg\u0011\u001d\t9\u000e\u0001C\u0001\u00033Dq!a9\u0001\t\u0003\n)\u000f\u0003\u0005\u0002n\u0002\u0001K\u0011BAx\u0011!\t\u0019\u0010\u0001Q\u0005\n\u0005U\b\u0002CA|\u0001\u0001&I!!?\t\u0011\u0005u\b\u0001)C\u0005\u0003\u007fD\u0001B!\u0001\u0001A\u0013%!1A\u0004\u0007#FB\ta\r*\u0007\rA\n\u0004\u0012A\u001aT\u0011\u0015\u0011U\u0003\"\u0001X\r\u0015AV#!\u000bZ\u0011\u0015\u0011u\u0003\"\u0001[\u0011\u0015ivC\"\u0001_\u0011\u0015\u0001xC\"\u0001r\r\u00159X#!\u000by\u0011\u0019\u00115\u0004\"\u0001\u0002\u0004\u00199\u0011QB\u000b\u0002*\u0005=\u0001B\u0002\"\u001e\t\u0003\t\t\u0002C\u0005\u0002\u0016u\u0001\r\u0011\"\u0001\u0002\u0018!I\u0011\u0011D\u000fA\u0002\u0013\u0005\u00111\u0004\u0005\b\u0003Oi\u0002\u0015)\u0003=\u0011%\t\t$\ba\u0001\n\u0003\t9\u0002C\u0005\u00024u\u0001\r\u0011\"\u0001\u00026!9\u0011\u0011H\u000f!B\u0013a\u0004\"CA\u001f;\u0001\u0007I\u0011AA \u0011%\t9%\ba\u0001\n\u0003\tI\u0005\u0003\u0005\u0002Nu\u0001\u000b\u0015BA!\u0011%\t\t&\bb\u0001\n\u0003\t\u0019\u0006\u0003\u0005\u0002Xu\u0001\u000b\u0011BA+\u0011%\tI&\ba\u0001\n\u0003\ty\u0004C\u0005\u0002\\u\u0001\r\u0011\"\u0001\u0002^!A\u0011\u0011M\u000f!B\u0013\t\t\u0005C\u0005\u0002du\u0001\r\u0011\"\u0001\u0002f!I\u0011qM\u000fA\u0002\u0013\u0005\u0011\u0011\u000e\u0005\b\u0003[j\u0002\u0015)\u0003`\u0005)Q6k\u00195fIVdWM\u001d\u0006\u0003eM\n\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0002i\u0005\u0019!0[8\u0004\u0001M\u0011\u0001a\u000e\t\u0003qej\u0011aM\u0005\u0003uM\u0012\u0001\"\u0012=fGV$xN]\u0001\rCV$xN\u00117pG.Lgn\u001a\t\u0003{\u0001k\u0011A\u0010\u0006\u0002\u007f\u0005)1oY1mC&\u0011\u0011I\u0010\u0002\b\u0005>|G.Z1o\u0003\u0019a\u0014N\\5u}Q\u0011AI\u0012\t\u0003\u000b\u0002i\u0011!\r\u0005\u0006w\t\u0001\r\u0001P\u0001\ta>|GnU5{KB\u0011Q(S\u0005\u0003\u0015z\u00121!\u00138u\u0003\u0015\u0019\u0017m\u00195f!\r)UjT\u0005\u0003\u001dF\u0012a#T;uC\ndWmQ8oGV\u0014(/\u001a8u#V,W/\u001a\t\u0003!vq!!\u0012\u000b\u0002\u0015i\u001b6\r[3ek2,'\u000f\u0005\u0002F+M\u0011Q\u0003\u0016\t\u0003{UK!A\u0016 \u0003\r\u0005s\u0017PU3g)\u0005\u0011&!\u0003'pG\u0006$\u0018n\u001c8t'\t9B\u000bF\u0001\\!\tav#D\u0001\u0016\u0003\r9W\r\u001e\u000b\u0003?\n\u0004\"!\u00101\n\u0005\u0005t$\u0001\u0002'p]\u001eDQaY\rA\u0002\u0011\fQ\u0001\u001e:bG\u0016\u0004\"!Z7\u000f\u0005\u0019\\gBA4k\u001b\u0005A'BA56\u0003\u0019a$o\\8u}%\tA'\u0003\u0002mg\u00059\u0001/Y2lC\u001e,\u0017B\u00018p\u0005\u0015!&/Y2f\u0015\ta7'A\u0002qkR$\"a\u0018:\t\u000b\rT\u0002\u0019\u00013*\u0005]!h\u0001B;\u0018\u0001Y\u0014Q\u0002\u00107pG\u0006d\u0007e\u00195jY\u0012t4C\u0001;\\\u0005)\u0019V\u000f]3sm&\u001cxN]\n\u00037e\u0004\"A_@\u000e\u0003mT!\u0001`?\u0002\t1\fgn\u001a\u0006\u0002}\u0006!!.\u0019<b\u0013\r\t\ta\u001f\u0002\u0007)\"\u0014X-\u00193\u0015\u0005\u0005\u0015\u0001C\u0001/\u001cS\rY\u0012\u0011\u0002\u0004\u0006kn\u0001\u00111B\n\u0005\u0003\u0013\t)A\u0001\u0004X_J\\WM]\n\u0003;e$\"!a\u0005\u0011\u0005qk\u0012AB1di&4X-F\u0001=\u0003)\t7\r^5wK~#S-\u001d\u000b\u0005\u0003;\t\u0019\u0003E\u0002>\u0003?I1!!\t?\u0005\u0011)f.\u001b;\t\u0011\u0005\u0015\u0002%!AA\u0002q\n1\u0001\u001f\u00132\u0003\u001d\t7\r^5wK\u0002B3!IA\u0016!\ri\u0014QF\u0005\u0004\u0003_q$\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\u0011\tdwnY6j]\u001e\fAB\u00197pG.LgnZ0%KF$B!!\b\u00028!A\u0011QE\u0012\u0002\u0002\u0003\u0007A(A\u0005cY>\u001c7.\u001b8hA!\u001aA%a\u000b\u0002\u001f\r,(O]3oiJ+hN\\1cY\u0016,\"!!\u0011\u0011\u0007i\f\u0019%C\u0002\u0002Fm\u0014\u0001BU;o]\u0006\u0014G.Z\u0001\u0014GV\u0014(/\u001a8u%Vtg.\u00192mK~#S-\u001d\u000b\u0005\u0003;\tY\u0005C\u0005\u0002&\u0019\n\t\u00111\u0001\u0002B\u0005\u00012-\u001e:sK:$(+\u001e8oC\ndW\r\t\u0015\u0004O\u0005-\u0012A\u00037pG\u0006d\u0017+^3vKV\u0011\u0011Q\u000b\t\u0005\u000b6\u000b\t%A\u0006m_\u000e\fG.U;fk\u0016\u0004\u0013\u0001\u00048fqR\u0014VO\u001c8bE2,\u0017\u0001\u00058fqR\u0014VO\u001c8bE2,w\fJ3r)\u0011\ti\"a\u0018\t\u0013\u0005\u00152&!AA\u0002\u0005\u0005\u0013!\u00048fqR\u0014VO\u001c8bE2,\u0007%A\u0004pa\u000e{WO\u001c;\u0016\u0003}\u000b1b\u001c9D_VtGo\u0018\u0013fcR!\u0011QDA6\u0011!\t)CLA\u0001\u0002\u0004y\u0016\u0001C8q\u0007>,h\u000e\u001e\u0011)\u0007=\nY#K\u0002\u001e\u0003g2Q!^\u000f\u0001\u0003k\u001aB!a\u001d\u0002\u0014\u0005Yq\r\\8cC2\fV/Z;f\u0003\u0011IG\r\\3\u0002\u000bM$\u0018\r^3\u0011\t\u0005}\u0014QR\u0007\u0003\u0003\u0003SA!a!\u0002\u0006\u00061\u0011\r^8nS\u000eTA!a\"\u0002\n\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0007\u0005-U0\u0001\u0003vi&d\u0017\u0002BAH\u0003\u0003\u0013Q\"\u0011;p[&\u001c\u0017J\u001c;fO\u0016\u0014\u0018AE:vE6LG\u000f^3e\u0019>\u001c\u0017\r^5p]N\u0004\"\u0001U\f\u0002\u000f]|'o[3sgB!Q(!'P\u0013\r\tYJ\u0010\u0002\u0006\u0003J\u0014\u0018-_\u0001\u0012E2|7m[5oO2{7-\u0019;j_:\u001c\b#BAQ\u0003S#g\u0002BAR\u0003K\u0003\"a\u001a \n\u0007\u0005\u001df(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003W\u000biKA\u0002TKRT1!a*?Q\rQ\u00111F\u0001\b[\u0016$(/[2t)\u0011\t),!1\u0011\u000bu\n9,a/\n\u0007\u0005efH\u0001\u0004PaRLwN\u001c\t\u0004\u000b\u0006u\u0016bAA`c\t\u0001R\t_3dkRLwN\\'fiJL7m\u001d\u0005\b\u0003\u0007\\\u00019AAc\u0003\u0019)hn]1gKB\u0019\u0001(a2\n\u0007\u0005%7G\u0001\u0004V]N\fg-Z\u0001\ngR,\u0017\r\\,pe.$B!a4\u0002TR\u0019A(!5\t\u000f\u0005\rG\u0002q\u0001\u0002F\"1\u0011Q\u001b\u0007A\u0002!\u000bQ\u0001Z3qi\"\faa];c[&$H\u0003BAn\u0003?$2\u0001PAo\u0011\u001d\t\u0019-\u0004a\u0002\u0003\u000bDq!!9\u000e\u0001\u0004\t\t%\u0001\u0005sk:t\u0017M\u00197f\u00039\u0019XOY7ji\u0006sG-W5fY\u0012$B!a:\u0002lR\u0019A(!;\t\u000f\u0005\rg\u0002q\u0001\u0002F\"9\u0011\u0011\u001d\bA\u0002\u0005\u0005\u0013AC5t\u00052|7m[5oOR\u0019A(!=\t\u000f\u0005\u0005x\u00021\u0001\u0002B\u0005iQ.Y6f\u0019>\u001c\u0017\r^5p]N$\"!a%\u0002\u001d5\f7.Z*va\u0016\u0014h/[:peR\u0011\u00111 \t\u0003!n\t!\"\\1lK^{'o[3s)\u0005y\u0015AD:vE6LGO\u00117pG.Lgn\u001a\u000b\u0005\u0005\u000b\u0011I\u0001F\u0002=\u0005\u000fAq!a1\u0014\u0001\b\t)\rC\u0004\u0002bN\u0001\r!!\u0011")
public final class ZScheduler
extends Executor {
    public final int zio$internal$ZScheduler$$poolSize = Runtime.getRuntime().availableProcessors();
    public final MutableConcurrentQueue<Worker> zio$internal$ZScheduler$$cache = MutableConcurrentQueue$.MODULE$.unbounded();
    public final MutableConcurrentQueue<Runnable> zio$internal$ZScheduler$$globalQueue = MutableConcurrentQueue$.MODULE$.unbounded();
    public final MutableConcurrentQueue<Worker> zio$internal$ZScheduler$$idle = MutableConcurrentQueue$.MODULE$.unbounded();
    public final AtomicInteger zio$internal$ZScheduler$$state = new AtomicInteger(this.zio$internal$ZScheduler$$poolSize << 16);
    public final Locations zio$internal$ZScheduler$$submittedLocations = this.zio$internal$ZScheduler$$makeLocations();
    public final Worker[] zio$internal$ZScheduler$$workers = (Worker[])Array$.MODULE$.ofDim(this.zio$internal$ZScheduler$$poolSize, ClassTag$.MODULE$.apply(Worker.class));
    public volatile Set<Object> zio$internal$ZScheduler$$blockingLocations = Predef$.MODULE$.Set().empty();

    @Override
    public Option<ExecutionMetrics> metrics(Unsafe unsafe) {
        ExecutionMetrics metrics = new ExecutionMetrics(this){
            private final /* synthetic */ ZScheduler $outer;

            public int capacity() {
                return Integer.MAX_VALUE;
            }

            public int concurrency() {
                return this.$outer.zio$internal$ZScheduler$$poolSize;
            }

            public long dequeuedCount() {
                long dequeued = 0L;
                for (int i = 0; i != this.$outer.zio$internal$ZScheduler$$poolSize; ++i) {
                    Worker worker = this.$outer.zio$internal$ZScheduler$$workers[i];
                    dequeued += worker.opCount();
                }
                return dequeued;
            }

            public long enqueuedCount() {
                long enqueued = 0L;
                for (int i = 0; i != this.$outer.zio$internal$ZScheduler$$poolSize; ++i) {
                    Worker worker = this.$outer.zio$internal$ZScheduler$$workers[i];
                    enqueued += worker.opCount();
                    enqueued += (long)worker.localQueue().size();
                    if (worker.nextRunnable() == null) continue;
                    ++enqueued;
                }
                return enqueued += (long)this.$outer.zio$internal$ZScheduler$$globalQueue.size();
            }

            public int size() {
                int size = 0;
                for (int i = 0; i != this.$outer.zio$internal$ZScheduler$$poolSize; ++i) {
                    Worker worker = this.$outer.zio$internal$ZScheduler$$workers[i];
                    size += worker.localQueue().size();
                    if (worker.nextRunnable() == null) continue;
                    ++size;
                }
                return size += this.$outer.zio$internal$ZScheduler$$globalQueue.size();
            }

            public int workersCount() {
                return (this.$outer.zio$internal$ZScheduler$$state.get() & 0xFFFF0000) >> 16;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        return new Some((Object)metrics);
    }

    @Override
    public boolean stealWork(int depth, Unsafe unsafe) {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof Worker) {
            Runnable runnable;
            Worker worker = (Worker)currentThread;
            if (worker.nextRunnable() != null) {
                runnable = worker.nextRunnable();
                worker.nextRunnable_$eq(null);
            } else {
                runnable = worker.localQueue().poll(null);
                if (runnable == null) {
                    runnable = this.zio$internal$ZScheduler$$globalQueue.poll(null);
                }
            }
            if (runnable != null) {
                if (runnable instanceof FiberRunnable) {
                    FiberRunnable fiberRunnable = (FiberRunnable)runnable;
                    worker.currentRunnable_$eq(fiberRunnable);
                    fiberRunnable.run(depth);
                } else {
                    runnable.run();
                }
                return true;
            }
            worker.nextRunnable_$eq(null);
            return false;
        }
        return false;
    }

    @Override
    public boolean submit(Runnable runnable, Unsafe unsafe) {
        boolean bl;
        if (runnable instanceof FiberRunnable) {
            Object isBlocking_location = ((FiberRunnable)runnable).location();
            this.zio$internal$ZScheduler$$submittedLocations.put(isBlocking_location);
            bl = this.zio$internal$ZScheduler$$blockingLocations.contains(isBlocking_location);
        } else {
            bl = false;
        }
        if (bl) {
            return Blocking$.MODULE$.blockingExecutor().submit(runnable, unsafe);
        }
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof Worker) {
            Worker worker = (Worker)currentThread;
            if (worker.blocking()) {
                this.zio$internal$ZScheduler$$globalQueue.offer(runnable);
            } else if (worker.localQueue().offer(runnable)) {
                Runnable runnable2;
                if (worker.blocking() && (runnable2 = (Runnable)worker.localQueue().poll(null)) != null) {
                    this.zio$internal$ZScheduler$$globalQueue.offer(runnable2);
                }
            } else {
                this.zio$internal$ZScheduler$$globalQueue.offerAll((Iterable)worker.localQueue().pollUpTo(128).$colon$plus(runnable, ChunkLike$.MODULE$.chunkCanBuildFrom(ChunkCanBuildFrom$.MODULE$.apply())));
            }
        } else {
            this.zio$internal$ZScheduler$$globalQueue.offer(runnable);
        }
        int currentState = this.zio$internal$ZScheduler$$state.get();
        int currentActive = (currentState & 0xFFFF0000) >> 16;
        int currentSearching = currentState & 0xFFFF;
        if (currentActive != this.zio$internal$ZScheduler$$poolSize && currentSearching == 0) {
            boolean loop = true;
            while (loop) {
                Worker worker = this.zio$internal$ZScheduler$$idle.poll(null);
                if (worker == null) {
                    loop = false;
                    continue;
                }
                this.zio$internal$ZScheduler$$state.getAndAdd(65537);
                worker.active_$eq(true);
                LockSupport.unpark(worker);
                loop = false;
            }
        }
        return true;
    }

    @Override
    public boolean submitAndYield(Runnable runnable, Unsafe unsafe) {
        boolean bl;
        if (runnable instanceof FiberRunnable) {
            Object isBlocking_location = ((FiberRunnable)runnable).location();
            this.zio$internal$ZScheduler$$submittedLocations.put(isBlocking_location);
            bl = this.zio$internal$ZScheduler$$blockingLocations.contains(isBlocking_location);
        } else {
            bl = false;
        }
        if (bl) {
            return Blocking$.MODULE$.blockingExecutor().submit(runnable, unsafe);
        }
        Thread currentThread = Thread.currentThread();
        boolean notify = false;
        if (currentThread instanceof Worker) {
            Worker worker = (Worker)currentThread;
            if (worker.blocking()) {
                this.zio$internal$ZScheduler$$globalQueue.offer(runnable);
                notify = true;
            } else if (worker.nextRunnable() == null && worker.localQueue().isEmpty()) {
                worker.nextRunnable_$eq(runnable);
            } else if (worker.localQueue().offer(runnable)) {
                Runnable runnable2;
                if (worker.blocking() && (runnable2 = (Runnable)worker.localQueue().poll(null)) != null) {
                    this.zio$internal$ZScheduler$$globalQueue.offer(runnable2);
                }
                notify = true;
            } else {
                this.zio$internal$ZScheduler$$globalQueue.offerAll((Iterable)worker.localQueue().pollUpTo(128).$colon$plus(runnable, ChunkLike$.MODULE$.chunkCanBuildFrom(ChunkCanBuildFrom$.MODULE$.apply())));
                notify = true;
            }
        } else {
            this.zio$internal$ZScheduler$$globalQueue.offer(runnable);
            notify = true;
        }
        if (notify) {
            int currentState = this.zio$internal$ZScheduler$$state.get();
            int currentActive = (currentState & 0xFFFF0000) >> 16;
            int currentSearching = currentState & 0xFFFF;
            if (currentActive != this.zio$internal$ZScheduler$$poolSize && currentSearching == 0) {
                boolean loop = true;
                while (loop) {
                    Worker worker = this.zio$internal$ZScheduler$$idle.poll(null);
                    if (worker == null) {
                        loop = false;
                        continue;
                    }
                    this.zio$internal$ZScheduler$$state.getAndAdd(65537);
                    worker.active_$eq(true);
                    LockSupport.unpark(worker);
                    loop = false;
                }
            }
        }
        return true;
    }

    private boolean isBlocking(Runnable runnable) {
        if (runnable instanceof FiberRunnable) {
            Object location = ((FiberRunnable)runnable).location();
            this.zio$internal$ZScheduler$$submittedLocations.put(location);
            return this.zio$internal$ZScheduler$$blockingLocations.contains(location);
        }
        return false;
    }

    public Locations zio$internal$ZScheduler$$makeLocations() {
        return new Locations(null){
            private final HashMap<Object, long[]> locations;

            public long get(Object trace) {
                long[] array = this.locations.get(trace);
                if (array == null) {
                    return 0L;
                }
                return array[0];
            }

            public long put(Object trace) {
                long[] array = this.locations.get(trace);
                if (array == null) {
                    this.locations.put(trace, new long[]{1L});
                    return 0L;
                }
                long value = array[0];
                array[0] = array[0] + 1L;
                return value;
            }
            {
                this.locations = new HashMap<K, V>();
            }
        };
    }

    private Supervisor makeSupervisor() {
        return new Supervisor(this){
            private final /* synthetic */ ZScheduler $outer;

            public void run() {
                long currentTime = System.currentTimeMillis();
                Locations identifiedLocations = this.$outer.zio$internal$ZScheduler$$makeLocations();
                long[] previousOpCounts = (long[])Array$.MODULE$.fill(this.$outer.zio$internal$ZScheduler$$poolSize, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L, ClassTag$.MODULE$.Long());
                while (!this.isInterrupted()) {
                    for (int workerId = 0; workerId != this.$outer.zio$internal$ZScheduler$$poolSize; ++workerId) {
                        Worker currentWorker = this.$outer.zio$internal$ZScheduler$$workers[workerId];
                        if (currentWorker.active()) {
                            long previousOpCount;
                            long currentOpCount = currentWorker.opCount();
                            if (currentOpCount == (previousOpCount = previousOpCounts[workerId])) {
                                Object location;
                                Runnable currentRunnable = currentWorker.currentRunnable();
                                if (currentRunnable instanceof FiberRunnable && (location = ((FiberRunnable)currentRunnable).location()) != Trace$.MODULE$.empty()) {
                                    long identifiedCount = identifiedLocations.put(location);
                                    long submittedCount = this.$outer.zio$internal$ZScheduler$$submittedLocations.get(location);
                                    if (submittedCount > 64L && identifiedCount >= submittedCount / 2L) {
                                        this.$outer.zio$internal$ZScheduler$$blockingLocations = (Set)this.$outer.zio$internal$ZScheduler$$blockingLocations.$plus(location);
                                    }
                                }
                                previousOpCounts[workerId] = -1L;
                                currentWorker.blocking_$eq(true);
                                Chunk<Runnable> runnables = currentWorker.localQueue().pollUpTo(256);
                                this.$outer.zio$internal$ZScheduler$$globalQueue.offerAll(runnables);
                                Worker worker = this.$outer.zio$internal$ZScheduler$$cache.poll(null);
                                if (worker == null) {
                                    Worker worker2 = this.$outer.zio$internal$ZScheduler$$makeWorker();
                                    worker2.setName(new StringBuilder(18).append("ZScheduler-Worker-").append(workerId).toString());
                                    worker2.setDaemon(true);
                                    this.$outer.zio$internal$ZScheduler$$workers[workerId] = worker2;
                                    worker2.start();
                                    continue;
                                }
                                this.$outer.zio$internal$ZScheduler$$state.getAndIncrement();
                                worker.setName(new StringBuilder(18).append("ZScheduler-Worker-").append(workerId).toString());
                                this.$outer.zio$internal$ZScheduler$$workers[workerId] = worker;
                                worker.blocking_$eq(false);
                                worker.active_$eq(true);
                                LockSupport.unpark(worker);
                                continue;
                            }
                            previousOpCounts[workerId] = currentOpCount;
                            continue;
                        }
                        previousOpCounts[workerId] = -1L;
                    }
                    long deadline = currentTime + 100L;
                    boolean loop = true;
                    while (loop) {
                        LockSupport.parkUntil(deadline);
                        currentTime = System.currentTimeMillis();
                        loop = currentTime < deadline;
                    }
                    Fiber$.MODULE$._roots().graduate();
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1()}, serializedLambda);
            }
        };
    }

    public Worker zio$internal$ZScheduler$$makeWorker() {
        return new Worker(this){
            private final /* synthetic */ ZScheduler $outer;

            public void run() {
                long currentOpCount = 0L;
                ThreadLocalRandom random = ThreadLocalRandom.current();
                Runnable runnable = null;
                boolean searching = false;
                while (!this.isInterrupted()) {
                    boolean currentBlocking = this.blocking();
                    if (currentBlocking) {
                        if (this.nextRunnable() != null) {
                            runnable = this.nextRunnable();
                            this.nextRunnable_$eq(null);
                        }
                    } else {
                        if ((currentOpCount & 0x3FL) == 0L) {
                            runnable = this.$outer.zio$internal$ZScheduler$$globalQueue.poll(null);
                            if (runnable == null) {
                                if (this.nextRunnable() != null) {
                                    runnable = this.nextRunnable();
                                    this.nextRunnable_$eq(null);
                                } else {
                                    runnable = this.localQueue().poll(null);
                                }
                            }
                        } else if (this.nextRunnable() != null) {
                            runnable = this.nextRunnable();
                            this.nextRunnable_$eq(null);
                        } else {
                            runnable = this.localQueue().poll(null);
                            if (runnable == null) {
                                runnable = this.$outer.zio$internal$ZScheduler$$globalQueue.poll(null);
                            }
                        }
                        if (runnable == null) {
                            int currentActive;
                            if (!searching && 2 * (currentActive = this.$outer.zio$internal$ZScheduler$$state.get() & 0xFFFF) < this.$outer.zio$internal$ZScheduler$$poolSize) {
                                this.$outer.zio$internal$ZScheduler$$state.getAndIncrement();
                                searching = true;
                            }
                            if (searching) {
                                boolean loop = true;
                                int offset = random.nextInt(this.$outer.zio$internal$ZScheduler$$poolSize);
                                for (int i = 0; i != this.$outer.zio$internal$ZScheduler$$poolSize && loop; ++i) {
                                    Chunk<Runnable> runnables;
                                    Chunk<Runnable> runnables2;
                                    int size;
                                    int index = (i + offset) % this.$outer.zio$internal$ZScheduler$$poolSize;
                                    Worker worker = this.$outer.zio$internal$ZScheduler$$workers[index];
                                    if (worker == this || worker.blocking() || (size = worker.localQueue().size()) <= 0 || !(runnables2 = worker.localQueue().pollUpTo(size - size / 2)).nonEmpty()) continue;
                                    runnable = runnables2.head();
                                    if (((ChunkLike)runnables2.tail()).nonEmpty()) {
                                        this.localQueue().offerAll((Iterable)runnables2.tail());
                                    }
                                    if ((currentBlocking = this.blocking()) && (runnables = this.localQueue().pollUpTo(256)).nonEmpty()) {
                                        this.$outer.zio$internal$ZScheduler$$globalQueue.offerAll(runnables);
                                    }
                                    loop = false;
                                }
                                if (runnable == null) {
                                    runnable = this.$outer.zio$internal$ZScheduler$$globalQueue.poll(null);
                                }
                            }
                        }
                    }
                    if (runnable == null) {
                        int currentSearching = (currentBlocking && searching ? this.$outer.zio$internal$ZScheduler$$state.decrementAndGet() : (currentBlocking ? this.$outer.zio$internal$ZScheduler$$state.get() : (searching ? this.$outer.zio$internal$ZScheduler$$state.addAndGet(-65537) : this.$outer.zio$internal$ZScheduler$$state.addAndGet(-65536)))) & 0xFFFF;
                        this.active_$eq(false);
                        if (currentBlocking) {
                            this.$outer.zio$internal$ZScheduler$$cache.offer(this);
                        } else {
                            this.$outer.zio$internal$ZScheduler$$idle.offer(this);
                        }
                        if (currentSearching == 0 && searching) {
                            boolean notify = false;
                            for (int i = 0; i != this.$outer.zio$internal$ZScheduler$$poolSize && !notify; ++i) {
                                notify = !this.$outer.zio$internal$ZScheduler$$workers[i].localQueue().isEmpty();
                            }
                            if (!notify) {
                                boolean bl = notify = !this.$outer.zio$internal$ZScheduler$$globalQueue.isEmpty();
                            }
                            if (notify) {
                                int currentState = this.$outer.zio$internal$ZScheduler$$state.get();
                                int currentActive = (currentState & 0xFFFF0000) >> 16;
                                int currentSearching2 = currentState & 0xFFFF;
                                if (currentActive != this.$outer.zio$internal$ZScheduler$$poolSize && currentSearching2 == 0) {
                                    boolean loop = true;
                                    while (loop) {
                                        Worker worker = this.$outer.zio$internal$ZScheduler$$idle.poll(null);
                                        if (worker == null) {
                                            loop = false;
                                            continue;
                                        }
                                        this.$outer.zio$internal$ZScheduler$$state.getAndAdd(65537);
                                        worker.active_$eq(true);
                                        LockSupport.unpark(worker);
                                        loop = false;
                                    }
                                }
                            }
                        }
                        while (!this.active() && !this.isInterrupted()) {
                            LockSupport.park();
                        }
                        searching = true;
                        continue;
                    }
                    if (searching) {
                        searching = false;
                        int currentState = this.$outer.zio$internal$ZScheduler$$state.decrementAndGet();
                        int currentSearching = currentState & 0xFFFF;
                        if ((currentState & 0xFFFF0000) >> 16 != this.$outer.zio$internal$ZScheduler$$poolSize && currentSearching == 0) {
                            boolean loop = true;
                            while (loop) {
                                Worker worker = this.$outer.zio$internal$ZScheduler$$idle.poll(null);
                                if (worker == null) {
                                    loop = false;
                                    continue;
                                }
                                this.$outer.zio$internal$ZScheduler$$state.getAndAdd(65537);
                                worker.active_$eq(true);
                                LockSupport.unpark(worker);
                                loop = false;
                            }
                        }
                    }
                    this.currentRunnable_$eq(runnable);
                    runnable.run();
                    runnable = null;
                    this.currentRunnable_$eq(null);
                    this.opCount_$eq(++currentOpCount);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    private boolean submitBlocking(Runnable runnable, Unsafe unsafe) {
        return Blocking$.MODULE$.blockingExecutor().submit(runnable, unsafe);
    }

    public ZScheduler(boolean autoBlocking) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.zio$internal$ZScheduler$$poolSize).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)workerId -> {
            Worker worker = this.zio$internal$ZScheduler$$makeWorker();
            worker.setName(new StringBuilder(18).append("ZScheduler-Worker-").append(workerId).toString());
            worker.setDaemon(true);
            $this.zio$internal$ZScheduler$$workers[workerId] = worker;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.zio$internal$ZScheduler$$workers)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.start();
            return BoxedUnit.UNIT;
        });
        if (autoBlocking) {
            Supervisor supervisor = this.makeSupervisor();
            supervisor.setName("ZScheduler-Supervisor");
            supervisor.setDaemon(true);
            supervisor.start();
        }
    }

    private static abstract class Locations {
        public abstract long get(Object var1);

        public abstract long put(Object var1);
    }

    private static abstract class Supervisor
    extends Thread {
    }

    private static abstract class Worker
    extends Thread {
        private volatile boolean active = true;
        private volatile boolean blocking = false;
        private volatile Runnable currentRunnable = null;
        private final MutableConcurrentQueue<Runnable> localQueue = MutableConcurrentQueue$.MODULE$.bounded(256);
        private Runnable nextRunnable = null;
        private volatile long opCount = 0L;

        public boolean active() {
            return this.active;
        }

        public void active_$eq(boolean x$1) {
            this.active = x$1;
        }

        public boolean blocking() {
            return this.blocking;
        }

        public void blocking_$eq(boolean x$1) {
            this.blocking = x$1;
        }

        public Runnable currentRunnable() {
            return this.currentRunnable;
        }

        public void currentRunnable_$eq(Runnable x$1) {
            this.currentRunnable = x$1;
        }

        public MutableConcurrentQueue<Runnable> localQueue() {
            return this.localQueue;
        }

        public Runnable nextRunnable() {
            return this.nextRunnable;
        }

        public void nextRunnable_$eq(Runnable x$1) {
            this.nextRunnable = x$1;
        }

        public long opCount() {
            return this.opCount;
        }

        public void opCount_$eq(long x$1) {
            this.opCount = x$1;
        }
    }
}

