/*
 * Decompiled with CFR 0.152.
 */
package zio.metrics;

import java.io.IOException;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import zio.Chunk;
import zio.Console$;
import zio.System$;
import zio.ZIO;
import zio.metrics.MetricKey;
import zio.metrics.MetricKeyType;
import zio.metrics.MetricLabel;
import zio.metrics.MetricPair;
import zio.metrics.MetricState;
import zio.metrics.Metrics$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015h\u0001\u0002\u000f\u001e\u0005\nB\u0001B\b\u0001\u0003\u0016\u0004%\ta\f\u0005\t\u0007\u0002\u0011\t\u0012)A\u0005a!1A\t\u0001C\u0001?\u0015CQ\u0001\u0013\u0001\u0005\u0002%CQa\u0017\u0001\u0005\u0002qCQ\u0001\u001c\u0001\u0005\n5DQ!\u001d\u0001\u0005\nIDq!a\u0005\u0001\t\u0013\t)\u0002C\u0004\u0002&\u0001!I!a\n\t\u000f\u0005\u0005\u0003\u0001\"\u0003\u0002D!I\u0011\u0011\u000b\u0001\u0002\u0002\u0013\u0005\u00111\u000b\u0005\n\u0003/\u0002\u0011\u0013!C\u0001\u00033B\u0011\"a\u001c\u0001\u0003\u0003%\t%!\u001d\t\u0013\u0005u\u0004!!A\u0005\u0002\u0005}\u0004\"CAA\u0001\u0005\u0005I\u0011AAB\u0011%\tI\tAA\u0001\n\u0003\nY\tC\u0005\u0002\u001a\u0002\t\t\u0011\"\u0001\u0002\u001c\"I\u0011Q\u0015\u0001\u0002\u0002\u0013\u0005\u0013q\u0015\u0005\n\u0003S\u0003\u0011\u0011!C!\u0003WC\u0011\"!,\u0001\u0003\u0003%\t%a,\b\u0013\u0005MV$!A\t\u0002\u0005Uf\u0001\u0003\u000f\u001e\u0003\u0003E\t!a.\t\r\u00113B\u0011AAc\u0011%\tIKFA\u0001\n\u000b\nY\u000bC\u0005\u0002HZ\t\t\u0011\"!\u0002J\"I\u0011Q\u001a\f\u0002\u0002\u0013\u0005\u0015q\u001a\u0005\n\u000374\u0012\u0011!C\u0005\u0003;\u0014q!T3ue&\u001c7O\u0003\u0002\u001f?\u00059Q.\u001a;sS\u000e\u001c(\"\u0001\u0011\u0002\u0007iLwn\u0001\u0001\u0014\t\u0001\u0019\u0013\u0006\f\t\u0003I\u001dj\u0011!\n\u0006\u0002M\u0005)1oY1mC&\u0011\u0001&\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0011R\u0013BA\u0016&\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001J\u0017\n\u00059*#\u0001D*fe&\fG.\u001b>bE2,W#\u0001\u0019\u0011\u0007EB4H\u0004\u00023mA\u00111'J\u0007\u0002i)\u0011Q'I\u0001\u0007yI|w\u000e\u001e \n\u0005]*\u0013A\u0002)sK\u0012,g-\u0003\u0002:u\t\u00191+\u001a;\u000b\u0005]*\u0003C\u0001\u001fA\u001d\tid(D\u0001\u001e\u0013\tyT$\u0001\u0006NKR\u0014\u0018n\u0019)bSJL!!\u0011\"\u0003\u000fUsG/\u001f9fI*\u0011q(H\u0001\t[\u0016$(/[2tA\u00051A(\u001b8jiz\"\"AR$\u0011\u0005u\u0002\u0001\"\u0002\u0010\u0004\u0001\u0004\u0001\u0014a\u00039sKR$\u0018\u0010\u0015:j]R$\"A\u0013,\u0011\u0007-\u00036K\u0004\u0002M\u001d:\u00111'T\u0005\u0002A%\u0011qjH\u0001\ba\u0006\u001c7.Y4f\u0013\t\t&KA\u0002V\u0013>S!aT\u0010\u0011\u0005E\"\u0016BA+;\u0005\u0019\u0019FO]5oO\")q\u000b\u0002a\u00021\u0006)AO]1dKB\u00111*W\u0005\u00035J\u0013Q\u0001\u0016:bG\u0016\fA\u0001Z;naR\u0011Ql\u001b\t\u0005\u0017z\u0003\u0007.\u0003\u0002`%\n\u0011\u0011j\u0014\t\u0003C\u001al\u0011A\u0019\u0006\u0003G\u0012\f!![8\u000b\u0003\u0015\fAA[1wC&\u0011qM\u0019\u0002\f\u0013>+\u0005pY3qi&|g\u000e\u0005\u0002%S&\u0011!.\n\u0002\u0005+:LG\u000fC\u0003X\u000b\u0001\u000f\u0001,A\u0007sK:$WM]'fiJL7m\u001d\u000b\u0004':|\u0007\"\u0002\u0010\u0007\u0001\u0004\u0001\u0004\"\u00029\u0007\u0001\u0004\u0019\u0016!\u00047j]\u0016\u001cV\r]1sCR|'/A\u0005sK:$WM]&fsR!1k]A\u0005\u0011\u0015!x\u00011\u0001v\u0003\rYW-\u001f\u0019\u0003mn\u00042!P<z\u0013\tAXDA\u0005NKR\u0014\u0018nY&fsB\u0011!p\u001f\u0007\u0001\t%a8/!A\u0001\u0002\u000b\u0005QPA\u0002`IE\n2A`A\u0002!\t!s0C\u0002\u0002\u0002\u0015\u0012qAT8uQ&tw\rE\u0002%\u0003\u000bI1!a\u0002&\u0005\r\te.\u001f\u0005\b\u0003\u00179\u0001\u0019AA\u0007\u0003\u0015\u0001\u0018\r\u001a+p!\r!\u0013qB\u0005\u0004\u0003#)#aA%oi\u0006Q!/\u001a8eKJ$\u0016mZ:\u0015\u000bM\u000b9\"a\t\t\rQD\u0001\u0019AA\ra\u0011\tY\"a\b\u0011\tu:\u0018Q\u0004\t\u0004u\u0006}AaCA\u0011\u0003/\t\t\u0011!A\u0003\u0002u\u00141a\u0018\u00133\u0011\u001d\tY\u0001\u0003a\u0001\u0003\u001b\t1B]3oI\u0016\u0014h+\u00197vKR\u00191+!\u000b\t\u000f\u0005-\u0012\u00021\u0001\u0002.\u00051Q.\u001a;sS\u000e\u0004d!a\f\u00028\u0005u\u0002cB\u001f\u00022\u0005U\u00121H\u0005\u0004\u0003gi\"AC'fiJL7\rU1jeB\u0019!0a\u000e\u0005\u0017\u0005e\u0012\u0011FA\u0001\u0002\u0003\u0015\t! \u0002\u0004?\u0012\u001a\u0004c\u0001>\u0002>\u0011Y\u0011qHA\u0015\u0003\u0003\u0005\tQ!\u0001~\u0005\ryF\u0005N\u0001\ri\u0006<7\u000fV8TiJLgn\u001a\u000b\u0004'\u0006\u0015\u0003bBA$\u0015\u0001\u0007\u0011\u0011J\u0001\u0005i\u0006<7\u000f\u0005\u00032q\u0005-\u0003cA\u001f\u0002N%\u0019\u0011qJ\u000f\u0003\u00175+GO]5d\u0019\u0006\u0014W\r\\\u0001\u0005G>\u0004\u0018\u0010F\u0002G\u0003+BqAH\u0006\u0011\u0002\u0003\u0007\u0001'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005m#f\u0001\u0019\u0002^-\u0012\u0011q\f\t\u0005\u0003C\nY'\u0004\u0002\u0002d)!\u0011QMA4\u0003%)hn\u00195fG.,GMC\u0002\u0002j\u0015\n!\"\u00198o_R\fG/[8o\u0013\u0011\ti'a\u0019\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003g\u0002B!!\u001e\u0002|5\u0011\u0011q\u000f\u0006\u0004\u0003s\"\u0017\u0001\u00027b]\u001eL1!VA<\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ti!\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\r\u0011Q\u0011\u0005\n\u0003\u000f{\u0011\u0011!a\u0001\u0003\u001b\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAG!\u0019\ty)!&\u0002\u00045\u0011\u0011\u0011\u0013\u0006\u0004\u0003'+\u0013AC2pY2,7\r^5p]&!\u0011qSAI\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005u\u00151\u0015\t\u0004I\u0005}\u0015bAAQK\t9!i\\8mK\u0006t\u0007\"CAD#\u0005\u0005\t\u0019AA\u0002\u0003!A\u0017m\u001d5D_\u0012,GCAA\u0007\u0003!!xn\u0015;sS:<GCAA:\u0003\u0019)\u0017/^1mgR!\u0011QTAY\u0011%\t9\tFA\u0001\u0002\u0004\t\u0019!A\u0004NKR\u0014\u0018nY:\u0011\u0005u22\u0003\u0002\f\u0002:2\u0002b!a/\u0002BB2UBAA_\u0015\r\ty,J\u0001\beVtG/[7f\u0013\u0011\t\u0019-!0\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007\u0006\u0002\u00026\u0006)\u0011\r\u001d9msR\u0019a)a3\t\u000byI\u0002\u0019\u0001\u0019\u0002\u000fUt\u0017\r\u001d9msR!\u0011\u0011[Al!\u0011!\u00131\u001b\u0019\n\u0007\u0005UWE\u0001\u0004PaRLwN\u001c\u0005\t\u00033T\u0012\u0011!a\u0001\r\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003?\u0004B!!\u001e\u0002b&!\u00111]A<\u0005\u0019y%M[3di\u0002")
public final class Metrics
implements Product,
scala.Serializable {
    private final Set<MetricPair<MetricKeyType, Object>> metrics;

    public static Option<Set<MetricPair<MetricKeyType, Object>>> unapply(Metrics metrics) {
        return Metrics$.MODULE$.unapply(metrics);
    }

    public static Metrics apply(Set<MetricPair<MetricKeyType, Object>> set) {
        return Metrics$.MODULE$.apply(set);
    }

    public static <A> Function1<Set<MetricPair<MetricKeyType, Object>>, A> andThen(Function1<Metrics, A> function1) {
        return Metrics$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, Metrics> compose(Function1<A, Set<MetricPair<MetricKeyType, Object>>> function1) {
        return Metrics$.MODULE$.compose(function1);
    }

    public Set<MetricPair<MetricKeyType, Object>> metrics() {
        return this.metrics;
    }

    public ZIO<Object, Nothing$, String> prettyPrint(Object trace) {
        return System$.MODULE$.lineSeparator(trace).map((Function1 & Serializable & scala.Serializable)x$1 -> this.renderMetrics(this.metrics(), (String)x$1), trace);
    }

    public ZIO<Object, IOException, BoxedUnit> dump(Object trace) {
        return this.prettyPrint(trace).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> Console$.MODULE$.printLine((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> x$2, trace), trace);
    }

    private String renderMetrics(Set<MetricPair<MetricKeyType, Object>> metrics, String lineSeparator) {
        if (metrics.nonEmpty()) {
            int maxNameLength = BoxesRunTime.unboxToInt((Object)((TraversableOnce)metrics.map((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToInteger((int)Metrics.$anonfun$renderMetrics$1(m)), Set$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$)) + 2;
            int maxTagSectionLength = BoxesRunTime.unboxToInt((Object)((TraversableOnce)metrics.map((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToInteger((int)Metrics.$anonfun$renderMetrics$4(this, m)), Set$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$)) + 2;
            return ((TraversableOnce)((List)metrics.groupBy((Function1 & Serializable & scala.Serializable)x$4 -> x$4.metricKey().name()).toList().sortBy((Function1 & Serializable & scala.Serializable)x$5 -> (String)x$5._1(), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 != null) {
                    return ((TraversableOnce)((Set)x0$1._2()).map((Function1 & Serializable & scala.Serializable)metric -> new StringBuilder(0).append(this.renderKey(metric.metricKey(), maxNameLength)).append(this.renderTags(metric.metricKey(), maxTagSectionLength)).append(this.renderValue((MetricPair<?, ?>)metric)).toString(), Set$.MODULE$.canBuildFrom())).mkString(lineSeparator);
                }
                throw new MatchError(null);
            }, List$.MODULE$.canBuildFrom())).mkString(lineSeparator);
        }
        return "";
    }

    private String renderKey(MetricKey<?> key, int padTo) {
        return (String)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(0).append(key.name()).append(key.description().map((Function1 & Serializable & scala.Serializable)d -> new StringBuilder(2).append("(").append((String)d).append(")").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString())).padTo(padTo, (Object)BoxesRunTime.boxToCharacter((char)' '), Predef$.MODULE$.StringCanBuildFrom());
    }

    private String renderTags(MetricKey<?> key, int padTo) {
        String tagsStr = this.tagsToString(key.tags());
        return new StringBuilder(0).append(tagsStr).append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(package$.MODULE$.max(0, padTo - tagsStr.length()))).toString();
    }

    private String renderValue(MetricPair<?, ?> metric) {
        MetricState<?> metricState = metric.metricState();
        if (metricState instanceof MetricState.Counter) {
            double count = ((MetricState.Counter)metricState).count();
            return new StringBuilder(9).append("Counter[").append(count).append("]").toString();
        }
        if (metricState instanceof MetricState.Frequency) {
            Map<String, Object> occurrences = ((MetricState.Frequency)metricState).occurrences();
            return new StringBuilder(11).append("Frequency[").append(Metrics.renderKeyValues$1(occurrences)).append("]").toString();
        }
        if (metricState instanceof MetricState.Gauge) {
            double value = ((MetricState.Gauge)metricState).value();
            return new StringBuilder(7).append("Gauge[").append(value).append("]").toString();
        }
        if (metricState instanceof MetricState.Histogram) {
            MetricState.Histogram histogram = (MetricState.Histogram)metricState;
            Chunk<Tuple2<Object, Object>> buckets = histogram.buckets();
            long count = histogram.count();
            double min = histogram.min();
            double max = histogram.max();
            double sum = histogram.sum();
            return new StringBuilder(60).append("Histogram[buckets: [").append(Metrics.renderKeyValues$1(buckets)).append("], count: [").append(count).append("], min: [").append(min).append("], max: [").append(max).append("], sum: [").append(sum).append("]]").toString();
        }
        if (metricState instanceof MetricState.Summary) {
            MetricState.Summary summary = (MetricState.Summary)metricState;
            Chunk<Tuple2<Object, Option<Object>>> quantiles = summary.quantiles();
            long count = summary.count();
            double min = summary.min();
            double max = summary.max();
            double sum = summary.sum();
            return new StringBuilder(60).append("Summary[quantiles: [").append(Metrics.renderKeyValues$1(quantiles)).append("], count: [").append(count).append("], min: [").append(min).append("], max: [").append(max).append("], sum: [").append(sum).append("]]").toString();
        }
        throw new MatchError(metricState);
    }

    private String tagsToString(Set<MetricLabel> tags) {
        List byName = (List)tags.toList().sortBy((Function1 & Serializable & scala.Serializable)x$6 -> x$6.key(), (Ordering)Ordering.String$.MODULE$);
        return new StringBuilder(6).append("tags[").append(((TraversableOnce)byName.map((Function1 & Serializable & scala.Serializable)l -> new StringBuilder(2).append(l.key()).append(": ").append(l.value()).toString(), List$.MODULE$.canBuildFrom())).mkString(", ")).append("]").toString();
    }

    public Metrics copy(Set<MetricPair<MetricKeyType, Object>> metrics) {
        return new Metrics(metrics);
    }

    public Set<MetricPair<MetricKeyType, Object>> copy$default$1() {
        return this.metrics();
    }

    public String productPrefix() {
        return "Metrics";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        switch (x$1) {
            case 0: {
                return this.metrics();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Metrics;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean equals(Object x$1) {
        block3: {
            block2: {
                if (this == x$1) break block2;
                if (!(x$1 instanceof Metrics)) break block3;
                Metrics metrics = (Metrics)x$1;
                Set<MetricPair<MetricKeyType, Object>> set = this.metrics();
                Set<MetricPair<MetricKeyType, Object>> set2 = metrics.metrics();
                if (set != null ? !set.equals(set2) : set2 != null) break block3;
            }
            return true;
        }
        return false;
    }

    public static final /* synthetic */ int $anonfun$renderMetrics$2(String x$3) {
        return x$3.length() + 2;
    }

    public static final /* synthetic */ int $anonfun$renderMetrics$1(MetricPair m) {
        return m.metricKey().name().length() + BoxesRunTime.unboxToInt((Object)m.metricKey().description().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)Metrics.$anonfun$renderMetrics$2(x$3))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
    }

    public static final /* synthetic */ int $anonfun$renderMetrics$4(Metrics $this, MetricPair m) {
        return $this.tagsToString(m.metricKey().tags()).length();
    }

    private static final String renderKeyValues$1(Iterable keyValues) {
        return ((TraversableOnce)keyValues.map((Function1 & Serializable & scala.Serializable)p -> new StringBuilder(6).append("(").append(p._1()).append(" -> ").append(p._2()).append(")").toString(), Iterable$.MODULE$.canBuildFrom())).mkString(", ");
    }

    public Metrics(Set<MetricPair<MetricKeyType, Object>> metrics) {
        this.metrics = metrics;
        Product.$init$((Product)this);
    }
}

