/*
 * Decompiled with CFR 0.152.
 */
package zio.internal;

import java.util.concurrent.ThreadLocalRandom;
import scala.Array$;
import scala.Function0;
import scala.Serializable;
import scala.collection.Iterable;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import zio.Chunk;
import zio.Chunk$;
import zio.internal.LinkedQueue;
import zio.internal.MutableConcurrentQueue;
import zio.internal.MutableConcurrentQueue$;

@ScalaSignature(bytes="\u0006\u0001\u0005-b!B\u000b\u0017\u0005aQ\u0002\u0002\u0003\u001a\u0001\u0005\u0003\u0005\u000b\u0011B\u001a\t\u0011Y\u0002!\u0011!Q\u0001\n]BQA\u000f\u0001\u0005\u0002mBqa\u0010\u0001C\u0002\u0013\u0015\u0003\t\u0003\u0004D\u0001\u0001\u0006i!\u0011\u0005\u0007\t\u0002\u0001\u000b\u0011B\u001a\t\r\u0015\u0003\u0001\u0015!\u00034\u0011\u00191\u0005\u0001)A\u0005\u000f\")Q\n\u0001C\u0001\u001d\")q\n\u0001C!\u001d\")\u0001\u000b\u0001C!#\")Q\u000b\u0001C!#\")a\u000b\u0001C\u0001/\")a\u000b\u0001C!S\")1\u000e\u0001C\u0001Y\"11\u000e\u0001C!\u0003\u0007Aq!a\u0006\u0001\t\u0003\tI\u0002C\u0004\u0002\u0018\u0001!\t%!\t\t\u000f\u0005\u0015\u0002\u0001\"\u0011\u0002(!9\u0011\u0011\u0006\u0001\u0005B\u0005\u001d\"A\u0006)beRLG/[8oK\u0012d\u0015N\\6fIF+X-^3\u000b\u0005]A\u0012\u0001C5oi\u0016\u0014h.\u00197\u000b\u0003e\t1A_5p+\tY\"eE\u0002\u00019=\u00022!\b\u0010!\u001b\u00051\u0012BA\u0010\u0017\u0005YiU\u000f^1cY\u0016\u001cuN\\2veJ,g\u000e^)vKV,\u0007CA\u0011#\u0019\u0001!Qa\t\u0001C\u0002\u0015\u0012\u0011!Q\u0002\u0001#\t1C\u0006\u0005\u0002(U5\t\u0001FC\u0001*\u0003\u0015\u00198-\u00197b\u0013\tY\u0003FA\u0004O_RD\u0017N\\4\u0011\u0005\u001dj\u0013B\u0001\u0018)\u0005\u0019\te.\u001f*fMB\u0011q\u0005M\u0005\u0003c!\u0012AbU3sS\u0006d\u0017N_1cY\u0016\f1\u0003\u001d:fM\u0016\u0014(/\u001a3QCJ$\u0018\u000e^5p]N\u0004\"a\n\u001b\n\u0005UB#aA%oi\u0006Q\u0011\r\u001a3NKR\u0014\u0018nY:\u0011\u0005\u001dB\u0014BA\u001d)\u0005\u001d\u0011un\u001c7fC:\fa\u0001P5oSRtDc\u0001\u001f>}A\u0019Q\u0004\u0001\u0011\t\u000bI\u001a\u0001\u0019A\u001a\t\u000bY\u001a\u0001\u0019A\u001c\u0002\u0011\r\f\u0007/Y2jif,\u0012!Q\b\u0002\u0005v!qp\u0000\u0000\u0000\u0004%\u0019\u0017\r]1dSRL\b%\u0001\u0003nCN\\\u0017a\u00028Rk\u0016,Xm]\u0001\u0007cV,W/Z:\u0011\u0007\u001dB%*\u0003\u0002JQ\t)\u0011I\u001d:bsB\u0019Qd\u0013\u0011\n\u000513\"a\u0003'j].,G-U;fk\u0016\f1B\u001c)beRLG/[8ogR\t1'\u0001\u0003tSj,\u0017!D3ocV,W/\u001a3D_VtG\u000fF\u0001S!\t93+\u0003\u0002UQ\t!Aj\u001c8h\u00035!W-];fk\u0016$7i\\;oi\u0006)qN\u001a4feR\u0019\u0001lW/\u0011\u0005\u001dJ\u0016B\u0001.)\u0005\u0011)f.\u001b;\t\u000bqk\u0001\u0019\u0001\u0011\u0002\u0003\u0005DQAX\u0007A\u0002}\u000baA]1oI>l\u0007C\u00011h\u001b\u0005\t'B\u00012d\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003I\u0016\fA!\u001e;jY*\ta-\u0001\u0003kCZ\f\u0017B\u00015b\u0005E!\u0006N]3bI2{7-\u00197SC:$w.\u001c\u000b\u0003o)DQ\u0001\u0018\bA\u0002\u0001\n\u0001b\u001c4gKJ\fE\u000e\\\u000b\u0003[v$B\u0001\u00178\u0002\u0002!)qn\u0004a\u0001a\u0006\u0011\u0011m\u001d\t\u0004cfdhB\u0001:x\u001d\t\u0019h/D\u0001u\u0015\t)H%\u0001\u0004=e>|GOP\u0005\u0002S%\u0011\u0001\u0010K\u0001\ba\u0006\u001c7.Y4f\u0013\tQ8P\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\tA\b\u0006\u0005\u0002\"{\u0012)ap\u0004b\u0001\u007f\n\u0011\u0011)M\t\u0003M\u0001BQAX\bA\u0002}+B!!\u0002\u0002\u0012Q!\u0011qAA\n!\u0019\tI!a\u0003\u0002\u00105\t\u0001$C\u0002\u0002\u000ea\u0011Qa\u00115v].\u00042!IA\t\t\u0015q\bC1\u0001\u0000\u0011\u0019y\u0007\u00031\u0001\u0002\u0016A!\u0011/_A\b\u0003\u0011\u0001x\u000e\u001c7\u0015\u000b\u0001\nY\"a\b\t\r\u0005u\u0011\u00031\u0001!\u0003\u001d!WMZ1vYRDQAX\tA\u0002}#2\u0001IA\u0012\u0011\u0019\tiB\u0005a\u0001A\u00059\u0011n]#naRLH#A\u001c\u0002\r%\u001ch)\u001e7m\u0001")
public final class PartitionedLinkedQueue<A>
extends MutableConcurrentQueue<A>
implements Serializable {
    private final boolean addMetrics;
    private final int mask;
    private final int nQueues;
    private final LinkedQueue<A>[] queues;

    @Override
    public final int capacity() {
        return Integer.MAX_VALUE;
    }

    public int nPartitions() {
        return this.nQueues;
    }

    @Override
    public int size() {
        int from = ThreadLocalRandom.current().nextInt(this.nQueues);
        int size = 0;
        for (int i = 0; i < this.nQueues; ++i) {
            int idx = from + i & this.mask;
            size += this.queues[idx].size();
        }
        return size;
    }

    @Override
    public long enqueuedCount() {
        if (this.addMetrics) {
            int from = ThreadLocalRandom.current().nextInt(this.nQueues);
            long size = 0L;
            for (int i = 0; i < this.nQueues; ++i) {
                int idx = from + i & this.mask;
                size += this.queues[idx].enqueuedCount();
            }
            return size;
        }
        return 0L;
    }

    @Override
    public long dequeuedCount() {
        if (this.addMetrics) {
            int from = ThreadLocalRandom.current().nextInt(this.nQueues);
            long size = 0L;
            for (int i = 0; i < this.nQueues; ++i) {
                int idx = from + i & this.mask;
                size += this.queues[idx].dequeuedCount();
            }
            return size;
        }
        return 0L;
    }

    public void offer(A a, ThreadLocalRandom random) {
        int idx = random.nextInt(this.nQueues);
        this.queues[idx].offer(a);
    }

    @Override
    public boolean offer(A a) {
        this.offer(a, ThreadLocalRandom.current());
        return true;
    }

    public <A1 extends A> void offerAll(Iterable<A1> as, ThreadLocalRandom random) {
        int from = random.nextInt(this.nQueues);
        int i = 0;
        for (Object value : as) {
            int idx = from + i & this.mask;
            this.queues[idx].offer(value);
            ++i;
        }
    }

    @Override
    public <A1 extends A> Chunk<A1> offerAll(Iterable<A1> as) {
        this.offerAll(as, ThreadLocalRandom.current());
        return Chunk$.MODULE$.empty();
    }

    public A poll(A a, ThreadLocalRandom random) {
        int from = random.nextInt(this.nQueues);
        A result = null;
        for (int i = 0; result == null && i < this.nQueues; ++i) {
            int idx = from + i & this.mask;
            result = this.queues[idx].poll(a);
        }
        return result;
    }

    @Override
    public A poll(A a) {
        return this.poll(a, ThreadLocalRandom.current());
    }

    @Override
    public boolean isEmpty() {
        int from = ThreadLocalRandom.current().nextInt(this.nQueues);
        boolean result = true;
        for (int i = 0; result && i < this.nQueues; ++i) {
            int idx = from + i & this.mask;
            result = this.queues[idx].isEmpty();
        }
        return result;
    }

    @Override
    public boolean isFull() {
        return false;
    }

    public PartitionedLinkedQueue(int preferredPartitions, boolean addMetrics) {
        this.addMetrics = addMetrics;
        this.mask = MutableConcurrentQueue$.MODULE$.roundToPow2MinusOne(preferredPartitions);
        this.nQueues = this.mask + 1;
        this.queues = (LinkedQueue[])Array$.MODULE$.fill(this.nQueues, (Function0 & java.io.Serializable & Serializable)() -> new LinkedQueue($this.addMetrics), ClassTag$.MODULE$.apply(LinkedQueue.class));
    }
}

