/*
 * Decompiled with CFR 0.152.
 */
package zio.internal.metrics;

import java.io.Serializable;
import java.time.Instant;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import zio.Unsafe;
import zio.internal.metrics.ConcurrentMetricHooks$;
import zio.internal.metrics.MetricEventType;
import zio.internal.metrics.MetricEventType$Modify$;
import zio.internal.metrics.MetricEventType$Update$;
import zio.internal.metrics.MetricHook;
import zio.metrics.MetricKey;
import zio.metrics.MetricKeyType;
import zio.metrics.MetricKeyType$Counter$;
import zio.metrics.MetricKeyType$Frequency$;
import zio.metrics.MetricKeyType$Gauge$;
import zio.metrics.MetricListener;
import zio.metrics.MetricPair;
import zio.metrics.MetricPair$;
import zio.metrics.MetricState;

@ScalaSignature(bytes="\u0006\u0001\u0005Mh!\u0002\t\u0012\u0001U9\u0002\"\u0002\u0010\u0001\t\u0003\u0001\u0003bB\u0012\u0001\u0005\u0004%I\u0001\n\u0005\u0007s\u0001\u0001\u000b\u0011B\u0013\t\u000fi\u0002!\u0019!C\u0005w!1Q\n\u0001Q\u0001\nqBQA\u0014\u0001\u0005\u0002=CQ!\u001b\u0001\u0005\u0002)Dq!!\u0004\u0001\t\u000b\ty\u0001C\u0004\u0002.\u0001!)!a\f\t\u0011\u0005e\u0002\u0001\"\u0001\u0016\u0003wAq!a\"\u0001\t\u0013\tI\tC\u0004\u0002$\u0002!I!!*\t\u000f\u0005]\u0006\u0001\"\u0003\u0002:\"9\u00111\u001a\u0001\u0005\n\u00055\u0007bBAp\u0001\u0011%\u0011\u0011\u001d\u0002\u0019\u0007>t7-\u001e:sK:$X*\u001a;sS\u000e\u0014VmZ5tiJL(B\u0001\n\u0014\u0003\u001diW\r\u001e:jGNT!\u0001F\u000b\u0002\u0011%tG/\u001a:oC2T\u0011AF\u0001\u0004u&|7C\u0001\u0001\u0019!\tIB$D\u0001\u001b\u0015\u0005Y\u0012!B:dC2\f\u0017BA\u000f\u001b\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\u001a\u0001\u0001F\u0001\"!\t\u0011\u0003!D\u0001\u0012\u00031a\u0017n\u001d;f]\u0016\u00148OU3g+\u0005)\u0003c\u0001\u00140c5\tqE\u0003\u0002)S\u00051\u0011\r^8nS\u000eT!AK\u0016\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002-[\u0005!Q\u000f^5m\u0015\u0005q\u0013\u0001\u00026bm\u0006L!\u0001M\u0014\u0003\u001f\u0005#x.\\5d%\u00164WM]3oG\u0016\u00042!\u0007\u001a5\u0013\t\u0019$DA\u0003BeJ\f\u0017\u0010\u0005\u00026o5\taG\u0003\u0002\u0013+%\u0011\u0001H\u000e\u0002\u000f\u001b\u0016$(/[2MSN$XM\\3s\u00035a\u0017n\u001d;f]\u0016\u00148OU3gA\u0005\u0019Q.\u00199\u0016\u0003q\u0002B!\u0010 A\r6\t\u0011&\u0003\u0002@S\t\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u00199\u0011\u0007U\n5)\u0003\u0002Cm\tIQ*\u001a;sS\u000e\\U-\u001f\t\u0003k\u0011K!!\u0012\u001c\u0003\u001b5+GO]5d\u0017\u0016LH+\u001f9f!\t9%J\u0004\u0002#\u0011&\u0011\u0011*E\u0001\u000b\u001b\u0016$(/[2I_>\\\u0017BA&M\u0005\u0011\u0011vn\u001c;\u000b\u0005%\u000b\u0012\u0001B7ba\u0002\n\u0001b\u001d8baNDw\u000e\u001e\u000b\u0002!R\u0011\u0011k\u0019\t\u0004%fcfBA*X!\t!&$D\u0001V\u0015\t1v$\u0001\u0004=e>|GOP\u0005\u00031j\ta\u0001\u0015:fI\u00164\u0017B\u0001.\\\u0005\r\u0019V\r\u001e\u0006\u00031j\u0001\"!\u00181\u000f\u0005Ur\u0016BA07\u0003)iU\r\u001e:jGB\u000b\u0017N]\u0005\u0003C\n\u0014q!\u00168usB,GM\u0003\u0002`m!)AM\u0002a\u0002K\u00061QO\\:bM\u0016\u0004\"AZ4\u000e\u0003UI!\u0001[\u000b\u0003\rUs7/\u00194f\u0003\r9W\r^\u000b\u0003Wb$\"\u0001\u001c;\u0015\u00075\fY\u0001E\u0003#]B\f)!\u0003\u0002p#\tQQ*\u001a;sS\u000eDun\\6\u0011\u0007E\f\tA\u0004\u0002s}:\u00111\u000f\u001e\u0007\u0001\u0011\u0015)x\u00011\u0001w\u0003\rYW-\u001f\t\u0004k\u0005;\bCA:y\t\u0015IxA1\u0001{\u0005\u0011!\u0016\u0010]3\u0012\u0005m\u001c\u0005CA\r}\u0013\ti(DA\u0004O_RD\u0017N\\4\n\u0005}\f\u0015aB6fsRK\b/Z\u0005\u0004\u0003\u0007!%AA%o!\r\t\u0018qA\u0005\u0004\u0003\u0013!%aA(vi\")Am\u0002a\u0002K\u0006Y\u0011\r\u001a3MSN$XM\\3s)\u0011\t\t\"a\u0007\u0015\t\u0005M\u0011\u0011\u0004\t\u00043\u0005U\u0011bAA\f5\t!QK\\5u\u0011\u0015!\u0007\u0002q\u0001f\u0011\u0019\ti\u0002\u0003a\u0001i\u0005AA.[:uK:,'\u000fK\u0002\t\u0003C\u0001B!a\t\u0002*5\u0011\u0011Q\u0005\u0006\u0004\u0003OQ\u0012AC1o]>$\u0018\r^5p]&!\u00111FA\u0013\u0005\u001d!\u0018-\u001b7sK\u000e\faB]3n_Z,G*[:uK:,'\u000f\u0006\u0003\u00022\u0005UB\u0003BA\n\u0003gAQ\u0001Z\u0005A\u0004\u0015Da!!\b\n\u0001\u0004!\u0004fA\u0005\u0002\"\u0005yan\u001c;jMfd\u0015n\u001d;f]\u0016\u00148/\u0006\u0003\u0002>\u00055D\u0003CA \u00033\nI(! \u0015\r\u0005M\u0011\u0011IA,\u0011\u001d\t\u0019E\u0003a\u0002\u0003\u000b\nQ\u0001\u001e:bG\u0016\u0004B!a\u0012\u0002R9!\u0011\u0011JA'\u001d\r!\u00161J\u0005\u0002-%\u0019\u0011qJ\u000b\u0002\u000fA\f7m[1hK&!\u00111KA+\u0005\u0015!&/Y2f\u0015\r\ty%\u0006\u0005\u0006I*\u0001\u001d!\u001a\u0005\u0007k*\u0001\r!a\u0017\u0011\tU\n\u0015Q\f\t\u0007\u0003?\n)'a\u001b\u000f\u0007U\n\t'C\u0002\u0002dY\nQ\"T3ue&\u001c7*Z=UsB,\u0017\u0002BA4\u0003S\u0012aaV5uQ&s'bAA2mA\u00191/!\u001c\u0005\u000f\u0005=$B1\u0001\u0002r\t\tA+E\u0002|\u0003g\u00022!GA;\u0013\r\t9H\u0007\u0002\u0004\u0003:L\bbBA>\u0015\u0001\u0007\u00111N\u0001\u0006m\u0006dW/\u001a\u0005\b\u0003\u007fR\u0001\u0019AAA\u0003%)g/\u001a8u)f\u0004X\rE\u0002#\u0003\u0007K1!!\"\u0012\u0005=iU\r\u001e:jG\u00163XM\u001c;UsB,\u0017AC4fi\u000e{WO\u001c;feR!\u00111RAK)\u0011\ti)a%\u0011\u0007\u001d\u000by)C\u0002\u0002\u00122\u0013qaQ8v]R,'\u000fC\u0003e\u0017\u0001\u000fQ\r\u0003\u0004v\u0017\u0001\u0007\u0011q\u0013\t\u0005\u00033\u000byJD\u00026\u00037K1!!(7\u0003%iU\r\u001e:jG.+\u00170\u0003\u0003\u0002\u0012\u0006\u0005&bAAOm\u0005Aq-\u001a;HCV<W\r\u0006\u0003\u0002(\u0006EF\u0003BAU\u0003_\u00032aRAV\u0013\r\ti\u000b\u0014\u0002\u0006\u000f\u0006,x-\u001a\u0005\u0006I2\u0001\u001d!\u001a\u0005\u0007k2\u0001\r!a-\u0011\t\u0005e\u0015QW\u0005\u0005\u0003[\u000b\t+\u0001\u0007hKRD\u0015n\u001d;pOJ\fW\u000e\u0006\u0003\u0002<\u0006\u0015G\u0003BA_\u0003\u0007\u00042aRA`\u0013\r\t\t\r\u0014\u0002\n\u0011&\u001cHo\\4sC6DQ\u0001Z\u0007A\u0004\u0015Da!^\u0007A\u0002\u0005\u001d\u0007\u0003BAM\u0003\u0013LA!!1\u0002\"\u0006Qq-\u001a;Tk6l\u0017M]=\u0015\t\u0005=\u0017\u0011\u001c\u000b\u0005\u0003#\f9\u000eE\u0002H\u0003'L1!!6M\u0005\u001d\u0019V/\\7befDQ\u0001\u001a\bA\u0004\u0015Da!\u001e\bA\u0002\u0005m\u0007\u0003BAM\u0003;LA!!6\u0002\"\u0006Yq-\u001a;TKR\u001cu.\u001e8u)\u0011\t\u0019/!<\u0015\t\u0005\u0015\u00181\u001e\t\u0004\u000f\u0006\u001d\u0018bAAu\u0019\nIaI]3rk\u0016t7-\u001f\u0005\u0006I>\u0001\u001d!\u001a\u0005\u0007k>\u0001\r!a<\u0011\t\u0005e\u0015\u0011_\u0005\u0005\u0003S\f\t\u000b")
public class ConcurrentMetricRegistry {
    private final AtomicReference<MetricListener[]> listenersRef = new AtomicReference<Object>(Array$.MODULE$.empty(ClassTag$.MODULE$.apply(MetricListener.class)));
    private final ConcurrentHashMap<MetricKey<MetricKeyType>, MetricHook<?, MetricState<Object>>> map = new ConcurrentHashMap();

    private AtomicReference<MetricListener[]> listenersRef() {
        return this.listenersRef;
    }

    private ConcurrentHashMap<MetricKey<MetricKeyType>, MetricHook<?, MetricState<Object>>> map() {
        return this.map;
    }

    public scala.collection.immutable.Set<MetricPair<MetricKeyType, Object>> snapshot(Unsafe unsafe) {
        Iterator<Map.Entry<MetricKey<MetricKeyType>, MetricHook<?, MetricState<Object>>>> iterator = this.map().entrySet().iterator();
        Set result = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (iterator.hasNext()) {
            Map.Entry<MetricKey<MetricKeyType>, MetricHook<?, MetricState<Object>>> value = iterator.next();
            MetricKey<MetricKeyType> key = value.getKey();
            MetricHook<?, MetricState<Object>> hook = value.getValue();
            result.add(MetricPair$.MODULE$.make(key, (MetricState)hook.get().apply(), unsafe));
        }
        return result.toSet();
    }

    public <Type extends MetricKeyType> MetricHook<Object, Object> get(MetricKey<Type> key, Unsafe unsafe) {
        MetricHook<Object, Object> hook0 = this.map().get(key);
        if (hook0 == null) {
            MetricKeyType metricKeyType = (MetricKeyType)key.keyType();
            if (MetricKeyType$Counter$.MODULE$.equals(metricKeyType)) {
                return this.getCounter(key, unsafe);
            }
            if (MetricKeyType$Frequency$.MODULE$.equals(metricKeyType)) {
                return this.getSetCount(key, unsafe);
            }
            if (MetricKeyType$Gauge$.MODULE$.equals(metricKeyType)) {
                return this.getGauge(key, unsafe);
            }
            if (metricKeyType instanceof MetricKeyType.Histogram) {
                return this.getHistogram(key, unsafe);
            }
            if (metricKeyType instanceof MetricKeyType.Summary) {
                return this.getSummary(key, unsafe);
            }
            throw new MatchError((Object)metricKeyType);
        }
        return hook0;
    }

    public final void addListener(MetricListener listener, Unsafe unsafe) {
        MetricListener[] newListeners;
        MetricListener[] oldListeners;
        do {
            oldListeners = this.listenersRef().get();
            newListeners = (MetricListener[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])oldListeners)).$colon$plus((Object)listener, ClassTag$.MODULE$.apply(MetricListener.class));
        } while (!this.listenersRef().compareAndSet(oldListeners, newListeners));
    }

    public final void removeListener(MetricListener listener, Unsafe unsafe) {
        MetricListener[] newListeners;
        MetricListener[] oldListeners;
        do {
            oldListeners = this.listenersRef().get();
            newListeners = (MetricListener[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])oldListeners)).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ConcurrentMetricRegistry.$anonfun$removeListener$1(listener, x$1)));
        } while (!this.listenersRef().compareAndSet(oldListeners, newListeners));
    }

    /*
     * WARNING - void declaration
     */
    public <T> void notifyListeners(MetricKey<MetricKeyType> key, T value, MetricEventType eventType, Object trace, Unsafe unsafe) {
        MetricListener[] listeners = this.listenersRef().get();
        int len = listeners.length;
        if (len > 0) {
            int i;
            MetricKeyType metricKeyType = key.keyType();
            if (MetricKeyType$Gauge$.MODULE$.equals(metricKeyType)) {
                if (MetricEventType$Modify$.MODULE$.equals(eventType)) {
                    for (i = 0; i < len; ++i) {
                        listeners[i].modifyGauge(key, BoxesRunTime.unboxToDouble(value), unsafe);
                    }
                } else if (MetricEventType$Update$.MODULE$.equals(eventType)) {
                    while (i < len) {
                        listeners[i].updateGauge(key, BoxesRunTime.unboxToDouble(value), unsafe);
                        ++i;
                    }
                } else {
                    throw new MatchError((Object)eventType);
                }
                return;
            }
            if (metricKeyType instanceof MetricKeyType.Histogram) {
                while (i < len) {
                    listeners[i].updateHistogram(key, BoxesRunTime.unboxToDouble(value), unsafe);
                    ++i;
                }
                return;
            }
            if (MetricKeyType$Frequency$.MODULE$.equals(metricKeyType)) {
                while (i < len) {
                    listeners[i].updateFrequency(key, (String)value, unsafe);
                    ++i;
                }
                return;
            }
            if (metricKeyType instanceof MetricKeyType.Summary) {
                while (i < len) {
                    void var13_12;
                    void var11_11;
                    Tuple2 tuple2 = (Tuple2)value;
                    if (tuple2 == null) {
                        throw new MatchError(null);
                    }
                    double v = tuple2._1$mcD$sp();
                    Instant instant = (Instant)tuple2._2();
                    listeners[i].updateSummary(key, (double)var11_11, (Instant)var13_12, unsafe);
                    ++i;
                }
                return;
            }
            if (MetricKeyType$Counter$.MODULE$.equals(metricKeyType)) {
                while (i < len) {
                    listeners[i].updateCounter(key, BoxesRunTime.unboxToDouble(value), unsafe);
                    ++i;
                }
                return;
            }
            throw new MatchError((Object)metricKeyType);
        }
    }

    private MetricHook<Object, MetricState.Counter> getCounter(MetricKey<MetricKeyType$Counter$> key, Unsafe unsafe) {
        MetricHook<?, MetricState<Object>> value = this.map().get(key);
        if (value == null) {
            MetricHook<Object, MetricState.Counter> counter = ConcurrentMetricHooks$.MODULE$.counter(key);
            this.map().putIfAbsent(key, counter);
            value = this.map().get(key);
        }
        return value;
    }

    private MetricHook<Object, MetricState.Gauge> getGauge(MetricKey<MetricKeyType$Gauge$> key, Unsafe unsafe) {
        MetricHook<?, MetricState<Object>> value = this.map().get(key);
        if (value == null) {
            MetricHook<Object, MetricState.Gauge> gauge = ConcurrentMetricHooks$.MODULE$.gauge(key, 0.0);
            this.map().putIfAbsent(key, gauge);
            value = this.map().get(key);
        }
        return value;
    }

    private MetricHook<Object, MetricState.Histogram> getHistogram(MetricKey<MetricKeyType.Histogram> key, Unsafe unsafe) {
        MetricHook<?, MetricState<Object>> value = this.map().get(key);
        if (value == null) {
            MetricHook<Object, MetricState.Histogram> histogram = ConcurrentMetricHooks$.MODULE$.histogram(key);
            this.map().putIfAbsent(key, histogram);
            value = this.map().get(key);
        }
        return value;
    }

    private MetricHook<Tuple2<Object, Instant>, MetricState.Summary> getSummary(MetricKey<MetricKeyType.Summary> key, Unsafe unsafe) {
        MetricHook<?, MetricState<Object>> value = this.map().get(key);
        if (value == null) {
            MetricHook<Tuple2<Object, Instant>, MetricState.Summary> summary = ConcurrentMetricHooks$.MODULE$.summary(key);
            this.map().putIfAbsent(key, summary);
            value = this.map().get(key);
        }
        return value;
    }

    private MetricHook<String, MetricState.Frequency> getSetCount(MetricKey<MetricKeyType$Frequency$> key, Unsafe unsafe) {
        MetricHook<?, MetricState<Object>> value = this.map().get(key);
        if (value == null) {
            MetricHook<String, MetricState.Frequency> frequency = ConcurrentMetricHooks$.MODULE$.frequency(key);
            this.map().putIfAbsent(key, frequency);
            value = this.map().get(key);
        }
        return value;
    }

    public static final /* synthetic */ boolean $anonfun$removeListener$1(MetricListener listener$1, MetricListener x$1) {
        return x$1 != listener$1;
    }
}

