/*
 * Decompiled with CFR 0.152.
 */
package zio.internal.metrics;

import java.io.Serializable;
import java.time.Instant;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import zio.Unsafe;
import zio.internal.metrics.ConcurrentMetricHooks$;
import zio.internal.metrics.MetricEventType;
import zio.internal.metrics.MetricEventType$Modify$;
import zio.internal.metrics.MetricEventType$Update$;
import zio.internal.metrics.MetricHook;
import zio.metrics.MetricKey;
import zio.metrics.MetricKeyType;
import zio.metrics.MetricKeyType$Counter$;
import zio.metrics.MetricKeyType$Frequency$;
import zio.metrics.MetricKeyType$Gauge$;
import zio.metrics.MetricListener;
import zio.metrics.MetricPair;
import zio.metrics.MetricPair$;
import zio.metrics.MetricState;

@ScalaSignature(bytes="\u0006\u0001\t5a!B\t\u0013\u0001YA\u0002\"B\u0010\u0001\t\u0003\t\u0003b\u0002\u0013\u0001\u0005\u0004%I!\n\u0005\u0007u\u0001\u0001\u000b\u0011\u0002\u0014\t\u000fm\u0002!\u0019!C\u0005y!1a\n\u0001Q\u0001\nuBQa\u0014\u0001\u0005\u0002ACQA\u001b\u0001\u0005\u0002-Dq!a\u0004\u0001\t\u0003\t\t\u0002C\u0004\u0002(\u0001!)!!\u000b\t\u000f\u0005\u001d\u0003\u0001\"\u0002\u0002J!A\u00111\u000b\u0001\u0005\u0002Y\t)\u0006C\u0004\u0002\"\u0002!I!a)\t\u000f\u0005u\u0006\u0001\"\u0003\u0002@\"9\u0011\u0011\u001b\u0001\u0005\n\u0005M\u0007bBAs\u0001\u0011%\u0011q\u001d\u0005\b\u0003s\u0004A\u0011BA~\u0005a\u0019uN\\2veJ,g\u000e^'fiJL7MU3hSN$(/\u001f\u0006\u0003'Q\tq!\\3ue&\u001c7O\u0003\u0002\u0016-\u0005A\u0011N\u001c;fe:\fGNC\u0001\u0018\u0003\rQ\u0018n\\\n\u0003\u0001e\u0001\"AG\u000f\u000e\u0003mQ\u0011\u0001H\u0001\u0006g\u000e\fG.Y\u0005\u0003=m\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003\t\u0002\"a\t\u0001\u000e\u0003I\tA\u0002\\5ti\u0016tWM]:SK\u001a,\u0012A\n\t\u0004OA\u0012T\"\u0001\u0015\u000b\u0005%R\u0013AB1u_6L7M\u0003\u0002,Y\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u00055r\u0013\u0001B;uS2T\u0011aL\u0001\u0005U\u00064\u0018-\u0003\u00022Q\ty\u0011\t^8nS\u000e\u0014VMZ3sK:\u001cW\rE\u0002\u001bgUJ!\u0001N\u000e\u0003\u000b\u0005\u0013(/Y=\u0011\u0005YBT\"A\u001c\u000b\u0005M1\u0012BA\u001d8\u00059iU\r\u001e:jG2K7\u000f^3oKJ\fQ\u0002\\5ti\u0016tWM]:SK\u001a\u0004\u0013aA7baV\tQ\b\u0005\u0003?\u007f\u0005;U\"\u0001\u0016\n\u0005\u0001S#!E\"p]\u000e,(O]3oi\"\u000b7\u000f['baB\u0019aG\u0011#\n\u0005\r;$!C'fiJL7mS3z!\t1T)\u0003\u0002Go\tiQ*\u001a;sS\u000e\\U-\u001f+za\u0016\u0004\"\u0001S&\u000f\u0005\rJ\u0015B\u0001&\u0013\u0003)iU\r\u001e:jG\"{wn[\u0005\u0003\u00196\u0013AAU8pi*\u0011!JE\u0001\u0005[\u0006\u0004\b%\u0001\u0005t]\u0006\u00048\u000f[8u)\u0005\tFC\u0001*e!\r\u0019&,\u0018\b\u0003)b\u0003\"!V\u000e\u000e\u0003YS!a\u0016\u0011\u0002\rq\u0012xn\u001c;?\u0013\tI6$\u0001\u0004Qe\u0016$WMZ\u0005\u00037r\u00131aU3u\u0015\tI6\u0004\u0005\u0002_C:\u0011agX\u0005\u0003A^\n!\"T3ue&\u001c\u0007+Y5s\u0013\t\u00117MA\u0004V]RL\b/\u001a3\u000b\u0005\u0001<\u0004\"B3\u0007\u0001\b1\u0017AB;og\u00064W\r\u0005\u0002hQ6\ta#\u0003\u0002j-\t1QK\\:bM\u0016\f1aZ3u+\ta\u0017\u0010\u0006\u0002nkR\u0019a.!\u0004\u0011\u000b\rz\u0017/a\u0002\n\u0005A\u0014\"AC'fiJL7\rS8pWB\u0019!/a\u0001\u000f\u0005M|hB\u0001;v\u0019\u0001AQA^\u0004A\u0002]\f1a[3z!\r1$\t\u001f\t\u0003if$QA_\u0004C\u0002m\u0014A\u0001V=qKF\u0011A\u0010\u0012\t\u00035uL!A`\u000e\u0003\u000f9{G\u000f[5oO&\u0019\u0011\u0011\u0001\"\u0002\u000f-,\u0017\u0010V=qK&\u0019\u0011QA#\u0003\u0005%s\u0007c\u0001:\u0002\n%\u0019\u00111B#\u0003\u0007=+H\u000fC\u0003f\u000f\u0001\u000fa-\u0001\u0004sK6|g/Z\u000b\u0005\u0003'\t)\u0003\u0006\u0003\u0002\u0016\u0005}A\u0003BA\f\u0003;\u00012AGA\r\u0013\r\tYb\u0007\u0002\b\u0005>|G.Z1o\u0011\u0015)\u0007\u0002q\u0001g\u0011\u00191\b\u00021\u0001\u0002\"A!aGQA\u0012!\r!\u0018Q\u0005\u0003\u0006u\"\u0011\ra_\u0001\fC\u0012$G*[:uK:,'\u000f\u0006\u0003\u0002,\u0005UB\u0003BA\u0017\u0003g\u00012AGA\u0018\u0013\r\t\td\u0007\u0002\u0005+:LG\u000fC\u0003f\u0013\u0001\u000fa\r\u0003\u0004\u00028%\u0001\r!N\u0001\tY&\u001cH/\u001a8fe\"\u001a\u0011\"a\u000f\u0011\t\u0005u\u00121I\u0007\u0003\u0003\u007fQ1!!\u0011\u001c\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u000b\nyDA\u0004uC&d'/Z2\u0002\u001dI,Wn\u001c<f\u0019&\u001cH/\u001a8feR!\u00111JA()\u0011\ti#!\u0014\t\u000b\u0015T\u00019\u00014\t\r\u0005]\"\u00021\u00016Q\rQ\u00111H\u0001\u0010]>$\u0018NZ=MSN$XM\\3sgV!\u0011qKAD)!\tI&a\u001d\u0002\u0014\u0006]ECBA\u0017\u00037\n\t\bC\u0004\u0002^-\u0001\u001d!a\u0018\u0002\u000bQ\u0014\u0018mY3\u0011\t\u0005\u0005\u00141\u000e\b\u0005\u0003G\n9GD\u0002V\u0003KJ\u0011aF\u0005\u0004\u0003S2\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003[\nyGA\u0003Ue\u0006\u001cWMC\u0002\u0002jYAQ!Z\u0006A\u0004\u0019DaA^\u0006A\u0002\u0005U\u0004\u0003\u0002\u001cC\u0003o\u0002b!!\u001f\u0002\u0000\u0005\u0015eb\u0001\u001c\u0002|%\u0019\u0011QP\u001c\u0002\u001b5+GO]5d\u0017\u0016LH+\u001f9f\u0013\u0011\t\t)a!\u0003\r]KG\u000f[%o\u0015\r\tih\u000e\t\u0004i\u0006\u001dEaBAE\u0017\t\u0007\u00111\u0012\u0002\u0002)F\u0019A0!$\u0011\u0007i\ty)C\u0002\u0002\u0012n\u00111!\u00118z\u0011\u001d\t)j\u0003a\u0001\u0003\u000b\u000bQA^1mk\u0016Dq!!'\f\u0001\u0004\tY*A\u0005fm\u0016tG\u000fV=qKB\u00191%!(\n\u0007\u0005}%CA\bNKR\u0014\u0018nY#wK:$H+\u001f9f\u0003)9W\r^\"pk:$XM\u001d\u000b\u0005\u0003K\u000by\u000b\u0006\u0003\u0002(\u00065\u0006c\u0001%\u0002*&\u0019\u00111V'\u0003\u000f\r{WO\u001c;fe\")Q\r\u0004a\u0002M\"1a\u000f\u0004a\u0001\u0003c\u0003B!a-\u0002::\u0019a'!.\n\u0007\u0005]v'A\u0005NKR\u0014\u0018nY&fs&!\u00111VA^\u0015\r\t9lN\u0001\tO\u0016$x)Y;hKR!\u0011\u0011YAf)\u0011\t\u0019-!3\u0011\u0007!\u000b)-C\u0002\u0002H6\u0013QaR1vO\u0016DQ!Z\u0007A\u0004\u0019DaA^\u0007A\u0002\u00055\u0007\u0003BAZ\u0003\u001fLA!a2\u0002<\u0006aq-\u001a;ISN$xn\u001a:b[R!\u0011Q[Ap)\u0011\t9.!8\u0011\u0007!\u000bI.C\u0002\u0002\\6\u0013\u0011\u0002S5ti><'/Y7\t\u000b\u0015t\u00019\u00014\t\rYt\u0001\u0019AAq!\u0011\t\u0019,a9\n\t\u0005m\u00171X\u0001\u000bO\u0016$8+^7nCJLH\u0003BAu\u0003g$B!a;\u0002rB\u0019\u0001*!<\n\u0007\u0005=XJA\u0004Tk6l\u0017M]=\t\u000b\u0015|\u00019\u00014\t\rY|\u0001\u0019AA{!\u0011\t\u0019,a>\n\t\u0005=\u00181X\u0001\fO\u0016$8+\u001a;D_VtG\u000f\u0006\u0003\u0002~\n\u001dA\u0003BA\u0000\u0005\u000b\u00012\u0001\u0013B\u0001\u0013\r\u0011\u0019!\u0014\u0002\n\rJ,\u0017/^3oGfDQ!\u001a\tA\u0004\u0019DaA\u001e\tA\u0002\t%\u0001\u0003BAZ\u0005\u0017IAAa\u0001\u0002<\u0002")
public class ConcurrentMetricRegistry {
    private final AtomicReference<MetricListener[]> listenersRef = new AtomicReference<Object>(Array$.MODULE$.empty(ClassTag$.MODULE$.apply(MetricListener.class)));
    private final ConcurrentHashMap<MetricKey<MetricKeyType>, MetricHook<?, MetricState<Object>>> map = new ConcurrentHashMap();

    private AtomicReference<MetricListener[]> listenersRef() {
        return this.listenersRef;
    }

    private ConcurrentHashMap<MetricKey<MetricKeyType>, MetricHook<?, MetricState<Object>>> map() {
        return this.map;
    }

    public scala.collection.immutable.Set<MetricPair<MetricKeyType, Object>> snapshot(Unsafe unsafe) {
        Iterator<Map.Entry<MetricKey<MetricKeyType>, MetricHook<?, MetricState<Object>>>> iterator = this.map().entrySet().iterator();
        Set result = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (iterator.hasNext()) {
            Map.Entry<MetricKey<MetricKeyType>, MetricHook<?, MetricState<Object>>> value = iterator.next();
            MetricKey<MetricKeyType> key = value.getKey();
            MetricHook<?, MetricState<Object>> hook = value.getValue();
            result.add(MetricPair$.MODULE$.make(key, (MetricState)hook.get().apply(), unsafe));
        }
        return result.toSet();
    }

    public <Type extends MetricKeyType> MetricHook<Object, Object> get(MetricKey<Type> key, Unsafe unsafe) {
        MetricHook<Object, Object> hook0 = this.map().get(key);
        if (hook0 == null) {
            MetricKeyType metricKeyType = (MetricKeyType)key.keyType();
            if (MetricKeyType$Counter$.MODULE$.equals(metricKeyType)) {
                return this.getCounter(key, unsafe);
            }
            if (MetricKeyType$Frequency$.MODULE$.equals(metricKeyType)) {
                return this.getSetCount(key, unsafe);
            }
            if (MetricKeyType$Gauge$.MODULE$.equals(metricKeyType)) {
                return this.getGauge(key, unsafe);
            }
            if (metricKeyType instanceof MetricKeyType.Histogram) {
                return this.getHistogram(key, unsafe);
            }
            if (metricKeyType instanceof MetricKeyType.Summary) {
                return this.getSummary(key, unsafe);
            }
            throw new MatchError((Object)metricKeyType);
        }
        return hook0;
    }

    public <Type extends MetricKeyType> boolean remove(MetricKey<Type> key, Unsafe unsafe) {
        return this.map().remove(key) != null;
    }

    public final void addListener(MetricListener listener, Unsafe unsafe) {
        MetricListener[] newListeners;
        MetricListener[] oldListeners;
        do {
            oldListeners = this.listenersRef().get();
            newListeners = (MetricListener[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])oldListeners)).$colon$plus((Object)listener, ClassTag$.MODULE$.apply(MetricListener.class));
        } while (!this.listenersRef().compareAndSet(oldListeners, newListeners));
    }

    public final void removeListener(MetricListener listener, Unsafe unsafe) {
        MetricListener[] newListeners;
        MetricListener[] oldListeners;
        do {
            oldListeners = this.listenersRef().get();
            newListeners = (MetricListener[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])oldListeners)).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ConcurrentMetricRegistry.$anonfun$removeListener$1(listener, x$1)));
        } while (!this.listenersRef().compareAndSet(oldListeners, newListeners));
    }

    /*
     * WARNING - void declaration
     */
    public <T> void notifyListeners(MetricKey<MetricKeyType> key, T value, MetricEventType eventType, Object trace, Unsafe unsafe) {
        MetricListener[] listeners = this.listenersRef().get();
        int len = listeners.length;
        if (len > 0) {
            int i;
            MetricKeyType metricKeyType = key.keyType();
            if (MetricKeyType$Gauge$.MODULE$.equals(metricKeyType)) {
                if (MetricEventType$Modify$.MODULE$.equals(eventType)) {
                    for (i = 0; i < len; ++i) {
                        listeners[i].modifyGauge(key, BoxesRunTime.unboxToDouble(value), unsafe);
                    }
                } else if (MetricEventType$Update$.MODULE$.equals(eventType)) {
                    while (i < len) {
                        listeners[i].updateGauge(key, BoxesRunTime.unboxToDouble(value), unsafe);
                        ++i;
                    }
                } else {
                    throw new MatchError((Object)eventType);
                }
                return;
            }
            if (metricKeyType instanceof MetricKeyType.Histogram) {
                while (i < len) {
                    listeners[i].updateHistogram(key, BoxesRunTime.unboxToDouble(value), unsafe);
                    ++i;
                }
                return;
            }
            if (MetricKeyType$Frequency$.MODULE$.equals(metricKeyType)) {
                while (i < len) {
                    listeners[i].updateFrequency(key, (String)value, unsafe);
                    ++i;
                }
                return;
            }
            if (metricKeyType instanceof MetricKeyType.Summary) {
                while (i < len) {
                    void var13_12;
                    void var11_11;
                    Tuple2 tuple2 = (Tuple2)value;
                    if (tuple2 == null) {
                        throw new MatchError(null);
                    }
                    double v = tuple2._1$mcD$sp();
                    Instant instant = (Instant)tuple2._2();
                    listeners[i].updateSummary(key, (double)var11_11, (Instant)var13_12, unsafe);
                    ++i;
                }
                return;
            }
            if (MetricKeyType$Counter$.MODULE$.equals(metricKeyType)) {
                while (i < len) {
                    listeners[i].updateCounter(key, BoxesRunTime.unboxToDouble(value), unsafe);
                    ++i;
                }
                return;
            }
            throw new MatchError((Object)metricKeyType);
        }
    }

    private MetricHook<Object, MetricState.Counter> getCounter(MetricKey<MetricKeyType$Counter$> key, Unsafe unsafe) {
        MetricHook<?, MetricState<Object>> value = this.map().get(key);
        if (value == null) {
            MetricHook<Object, MetricState.Counter> counter = ConcurrentMetricHooks$.MODULE$.counter(key);
            this.map().putIfAbsent(key, counter);
            value = this.map().get(key);
        }
        return value;
    }

    private MetricHook<Object, MetricState.Gauge> getGauge(MetricKey<MetricKeyType$Gauge$> key, Unsafe unsafe) {
        MetricHook<?, MetricState<Object>> value = this.map().get(key);
        if (value == null) {
            MetricHook<Object, MetricState.Gauge> gauge = ConcurrentMetricHooks$.MODULE$.gauge(key, 0.0);
            this.map().putIfAbsent(key, gauge);
            value = this.map().get(key);
        }
        return value;
    }

    private MetricHook<Object, MetricState.Histogram> getHistogram(MetricKey<MetricKeyType.Histogram> key, Unsafe unsafe) {
        MetricHook<?, MetricState<Object>> value = this.map().get(key);
        if (value == null) {
            MetricHook<Object, MetricState.Histogram> histogram = ConcurrentMetricHooks$.MODULE$.histogram(key);
            this.map().putIfAbsent(key, histogram);
            value = this.map().get(key);
        }
        return value;
    }

    private MetricHook<Tuple2<Object, Instant>, MetricState.Summary> getSummary(MetricKey<MetricKeyType.Summary> key, Unsafe unsafe) {
        MetricHook<?, MetricState<Object>> value = this.map().get(key);
        if (value == null) {
            MetricHook<Tuple2<Object, Instant>, MetricState.Summary> summary = ConcurrentMetricHooks$.MODULE$.summary(key);
            this.map().putIfAbsent(key, summary);
            value = this.map().get(key);
        }
        return value;
    }

    private MetricHook<String, MetricState.Frequency> getSetCount(MetricKey<MetricKeyType$Frequency$> key, Unsafe unsafe) {
        MetricHook<?, MetricState<Object>> value = this.map().get(key);
        if (value == null) {
            MetricHook<String, MetricState.Frequency> frequency = ConcurrentMetricHooks$.MODULE$.frequency(key);
            this.map().putIfAbsent(key, frequency);
            value = this.map().get(key);
        }
        return value;
    }

    public static final /* synthetic */ boolean $anonfun$removeListener$1(MetricListener listener$1, MetricListener x$1) {
        return x$1 != listener$1;
    }
}

