/*
 * Decompiled with CFR 0.152.
 */
package zio.internal;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadLocalRandom;
import scala.Array$;
import scala.Function0;
import scala.Serializable;
import scala.collection.Iterable;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import zio.Chunk;
import zio.Chunk$;
import zio.internal.MutableConcurrentQueue$;

@ScalaSignature(bytes="\u0006\u0001m4Aa\u0004\t\u0007+!A\u0001\u0005\u0001B\u0001B\u0003%\u0011\u0005C\u0003%\u0001\u0011\u0005Q\u0005\u0003\u00042\u0001\u0001\u0006I!\t\u0005\u0007e\u0001\u0001\u000b\u0011B\u0011\t\rM\u0002\u0001\u0015!\u00035\u0011\u0015\t\u0005\u0001\"\u0001C\u0011\u0015\u0019\u0005\u0001\"\u0001C\u0011\u0015!\u0005\u0001\"\u0001F\u0011\u0015!\u0005\u0001\"\u0001Q\u0011\u0015)\u0006\u0001\"\u0001W\u0011\u0015)\u0006\u0001\"\u0001l\u0011\u0015)\b\u0001\"\u0001w\u0011\u0015)\b\u0001\"\u0001y\u0011\u0015I\b\u0001\"\u0001{\u0005Y\u0001\u0016M\u001d;ji&|g.\u001a3MS:\\W\rZ)vKV,'BA\t\u0013\u0003!Ig\u000e^3s]\u0006d'\"A\n\u0002\u0007iLwn\u0001\u0001\u0016\u0005YQ3c\u0001\u0001\u0018;A\u0011\u0001dG\u0007\u00023)\t!$A\u0003tG\u0006d\u0017-\u0003\u0002\u001d3\t1\u0011I\\=SK\u001a\u0004\"\u0001\u0007\u0010\n\u0005}I\"\u0001D*fe&\fG.\u001b>bE2,\u0017a\u00059sK\u001a,'O]3e!\u0006\u0014H/\u001b;j_:\u001c\bC\u0001\r#\u0013\t\u0019\u0013DA\u0002J]R\fa\u0001P5oSRtDC\u0001\u00141!\r9\u0003\u0001K\u0007\u0002!A\u0011\u0011F\u000b\u0007\u0001\t\u0015Y\u0003A1\u0001-\u0005\u0005\t\u0015CA\u0017\u0018!\tAb&\u0003\u000203\t9aj\u001c;iS:<\u0007\"\u0002\u0011\u0003\u0001\u0004\t\u0013\u0001B7bg.\fqA\\)vKV,7/\u0001\u0004rk\u0016,Xm\u001d\t\u00041U:\u0014B\u0001\u001c\u001a\u0005\u0015\t%O]1z!\rAt\bK\u0007\u0002s)\u0011!hO\u0001\u000bG>t7-\u001e:sK:$(B\u0001\u001f>\u0003\u0011)H/\u001b7\u000b\u0003y\nAA[1wC&\u0011\u0001)\u000f\u0002\u0016\u0007>t7-\u001e:sK:$H*\u001b8lK\u0012\fV/Z;f\u0003-q\u0007+\u0019:uSRLwN\\:\u0015\u0003\u0005\nAa]5{K\u0006)qN\u001a4feR\u0019a)S&\u0011\u0005a9\u0015B\u0001%\u001a\u0005\u0011)f.\u001b;\t\u000b)C\u0001\u0019\u0001\u0015\u0002\u0003\u0005DQ\u0001\u0014\u0005A\u00025\u000baA]1oI>l\u0007C\u0001\u001dO\u0013\ty\u0015HA\tUQJ,\u0017\r\u001a'pG\u0006d'+\u00198e_6$\"!\u0015+\u0011\u0005a\u0011\u0016BA*\u001a\u0005\u001d\u0011un\u001c7fC:DQAS\u0005A\u0002!\n\u0001b\u001c4gKJ\fE\u000e\\\u000b\u0003/\u001e$2A\u0012-k\u0011\u0015I&\u00021\u0001[\u0003\t\t7\u000fE\u0002\\G\u001at!\u0001X1\u000f\u0005u\u0003W\"\u00010\u000b\u0005}#\u0012A\u0002\u001fs_>$h(C\u0001\u001b\u0013\t\u0011\u0017$A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0011,'\u0001C%uKJ\f'\r\\3\u000b\u0005\tL\u0002CA\u0015h\t\u0015A'B1\u0001j\u0005\t\t\u0015'\u0005\u0002.Q!)AJ\u0003a\u0001\u001bV\u0011AN\u001d\u000b\u0003[N\u00042A\\8r\u001b\u0005\u0011\u0012B\u00019\u0013\u0005\u0015\u0019\u0005.\u001e8l!\tI#\u000fB\u0003i\u0017\t\u0007\u0011\u000eC\u0003Z\u0017\u0001\u0007A\u000fE\u0002\\GF\fA\u0001]8mYR\u0011\u0001f\u001e\u0005\u0006\u00192\u0001\r!\u0014\u000b\u0002Q\u00059\u0011n]#naRLH#A)")
public final class PartitionedLinkedQueue<A>
implements Serializable {
    private final int mask;
    private final int nQueues;
    private final ConcurrentLinkedQueue<A>[] queues;

    public int nPartitions() {
        return this.nQueues;
    }

    public int size() {
        int from = ThreadLocalRandom.current().nextInt(this.nQueues);
        int size = 0;
        for (int i = 0; i < this.nQueues; ++i) {
            int idx = from + i & this.mask;
            size += this.queues[idx].size();
        }
        return size;
    }

    public void offer(A a, ThreadLocalRandom random) {
        int idx = random.nextInt(this.nQueues);
        this.queues[idx].offer(a);
    }

    public boolean offer(A a) {
        this.offer(a, ThreadLocalRandom.current());
        return true;
    }

    public <A1 extends A> void offerAll(Iterable<A1> as, ThreadLocalRandom random) {
        int from = random.nextInt(this.nQueues);
        int i = 0;
        for (Object value : as) {
            int idx = from + i & this.mask;
            this.queues[idx].offer(value);
            ++i;
        }
    }

    public <A1 extends A> Chunk<A1> offerAll(Iterable<A1> as) {
        this.offerAll(as, ThreadLocalRandom.current());
        return Chunk$.MODULE$.empty();
    }

    public A poll(ThreadLocalRandom random) {
        int from = random.nextInt(this.nQueues);
        A result = null;
        for (int i = 0; result == null && i < this.nQueues; ++i) {
            int idx = from + i & this.mask;
            result = this.queues[idx].poll();
        }
        return result;
    }

    public A poll() {
        return this.poll(ThreadLocalRandom.current());
    }

    public boolean isEmpty() {
        int from = ThreadLocalRandom.current().nextInt(this.nQueues);
        boolean result = true;
        for (int i = 0; result && i < this.nQueues; ++i) {
            int idx = from + i & this.mask;
            result = this.queues[idx].isEmpty();
        }
        return result;
    }

    public PartitionedLinkedQueue(int preferredPartitions) {
        this.mask = MutableConcurrentQueue$.MODULE$.roundToPow2MinusOne(preferredPartitions);
        this.nQueues = this.mask + 1;
        this.queues = (ConcurrentLinkedQueue[])Array$.MODULE$.fill(this.nQueues, (Function0 & java.io.Serializable & Serializable)() -> new ConcurrentLinkedQueue(), ClassTag$.MODULE$.apply(ConcurrentLinkedQueue.class));
    }
}

