/*
 * Decompiled with CFR 0.152.
 */
package zio.internal;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.function.Consumer;
import java.util.logging.Logger;
import scala.runtime.BoxedUnit;
import zio.internal.Signal;

public final class Signal$ {
    public static final Signal$ MODULE$;
    private static final Signal.SignalHandler signalHandler;

    static {
        Signal.SignalHandler signalHandler;
        MODULE$ = new Signal$();
        Logger logger = Logger.getLogger("zio.internal.Signal");
        Class<?> signalClass = MODULE$.findClass("sun.misc.Signal");
        Class<?> signalHandlerClass = MODULE$.findClass("sun.misc.SignalHandler");
        MethodHandle constructorHandle = null;
        MethodHandle staticMethodHandle = null;
        if (signalClass != null && signalHandlerClass != null) {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            constructorHandle = MODULE$.initSignalConstructorMethodHandle(lookup, signalClass);
            staticMethodHandle = MODULE$.initHandleStaticMethodHandle(lookup, signalClass, signalHandlerClass);
        }
        if (signalHandlerClass != null && constructorHandle != null && staticMethodHandle != null) {
            signalHandler = new Signal.SignalHandler.SunMiscSignalHandler(signalHandlerClass, constructorHandle, staticMethodHandle);
        } else {
            logger.warning("sun.misc.Signal and sun.misc.SignalHandler are not available on this platform. Defaulting to no-op signal handling implementation; ZIO fiber dump functionality might not work as expected.");
            signalHandler = new Signal.SignalHandler.NoOpSignalHandler();
        }
        Signal$.signalHandler = signalHandler;
    }

    private Signal.SignalHandler signalHandler() {
        return signalHandler;
    }

    public void handle(String signal, Consumer<Object> handler) {
        this.signalHandler().handle(signal, handler);
    }

    private Class<?> findClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private MethodHandle initSignalConstructorMethodHandle(MethodHandles.Lookup lookup, Class<?> signalClass) {
        MethodType signalConstructorMethodType = MethodType.methodType(BoxedUnit.TYPE, String.class);
        try {
            return lookup.findConstructor(signalClass, signalConstructorMethodType);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private MethodHandle initHandleStaticMethodHandle(MethodHandles.Lookup lookup, Class<?> signalClass, Class<?> signalHandlerClass) {
        try {
            MethodType handleStaticMethodType = MethodType.methodType(signalHandlerClass, signalClass, signalHandlerClass);
            return lookup.findStatic(signalClass, "handle", handleStaticMethodType);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Signal$() {
    }
}

