/*
 * Decompiled with CFR 0.152.
 */
package zio.internal;

import java.io.Serializable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import scala.collection.Iterable;
import scala.collection.JavaConverters;
import scala.reflect.ScalaSignature;
import zio.Chunk;
import zio.Chunk$Empty$;
import zio.internal.MutableConcurrentQueue;

@ScalaSignature(bytes="\u0006\u0005\u0005ub!\u0002\f\u0018\u0005eY\u0002\u0002\u0003\u001f\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\t\u000b\u0001\u0003A\u0011B!\t\u000b\u0001\u0003A\u0011\u0001#\t\u000f\u0015\u0003!\u0019!C#\r\"1\u0011\n\u0001Q\u0001\u000e\u001dCaA\u0013\u0001!\u0002\u0013Y\u0005BB+\u0001A\u0003%a\u000b\u0003\u0004]\u0001\u0001\u0006IA\u0016\u0005\u0006;\u0002!\tE\u0018\u0005\u0006E\u0002!\te\u0019\u0005\u0006O\u0002!\te\u0019\u0005\u0006Q\u0002!\t%\u001b\u0005\u0006Y\u0002!\t%\u001c\u0005\u0006y\u0002!\t% \u0005\b\u0003\u0003\u0001A\u0011IA\u0002\u0011\u001d\t)\u0001\u0001C!\u0003\u00079q!a\u0002\u0018\u0011\u0003\tIA\u0002\u0004\u0017/!\u0005\u00111\u0002\u0005\u0007\u0001J!\t!!\b\t\u000f\u0005}!\u0003\"\u0001\u0002\"!I\u0011Q\u0006\n\u0002\u0002\u0013%\u0011q\u0006\u0002\f\u0019&t7.\u001a3Rk\u0016,XM\u0003\u0002\u00193\u0005A\u0011N\u001c;fe:\fGNC\u0001\u001b\u0003\rQ\u0018n\\\u000b\u00039\r\u001a2\u0001A\u000f1!\rqr$I\u0007\u0002/%\u0011\u0001e\u0006\u0002\u0017\u001bV$\u0018M\u00197f\u0007>t7-\u001e:sK:$\u0018+^3vKB\u0011!e\t\u0007\u0001\t\u0015!\u0003A1\u0001'\u0005\u0005\t5\u0001A\t\u0003O5\u0002\"\u0001K\u0016\u000e\u0003%R\u0011AK\u0001\u0006g\u000e\fG.Y\u0005\u0003Y%\u0012qAT8uQ&tw\r\u0005\u0002)]%\u0011q&\u000b\u0002\u0004\u0003:L\bCA\u0019:\u001d\t\u0011tG\u0004\u00024m5\tAG\u0003\u00026K\u00051AH]8pizJ\u0011AK\u0005\u0003q%\nq\u0001]1dW\u0006<W-\u0003\u0002;w\ta1+\u001a:jC2L'0\u00192mK*\u0011\u0001(K\u0001\u000bC\u0012$W*\u001a;sS\u000e\u001c\bC\u0001\u0015?\u0013\ty\u0014FA\u0004C_>dW-\u00198\u0002\rqJg.\u001b;?)\t\u00115\tE\u0002\u001f\u0001\u0005BQ\u0001\u0010\u0002A\u0002u\"\u0012AQ\u0001\tG\u0006\u0004\u0018mY5usV\tqiD\u0001I;\u0011yx\u0000\u0000\u0000\u0002\u0013\r\f\u0007/Y2jif\u0004\u0013A\u00056vG\u000e{gnY;se\u0016tG/U;fk\u0016\u00042\u0001T*\"\u001b\u0005i%B\u0001(P\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003!F\u000bA!\u001e;jY*\t!+\u0001\u0003kCZ\f\u0017B\u0001+N\u0005U\u0019uN\\2veJ,g\u000e\u001e'j].,G-U;fk\u0016\fq\"\u001a8rk\u0016,X\rZ\"pk:$XM\u001d\t\u0003/jk\u0011\u0001\u0017\u0006\u000336\u000ba!\u0019;p[&\u001c\u0017BA.Y\u0005)\tEo\\7jG2{gnZ\u0001\u0010I\u0016\fX/Z;fI\u000e{WO\u001c;fe\u0006!1/\u001b>f)\u0005y\u0006C\u0001\u0015a\u0013\t\t\u0017FA\u0002J]R\fQ\"\u001a8rk\u0016,X\rZ\"pk:$H#\u00013\u0011\u0005!*\u0017B\u00014*\u0005\u0011auN\\4\u0002\u001b\u0011,\u0017/^3vK\u0012\u001cu.\u001e8u\u0003\u0015ygMZ3s)\ti$\u000eC\u0003l\u0019\u0001\u0007\u0011%A\u0001b\u0003!ygMZ3s\u00032dWC\u00018u)\tyw\u000fE\u0002qcNl\u0011!G\u0005\u0003ef\u0011Qa\u00115v].\u0004\"A\t;\u0005\u000bUl!\u0019\u0001<\u0003\u0005\u0005\u000b\u0014CA\u0014\"\u0011\u0015AX\u00021\u0001z\u0003\t\t7\u000fE\u00022uNL!a_\u001e\u0003\u0011%#XM]1cY\u0016\fA\u0001]8mYR\u0011\u0011E \u0005\u0006\u007f:\u0001\r!I\u0001\bI\u00164\u0017-\u001e7u\u0003\u001dI7/R7qif$\u0012!P\u0001\u0007SN4U\u000f\u001c7\u0002\u00171Kgn[3e#V,W/\u001a\t\u0003=I\u0019RAEA\u0007\u0003'\u00012\u0001KA\b\u0013\r\t\t\"\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\t\u0005U\u00111D\u0007\u0003\u0003/Q1!!\u0007R\u0003\tIw.C\u0002;\u0003/!\"!!\u0003\u0002\u000b\u0005\u0004\b\u000f\\=\u0016\t\u0005\r\u0012\u0011\u0006\u000b\u0005\u0003K\tY\u0003\u0005\u0003\u001f\u0001\u0005\u001d\u0002c\u0001\u0012\u0002*\u0011)A\u0005\u0006b\u0001M!)A\b\u0006a\u0001{\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011\u0011\u0007\t\u0005\u0003g\tI$\u0004\u0002\u00026)\u0019\u0011qG)\u0002\t1\fgnZ\u0005\u0005\u0003w\t)D\u0001\u0004PE*,7\r\u001e")
public final class LinkedQueue<A>
extends MutableConcurrentQueue<A>
implements Serializable {
    private final ConcurrentLinkedQueue<A> jucConcurrentQueue = new ConcurrentLinkedQueue();
    private final AtomicLong enqueuedCounter;
    private final AtomicLong dequeuedCounter;

    public static <A> LinkedQueue<A> apply(boolean addMetrics) {
        return new LinkedQueue<A>(addMetrics);
    }

    @Override
    public final int capacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int size() {
        return this.jucConcurrentQueue.size();
    }

    @Override
    public long enqueuedCount() {
        if (this.enqueuedCounter != null) {
            return this.enqueuedCounter.get();
        }
        return 0L;
    }

    @Override
    public long dequeuedCount() {
        if (this.dequeuedCounter != null) {
            return this.dequeuedCounter.get();
        }
        return 0L;
    }

    @Override
    public boolean offer(A a) {
        boolean success = this.jucConcurrentQueue.offer(a);
        if (this.enqueuedCounter != null && success) {
            this.enqueuedCounter.incrementAndGet();
        }
        return success;
    }

    @Override
    public <A1 extends A> Chunk<A1> offerAll(Iterable<A1> as) {
        this.jucConcurrentQueue.addAll(new JavaConverters.AsJavaCollection(as).asJavaCollection());
        if (this.enqueuedCounter != null) {
            this.enqueuedCounter.addAndGet(as.size());
        }
        return Chunk$Empty$.MODULE$;
    }

    @Override
    public A poll(A a) {
        A polled = this.jucConcurrentQueue.poll();
        if (polled != null) {
            if (this.dequeuedCounter != null) {
                this.dequeuedCounter.incrementAndGet();
            }
            return polled;
        }
        return a;
    }

    @Override
    public boolean isEmpty() {
        return this.jucConcurrentQueue.isEmpty();
    }

    @Override
    public boolean isFull() {
        return false;
    }

    public LinkedQueue(boolean addMetrics) {
        this.enqueuedCounter = addMetrics ? new AtomicLong(0L) : null;
        this.dequeuedCounter = addMetrics ? new AtomicLong(0L) : null;
    }

    public LinkedQueue() {
        this(true);
    }
}

