/*
 * Decompiled with CFR 0.152.
 */
package zio.internal;

import java.io.Serializable;
import scala.Function0;
import scala.MatchError;
import scala.collection.StringOps$;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import zio.Fiber;
import zio.Fiber$Status$Done$;
import zio.FiberId;
import zio.FiberId$None$;
import zio.RuntimeFlags$;
import zio.Trace$;
import zio.ZIO;

public final class FiberRenderer$ {
    public static final FiberRenderer$ MODULE$ = new FiberRenderer$();

    public ZIO<Object, Nothing$, String> prettyPrint(Fiber.Dump dump, Object trace) {
        Function0 & Serializable succeed_a = (Function0 & Serializable)() -> MODULE$.unsafePrettyPrint(dump, System.currentTimeMillis());
        return new ZIO.Sync<String>(trace, succeed_a);
    }

    /*
     * WARNING - void declaration
     */
    private String unsafePrettyPrint(Fiber.Dump dump, long now) {
        Object object;
        long totalMillis = now - dump.fiberId().startTimeMillis();
        long millis = totalMillis % 1000L;
        long seconds = totalMillis / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        FiberId.Runtime runtime = dump.fiberId();
        if (runtime == null) {
            throw null;
        }
        String name = "\"" + FiberId.threadName$(runtime) + "\"";
        String lifeMsg = (String)(hours == 0L ? "" : hours + "h ") + (hours == 0L && minutes == 0L ? "" : minutes + "m ") + (hours == 0L && minutes == 0L && seconds == 0L ? "" : seconds + "s ") + millis + "ms";
        Fiber.Status status = dump.status();
        if (status instanceof Fiber.Status.Suspended) {
            FiberId blockingOn = ((Fiber.Status.Suspended)status).blockingOn();
            if (blockingOn != FiberId$None$.MODULE$) {
                void mkString_sep;
                Set<Object> set = blockingOn.ids();
                String string = ", ";
                if (set == null) {
                    throw null;
                }
                string = null;
                object = "waiting on #" + set.mkString("", (String)mkString_sep, "");
            } else {
                object = "";
            }
        } else {
            object = "";
        }
        String waitMsg = object;
        String statMsg = this.renderStatus(dump.status());
        return StringOps$.MODULE$.stripMargin$extension("\n       |" + name + " (" + lifeMsg + ") " + waitMsg + "\n       |\tStatus: " + statMsg + "\n       |" + dump.trace().prettyPrint() + "\n       |", '|');
    }

    private String renderFlags(int runtimeFlags) {
        return RuntimeFlags$.MODULE$.toSet(runtimeFlags).mkString("(", ", ", ")");
    }

    private String renderTrace(Object trace) {
        if (BoxesRunTime.equals((Object)trace, (Object)Trace$.MODULE$.empty())) {
            return "<no trace>";
        }
        return trace.toString();
    }

    private String renderStatus(Fiber.Status status) {
        if (Fiber$Status$Done$.MODULE$.equals(status)) {
            return "Done";
        }
        if (status instanceof Fiber.Status.Running) {
            Fiber.Status.Running running = (Fiber.Status.Running)status;
            int runtimeFlags = running.runtimeFlags();
            Object trace0 = running.trace();
            String flags = this.renderFlags(runtimeFlags);
            String trace = this.renderTrace(trace0);
            return "Running(" + flags + ", " + trace + ")";
        }
        if (status instanceof Fiber.Status.Suspended) {
            Fiber.Status.Suspended suspended = (Fiber.Status.Suspended)status;
            int runtimeFlags = suspended.runtimeFlags();
            Object trace0 = suspended.trace();
            String flags = this.renderFlags(runtimeFlags);
            String trace = this.renderTrace(trace0);
            return "Suspended(" + flags + ", " + trace + ")";
        }
        throw new MatchError((Object)status);
    }

    private FiberRenderer$() {
    }
}

