/*
 * Decompiled with CFR 0.152.
 */
package zio.internal;

import java.io.Serializable;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import zio.Fiber;
import zio.Fiber$Status$Done$;
import zio.FiberId;
import zio.FiberId$None$;
import zio.RuntimeFlags$;
import zio.Trace$;
import zio.ZIO;
import zio.ZIO$;

public final class FiberRenderer$ {
    public static final FiberRenderer$ MODULE$ = new FiberRenderer$();

    public ZIO<Object, Nothing$, String> prettyPrint(Fiber.Dump dump, Object trace) {
        return ZIO$.MODULE$.succeed((Function0 & Serializable)() -> MODULE$.unsafePrettyPrint(dump, System.currentTimeMillis()), trace);
    }

    private String unsafePrettyPrint(Fiber.Dump dump, long now) {
        FiberId blockingOn;
        long totalMillis = now - dump.fiberId().startTimeMillis();
        long millis = totalMillis % 1000L;
        long seconds = totalMillis / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        String name = new StringBuilder(2).append("\"").append(dump.fiberId().threadName()).append("\"").toString();
        String lifeMsg = new StringBuilder(2).append(hours == 0L ? "" : new StringBuilder(2).append(hours).append("h ").toString()).append((Object)(hours == 0L && minutes == 0L ? "" : new StringBuilder(2).append(minutes).append("m ").toString())).append((Object)(hours == 0L && minutes == 0L && seconds == 0L ? "" : new StringBuilder(2).append(seconds).append("s ").toString())).append(millis).append("ms").toString();
        Fiber.Status status = dump.status();
        String waitMsg = status instanceof Fiber.Status.Suspended ? ((blockingOn = ((Fiber.Status.Suspended)status).blockingOn()) != FiberId$None$.MODULE$ ? new StringBuilder(12).append("waiting on ").append("#").append(blockingOn.ids().mkString(", ")).toString() : "") : "";
        String statMsg = this.renderStatus(dump.status());
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(49).append("\n       |").append(name).append(" (").append(lifeMsg).append(") ").append(waitMsg).append("\n       |\tStatus: ").append(statMsg).append("\n       |").append(dump.trace().prettyPrint()).append("\n       |").toString()));
    }

    private String renderFlags(int runtimeFlags) {
        return RuntimeFlags$.MODULE$.toSet(runtimeFlags).mkString("(", ", ", ")");
    }

    private String renderTrace(Object trace) {
        if (BoxesRunTime.equals((Object)trace, (Object)Trace$.MODULE$.empty())) {
            return "<no trace>";
        }
        return trace.toString();
    }

    private String renderStatus(Fiber.Status status) {
        if (Fiber$Status$Done$.MODULE$.equals(status)) {
            return "Done";
        }
        if (status instanceof Fiber.Status.Running) {
            Fiber.Status.Running running = (Fiber.Status.Running)status;
            int runtimeFlags = running.runtimeFlags();
            Object trace0 = running.trace();
            String flags = this.renderFlags(runtimeFlags);
            String trace = this.renderTrace(trace0);
            return new StringBuilder(11).append("Running(").append(flags).append(", ").append(trace).append(")").toString();
        }
        if (status instanceof Fiber.Status.Suspended) {
            Fiber.Status.Suspended suspended = (Fiber.Status.Suspended)status;
            int runtimeFlags = suspended.runtimeFlags();
            Object trace0 = suspended.trace();
            String flags = this.renderFlags(runtimeFlags);
            String trace = this.renderTrace(trace0);
            return new StringBuilder(13).append("Suspended(").append(flags).append(", ").append(trace).append(")").toString();
        }
        throw new MatchError((Object)status);
    }

    private FiberRenderer$() {
    }
}

