/*
 * Decompiled with CFR 0.152.
 */
package zio.internal;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import zio.Chunk;
import zio.Chunk$;
import zio.ChunkBuilder;
import zio.ChunkBuilder$;
import zio.internal.HeadPadding;
import zio.internal.MutableQueueFieldsPadding;
import zio.internal.RingBuffer$;
import zio.internal.TailPadding;

@ScalaSignature(bytes="\u0006\u0005\u0005%vAB\u0011#\u0011\u0003!cE\u0002\u0004)E!\u0005A%\u000b\u0005\u0006q\u0005!\tA\u000f\u0005\u0006w\u0005!)\u0001\u0010\u0005\b\u0003W\nAQAA7\u0011%\t\t(\u0001b\u0001\n\u001b\t\u0019\b\u0003\u0005\u0002z\u0005\u0001\u000bQBA;\u0011%\tY(\u0001b\u0001\n\u001b\ti\b\u0003\u0005\u0002\u0004\u0006\u0001\u000bQBA@\u0011%\t))\u0001b\u0001\n\u001b\t9\t\u0003\u0005\u0002\u000e\u0006\u0001\u000bQBAE\u0011%\ty)\u0001b\u0001\n\u001b\t\t\n\u0003\u0005\u0002\u0018\u0006\u0001\u000bQBAJ\u0011%\tI*AA\u0001\n\u0013\tYJ\u0002\u0004)E\u0005\u0005Ae\u0010\u0005\t5:\u0011)\u0019!C#7\"AqL\u0004B\u0001B\u00035A\fC\u00039\u001d\u0011\u0005\u0001\rC\u0004d\u001d\t\u0007I\u0011\u00023\t\r!t\u0001\u0015!\u0003f\u0011\u001dIgB1A\u0005\n)Da!\u001e\b!\u0002\u0013Y\u0007\"\u0002<\u000f\r#9\b\"\u0002@\u000f\t\u000bz\bbBA\u0001\u001d\u0011\u0015\u00131\u0001\u0005\b\u0003\u000bqAQIA\u0002\u0011\u001d\t9A\u0004C#\u0003\u0013Aq!!\u0006\u000f\t\u000b\n9\u0002C\u0004\u0002\u00169!)!!\u000e\t\u000f\u0005-c\u0002\"\u0012\u0002N!9\u00111\u000b\b\u0005F\u0005U\u0003bBA/\u001d\u0011\u0015\u0013q\f\u0005\b\u0003CrAQIA0\u0003)\u0011\u0016N\\4Ck\u001a4WM\u001d\u0006\u0003G\u0011\n\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0002K\u0005\u0019!0[8\u0011\u0005\u001d\nQ\"\u0001\u0012\u0003\u0015IKgn\u001a\"vM\u001a,'oE\u0002\u0002UA\u0002\"a\u000b\u0018\u000e\u00031R\u0011!L\u0001\u0006g\u000e\fG.Y\u0005\u0003_1\u0012a!\u00118z%\u00164\u0007CA\u00197\u001b\u0005\u0011$BA\u001a5\u0003\tIwNC\u00016\u0003\u0011Q\u0017M^1\n\u0005]\u0012$\u0001D*fe&\fG.\u001b>bE2,\u0017A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003\u0019\nQ!\u00199qYf,2!PA3)\rq\u0014q\r\t\u0005O9\t\u0019'\u0006\u0002A\rN\u0019a\"Q(\u0011\u0007\u001d\u0012E)\u0003\u0002DE\tIR*\u001e;bE2,\u0017+^3vK\u001aKW\r\u001c3t!\u0006$G-\u001b8h!\t)e\t\u0004\u0001\u0005\u000b\u001ds!\u0019\u0001%\u0003\u0003\u0005\u000b\"!\u0013'\u0011\u0005-R\u0015BA&-\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"aK'\n\u00059c#aA!osB\u0011\u0001\u000b\u0017\b\u0003#Zs!AU+\u000e\u0003MS!\u0001V\u001d\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0013BA,-\u0003\u001d\u0001\u0018mY6bO\u0016L!aN-\u000b\u0005]c\u0013\u0001C2ba\u0006\u001c\u0017\u000e^=\u0016\u0003q\u0003\"aK/\n\u0005yc#aA%oi\u0006I1-\u00199bG&$\u0018\u0010\t\u000b\u0003C\n\u00042a\n\bE\u0011\u0015Q\u0016\u00031\u0001]\u0003\r\u0011WOZ\u000b\u0002KB\u00191F\u001a\u0016\n\u0005\u001dd#!B!se\u0006L\u0018\u0001\u00022vM\u0002\n1a]3r+\u0005Y\u0007C\u00017t\u001b\u0005i'B\u00018p\u0003\u0019\tGo\\7jG*\u0011\u0001/]\u0001\u000bG>t7-\u001e:sK:$(B\u0001:5\u0003\u0011)H/\u001b7\n\u0005Ql'aD!u_6L7\rT8oO\u0006\u0013(/Y=\u0002\tM,\u0017\u000fI\u0001\ta>\u001cHk\\%eqR\u0019A\f_?\t\u000be4\u0002\u0019\u0001>\u0002\u0007A|7\u000f\u0005\u0002,w&\u0011A\u0010\f\u0002\u0005\u0019>tw\rC\u0003[-\u0001\u0007A,\u0001\u0003tSj,G#\u0001/\u0002\u001b\u0015t\u0017/^3vK\u0012\u001cu.\u001e8u)\u0005Q\u0018!\u00043fcV,W/\u001a3D_VtG/A\u0003pM\u001a,'\u000f\u0006\u0003\u0002\f\u0005E\u0001cA\u0016\u0002\u000e%\u0019\u0011q\u0002\u0017\u0003\u000f\t{w\u000e\\3b]\"1\u00111\u0003\u000eA\u0002\u0011\u000b\u0011!Y\u0001\t_\u001a4WM]!mYV!\u0011\u0011DA\u0013)\u0011\tY\"a\u000b\u0011\r\u0005u\u0011qDA\u0012\u001b\u0005!\u0013bAA\u0011I\t)1\t[;oWB\u0019Q)!\n\u0005\u000f\u0005\u001d2D1\u0001\u0002*\t\u0011\u0011)M\t\u0003\u0013\u0012Cq!!\f\u001c\u0001\u0004\ty#\u0001\u0002bgB)\u0001+!\r\u0002$%\u0019\u00111G-\u0003\u0011%#XM]1cY\u0016,B!a\u000e\u0002>Q1\u0011\u0011HA \u0003\u000f\u0002b!!\b\u0002 \u0005m\u0002cA#\u0002>\u00119\u0011q\u0005\u000fC\u0002\u0005%\u0002bBA\u00179\u0001\u0007\u0011\u0011\t\t\u0006!\u0006\r\u00131H\u0005\u0004\u0003\u000bJ&\u0001C%uKJ\fGo\u001c:\t\r\u0005%C\u00041\u0001{\u0003\u0019ygMZ3sg\u0006!\u0001o\u001c7m)\r!\u0015q\n\u0005\u0007\u0003#j\u0002\u0019\u0001#\u0002\u000f\u0011,g-Y;mi\u0006A\u0001o\u001c7m+B$v\u000e\u0006\u0003\u0002X\u0005e\u0003#BA\u000f\u0003?!\u0005BBA.=\u0001\u0007A,A\u0001o\u0003\u001dI7/R7qif$\"!a\u0003\u0002\r%\u001ch)\u001e7m!\r)\u0015Q\r\u0003\u0006\u000f\u000e\u0011\r\u0001\u0013\u0005\u0007\u0003S\u001a\u0001\u0019\u0001/\u0002#I,\u0017/^3ti\u0016$7)\u00199bG&$\u00180\u0001\u0005oKb$\bk\\<3)\ra\u0016q\u000e\u0005\u0007\u00037\"\u0001\u0019\u0001/\u0002\u0015M#\u0016\tV#`\u0019>{\u0005+\u0006\u0002\u0002v=\u0011\u0011qO\u000f\u0002\u0001\u0005Y1\u000bV!U\u000b~cuj\u0014)!\u0003-\u0019F+\u0011+F?\u0016k\u0005\u000bV-\u0016\u0005\u0005}tBAAA;\u0005y \u0001D*U\u0003R+u,R'Q)f\u0003\u0013AC*U\u0003R+uLR+M\u0019V\u0011\u0011\u0011R\b\u0003\u0003\u0017k\u0012A\u0000\u0001\f'R\u000bE+R0G+2c\u0005%\u0001\bT)\u0006#Vi\u0018*F'\u0016\u0013f+\u0012#\u0016\u0005\u0005MuBAAK;\u0005\t\u0011aD*U\u0003R+uLU#T\u000bJ3V\t\u0012\u0011\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u0005u\u0005\u0003BAP\u0003Kk!!!)\u000b\u0007\u0005\rF'\u0001\u0003mC:<\u0017\u0002BAT\u0003C\u0013aa\u00142kK\u000e$\b")
public abstract class RingBuffer<A>
extends MutableQueueFieldsPadding<A> {
    private final int capacity;
    private final Object[] buf;
    private final AtomicLongArray seq;

    public static int nextPow2(int n) {
        return RingBuffer$.MODULE$.nextPow2(n);
    }

    public static <A> RingBuffer<A> apply(int requestedCapacity) {
        return RingBuffer$.MODULE$.apply(requestedCapacity);
    }

    @Override
    public final int capacity() {
        return this.capacity;
    }

    private Object[] buf() {
        return this.buf;
    }

    private AtomicLongArray seq() {
        return this.seq;
    }

    public abstract int posToIdx(long var1, int var3);

    @Override
    public final int size() {
        return (int)(MutableQueueFieldsPadding.tailUpdater.get(this) - MutableQueueFieldsPadding.headUpdater.get(this));
    }

    @Override
    public final long enqueuedCount() {
        return MutableQueueFieldsPadding.tailUpdater.get(this);
    }

    @Override
    public final long dequeuedCount() {
        return MutableQueueFieldsPadding.headUpdater.get(this);
    }

    @Override
    public final boolean offer(A a) {
        int aCapacity = this.capacity();
        AtomicLongArray aSeq = this.seq();
        AtomicLongFieldUpdater<HeadPadding> aHead = MutableQueueFieldsPadding.headUpdater;
        AtomicLongFieldUpdater<TailPadding> aTail = MutableQueueFieldsPadding.tailUpdater;
        long curTail = aTail.get(this);
        int curIdx = 0;
        int state = 0;
        while (state == 0) {
            curIdx = this.posToIdx(curTail, aCapacity);
            long curSeq = aSeq.get(curIdx);
            if (curSeq < curTail) {
                long curHead = aHead.get(this);
                if (curTail >= curHead + (long)aCapacity) {
                    state = -2;
                    continue;
                }
                state = 0;
                continue;
            }
            if (curSeq == curTail) {
                if (aTail.compareAndSet(this, curTail, curTail + 1L)) {
                    state = 1;
                    continue;
                }
                ++curTail;
                state = 0;
                continue;
            }
            curTail = aTail.get(this);
            state = 0;
        }
        if (state == 1) {
            this.buf()[curIdx] = a;
            aSeq.lazySet(curIdx, curTail + 1L);
            return true;
        }
        return false;
    }

    @Override
    public final <A1 extends A> Chunk<A1> offerAll(Iterable<A1> as) {
        return this.offerAll(as.iterator(), as.size());
    }

    public final <A1 extends A> Chunk<A1> offerAll(Iterator<A1> as, long offers) {
        int curIdx;
        int aCapacity = this.capacity();
        AtomicLongArray aSeq = this.seq();
        AtomicLongFieldUpdater<HeadPadding> aHead = MutableQueueFieldsPadding.headUpdater;
        AtomicLongFieldUpdater<TailPadding> aTail = MutableQueueFieldsPadding.tailUpdater;
        long enqHead = 0L;
        long enqTail = 0L;
        int state = 0;
        while (state == 0) {
            long curHead = aHead.get(this);
            long curTail = aTail.get(this);
            long size = curTail - curHead;
            long available = (long)aCapacity - size;
            long forQueue = package$.MODULE$.min(offers, available);
            if (forQueue == 0L) {
                state = -2;
                continue;
            }
            enqHead = curTail;
            enqTail = curTail + forQueue;
            boolean bl = true;
            while (bl & enqHead < enqTail) {
                curIdx = this.posToIdx(enqHead, aCapacity);
                if (aSeq.get(curIdx) != enqHead) {
                    bl = false;
                }
                ++enqHead;
            }
            if (bl && aTail.compareAndSet(this, curTail, enqTail)) {
                enqHead = curTail;
                state = 1;
                continue;
            }
            state = 0;
        }
        if (state == 1) {
            while (enqHead < enqTail) {
                Object a = as.next();
                curIdx = this.posToIdx(enqHead, aCapacity);
                this.buf()[curIdx] = a;
                aSeq.lazySet(curIdx, enqHead + 1L);
                ++enqHead;
            }
        }
        return Chunk$.MODULE$.fromIterator(as);
    }

    @Override
    public final A poll(A a) {
        int aCapacity = this.capacity();
        Object[] aBuf = this.buf();
        AtomicLongArray aSeq = this.seq();
        AtomicLongFieldUpdater<HeadPadding> aHead = MutableQueueFieldsPadding.headUpdater;
        long curHead = aHead.get(this);
        int curIdx = 0;
        AtomicLongFieldUpdater<TailPadding> aTail = MutableQueueFieldsPadding.tailUpdater;
        int state = 0;
        while (state == 0) {
            curIdx = this.posToIdx(curHead, aCapacity);
            long curSeq = aSeq.get(curIdx);
            if (curSeq <= curHead) {
                long curTail = aTail.get(this);
                if (curHead >= curTail) {
                    state = -1;
                    continue;
                }
                state = 0;
                continue;
            }
            if (curSeq == curHead + 1L) {
                if (aHead.compareAndSet(this, curHead, curHead + 1L)) {
                    state = 1;
                    continue;
                }
                ++curHead;
                state = 0;
                continue;
            }
            curHead = aHead.get(this);
            state = 0;
        }
        if (state == 1) {
            Object deqElement = aBuf[curIdx];
            aBuf[curIdx] = null;
            aSeq.lazySet(curIdx, curHead + (long)aCapacity);
            return (A)deqElement;
        }
        return a;
    }

    @Override
    public final Chunk<A> pollUpTo(int n) {
        int curIdx;
        int aCapacity = this.capacity();
        AtomicLongArray aSeq = this.seq();
        AtomicLongFieldUpdater<HeadPadding> aHead = MutableQueueFieldsPadding.headUpdater;
        AtomicLongFieldUpdater<TailPadding> aTail = MutableQueueFieldsPadding.tailUpdater;
        long takers = n;
        long deqHead = 0L;
        long deqTail = 0L;
        int state = 0;
        while (state == 0) {
            long curHead = aHead.get(this);
            long size = aTail.get(this) - curHead;
            long toTake = package$.MODULE$.min(takers, size);
            if (toTake <= 0L) {
                state = -1;
                continue;
            }
            deqTail = curHead + toTake;
            boolean bl = true;
            for (deqHead = curHead; bl && deqHead < deqTail; ++deqHead) {
                curIdx = this.posToIdx(deqHead, aCapacity);
                if (aSeq.get(curIdx) == deqHead + 1L) continue;
                bl = false;
            }
            if (bl && aHead.compareAndSet(this, curHead, deqTail)) {
                deqHead = curHead;
                state = 1;
                continue;
            }
            state = 0;
        }
        if (state == 1) {
            ChunkBuilder builder = ChunkBuilder$.MODULE$.make((int)(deqTail - deqHead));
            while (deqHead < deqTail) {
                curIdx = this.posToIdx(deqHead, aCapacity);
                Object a = this.buf()[curIdx];
                this.buf()[curIdx] = null;
                aSeq.lazySet(curIdx, deqHead + (long)aCapacity);
                builder.addOne(a);
                ++deqHead;
            }
            return (Chunk)builder.result();
        }
        return Chunk$.MODULE$.empty();
    }

    @Override
    public final boolean isEmpty() {
        return MutableQueueFieldsPadding.tailUpdater.get(this) == MutableQueueFieldsPadding.headUpdater.get(this);
    }

    @Override
    public final boolean isFull() {
        return MutableQueueFieldsPadding.tailUpdater.get(this) == MutableQueueFieldsPadding.headUpdater.get(this) + (long)this.capacity();
    }

    public RingBuffer(int capacity) {
        this.capacity = capacity;
        this.buf = new Object[capacity];
        this.seq = new AtomicLongArray(capacity);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), capacity).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.seq().set(i, i));
    }
}

