/*
 * Decompiled with CFR 0.152.
 */
package zio.internal;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import zio.Fiber;
import zio.Fiber$Status$Done$;
import zio.Fiber$Status$Finishing$;
import zio.Fiber$Status$Running$;
import zio.Fiber$Status$Suspended$;
import zio.UIO$;
import zio.ZIO;
import zio.ZIO$;
import zio.internal.stacktracer.ZTraceElement;

public final class FiberRenderer$
implements Serializable {
    public static final FiberRenderer$ MODULE$ = new FiberRenderer$();

    private FiberRenderer$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(FiberRenderer$.class);
    }

    public ZIO<Object, Nothing$, String> dumpStr(Seq<Fiber.Runtime<?, ?>> fibers, boolean withTrace) {
        return ZIO$.MODULE$.foreach(fibers, (Function1 & Serializable)f -> f.dumpWith(withTrace), BuildFrom$.MODULE$.buildFromIterableOps()).flatMap((Function1 & Serializable)dumps -> UIO$.MODULE$.apply(this::dumpStr$$anonfun$3$$anonfun$1).map((Function1 & Serializable)now -> this.dumpStr$$anonfun$4$$anonfun$2(withTrace, (Seq)dumps, BoxesRunTime.unboxToLong((Object)now))));
    }

    public ZIO prettyPrintM(Fiber.Dump dump) {
        return UIO$.MODULE$.apply(() -> this.prettyPrintM$$anonfun$1(dump));
    }

    private <A> Iterable<Tuple2<A, Object>> zipWithHasNext(Iterable<A> it) {
        return it.isEmpty() ? (Iterable)package$.MODULE$.Seq().empty() : (Iterable)package$.MODULE$.Iterable().concat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Iterable[]{(Iterable)((IterableOps)it.dropRight(1)).map((Function1 & Serializable)_$1 -> Tuple2$.MODULE$.apply(_$1, (Object)BoxesRunTime.boxToBoolean((boolean)true))), (Iterable)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Tuple2$.MODULE$.apply(it.last(), (Object)BoxesRunTime.boxToBoolean((boolean)false))}))}));
    }

    private String prettyPrint(Fiber.Dump dump, long now) {
        String string;
        long millis = now - dump.fiberId().startTimeMillis();
        long seconds = millis / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        String name2 = (String)dump.fiberName().fold(this::$anonfun$1, (Function1 & Serializable)name -> new StringBuilder(3).append("\"").append((String)name).append("\" ").toString());
        String lifeMsg = new StringBuilder(0).append(hours == 0L ? "" : new StringBuilder(1).append(hours).append("h").toString()).append(hours == 0L && minutes == 0L ? "" : new StringBuilder(1).append(minutes).append("m").toString()).append(hours == 0L && minutes == 0L && seconds == 0L ? "" : new StringBuilder(1).append(seconds).append("s").toString()).append(new StringBuilder(2).append(millis).append("ms").toString()).toString();
        Fiber.Status status = dump.status();
        if (status instanceof Fiber.Status.Suspended) {
            Fiber.Status.Suspended suspended = Fiber$Status$Suspended$.MODULE$.unapply((Fiber.Status.Suspended)status);
            Fiber.Status status2 = suspended._1();
            boolean bl = suspended._2();
            long l = suspended._3();
            List<Fiber.Id> list = suspended._4();
            Option<ZTraceElement> option = suspended._5();
            List<Fiber.Id> blockingOn = list;
            string = blockingOn.nonEmpty() ? new StringBuilder(11).append("waiting on ").append(blockingOn.map((Function1 & Serializable)id -> new StringBuilder(1).append("#").append(id.seqNumber()).toString()).mkString(", ")).toString() : "";
        } else {
            string = "";
        }
        String waitMsg = string;
        String statMsg = this.renderStatus(dump.status());
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(52).append("\n       |").append(name2).append("#").append(dump.fiberId().seqNumber()).append(" (").append(lifeMsg).append(") ").append(waitMsg).append("\n       |   Status: ").append(statMsg).append("\n       |").append(dump.trace().fold(this::prettyPrint$$anonfun$1, (Function1 & Serializable)_$2 -> _$2.prettyPrint())).append("\n       |").toString()));
    }

    private String renderStatus(Fiber.Status status) {
        String string;
        Fiber.Status status2 = status;
        if (Fiber$Status$Done$.MODULE$.equals(status2)) {
            string = "Done";
        } else if (status2 instanceof Fiber.Status.Finishing) {
            boolean bl;
            Fiber.Status.Finishing finishing = Fiber$Status$Finishing$.MODULE$.unapply((Fiber.Status.Finishing)status2);
            boolean b = bl = finishing._1();
            string = new StringBuilder(11).append("Finishing(").append(b ? "interrupting" : "").append(")").toString();
        } else if (status2 instanceof Fiber.Status.Running) {
            boolean bl;
            Fiber.Status.Running running = Fiber$Status$Running$.MODULE$.unapply((Fiber.Status.Running)status2);
            boolean b = bl = running._1();
            string = new StringBuilder(9).append("Running(").append(b ? "interrupting" : "").append(")").toString();
        } else if (status2 instanceof Fiber.Status.Suspended) {
            Fiber.Status.Suspended suspended = Fiber$Status$Suspended$.MODULE$.unapply((Fiber.Status.Suspended)status2);
            Fiber.Status status3 = suspended._1();
            boolean bl = suspended._2();
            long l = suspended._3();
            List<Fiber.Id> list = suspended._4();
            Option<ZTraceElement> option = suspended._5();
            boolean interruptible = bl;
            long epoch = l;
            Option<ZTraceElement> asyncTrace = option;
            String in = interruptible ? "interruptible" : "uninterruptible";
            String ep = new StringBuilder(7).append(epoch).append(" asyncs").toString();
            String as = (String)asyncTrace.map((Function1 & Serializable)_$3 -> _$3.prettyPrint()).getOrElse(this::$anonfun$5);
            string = new StringBuilder(15).append("Suspended(").append(in).append(", ").append(ep).append(", ").append(as).append(")").toString();
        } else {
            throw new MatchError((Object)status2);
        }
        return string;
    }

    private String renderHierarchy(Iterable<Fiber.Dump> trees) {
        return ((IterableOnceOps)this.zipWithHasNext(trees).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Fiber.Dump tree = (Fiber.Dump)tuple2._1();
            return this.renderOne(tree);
        })).mkString();
    }

    private String renderOne(Fiber.Dump tree) {
        return this.go$1(tree, "");
    }

    private Vector<String> collectTraces(Iterable<Fiber.Dump> dumps, long now) {
        return ((IterableOnceOps)dumps.map((Function1 & Serializable)_$4 -> this.prettyPrint((Fiber.Dump)_$4, now))).toVector();
    }

    private final long dumpStr$$anonfun$3$$anonfun$1() {
        return System.currentTimeMillis();
    }

    private final /* synthetic */ String dumpStr$$anonfun$4$$anonfun$2(boolean withTrace$2, Seq dumps$1, long now) {
        String treeString = this.renderHierarchy((Iterable<Fiber.Dump>)dumps$1);
        Seq dumpStrings = withTrace$2 ? this.collectTraces((Iterable<Fiber.Dump>)dumps$1, now) : (Seq)package$.MODULE$.Seq().empty();
        return ((IterableOnceOps)dumpStrings.$plus$colon((Object)treeString)).mkString("\n");
    }

    private final String prettyPrintM$$anonfun$1(Fiber.Dump dump$1) {
        return this.prettyPrint(dump$1, System.currentTimeMillis());
    }

    private final String $anonfun$1() {
        return "";
    }

    private final String prettyPrint$$anonfun$1() {
        return "";
    }

    private final String $anonfun$5() {
        return "";
    }

    private final String $anonfun$6() {
        return "";
    }

    private final String go$1(Fiber.Dump t, String prefix) {
        String nameStr = (String)t.fiberName().fold(this::$anonfun$6, (Function1 & Serializable)n -> new StringBuilder(3).append("\"").append((String)n).append("\" ").toString());
        String statusMsg = this.renderStatus(t.status());
        return new StringBuilder(15).append(prefix).append("+---").append(nameStr).append("#").append(t.fiberId().seqNumber()).append(" Status: ").append(statusMsg).append("\n").toString();
    }
}

