/*
 * Decompiled with CFR 0.152.
 */
package zio.internal;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;
import zio.Chunk;
import zio.Chunk$;
import zio.ChunkBuilder;
import zio.ChunkBuilder$;
import zio.internal.BoundedHubArb$State$;
import zio.internal.Hub;

public final class BoundedHubArb<A>
extends Hub<A> {
    public final Object[] zio$internal$BoundedHubArb$$array;
    public final AtomicLongArray zio$internal$BoundedHubArb$$seq;
    public final AtomicLongArray zio$internal$BoundedHubArb$$sliding;
    public final AtomicReference<State> zio$internal$BoundedHubArb$$state;
    public final AtomicIntegerArray zio$internal$BoundedHubArb$$subscribers;
    public final AtomicLong zio$internal$BoundedHubArb$$subscribersIndex;
    private final int capacity;

    public BoundedHubArb(int requestedCapacity) {
        this.zio$internal$BoundedHubArb$$array = new Object[requestedCapacity];
        this.zio$internal$BoundedHubArb$$seq = new AtomicLongArray(requestedCapacity);
        this.zio$internal$BoundedHubArb$$sliding = new AtomicLongArray(requestedCapacity);
        this.zio$internal$BoundedHubArb$$state = new AtomicReference<State>(BoundedHubArb$State$.MODULE$.apply(0L, 0));
        this.zio$internal$BoundedHubArb$$subscribers = new AtomicIntegerArray(requestedCapacity);
        this.zio$internal$BoundedHubArb$$subscribersIndex = new AtomicLong(0L);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), requestedCapacity).foreach((Function1)(JFunction1.mcVI.sp & Serializable)n -> this.zio$internal$BoundedHubArb$$seq.set(n, n));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), requestedCapacity).foreach((Function1)(JFunction1.mcVI.sp & Serializable)n -> this.zio$internal$BoundedHubArb$$sliding.set(n, n));
        this.capacity = requestedCapacity;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public boolean isEmpty() {
        long currentSubscribersIndex;
        State currentState = this.zio$internal$BoundedHubArb$$state.get();
        long currentPublisherIndex = currentState.publisherIndex();
        return currentPublisherIndex == (currentSubscribersIndex = this.zio$internal$BoundedHubArb$$subscribersIndex.get());
    }

    @Override
    public boolean isFull() {
        long currentSubscribersIndex;
        State currentState = this.zio$internal$BoundedHubArb$$state.get();
        long currentPublisherIndex = currentState.publisherIndex();
        return currentPublisherIndex == (currentSubscribersIndex = this.zio$internal$BoundedHubArb$$subscribersIndex.get()) + (long)this.capacity();
    }

    @Override
    public boolean publish(A a) {
        State currentState = this.zio$internal$BoundedHubArb$$state.get();
        boolean loop = true;
        boolean published = true;
        while (loop) {
            int currentIndex;
            long currentSeq;
            long currentPublisherIndex = currentState.publisherIndex();
            if (currentPublisherIndex == (currentSeq = this.zio$internal$BoundedHubArb$$seq.get(currentIndex = (int)(currentPublisherIndex % (long)this.capacity())))) {
                State state = currentState;
                if (this.zio$internal$BoundedHubArb$$state.compareAndSet(currentState, state.copy(currentPublisherIndex + 1L, state.copy$default$2()))) {
                    Boolean bl;
                    this.zio$internal$BoundedHubArb$$array[currentIndex] = a;
                    int currentSubscriberCount = currentState.subscriberCount();
                    this.zio$internal$BoundedHubArb$$subscribers.getAndAdd(currentIndex, currentSubscriberCount);
                    this.zio$internal$BoundedHubArb$$sliding.set(currentIndex, currentPublisherIndex + 1L);
                    int currentSubscribers = this.zio$internal$BoundedHubArb$$subscribers.get(currentIndex);
                    if (currentSubscribers == 0) {
                        if (this.zio$internal$BoundedHubArb$$sliding.compareAndSet(currentIndex, currentPublisherIndex + 1L, currentPublisherIndex + (long)this.capacity())) {
                            this.zio$internal$BoundedHubArb$$array[currentIndex] = null;
                            this.zio$internal$BoundedHubArb$$subscribersIndex.getAndIncrement();
                            this.zio$internal$BoundedHubArb$$seq.lazySet(currentIndex, currentPublisherIndex + (long)this.capacity());
                            bl = BoxedUnit.UNIT;
                        } else {
                            bl = BoxedUnit.UNIT;
                        }
                    } else {
                        bl = BoxesRunTime.boxToBoolean((boolean)this.zio$internal$BoundedHubArb$$seq.compareAndSet(currentIndex, currentPublisherIndex, currentPublisherIndex + 1L));
                    }
                    loop = false;
                    continue;
                }
                currentState = this.zio$internal$BoundedHubArb$$state.get();
                continue;
            }
            long currentSubscribersIndex = this.zio$internal$BoundedHubArb$$subscribersIndex.get();
            if (currentPublisherIndex == currentSubscribersIndex + (long)this.capacity()) {
                loop = false;
                published = false;
                continue;
            }
            currentState = this.zio$internal$BoundedHubArb$$state.get();
        }
        return published;
    }

    @Override
    public Chunk<A> publishAll(Iterable<A> as) {
        State currentState = this.zio$internal$BoundedHubArb$$state.get();
        Iterator iterator = as.iterator();
        boolean loop = true;
        int remaining = as.size();
        while (loop) {
            long currentPublisherIndex;
            long currentSubscribersIndex = this.zio$internal$BoundedHubArb$$subscribersIndex.get();
            int size = (int)(currentPublisherIndex - currentSubscribersIndex);
            int available = this.capacity() - size;
            int forHub = package$.MODULE$.min(remaining, available);
            if (forHub == 0) {
                loop = false;
                continue;
            }
            boolean bl = true;
            long publishAllIndex = currentPublisherIndex + (long)forHub;
            for (currentPublisherIndex = currentState.publisherIndex(); bl && currentPublisherIndex != publishAllIndex; ++currentPublisherIndex) {
                int currentIndex = (int)(currentPublisherIndex % (long)this.capacity());
                long currentSeq = this.zio$internal$BoundedHubArb$$seq.get(currentIndex);
                if (currentPublisherIndex == currentSeq) continue;
                bl = false;
            }
            if (bl) {
                State state = currentState;
                if (this.zio$internal$BoundedHubArb$$state.compareAndSet(currentState, state.copy(currentPublisherIndex, state.copy$default$2()))) {
                    currentPublisherIndex -= (long)forHub;
                    while (currentPublisherIndex != publishAllIndex) {
                        Boolean bl2;
                        Object a = iterator.next();
                        int currentIndex = (int)(currentPublisherIndex % (long)this.capacity());
                        this.zio$internal$BoundedHubArb$$array[currentIndex] = a;
                        int currentSubscriberCount = currentState.subscriberCount();
                        this.zio$internal$BoundedHubArb$$subscribers.getAndAdd(currentIndex, currentSubscriberCount);
                        this.zio$internal$BoundedHubArb$$sliding.set(currentIndex, currentPublisherIndex + 1L);
                        int currentSubscribers = this.zio$internal$BoundedHubArb$$subscribers.get(currentIndex);
                        if (currentSubscribers == 0) {
                            if (this.zio$internal$BoundedHubArb$$sliding.compareAndSet(currentIndex, currentPublisherIndex + 1L, currentPublisherIndex + (long)this.capacity())) {
                                this.zio$internal$BoundedHubArb$$array[currentIndex] = null;
                                this.zio$internal$BoundedHubArb$$subscribersIndex.getAndIncrement();
                                this.zio$internal$BoundedHubArb$$seq.lazySet(currentIndex, currentPublisherIndex + (long)this.capacity());
                                bl2 = BoxedUnit.UNIT;
                            } else {
                                bl2 = BoxedUnit.UNIT;
                            }
                        } else {
                            bl2 = BoxesRunTime.boxToBoolean((boolean)this.zio$internal$BoundedHubArb$$seq.compareAndSet(currentIndex, currentPublisherIndex, currentPublisherIndex + 1L));
                        }
                        ++currentPublisherIndex;
                    }
                    remaining -= forHub;
                    continue;
                }
                currentState = this.zio$internal$BoundedHubArb$$state.get();
                continue;
            }
            currentState = this.zio$internal$BoundedHubArb$$state.get();
        }
        return Chunk$.MODULE$.fromIterator(iterator);
    }

    @Override
    public int size() {
        State currentState = this.zio$internal$BoundedHubArb$$state.get();
        long currentPublisherIndex = currentState.publisherIndex();
        long currentSubscribersIndex = this.zio$internal$BoundedHubArb$$subscribersIndex.get();
        return (int)(currentPublisherIndex - currentSubscribersIndex);
    }

    @Override
    public void slide() {
        long currentSubscribersIndex = this.zio$internal$BoundedHubArb$$subscribersIndex.get();
        boolean loop = true;
        while (loop) {
            int currentIndex = (int)(currentSubscribersIndex % (long)this.capacity());
            if (this.zio$internal$BoundedHubArb$$sliding.compareAndSet(currentIndex, currentSubscribersIndex + 1L, currentSubscribersIndex + (long)this.capacity())) {
                this.zio$internal$BoundedHubArb$$array[currentIndex] = null;
                this.zio$internal$BoundedHubArb$$subscribersIndex.getAndIncrement();
                this.zio$internal$BoundedHubArb$$seq.lazySet(currentIndex, currentSubscribersIndex + (long)this.capacity());
                loop = false;
                continue;
            }
            long currentSliding = this.zio$internal$BoundedHubArb$$sliding.get(currentIndex);
            if (currentSliding == currentSubscribersIndex + (long)this.capacity()) {
                ++currentSubscribersIndex;
                continue;
            }
            State currentState = this.zio$internal$BoundedHubArb$$state.get();
            long currentPublisherIndex = currentState.publisherIndex();
            if (currentSubscribersIndex == currentPublisherIndex) {
                loop = false;
                continue;
            }
            currentSubscribersIndex = this.zio$internal$BoundedHubArb$$subscribersIndex.get();
        }
    }

    @Override
    public Hub.Subscription<A> subscribe() {
        return new Hub.Subscription<A>(this){
            private final AtomicLong subscriberIndex;
            private final AtomicBoolean unsubscribed;
            private final /* synthetic */ BoundedHubArb $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                State currentState = $outer.zio$internal$BoundedHubArb$$state.getAndUpdate(BoundedHubArb::zio$internal$BoundedHubArb$$anon$1$$_$_$$lessinit$greater$$anonfun$3);
                long currentPublisherIndex = currentState.publisherIndex();
                this.subscriberIndex = new AtomicLong(currentPublisherIndex);
                this.unsubscribed = new AtomicBoolean(false);
            }

            public boolean isEmpty() {
                long currentSubscribersIndex;
                long currentSubscriberIndex;
                State currentState;
                long currentPublisherIndex;
                return this.unsubscribed.get() ? true : ((currentPublisherIndex = (currentState = this.$outer.zio$internal$BoundedHubArb$$state.get()).publisherIndex()) == (currentSubscriberIndex = this.subscriberIndex.get()) ? true : currentPublisherIndex == (currentSubscribersIndex = this.$outer.zio$internal$BoundedHubArb$$subscribersIndex.get()));
            }

            public Object poll(Object object) {
                long currentSubscriberIndex = this.subscriberIndex.get();
                boolean loop = true;
                Object polled = object;
                while (loop && !this.unsubscribed.get()) {
                    int currentIndex = (int)(currentSubscriberIndex % (long)this.$outer.capacity());
                    long currentSeq = this.$outer.zio$internal$BoundedHubArb$$seq.get(currentIndex);
                    if (currentSubscriberIndex + 1L == currentSeq) {
                        if (this.subscriberIndex.compareAndSet(currentSubscriberIndex, currentSubscriberIndex + 1L)) {
                            polled = this.$outer.zio$internal$BoundedHubArb$$array[currentIndex];
                            long currentSliding = this.$outer.zio$internal$BoundedHubArb$$sliding.get(currentIndex);
                            int currentSubscribers = this.$outer.zio$internal$BoundedHubArb$$subscribers.decrementAndGet(currentIndex);
                            if (currentSubscribers == 0 && this.$outer.zio$internal$BoundedHubArb$$sliding.compareAndSet(currentIndex, currentSubscriberIndex + 1L, currentSubscriberIndex + (long)this.$outer.capacity())) {
                                this.$outer.zio$internal$BoundedHubArb$$array[currentIndex] = null;
                                this.$outer.zio$internal$BoundedHubArb$$subscribersIndex.getAndIncrement();
                                this.$outer.zio$internal$BoundedHubArb$$seq.lazySet(currentIndex, currentSubscriberIndex + (long)this.$outer.capacity());
                            }
                            if (currentSubscriberIndex + 1L == currentSliding) {
                                loop = false;
                                continue;
                            }
                            polled = object;
                            currentSubscriberIndex = this.subscriberIndex.get();
                            continue;
                        }
                        ++currentSubscriberIndex;
                        continue;
                    }
                    State currentState = this.$outer.zio$internal$BoundedHubArb$$state.get();
                    long currentPublisherIndex = currentState.publisherIndex();
                    if (currentSubscriberIndex == currentPublisherIndex) {
                        loop = false;
                        continue;
                    }
                    long currentSubscribersIndex = this.$outer.zio$internal$BoundedHubArb$$subscribersIndex.get();
                    if (currentSubscriberIndex - currentSubscribersIndex < 0L && this.subscriberIndex.compareAndSet(currentSubscriberIndex, currentSubscriberIndex + 1L)) {
                        this.$outer.zio$internal$BoundedHubArb$$subscribers.getAndDecrement(currentIndex);
                    }
                    currentSubscriberIndex = this.subscriberIndex.get();
                }
                return polled;
            }

            public Chunk pollUpTo(int n) {
                ChunkBuilder<A> builder = ChunkBuilder$.MODULE$.make();
                long currentSubscriberIndex = this.subscriberIndex.get();
                boolean loop = true;
                int remaining = n;
                while (loop && !this.unsubscribed.get()) {
                    State currentState = this.$outer.zio$internal$BoundedHubArb$$state.get();
                    long currentPublisherIndex = currentState.publisherIndex();
                    int size = (int)(currentPublisherIndex - currentSubscriberIndex);
                    int toPoll = package$.MODULE$.min(remaining, size);
                    if (toPoll <= 0) {
                        loop = false;
                        continue;
                    }
                    boolean bl = true;
                    long pollUpToIndex = currentSubscriberIndex + (long)toPoll;
                    while (bl && currentSubscriberIndex != pollUpToIndex) {
                        int currentIndex = (int)(currentSubscriberIndex % (long)this.$outer.capacity());
                        long currentSeq = this.$outer.zio$internal$BoundedHubArb$$seq.get(currentIndex);
                        if (currentSubscriberIndex + 1L != currentSeq) {
                            bl = false;
                        }
                        ++currentSubscriberIndex;
                    }
                    if (bl) {
                        if (this.subscriberIndex.compareAndSet(currentSubscriberIndex -= (long)toPoll, currentSubscriberIndex + (long)toPoll)) {
                            while (currentSubscriberIndex != pollUpToIndex) {
                                int currentIndex = (int)(currentSubscriberIndex % (long)this.$outer.capacity());
                                Object a = this.$outer.zio$internal$BoundedHubArb$$array[currentIndex];
                                long currentSliding = this.$outer.zio$internal$BoundedHubArb$$sliding.get(currentIndex);
                                int currentSubscribers = this.$outer.zio$internal$BoundedHubArb$$subscribers.decrementAndGet(currentIndex);
                                if (currentSubscribers == 0 && this.$outer.zio$internal$BoundedHubArb$$sliding.compareAndSet(currentIndex, currentSubscriberIndex + 1L, currentSubscriberIndex + (long)this.$outer.capacity())) {
                                    this.$outer.zio$internal$BoundedHubArb$$array[currentIndex] = null;
                                    this.$outer.zio$internal$BoundedHubArb$$subscribersIndex.getAndIncrement();
                                    this.$outer.zio$internal$BoundedHubArb$$seq.lazySet(currentIndex, currentSubscriberIndex + (long)this.$outer.capacity());
                                }
                                if (currentSubscriberIndex + 1L == currentSliding) {
                                    builder.$plus$eq(a);
                                    --remaining;
                                }
                                ++currentSubscriberIndex;
                            }
                            continue;
                        }
                        currentSubscriberIndex = this.subscriberIndex.get();
                        continue;
                    }
                    State currentState2 = this.$outer.zio$internal$BoundedHubArb$$state.get();
                    long currentPublisherIndex2 = currentState2.publisherIndex();
                    long currentSubscriberIndex2 = this.subscriberIndex.get();
                    int currentIndex = (int)(currentSubscriberIndex2 % (long)this.$outer.capacity());
                    if (currentSubscriberIndex2 == currentPublisherIndex2) {
                        loop = false;
                        continue;
                    }
                    long currentSubscribersIndex = this.$outer.zio$internal$BoundedHubArb$$subscribersIndex.get();
                    if (currentSubscriberIndex2 - currentSubscribersIndex >= 0L || !this.subscriberIndex.compareAndSet(currentSubscriberIndex2, currentSubscriberIndex2 + 1L)) continue;
                    this.$outer.zio$internal$BoundedHubArb$$subscribers.getAndDecrement(currentIndex);
                }
                return (Chunk)builder.result();
            }

            public int size() {
                int n;
                if (this.unsubscribed.get()) {
                    n = 0;
                } else {
                    long currentSubscribersIndex;
                    State currentState = this.$outer.zio$internal$BoundedHubArb$$state.get();
                    long currentPublisherIndex = currentState.publisherIndex();
                    long currentSubscriberIndex = this.subscriberIndex.get();
                    n = currentSubscriberIndex - (currentSubscribersIndex = this.$outer.zio$internal$BoundedHubArb$$subscribersIndex.get()) < 0L ? (int)(currentPublisherIndex - currentSubscribersIndex) : (int)(currentPublisherIndex - currentSubscriberIndex);
                }
                return n;
            }

            public void unsubscribe() {
                if (this.unsubscribed.compareAndSet(false, true)) {
                    State currentState = this.$outer.zio$internal$BoundedHubArb$$state.getAndUpdate(BoundedHubArb::zio$internal$BoundedHubArb$$anon$1$$_$_$$anonfun$1);
                    int currentPublisherIndex = (int)currentState.publisherIndex();
                    for (long currentSubscriberIndex = this.subscriberIndex.getAndAdd(Integer.MAX_VALUE); currentSubscriberIndex != (long)currentPublisherIndex; ++currentSubscriberIndex) {
                        int updatedSubscribers;
                        long currentSliding;
                        int currentIndex = (int)(currentSubscriberIndex % (long)this.$outer.capacity());
                        int currentSubscribers = this.$outer.zio$internal$BoundedHubArb$$subscribers.decrementAndGet(currentIndex);
                        if (currentSubscribers != 0 || (currentSliding = this.$outer.zio$internal$BoundedHubArb$$sliding.get(currentIndex)) != currentSubscriberIndex + 1L || (updatedSubscribers = this.$outer.zio$internal$BoundedHubArb$$subscribers.get(currentIndex)) != 0 || !this.$outer.zio$internal$BoundedHubArb$$sliding.compareAndSet(currentIndex, currentSubscriberIndex + 1L, currentSubscriberIndex + (long)this.$outer.capacity())) continue;
                        this.$outer.zio$internal$BoundedHubArb$$array[currentIndex] = null;
                        this.$outer.zio$internal$BoundedHubArb$$subscribersIndex.getAndIncrement();
                        this.$outer.zio$internal$BoundedHubArb$$seq.lazySet(currentIndex, currentSubscriberIndex + (long)this.$outer.capacity());
                    }
                }
            }
        };
    }

    public static final /* synthetic */ State zio$internal$BoundedHubArb$$anon$1$$_$_$$lessinit$greater$$anonfun$3(State currentState) {
        int n = currentState.subscriberCount() + 1;
        long l = currentState.copy$default$1();
        return currentState.copy(l, n);
    }

    public static final /* synthetic */ State zio$internal$BoundedHubArb$$anon$1$$_$_$$anonfun$1(State currentState) {
        int n = currentState.subscriberCount() - 1;
        long l = currentState.copy$default$1();
        return currentState.copy(l, n);
    }

    public static final class State
    implements Product,
    Serializable {
        private final long publisherIndex;
        private final int subscriberCount;

        public static State apply(long l, int n) {
            return BoundedHubArb$State$.MODULE$.apply(l, n);
        }

        public static State fromProduct(Product product) {
            return BoundedHubArb$State$.MODULE$.fromProduct(product);
        }

        public static State unapply(State state) {
            return BoundedHubArb$State$.MODULE$.unapply(state);
        }

        public State(long publisherIndex, int subscriberCount) {
            this.publisherIndex = publisherIndex;
            this.subscriberCount = subscriberCount;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.publisherIndex()));
            n = Statics.mix((int)n, (int)this.subscriberCount());
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof State)) return false;
            State state = (State)object;
            if (this.publisherIndex() != state.publisherIndex()) return false;
            if (this.subscriberCount() != state.subscriberCount()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof State;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "State";
        }

        public Object productElement(int n) {
            Number number;
            int n2 = n;
            if (0 == n2) {
                number = BoxesRunTime.boxToLong((long)this._1());
            } else if (1 == n2) {
                number = BoxesRunTime.boxToInteger((int)this._2());
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return number;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "publisherIndex";
            } else if (1 == n2) {
                string = "subscriberCount";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public long publisherIndex() {
            return this.publisherIndex;
        }

        public int subscriberCount() {
            return this.subscriberCount;
        }

        public State copy(long publisherIndex, int subscriberCount) {
            return new State(publisherIndex, subscriberCount);
        }

        public long copy$default$1() {
            return this.publisherIndex();
        }

        public int copy$default$2() {
            return this.subscriberCount();
        }

        public long _1() {
            return this.publisherIndex();
        }

        public int _2() {
            return this.subscriberCount();
        }
    }
}

