/*
 * Decompiled with CFR 0.152.
 */
package zio.internal;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.deriving.Mirror;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.function.JProcedure2;
import zio.Cause;
import zio.Cause$;
import zio.Chunk;
import zio.Chunk$;
import zio.Executor;
import zio.Exit;
import zio.Exit$Failure$;
import zio.Exit$Success$;
import zio.Fiber;
import zio.Fiber$;
import zio.Fiber$Status$Done$;
import zio.Fiber$Status$Running$;
import zio.Fiber$Status$Suspended$;
import zio.FiberId;
import zio.FiberId$None$;
import zio.FiberRef;
import zio.FiberRef$;
import zio.FiberRefs;
import zio.LogLevel;
import zio.LogSpan;
import zio.Promise;
import zio.Promise$unsafe$;
import zio.Runtime$;
import zio.RuntimeFlag$CurrentFiber$;
import zio.RuntimeFlag$Interruption$;
import zio.RuntimeFlag$WindDown$;
import zio.RuntimeFlags$;
import zio.RuntimeFlags$Patch$;
import zio.StackTrace;
import zio.StackTrace$;
import zio.Supervisor;
import zio.Trace$;
import zio.Unsafe;
import zio.Unsafe$;
import zio.ZIO;
import zio.ZIO$;
import zio.ZIO$EvaluationStep$Continuation$;
import zio.ZIO$EvaluationStep$UpdateRuntimeFlags$;
import zio.ZIO$EvaluationStep$UpdateTrace$;
import zio.ZIO$ZIOError$;
import zio.ZLogger;
import zio.internal.FiberMessage;
import zio.internal.FiberMessage$GenStackTrace$;
import zio.internal.FiberMessage$InterruptSignal$;
import zio.internal.FiberMessage$Resume$;
import zio.internal.FiberMessage$Stateful$;
import zio.internal.FiberMessage$YieldNow$;
import zio.internal.FiberRunnable;
import zio.internal.FiberRuntime$;
import zio.internal.FiberRuntime$EvaluationSignal$;
import zio.internal.FiberRuntime$EvaluationSignal$Continue$;
import zio.internal.FiberRuntime$EvaluationSignal$Done$;
import zio.internal.FiberRuntime$EvaluationSignal$YieldNow$;
import zio.internal.FiberScope;
import zio.internal.FiberScope$;
import zio.internal.IsFatal;
import zio.internal.PinchableArray;
import zio.internal.PinchableArray$;
import zio.internal.Platform$;
import zio.internal.ReifyStack;
import zio.internal.ReifyStack$AsyncJump$;
import zio.internal.ReifyStack$GenerateTrace$;
import zio.internal.ReifyStack$Trampoline$;
import zio.internal.StackTraceBuilder;
import zio.internal.StackTraceBuilder$;
import zio.metrics.Metric;
import zio.metrics.Metric$runtime$;

public final class FiberRuntime<E, A>
extends Fiber.Runtime.Internal<E, A>
implements FiberRunnable {
    private final FiberId.Runtime fiberId;
    private FiberRefs _fiberRefs;
    private final ConcurrentLinkedQueue<FiberMessage> queue;
    private Set<FiberRuntime<?, ?>> _children;
    private List<Function1<Exit<E, A>, BoxedUnit>> observers;
    private final AtomicBoolean running;
    private int _runtimeFlags;
    private final PinchableArray<ZIO.EvaluationStep> reifiedStack;
    private ZIO<Object, Object, Object> asyncEffect;
    private Function1<ZIO<Object, Object, Object>, Object> asyncInterruptor;
    private Object asyncTrace;
    private FiberId asyncBlockingOn;
    private volatile Exit _exitValue;

    public static int MaxOperationsBeforeYield() {
        return FiberRuntime$.MODULE$.MaxOperationsBeforeYield();
    }

    public static int MaxTrampolinesBeforeYield() {
        return FiberRuntime$.MODULE$.MaxTrampolinesBeforeYield();
    }

    public static <E, A> FiberRuntime<E, A> apply(FiberId.Runtime runtime, FiberRefs fiberRefs, int n) {
        return FiberRuntime$.MODULE$.apply(runtime, fiberRefs, n);
    }

    public static AtomicBoolean catastrophicFailure() {
        return FiberRuntime$.MODULE$.catastrophicFailure();
    }

    public FiberRuntime(FiberId.Runtime fiberId, FiberRefs fiberRefs0, int runtimeFlags0) {
        this.fiberId = fiberId;
        this._fiberRefs = fiberRefs0;
        this.queue = new ConcurrentLinkedQueue();
        this._children = null;
        this.observers = package$.MODULE$.Nil();
        this.running = new AtomicBoolean(false);
        this._runtimeFlags = runtimeFlags0;
        this.reifiedStack = PinchableArray$.MODULE$.make(-1, ClassTag$.MODULE$.apply(ZIO.EvaluationStep.class));
        this.asyncEffect = null;
        this.asyncInterruptor = null;
        this.asyncTrace = null;
        this.asyncBlockingOn = null;
        if (RuntimeFlags$.MODULE$.runtimeMetrics(this._runtimeFlags())) {
            Metric.UnsafeAPI unsafeAPI = Metric$runtime$.MODULE$.fibersStarted().unsafe();
            unsafeAPI.update(BoxesRunTime.boxToLong((long)1L), unsafeAPI.update$default$2(), Unsafe$.MODULE$.unsafe());
            Metric.UnsafeAPI unsafeAPI2 = Metric$runtime$.MODULE$.fiberForkLocations().unsafe();
            unsafeAPI2.update(fiberId.location().toString(), unsafeAPI2.update$default$2(), Unsafe$.MODULE$.unsafe());
        }
        this._exitValue = null;
    }

    private int _runtimeFlags() {
        return this._runtimeFlags;
    }

    private void _runtimeFlags_$eq(int x$0) {
        this._runtimeFlags = x$0;
    }

    private Exit<E, A> _exitValue() {
        return this._exitValue;
    }

    private void _exitValue_$eq(Exit<E, A> x$0) {
        this._exitValue = x$0;
    }

    public <A> ZIO<Object, Nothing$, A> ask(Function1<Unsafe, Function2<FiberRuntime<?, ?>, Fiber.Status, A>> f, Object trace) {
        return ZIO$.MODULE$.suspendSucceedUnsafe((Function1 & Serializable)u -> {
            Promise promise = Promise$unsafe$.MODULE$.make(this.fiberId, (Unsafe)u);
            this.tell(FiberMessage$Stateful$.MODULE$.apply((Function2<FiberRuntime<?, ?>, Fiber.Status, BoxedUnit>)(JProcedure2 & Serializable)(fiber, status) -> promise.unsafe().done(ZIO$.MODULE$.succeedNow(((Function2)f.apply(u)).apply(fiber, status)), (Unsafe)u)), (Unsafe)u);
            return promise.await(trace);
        }, trace);
    }

    @Override
    public ZIO<Object, Nothing$, Exit<E, A>> await(Object trace) {
        return ZIO$.MODULE$.async((Function1 & Serializable)evidence$1 -> (Function1 & Serializable)cb -> {
            this.tell(FiberMessage$Stateful$.MODULE$.apply((Function2<FiberRuntime<?, ?>, Fiber.Status, BoxedUnit>)(JProcedure2 & Serializable)(fiber, _$1) -> {
                if (fiber._exitValue() != null) {
                    cb.apply(Exit$Success$.MODULE$.apply(fiber.exitValue(Unsafe$.MODULE$.unsafe())));
                } else {
                    fiber.addObserver((Function1)(JProcedure1 & Serializable)exit -> cb.apply(Exit$Success$.MODULE$.apply(exit)), Unsafe$.MODULE$.unsafe());
                }
            }), Unsafe$.MODULE$.unsafe());
            return BoxedUnit.UNIT;
        }, this::await$$anonfun$2, trace);
    }

    @Override
    public ZIO<Object, Nothing$, Chunk<FiberRuntime<?, ?>>> children(Object trace) {
        return this.ask((Function1 & Serializable)u -> (Function2 & Serializable)(fiber, _$2) -> Chunk$.MODULE$.fromJavaIterable(fiber.getChildren((Unsafe)u)), trace);
    }

    @Override
    public ZIO<Object, Nothing$, FiberRefs> fiberRefs(Object trace) {
        return this.ask((Function1 & Serializable)u -> (Function2 & Serializable)(fiber, _$3) -> fiber.getFiberRefs((Unsafe)u), trace);
    }

    @Override
    public FiberId.Runtime id() {
        return this.fiberId;
    }

    @Override
    public ZIO<Object, Nothing$, BoxedUnit> inheritAll(Object trace) {
        return ZIO$.MODULE$.withFiberRuntime((Function2 & Serializable)(parentFiber, parentStatus) -> {
            Unsafe unsafe = Unsafe$.MODULE$.unsafe();
            FiberId.Runtime parentFiberId = parentFiber.id();
            FiberRefs parentFiberRefs = parentFiber.getFiberRefs(unsafe);
            int parentRuntimeFlags = parentStatus.runtimeFlags();
            FiberRefs childFiberRefs = this.getFiberRefs(unsafe);
            FiberRefs updatedFiberRefs = parentFiberRefs.joinAs(parentFiberId, childFiberRefs);
            parentFiber.setFiberRefs(updatedFiberRefs, unsafe);
            return this.runtimeFlags(trace).flatMap((Function1 & Serializable)childRuntimeFlags -> FiberRuntime.inheritAll$$anonfun$1$$anonfun$1(trace, parentRuntimeFlags, BoxesRunTime.unboxToInt((Object)childRuntimeFlags)), trace);
        }, trace);
    }

    @Override
    public ZIO<Object, Nothing$, BoxedUnit> interruptAsFork(FiberId fiberId, Object trace) {
        return ZIO$.MODULE$.succeed((Function1)(JProcedure1 & Serializable)evidence$2 -> {
            Cause<Nothing$> cause = Cause$.MODULE$.interrupt(fiberId, Cause$.MODULE$.interrupt$default$2()).traced(StackTrace$.MODULE$.apply(fiberId, (Chunk<Object>)Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{trace}))));
            this.tell(FiberMessage$InterruptSignal$.MODULE$.apply(cause), Unsafe$.MODULE$.unsafe());
        }, trace);
    }

    @Override
    public Object location() {
        return this.fiberId.location();
    }

    @Override
    public ZIO<Object, Nothing$, Option<Exit<E, A>>> poll(Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$3 -> Option$.MODULE$.apply(this.exitValue(Unsafe$.MODULE$.unsafe())), trace);
    }

    @Override
    public void run() {
        this.drainQueueOnCurrentThread(Unsafe$.MODULE$.unsafe());
    }

    @Override
    public ZIO<Object, Nothing$, Object> runtimeFlags(Object trace) {
        return this.ask((Function1 & Serializable)u -> (Function2 & Serializable)(state, status) -> {
            int n;
            Fiber.Status status2 = status;
            if (Fiber$Status$Done$.MODULE$.equals(status2)) {
                n = state._runtimeFlags();
            } else if (status2 instanceof Fiber.Status.Unfinished) {
                Fiber.Status.Unfinished active = (Fiber.Status.Unfinished)status2;
                n = active.runtimeFlags();
            } else {
                throw new MatchError((Object)status2);
            }
            return n;
        }, trace);
    }

    public FiberScope scope() {
        return FiberScope$.MODULE$.make(this);
    }

    @Override
    public ZIO<Object, Nothing$, Fiber.Status> status(Object trace) {
        return this.ask((Function1 & Serializable)u -> (Function2 & Serializable)(_$4, currentStatus) -> currentStatus, trace);
    }

    @Override
    public ZIO<Object, Nothing$, StackTrace> trace(Object trace) {
        return ZIO$.MODULE$.suspendSucceed(() -> this.trace$$anonfun$1(trace), trace);
    }

    public void addChild(FiberRuntime<?, ?> child, Unsafe unsafe) {
        this.getChildren(unsafe).add(child);
    }

    private void addInterruptedCause(Cause<Nothing$> cause, Unsafe unsafe) {
        Cause<Nothing$> oldSC = this.getFiberRef(FiberRef$.MODULE$.interruptedCause(), unsafe);
        this.setFiberRef(FiberRef$.MODULE$.interruptedCause(), oldSC.$plus$plus(cause), unsafe);
    }

    public void addObserver(Function1<Exit<E, A>, BoxedUnit> observer, Unsafe unsafe) {
        if (this._exitValue() != null) {
            observer.apply(this._exitValue());
        } else {
            this.observers = this.observers.$colon$colon(observer);
        }
    }

    public void deleteFiberRef(FiberRef<?> ref, Unsafe unsafe) {
        this._fiberRefs = this._fiberRefs.delete(ref);
    }

    private void drainQueueOnCurrentThread(Unsafe unsafe) {
        FiberRuntime fiberRuntime = this;
        while (true) {
            if (!fiberRuntime.running.get()) {
                throw Scala3RunTime$.MODULE$.assertFailed();
            }
            Mirror.Singleton evaluationSignal = FiberRuntime$EvaluationSignal$Continue$.MODULE$;
            if (RuntimeFlags$.MODULE$.currentFiber(fiberRuntime._runtimeFlags())) {
                Fiber$.MODULE$._currentFiber().set(fiberRuntime);
            }
            try {
                while (true) {
                    FiberRuntime$EvaluationSignal$Continue$ fiberRuntime$EvaluationSignal$Continue$ = evaluationSignal;
                    FiberRuntime$EvaluationSignal$Continue$ fiberRuntime$EvaluationSignal$Continue$2 = FiberRuntime$EvaluationSignal$Continue$.MODULE$;
                    if (fiberRuntime$EvaluationSignal$Continue$ == null) {
                        if (fiberRuntime$EvaluationSignal$Continue$2 != null) {
                            break;
                        }
                    } else if (!fiberRuntime$EvaluationSignal$Continue$.equals(fiberRuntime$EvaluationSignal$Continue$2)) break;
                    evaluationSignal = fiberRuntime.queue.isEmpty() ? FiberRuntime$EvaluationSignal$Done$.MODULE$ : fiberRuntime.evaluateMessageWhileSuspended(fiberRuntime.queue.poll(), unsafe);
                }
            }
            finally {
                fiberRuntime.running.set(false);
                if (RuntimeFlags$.MODULE$.currentFiber(fiberRuntime._runtimeFlags())) {
                    Fiber$.MODULE$._currentFiber().set(null);
                }
            }
            if (fiberRuntime.queue.isEmpty() || !fiberRuntime.running.compareAndSet(false, true)) break;
            Mirror.Singleton singleton = evaluationSignal;
            FiberRuntime$EvaluationSignal$YieldNow$ fiberRuntime$EvaluationSignal$YieldNow$ = FiberRuntime$EvaluationSignal$YieldNow$.MODULE$;
            if (singleton != null ? !singleton.equals(fiberRuntime$EvaluationSignal$YieldNow$) : fiberRuntime$EvaluationSignal$YieldNow$ != null) continue;
            fiberRuntime.drainQueueLaterOnExecutor(unsafe);
            break;
        }
    }

    private void drainQueueLaterOnExecutor(Unsafe unsafe) {
        if (!this.running.get()) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        this.getCurrentExecutor(unsafe).submitOrThrow(this, unsafe);
    }

    private ZIO<Object, Object, Object> drainQueueWhileRunning(int runtimeFlags, Object lastTrace, ZIO<Object, Object, Object> cur0, Unsafe unsafe) {
        ZIO<Object, Object, Object> cur = cur0;
        while (!this.queue.isEmpty()) {
            FiberMessage message = this.queue.poll();
            FiberMessage fiberMessage = message;
            if (fiberMessage instanceof FiberMessage.InterruptSignal) {
                Cause<Nothing$> cause;
                FiberMessage.InterruptSignal interruptSignal = FiberMessage$InterruptSignal$.MODULE$.unapply((FiberMessage.InterruptSignal)fiberMessage);
                Cause<Nothing$> cause2 = cause = interruptSignal._1();
                this.processNewInterruptSignal(cause2, unsafe);
                cur = RuntimeFlags$.MODULE$.interruptible(runtimeFlags) ? Exit$Failure$.MODULE$.apply(cause2) : cur;
                continue;
            }
            if (fiberMessage instanceof FiberMessage.GenStackTrace) {
                Function1<StackTrace, BoxedUnit> function1;
                FiberMessage.GenStackTrace genStackTrace = FiberMessage$GenStackTrace$.MODULE$.unapply((FiberMessage.GenStackTrace)fiberMessage);
                Function1<StackTrace, BoxedUnit> onTrace = function1 = genStackTrace._1();
                ZIO<Object, Object, Object> oldCur = cur;
                cur = ZIO$.MODULE$.stackTrace(Trace$.MODULE$.empty()).flatMap((Function1 & Serializable)stackTrace -> {
                    onTrace.apply(stackTrace);
                    return oldCur;
                }, Trace$.MODULE$.empty());
                continue;
            }
            if (fiberMessage instanceof FiberMessage.Stateful) {
                Function2<FiberRuntime<?, ?>, Fiber.Status, BoxedUnit> function2;
                FiberMessage.Stateful stateful = FiberMessage$Stateful$.MODULE$.unapply((FiberMessage.Stateful)fiberMessage);
                Function2<FiberRuntime<?, ?>, Fiber.Status, BoxedUnit> onFiber = function2 = stateful._1();
                this.processStatefulMessage(onFiber, Fiber$Status$Running$.MODULE$.apply(runtimeFlags, lastTrace), unsafe);
                continue;
            }
            if (FiberMessage$Resume$.MODULE$.equals(fiberMessage)) {
                throw new IllegalStateException("It is illegal to have multiple concurrent run loops in a single fiber");
            }
            if (FiberMessage$YieldNow$.MODULE$.equals(fiberMessage)) {
                ZIO<Object, Object, Object> oldCur = cur;
                cur = ZIO$.MODULE$.yieldNow(Trace$.MODULE$.empty()).flatMap((Function1 & Serializable)_$5 -> oldCur, Trace$.MODULE$.empty());
                continue;
            }
            throw new MatchError((Object)fiberMessage);
        }
        return cur;
    }

    private Exit<E, A> evaluateEffect(ZIO<Object, Object, Object> effect0, Unsafe unsafe) {
        Exit.Failure<Object> failure;
        if (!this.running.get()) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        this.getSupervisor(unsafe).onResume(this, unsafe);
        try {
            ZIO<Object, Object, Object> effect = RuntimeFlags$.MODULE$.interruptible(this._runtimeFlags()) && this.isInterrupted(unsafe) ? Exit$Failure$.MODULE$.apply(this.getInterruptedCause(unsafe)) : effect0;
            int trampolines = 0;
            Exit.Failure<Object> finalExit = null;
            while (effect != null) {
                try {
                    Exit exit;
                    Chunk<ZIO.EvaluationStep> localStack = this.reifiedStack.pinch();
                    try {
                        exit = Exit$Success$.MODULE$.apply(this.runLoop(effect, 0, localStack, this._runtimeFlags(), unsafe));
                    }
                    catch (ZIO.ZIOError zioError) {
                        exit = Exit$Failure$.MODULE$.apply(zioError.cause());
                    }
                    Exit.Failure<Object> exit2 = exit;
                    this._runtimeFlags_$eq(RuntimeFlags$.MODULE$.enable(this._runtimeFlags(), RuntimeFlag$WindDown$.MODULE$));
                    ZIO<Object, Nothing$, Object> interruption = this.interruptAllChildren(unsafe);
                    if (interruption == null) {
                        if (this.queue.isEmpty()) {
                            finalExit = exit2;
                            this.setExitValue(exit2, unsafe);
                        } else {
                            this.asyncEffect = exit2;
                            this.tell(FiberMessage$Resume$.MODULE$, unsafe);
                        }
                        effect = null;
                        continue;
                    }
                    effect = interruption.flatMap((Function1 & Serializable)_$6 -> exit2, this.id().location());
                }
                catch (ReifyStack.Trampoline trampoline) {
                    if ((++trampolines >= FiberRuntime$.MODULE$.MaxTrampolinesBeforeYield() || trampoline.forceYield()) && RuntimeFlags$.MODULE$.cooperativeYielding(this._runtimeFlags())) {
                        this.asyncEffect = trampoline.effect();
                        this.tell(FiberMessage$YieldNow$.MODULE$, unsafe);
                        this.tell(FiberMessage$Resume$.MODULE$, unsafe);
                        effect = null;
                        continue;
                    }
                    effect = trampoline.effect();
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (ReifyStack$AsyncJump$.MODULE$.equals(throwable2)) {
                        effect = null;
                        continue;
                    }
                    if (ReifyStack$GenerateTrace$.MODULE$.equals(throwable2)) {
                        effect = ZIO$.MODULE$.succeedNow(this.generateStackTrace());
                        continue;
                    }
                    if (throwable2 != null) {
                        Throwable t = throwable2;
                        if (this.isFatal(t, unsafe)) {
                            throw this.handleFatalError(t);
                        }
                        Cause<Nothing$> death = Cause$.MODULE$.die(t, Cause$.MODULE$.die$default$2());
                        this.log((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(58).append("An unhandled error was encountered on fiber ").append(this.id().threadName()).append(", created at ").append(this.id().location()).append(".").toString(), (Cause<Object>)death, (Option<LogLevel>)ZIO$.MODULE$.someError(), this.id().location(), unsafe);
                        effect = null;
                        continue;
                    }
                    throw throwable;
                }
            }
            failure = finalExit;
        }
        finally {
            this.getSupervisor(unsafe).onSuspend(this, unsafe);
        }
        return failure;
    }

    private EvaluationSignal evaluateMessageWhileSuspended(FiberMessage fiberMessage, Unsafe unsafe) {
        Mirror.Singleton singleton;
        if (!this.running.get()) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        FiberMessage fiberMessage2 = fiberMessage;
        if (fiberMessage2 instanceof FiberMessage.InterruptSignal) {
            Cause<Nothing$> cause;
            FiberMessage.InterruptSignal interruptSignal = FiberMessage$InterruptSignal$.MODULE$.unapply((FiberMessage.InterruptSignal)fiberMessage2);
            Cause<Nothing$> cause2 = cause = interruptSignal._1();
            this.processNewInterruptSignal(cause2, unsafe);
            if (this.asyncInterruptor != null) {
                this.asyncInterruptor.apply(Exit$Failure$.MODULE$.apply(cause2));
                this.asyncInterruptor = null;
            }
            singleton = FiberRuntime$EvaluationSignal$Continue$.MODULE$;
        } else if (fiberMessage2 instanceof FiberMessage.GenStackTrace) {
            Function1<StackTrace, BoxedUnit> function1;
            FiberMessage.GenStackTrace genStackTrace = FiberMessage$GenStackTrace$.MODULE$.unapply((FiberMessage.GenStackTrace)fiberMessage2);
            Function1<StackTrace, BoxedUnit> onTrace = function1 = genStackTrace._1();
            onTrace.apply((Object)this.generateStackTrace());
            singleton = FiberRuntime$EvaluationSignal$Continue$.MODULE$;
        } else if (fiberMessage2 instanceof FiberMessage.Stateful) {
            Function2<FiberRuntime<?, ?>, Fiber.Status, BoxedUnit> function2;
            FiberMessage.Stateful stateful = FiberMessage$Stateful$.MODULE$.unapply((FiberMessage.Stateful)fiberMessage2);
            Function2<FiberRuntime<?, ?>, Fiber.Status, BoxedUnit> onFiber = function2 = stateful._1();
            Fiber$Status$Done$ status = this._exitValue() != null ? Fiber$Status$Done$.MODULE$ : (Fiber.Status)(this.asyncTrace == null ? Fiber$Status$Running$.MODULE$.apply(this._runtimeFlags(), Trace$.MODULE$.empty()) : Fiber$Status$Suspended$.MODULE$.apply(this._runtimeFlags(), this.asyncTrace, this.asyncBlockingOn));
            this.processStatefulMessage(onFiber, status, unsafe);
            singleton = FiberRuntime$EvaluationSignal$Continue$.MODULE$;
        } else if (FiberMessage$Resume$.MODULE$.equals(fiberMessage2)) {
            ZIO<Object, Object, Object> nextEffect = this.asyncEffect;
            this.asyncInterruptor = null;
            this.asyncTrace = null;
            this.asyncBlockingOn = null;
            this.asyncEffect = null;
            this.evaluateEffect(nextEffect, unsafe);
            singleton = FiberRuntime$EvaluationSignal$Continue$.MODULE$;
        } else if (FiberMessage$YieldNow$.MODULE$.equals(fiberMessage2)) {
            singleton = FiberRuntime$EvaluationSignal$YieldNow$.MODULE$;
        } else {
            throw new MatchError((Object)fiberMessage2);
        }
        return singleton;
    }

    public Exit<E, A> exitValue(Unsafe unsafe) {
        return this._exitValue();
    }

    private StackTrace generateStackTrace() {
        StackTraceBuilder builder = StackTraceBuilder$.MODULE$.make(Unsafe$.MODULE$.unsafe());
        this.reifiedStack.foreach((Function1)(JProcedure1 & Serializable)k -> builder.$plus$eq(k.trace()));
        builder.$plus$eq(this.id().location());
        return StackTrace$.MODULE$.apply(this.fiberId, builder.result());
    }

    public Set<FiberRuntime<?, ?>> getChildren(Unsafe unsafe) {
        if (this._children == null) {
            this._children = Platform$.MODULE$.newWeakSet(unsafe);
        }
        return this._children;
    }

    public Executor getCurrentExecutor(Unsafe unsafe) {
        return (Executor)this.getFiberRef(FiberRef$.MODULE$.overrideExecutor(), unsafe).getOrElse(FiberRuntime::getCurrentExecutor$$anonfun$1);
    }

    public <A> A getFiberRef(FiberRef<A> fiberRef, Unsafe unsafe) {
        return this._fiberRefs.getOrDefault(fiberRef);
    }

    public <A> A getFiberRefOrElse(FiberRef<A> fiberRef, Function0<A> orElse, Unsafe unsafe) {
        return (A)this._fiberRefs.get(fiberRef).getOrElse(orElse);
    }

    public <A> Option<A> getFiberRefOption(FiberRef<A> fiberRef, Unsafe unsafe) {
        return this._fiberRefs.get(fiberRef);
    }

    public FiberRefs getFiberRefs(Unsafe unsafe) {
        return this._fiberRefs;
    }

    public Cause<Nothing$> getInterruptedCause(Unsafe unsafe) {
        return this.getFiberRef(FiberRef$.MODULE$.interruptedCause(), unsafe);
    }

    public scala.collection.immutable.Set<ZLogger<String, Object>> getLoggers(Unsafe unsafe) {
        return (scala.collection.immutable.Set)this.getFiberRef(FiberRef$.MODULE$.currentLoggers(), unsafe);
    }

    public Function1<Throwable, Nothing$> getReportFatal(Unsafe unsafe) {
        return this.getFiberRef(FiberRef$.MODULE$.currentReportFatal(), unsafe);
    }

    public Supervisor<Object> getSupervisor(Unsafe unsafe) {
        return (Supervisor)this.getFiberRef(FiberRef$.MODULE$.currentSupervisor(), unsafe);
    }

    private Nothing$ handleFatalError(Throwable throwable) {
        FiberRuntime$.MODULE$.catastrophicFailure().set(true);
        throwable.printStackTrace();
        throw throwable;
    }

    private void initiateAsync(int runtimeFlags, Function1<Function1<ZIO<Object, Object, Object>, BoxedUnit>, Object> asyncRegister, Unsafe unsafe) {
        AtomicBoolean alreadyCalled = new AtomicBoolean(false);
        JProcedure1 & Serializable callback = (JProcedure1 & Serializable)effect -> {
            if (alreadyCalled.compareAndSet(false, true)) {
                this.asyncEffect = effect;
                this.tell(FiberMessage$Resume$.MODULE$, unsafe);
            } else {
                String msg = new StringBuilder(81).append("An async callback was invoked more than once, which could be a sign of a defect: ").append(effect).toString();
                this.log((Function0<String>)(Function0 & Serializable)() -> msg, (Cause<Object>)Cause$.MODULE$.empty(), (Option<LogLevel>)ZIO$.MODULE$.someDebug(), this.asyncTrace, unsafe);
            }
        };
        if (RuntimeFlags$.MODULE$.interruptible(runtimeFlags)) {
            this.asyncInterruptor = callback;
        }
        try {
            asyncRegister.apply((Object)callback);
        }
        catch (Throwable throwable) {
            if (this.isFatal(throwable, unsafe)) {
                throw this.handleFatalError(throwable);
            }
            callback.apply(Exit$Failure$.MODULE$.apply(Cause$.MODULE$.die(throwable, Cause$.MODULE$.die$default$2())));
        }
    }

    private ZIO<Object, Nothing$, Object> interruptAllChildren(Unsafe unsafe) {
        ZIO zIO;
        if (this.sendInterruptSignalToAllChildren(unsafe)) {
            Iterator<FiberRuntime<?, ?>> iterator = this._children.iterator();
            this._children = null;
            Function0 & Serializable body = (Function0 & Serializable)() -> {
                FiberRuntime next = (FiberRuntime)iterator.next();
                return next != null ? next.await(this.id().location()) : ZIO$.MODULE$.unit();
            };
            zIO = ZIO$.MODULE$.whileLoop((Function0<Object>)((Function0 & Serializable)() -> FiberRuntime.interruptAllChildren$$anonfun$1(iterator)), body, (Function1 & Serializable)_$7 -> BoxedUnit.UNIT, this.id().location());
        } else {
            zIO = null;
        }
        return zIO;
    }

    public boolean isFatal(Throwable t, Unsafe unsafe) {
        return ((IsFatal)this.getFiberRef(FiberRef$.MODULE$.currentFatal(), unsafe)).apply(t);
    }

    public boolean isInterrupted(Unsafe unsafe) {
        return !this.getFiberRef(FiberRef$.MODULE$.interruptedCause(), unsafe).isEmpty();
    }

    public void log(Function0<String> message, Cause<Object> cause, Option<LogLevel> overrideLogLevel, Object trace, Unsafe unsafe) {
        LogLevel logLevel = overrideLogLevel.isDefined() ? (LogLevel)overrideLogLevel.get() : this.getFiberRef(FiberRef$.MODULE$.currentLogLevel(), unsafe);
        List<LogSpan> spans = this.getFiberRef(FiberRef$.MODULE$.currentLogSpan(), unsafe);
        Map<String, String> annotations = this.getFiberRef(FiberRef$.MODULE$.currentLogAnnotations(), unsafe);
        scala.collection.immutable.Set<ZLogger<String, Object>> loggers = this.getLoggers(unsafe);
        FiberRefs contextMap = this.getFiberRefs(unsafe);
        loggers.foreach((Function1 & Serializable)logger -> logger.apply(trace, this.fiberId, logLevel, message, cause, contextMap, spans, annotations));
    }

    private void processStatefulMessage(Function2<FiberRuntime<?, ?>, Fiber.Status, BoxedUnit> onFiber, Fiber.Status status, Unsafe unsafe) {
        try {
            onFiber.apply((Object)this, (Object)status);
        }
        catch (Throwable throwable) {
            if (this.isFatal(throwable, unsafe)) {
                throw this.handleFatalError(throwable);
            }
            this.log((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(90).append("An unexpected error was encountered while processing statefulf iber message with callback ").append(onFiber).toString(), (Cause<Object>)Cause$.MODULE$.die(throwable, Cause$.MODULE$.die$default$2()), (Option<LogLevel>)ZIO$.MODULE$.someError(), this.id().location(), unsafe);
        }
    }

    private int patchRuntimeFlags(int oldRuntimeFlags, long patch) {
        int newRuntimeFlags = RuntimeFlags$.MODULE$.patch(patch, oldRuntimeFlags);
        if (RuntimeFlags$Patch$.MODULE$.isEnabled(patch, RuntimeFlag$CurrentFiber$.MODULE$)) {
            Fiber$.MODULE$._currentFiber().set(this);
        } else if (RuntimeFlags$Patch$.MODULE$.isDisabled(patch, RuntimeFlag$CurrentFiber$.MODULE$)) {
            Fiber$.MODULE$._currentFiber().set(null);
        }
        this._runtimeFlags_$eq(newRuntimeFlags);
        return newRuntimeFlags;
    }

    private void processNewInterruptSignal(Cause<Nothing$> cause, Unsafe unsafe) {
        this.addInterruptedCause(cause, unsafe);
        this.sendInterruptSignalToAllChildren(unsafe);
    }

    public void removeChild(FiberRuntime<?, ?> child, Unsafe unsafe) {
        if (this._children != null) {
            this._children.remove(child);
        }
    }

    public void removeObserver(Function1<Exit<E, A>, BoxedUnit> observer, Unsafe unsafe) {
        this.observers = this.observers.filter((Function1 & Serializable)_$8 -> _$8 != observer);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private Object runLoop(ZIO<Object, Object, Object> effect, int currentDepth, Chunk<ZIO.EvaluationStep> localStack, int runtimeFlags0, Unsafe unsafe) {
        if (!this.running.get()) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        cur /* !! */  = effect;
        done = null;
        stackIndex = 0;
        runtimeFlags = runtimeFlags0;
        lastTrace = Trace$.MODULE$.empty();
        ops = 0;
        if (currentDepth >= 500) {
            this.reifiedStack.ensureCapacity(currentDepth);
            this.reifiedStack.$plus$plus$eq(localStack);
            throw ReifyStack$Trampoline$.MODULE$.apply(effect, false);
        }
        while (cur /* !! */  != null) {
            block73: {
                block72: {
                    block71: {
                        block70: {
                            block69: {
                                if (RuntimeFlags$.MODULE$.opSupervision(runtimeFlags)) {
                                    this.getSupervisor(unsafe).onEffect(this, cur /* !! */ , unsafe);
                                }
                                if ((nextTrace = cur /* !! */ .trace()) != Trace$.MODULE$.empty()) {
                                    lastTrace = nextTrace;
                                }
                                cur /* !! */  = this.drainQueueWhileRunning(runtimeFlags, lastTrace, cur /* !! */ , unsafe);
                                if (++ops > FiberRuntime$.MODULE$.MaxOperationsBeforeYield()) {
                                    ops = 0;
                                    oldCur = cur /* !! */ ;
                                    trace = lastTrace;
                                    cur /* !! */  = ZIO$.MODULE$.yieldNow(trace).flatMap((Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, runLoop$$anonfun$1(zio.ZIO scala.runtime.BoxedUnit ), (Lscala/runtime/BoxedUnit;)Lzio/ZIO;)(oldCur), trace);
                                    continue;
                                }
                                var15_15 = cur /* !! */ ;
                                if (!(var15_15 instanceof ZIO.OnSuccess)) ** GOTO lbl41
                                effect = effect0 = (ZIO.OnSuccess)var15_15;
                                try {
                                    v0 /* !! */  = (ZIO)effect.successK().apply(this.runLoop(effect.first(), currentDepth + 1, (Chunk<ZIO.EvaluationStep>)Chunk$.MODULE$.empty(), runtimeFlags, unsafe));
                                }
                                catch (ZIO.ZIOError zioError) {
                                    v0 /* !! */  = Exit$Failure$.MODULE$.apply(zioError.cause());
                                }
                                catch (ReifyStack reifyStack) {
                                    this.reifiedStack.$plus$eq(effect);
                                    throw reifyStack;
                                }
                                cur /* !! */  = v0 /* !! */ ;
                                continue;
lbl41:
                                // 1 sources

                                if (var15_15 instanceof ZIO.Sync) {
                                    effect = (ZIO.Sync)var15_15;
                                    try {
                                        value = effect.eval().apply();
                                        cur /* !! */  = null;
                                        while (cur /* !! */  == null && stackIndex < localStack.length()) {
                                            element = (ZIO.EvaluationStep)localStack.apply(stackIndex);
                                            ++stackIndex;
                                            var23_22 = element;
                                            if (var23_22 instanceof ZIO.OnSuccess) {
                                                k = (ZIO.OnSuccess)var23_22;
                                                cur /* !! */  = (Exit.Failure<Nothing$>)k.successK().apply(value);
                                                continue;
                                            }
                                            if (var23_22 instanceof ZIO.OnSuccessAndFailure) {
                                                k = (ZIO.OnSuccessAndFailure)var23_22;
                                                cur /* !! */  = (ZIO)k.successK().apply(value);
                                                continue;
                                            }
                                            if (var23_22 instanceof ZIO.OnFailure) {
                                                k = (ZIO.OnFailure)var23_22;
                                                continue;
                                            }
                                            if (var23_22 instanceof ZIO.EvaluationStep.UpdateRuntimeFlags) {
                                                k = (ZIO.EvaluationStep.UpdateRuntimeFlags)var23_22;
                                                if (!RuntimeFlags$.MODULE$.interruptible(runtimeFlags = this.patchRuntimeFlags(runtimeFlags, k.update())) || !this.isInterrupted(unsafe)) continue;
                                                cur /* !! */  = Exit$Failure$.MODULE$.apply(this.getInterruptedCause(unsafe));
                                                continue;
                                            }
                                            if (var23_22 instanceof ZIO.EvaluationStep.UpdateTrace) {
                                                k = (ZIO.EvaluationStep.UpdateTrace)var23_22;
                                                if (k.trace() == Trace$.MODULE$.empty()) continue;
                                                lastTrace = k.trace();
                                                continue;
                                            }
                                            throw new MatchError((Object)var23_22);
                                        }
                                        if (cur /* !! */  != null) continue;
                                        done = value;
                                    }
                                    catch (ZIO.ZIOError zioError) {
                                        cur /* !! */  = zioError.toEffect(effect.trace());
                                    }
                                    continue;
                                }
                                if (!(var15_15 instanceof ZIO.OnFailure)) ** GOTO lbl92
                                effect = effect0 = (ZIO.OnFailure)var15_15;
                                try {
                                    v1 = Exit$Success$.MODULE$.apply(this.runLoop(effect.first(), currentDepth + 1, (Chunk<ZIO.EvaluationStep>)Chunk$.MODULE$.empty(), runtimeFlags, unsafe));
                                }
                                catch (ZIO.ZIOError zioError) {
                                    v1 = effect.onFailure(zioError.cause());
                                }
                                catch (ReifyStack reifyStack) {
                                    this.reifiedStack.$plus$eq(effect);
                                    throw reifyStack;
                                }
                                cur /* !! */  = v1;
                                continue;
lbl92:
                                // 1 sources

                                if (!(var15_15 instanceof ZIO.OnSuccessAndFailure)) ** GOTO lbl106
                                effect = effect0 = (ZIO.OnSuccessAndFailure)var15_15;
                                try {
                                    v2 = (ZIO)effect.successK().apply(this.runLoop(effect.first(), currentDepth + 1, (Chunk<ZIO.EvaluationStep>)Chunk$.MODULE$.empty(), runtimeFlags, unsafe));
                                }
                                catch (ZIO.ZIOError zioError) {
                                    v2 = (Exit.Failure<Nothing$>)effect.failureK().apply(zioError.cause());
                                }
                                catch (ReifyStack reifyStack) {
                                    this.reifiedStack.$plus$eq(effect);
                                    throw reifyStack;
                                }
                                cur /* !! */  = v2;
                                continue;
lbl106:
                                // 1 sources

                                if (!(var15_15 instanceof ZIO.Async)) break block69;
                                effect = (ZIO.Async)var15_15;
                                this.reifiedStack.ensureCapacity(currentDepth);
                                this.asyncTrace = lastTrace;
                                this.asyncBlockingOn = (FiberId)effect.blockingOn().apply();
                                this.initiateAsync(runtimeFlags, effect.registerCallback(), unsafe);
                                throw ReifyStack$AsyncJump$.MODULE$;
                            }
                            if (!(var15_15 instanceof ZIO.UpdateRuntimeFlagsWithin)) ** GOTO lbl142
                            effect = (ZIO.UpdateRuntimeFlagsWithin)var15_15;
                            updateFlags = effect.update();
                            newRuntimeFlags = RuntimeFlags$.MODULE$.patch(updateFlags, oldRuntimeFlags = runtimeFlags);
                            if (newRuntimeFlags == oldRuntimeFlags) {
                                v3 /* !! */  = effect.scope(oldRuntimeFlags);
                                break block70;
                            }
                            if (RuntimeFlags$.MODULE$.interruptible(newRuntimeFlags) && this.isInterrupted(unsafe)) {
                                v3 /* !! */  = Exit$Failure$.MODULE$.apply(this.getInterruptedCause(unsafe));
                                break block70;
                            }
                            runtimeFlags = this.patchRuntimeFlags(runtimeFlags, updateFlags);
                            revertFlags = RuntimeFlags$.MODULE$.diff(newRuntimeFlags, oldRuntimeFlags);
                            try {
                                value = this.runLoop(effect.scope(oldRuntimeFlags), currentDepth + 1, (Chunk<ZIO.EvaluationStep>)Chunk$.MODULE$.empty(), runtimeFlags, unsafe);
                                runtimeFlags = this.patchRuntimeFlags(runtimeFlags, revertFlags);
                                v3 /* !! */  = RuntimeFlags$.MODULE$.interruptible(runtimeFlags) && this.isInterrupted(unsafe) ? Exit$Failure$.MODULE$.apply(this.getInterruptedCause(unsafe)) : Exit$Success$.MODULE$.apply(value);
                            }
                            catch (ZIO.ZIOError zioError) {
                                v3 /* !! */  = Exit$Failure$.MODULE$.apply(zioError.cause());
                            }
                            catch (ReifyStack reifyStack) {
                                this.reifiedStack.$plus$eq(ZIO$EvaluationStep$UpdateRuntimeFlags$.MODULE$.apply(revertFlags));
                                throw reifyStack;
                            }
                        }
                        cur /* !! */  = v3 /* !! */ ;
                        continue;
lbl142:
                        // 1 sources

                        if (!(var15_15 instanceof ZIO.GenerateStackTrace)) break block71;
                        generateStackTrace = (ZIO.GenerateStackTrace)var15_15;
                        this.reifiedStack.$plus$eq(ZIO$EvaluationStep$UpdateTrace$.MODULE$.apply(generateStackTrace.trace()));
                        throw ReifyStack$GenerateTrace$.MODULE$;
                    }
                    if (var15_15 instanceof ZIO.Stateful) {
                        stateful = (ZIO.Stateful)var15_15;
                        try {
                            v4 = (Exit.Failure<Nothing$>)stateful.erase().onState().apply((Object)this, (Object)Fiber$Status$Running$.MODULE$.apply(runtimeFlags, lastTrace));
                        }
                        catch (ZIO.ZIOError zioError) {
                            v4 = zioError.toEffect(stateful.trace());
                        }
                        cur /* !! */  = v4;
                        continue;
                    }
                    if (var15_15 instanceof Exit.Success) {
                        success = (Exit.Success)var15_15;
                        value = success.value();
                        cur /* !! */  = null;
                        while (cur /* !! */  == null && stackIndex < localStack.length()) {
                            element = (ZIO.EvaluationStep)localStack.apply(stackIndex);
                            ++stackIndex;
                            var55_47 = element;
                            if (var55_47 instanceof ZIO.OnSuccess) {
                                k = (ZIO.OnSuccess)var55_47;
                                cur /* !! */  = (ZIO)k.successK().apply(value);
                                continue;
                            }
                            if (var55_47 instanceof ZIO.OnSuccessAndFailure) {
                                k = (ZIO.OnSuccessAndFailure)var55_47;
                                cur /* !! */  = (ZIO)k.successK().apply(value);
                                continue;
                            }
                            if (var55_47 instanceof ZIO.OnFailure) {
                                k = (ZIO.OnFailure)var55_47;
                                continue;
                            }
                            if (var55_47 instanceof ZIO.EvaluationStep.UpdateRuntimeFlags) {
                                k = (ZIO.EvaluationStep.UpdateRuntimeFlags)var55_47;
                                if (!RuntimeFlags$.MODULE$.interruptible(runtimeFlags = this.patchRuntimeFlags(runtimeFlags, k.update())) || !this.isInterrupted(unsafe)) continue;
                                cur /* !! */  = Exit$Failure$.MODULE$.apply(this.getInterruptedCause(unsafe));
                                continue;
                            }
                            if (var55_47 instanceof ZIO.EvaluationStep.UpdateTrace) {
                                k = (ZIO.EvaluationStep.UpdateTrace)var55_47;
                                if (k.trace() == Trace$.MODULE$.empty()) continue;
                                lastTrace = k.trace();
                                continue;
                            }
                            throw new MatchError((Object)var55_47);
                        }
                        if (cur /* !! */  != null) continue;
                        done = value;
                        continue;
                    }
                    if (var15_15 instanceof Exit.Failure) {
                        failure = (Exit.Failure)var15_15;
                        cause = failure.cause();
                        cur /* !! */  = null;
                        while (cur /* !! */  == null && stackIndex < localStack.length()) {
                            element = (ZIO.EvaluationStep)localStack.apply(stackIndex);
                            ++stackIndex;
                            var64_56 = element;
                            if (var64_56 instanceof ZIO.OnSuccess) {
                                k = (ZIO.OnSuccess)var64_56;
                                continue;
                            }
                            if (var64_56 instanceof ZIO.OnSuccessAndFailure) {
                                k = (ZIO.OnSuccessAndFailure)var64_56;
                                if (!RuntimeFlags$.MODULE$.interruptible(runtimeFlags) || !this.isInterrupted(unsafe)) {
                                    cur /* !! */  = (ZIO)k.failureK().apply(cause);
                                    continue;
                                }
                                cause = cause.stripFailures();
                                continue;
                            }
                            if (var64_56 instanceof ZIO.OnFailure) {
                                k = (ZIO.OnFailure)var64_56;
                                if (!RuntimeFlags$.MODULE$.interruptible(runtimeFlags) || !this.isInterrupted(unsafe)) {
                                    cur /* !! */  = (ZIO)k.failureK().apply(cause);
                                    continue;
                                }
                                cause = cause.stripFailures();
                                continue;
                            }
                            if (var64_56 instanceof ZIO.EvaluationStep.UpdateRuntimeFlags) {
                                k = (ZIO.EvaluationStep.UpdateRuntimeFlags)var64_56;
                                if (!RuntimeFlags$.MODULE$.interruptible(runtimeFlags = this.patchRuntimeFlags(runtimeFlags, k.update())) || !this.isInterrupted(unsafe)) continue;
                                cur /* !! */  = Exit$Failure$.MODULE$.apply(cause.$plus$plus(this.getInterruptedCause(unsafe)));
                                continue;
                            }
                            if (var64_56 instanceof ZIO.EvaluationStep.UpdateTrace) {
                                k = (ZIO.EvaluationStep.UpdateTrace)var64_56;
                                if (k.trace() == Trace$.MODULE$.empty()) continue;
                                lastTrace = k.trace();
                                continue;
                            }
                            throw new MatchError((Object)var64_56);
                        }
                        if (cur /* !! */  != null) continue;
                        throw ZIO$ZIOError$.MODULE$.apply(cause);
                    }
                    if (!(var15_15 instanceof ZIO.UpdateRuntimeFlags)) ** GOTO lbl238
                    updateRuntimeFlags = (ZIO.UpdateRuntimeFlags)var15_15;
                    runtimeFlags = this.patchRuntimeFlags(runtimeFlags, updateRuntimeFlags.update());
                    if (currentDepth <= 0) break block72;
                    this.reifiedStack.ensureCapacity(currentDepth);
                    throw ReifyStack$Trampoline$.MODULE$.apply(ZIO$.MODULE$.unit(), false);
                }
                cur /* !! */  = ZIO$.MODULE$.unit();
                continue;
lbl238:
                // 1 sources

                if (!(var15_15 instanceof ZIO.WhileLoop)) ** GOTO lbl257
                iterate = iterate0 = (ZIO.WhileLoop)var15_15;
                check = iterate.check();
                try {
                    while (check.apply$mcZ$sp()) {
                        result = this.runLoop((ZIO)iterate.body().apply(), currentDepth + 1, (Chunk<ZIO.EvaluationStep>)Chunk$.MODULE$.empty(), runtimeFlags, unsafe);
                        iterate.process().apply(result);
                    }
                    cur /* !! */  = ZIO$.MODULE$.unit();
                }
                catch (ZIO.ZIOError zioError) {
                    cur /* !! */  = Exit$Failure$.MODULE$.apply(zioError.cause());
                }
                catch (ReifyStack reifyStack) {
                    this.reifiedStack.$plus$eq(ZIO$EvaluationStep$Continuation$.MODULE$.fromSuccess((Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, runLoop$$anonfun$2(zio.ZIO$WhileLoop java.lang.Object ), (Ljava/lang/Object;)Lzio/ZIO;)((ZIO.WhileLoop)iterate), iterate.trace()));
                    throw reifyStack;
                }
                continue;
lbl257:
                // 1 sources

                if (!(var15_15 instanceof ZIO.YieldNow)) break block73;
                yieldNow = (ZIO.YieldNow)var15_15;
                this.reifiedStack.$plus$eq(ZIO$EvaluationStep$UpdateTrace$.MODULE$.apply(yieldNow.trace()));
                throw ReifyStack$Trampoline$.MODULE$.apply(ZIO$.MODULE$.unit(), true);
            }
            try {
                throw new MatchError(var15_15);
            }
            catch (ZIO.ZIOError zioError) {
                if (stackIndex < localStack.length()) {
                    throw Scala3RunTime$.MODULE$.assertFailed();
                }
                throw zioError;
            }
            catch (ReifyStack reifyStack) {
                if (stackIndex < localStack.length()) {
                    this.reifiedStack.$plus$plus$eq((Chunk<ZIO.EvaluationStep>)localStack.drop(stackIndex));
                }
                throw reifyStack;
            }
            catch (InterruptedException interruptedException) {
                cur /* !! */  = Exit$Failure$.MODULE$.apply(Cause$.MODULE$.die(interruptedException, Cause$.MODULE$.die$default$2()).$plus$plus(Cause$.MODULE$.interrupt(FiberId$None$.MODULE$, Cause$.MODULE$.interrupt$default$2())));
            }
            catch (Throwable throwable) {
                if (this.isFatal(throwable, unsafe)) {
                    throw this.handleFatalError(throwable);
                }
                cur /* !! */  = Exit$Failure$.MODULE$.apply(Cause$.MODULE$.die(throwable, Cause$.MODULE$.die$default$2()));
            }
        }
        return done;
    }

    /*
     * WARNING - void declaration
     */
    private boolean sendInterruptSignalToAllChildren(Unsafe unsafe) {
        boolean bl;
        if (this._children == null || this._children.isEmpty()) {
            bl = false;
        } else {
            void var3_3;
            Iterator<FiberRuntime<?, ?>> iterator = this._children.iterator();
            boolean told = false;
            while (iterator.hasNext()) {
                FiberRuntime<?, ?> next = iterator.next();
                if (next == null) continue;
                next.tell(FiberMessage$InterruptSignal$.MODULE$.apply(Cause$.MODULE$.interrupt(this.id(), Cause$.MODULE$.interrupt$default$2())), unsafe);
                told = true;
            }
            bl = var3_3;
        }
        return bl;
    }

    private void setExitValue(Exit<E, A> e, Unsafe unsafe) {
        this._exitValue_$eq(e);
        if (RuntimeFlags$.MODULE$.runtimeMetrics(this._runtimeFlags())) {
            long startTimeMillis = this.fiberId.startTimeMillis();
            long endTimeMillis = System.currentTimeMillis();
            double lifetime = (double)(endTimeMillis - startTimeMillis) / 1000.0;
            Metric.UnsafeAPI unsafeAPI = Metric$runtime$.MODULE$.fiberLifetimes().unsafe();
            unsafeAPI.update(BoxesRunTime.boxToDouble((double)lifetime), unsafeAPI.update$default$2(), unsafe);
        }
        this.reportExitValue$1(e, unsafe);
        for (Function1 observer : this.observers) {
            observer.apply(e);
        }
        this.observers = package$.MODULE$.Nil();
    }

    public <A> void setFiberRef(FiberRef<A> fiberRef, A value, Unsafe unsafe) {
        this._fiberRefs = this._fiberRefs.updatedAs(this.fiberId, fiberRef, value);
    }

    public void setFiberRefs(FiberRefs fiberRefs0, Unsafe unsafe) {
        this._fiberRefs = fiberRefs0;
    }

    public <R> Exit<E, A> start(ZIO<R, E, A> effect, Unsafe unsafe) {
        Exit<E, A> exit;
        if (this.running.compareAndSet(false, true)) {
            try {
                exit = this.evaluateEffect(effect, unsafe);
            }
            finally {
                this.running.set(false);
                if (!this.queue.isEmpty() && this.running.compareAndSet(false, true)) {
                    this.drainQueueLaterOnExecutor(unsafe);
                }
            }
        } else {
            this.asyncEffect = effect;
            this.tell(FiberMessage$Resume$.MODULE$, unsafe);
            exit = null;
        }
        return exit;
    }

    public <R> void startFork(ZIO<R, E, A> effect, Unsafe unsafe) {
        this.asyncEffect = effect;
        this.tell(FiberMessage$Resume$.MODULE$, unsafe);
    }

    public void tell(FiberMessage message, Unsafe unsafe) {
        this.queue.add(message);
        if (this.running.compareAndSet(false, true)) {
            this.drainQueueLaterOnExecutor(unsafe);
        }
    }

    public <A> void updateFiberRef(FiberRef<A> fiberRef, Function1<A, A> f, Unsafe unsafe) {
        this.setFiberRef(fiberRef, f.apply(this.getFiberRef(fiberRef, unsafe)), unsafe);
    }

    @Override
    public Fiber.Runtime.UnsafeAPI unsafe() {
        return new Fiber.Runtime.UnsafeAPI(this){
            private final /* synthetic */ FiberRuntime $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void addObserver(Function1 observer, Unsafe unsafe) {
                this.$outer.addObserver(observer, unsafe);
            }

            public void deleteFiberRef(FiberRef ref, Unsafe unsafe) {
                this.$outer.deleteFiberRef(ref, unsafe);
            }

            public FiberRefs getFiberRefs(Unsafe unsafe) {
                return this.$outer.getFiberRefs(unsafe);
            }

            public void removeObserver(Function1 observer, Unsafe unsafe) {
                this.$outer.removeObserver(observer, unsafe);
            }
        };
    }

    private final FiberId.Runtime await$$anonfun$2() {
        return this.id();
    }

    private static final /* synthetic */ ZIO inheritAll$$anonfun$1$$anonfun$1(Object trace$3, int parentRuntimeFlags$1, int childRuntimeFlags) {
        long patch = RuntimeFlags$Patch$.MODULE$.exclude(RuntimeFlags$Patch$.MODULE$.exclude(RuntimeFlags$.MODULE$.diff(parentRuntimeFlags$1, childRuntimeFlags), RuntimeFlag$WindDown$.MODULE$), RuntimeFlag$Interruption$.MODULE$);
        return ZIO$.MODULE$.updateRuntimeFlags(patch, trace$3);
    }

    private final ZIO trace$$anonfun$1(Object trace$5) {
        Promise promise = Promise$unsafe$.MODULE$.make(this.fiberId, Unsafe$.MODULE$.unsafe());
        this.tell(FiberMessage$GenStackTrace$.MODULE$.apply((Function1<StackTrace, BoxedUnit>)(JProcedure1 & Serializable)trace -> promise.unsafe().done(ZIO$.MODULE$.succeedNow(trace), Unsafe$.MODULE$.unsafe())), Unsafe$.MODULE$.unsafe());
        return promise.await(trace$5);
    }

    private static final Executor getCurrentExecutor$$anonfun$1() {
        return Runtime$.MODULE$.defaultExecutor();
    }

    private static final boolean interruptAllChildren$$anonfun$1(Iterator iterator$2) {
        return iterator$2.hasNext();
    }

    private static final /* synthetic */ ZIO runLoop$$anonfun$1(ZIO oldCur$3, BoxedUnit _$9) {
        return oldCur$3;
    }

    private static final /* synthetic */ ZIO runLoop$$anonfun$2(ZIO.WhileLoop iterate$1, Object element) {
        iterate$1.process().apply(element);
        return iterate$1;
    }

    private final void reportExitValue$1(Exit v, Unsafe unsafe) {
        block5: {
            block6: {
                Cause<Object> cause;
                Exit exit = v;
                if (!(exit instanceof Exit.Failure)) break block6;
                Exit.Failure failure = Exit$Failure$.MODULE$.unapply((Exit.Failure)exit);
                Cause<Object> cause2 = cause = failure._1();
                try {
                    if (!cause2.isInterruptedOnly()) {
                        this.log((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("Fiber ").append(this.fiberId.threadName()).append(" did not handle an error").toString(), cause2, this.getFiberRef(FiberRef$.MODULE$.unhandledErrorLogLevel(), unsafe), this.id().location(), unsafe);
                    }
                    if (RuntimeFlags$.MODULE$.runtimeMetrics(this._runtimeFlags())) {
                        Metric.UnsafeAPI unsafeAPI = Metric$runtime$.MODULE$.fiberFailures().unsafe();
                        unsafeAPI.update(BoxesRunTime.boxToLong((long)1L), unsafeAPI.update$default$2(), unsafe);
                        cause2.foldContext(BoxedUnit.UNIT, FiberRuntime$.zio$internal$FiberRuntime$$$fiberFailureTracker);
                    }
                    break block5;
                }
                catch (Throwable throwable) {
                    if (this.isFatal(throwable, unsafe)) {
                        throw this.handleFatalError(throwable);
                    }
                    Predef$.MODULE$.println((Object)"An exception was thrown by a logger:");
                    throwable.printStackTrace();
                }
                break block5;
            }
            if (!RuntimeFlags$.MODULE$.runtimeMetrics(this._runtimeFlags())) break block5;
            Metric.UnsafeAPI unsafeAPI = Metric$runtime$.MODULE$.fiberSuccesses().unsafe();
            unsafeAPI.update(BoxesRunTime.boxToLong((long)1L), unsafeAPI.update$default$2(), unsafe);
        }
    }

    public static interface EvaluationSignal {
        public static int ordinal(EvaluationSignal evaluationSignal) {
            return FiberRuntime$EvaluationSignal$.MODULE$.ordinal(evaluationSignal);
        }
    }
}

