/*
 * Decompiled with CFR 0.152.
 */
package zio.internal.metrics;

import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.runtime.ScalaRunTime$;
import zio.Chunk;
import zio.Unsafe;
import zio.internal.metrics.ConcurrentMetricHooks$;
import zio.internal.metrics.MetricHook;
import zio.metrics.MetricKey;
import zio.metrics.MetricKeyType;
import zio.metrics.MetricKeyType$Counter$;
import zio.metrics.MetricKeyType$Frequency$;
import zio.metrics.MetricKeyType$Gauge$;
import zio.metrics.MetricKeyType$Histogram$;
import zio.metrics.MetricKeyType$Summary$;
import zio.metrics.MetricPair;
import zio.metrics.MetricPair$;
import zio.metrics.MetricState;

public class ConcurrentMetricRegistry {
    private final ConcurrentHashMap<MetricKey<MetricKeyType>, MetricHook<?, MetricState<Object>>> map = new ConcurrentHashMap();

    public scala.collection.immutable.Set<MetricPair<MetricKeyType, Object>> snapshot(Unsafe unsafe) {
        Iterator<Map.Entry<MetricKey<MetricKeyType>, MetricHook<?, MetricState<Object>>>> iterator = this.map.entrySet().iterator();
        Set result = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MetricPair[0]));
        while (iterator.hasNext()) {
            Map.Entry<MetricKey<MetricKeyType>, MetricHook<?, MetricState<Object>>> value = iterator.next();
            MetricKey<MetricKeyType> key = value.getKey();
            MetricHook<?, MetricState<Object>> hook = value.getValue();
            result.add(MetricPair$.MODULE$.make(key, (MetricState)hook.get().apply(), unsafe));
        }
        return result.toSet();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <Type extends MetricKeyType> MetricHook<Object, Object> get(MetricKey<Type> key, Unsafe unsafe) {
        MetricHook<Object, MetricState<MetricKeyType$Counter$>> metricHook;
        MetricHook<?, MetricState<Object>> hook0 = this.map.get(key);
        if (hook0 == null) {
            MetricKeyType metricKeyType = key.keyType();
            if (MetricKeyType$Counter$.MODULE$.equals(metricKeyType)) {
                metricHook = this.getCounter(key, unsafe);
                return metricHook;
            } else if (MetricKeyType$Frequency$.MODULE$.equals(metricKeyType)) {
                metricHook = this.getSetCount(key, unsafe);
                return metricHook;
            } else if (MetricKeyType$Gauge$.MODULE$.equals(metricKeyType)) {
                metricHook = this.getGauge(key, unsafe);
                return metricHook;
            } else if (metricKeyType instanceof MetricKeyType.Histogram) {
                MetricKeyType.Histogram histogram = MetricKeyType$Histogram$.MODULE$.unapply((MetricKeyType.Histogram)metricKeyType);
                MetricKeyType.Histogram.Boundaries boundaries = histogram._1();
                metricHook = this.getHistogram(key, unsafe);
                return metricHook;
            } else {
                if (!(metricKeyType instanceof MetricKeyType.Summary)) throw new MatchError((Object)metricKeyType);
                MetricKeyType.Summary summary = MetricKeyType$Summary$.MODULE$.unapply((MetricKeyType.Summary)metricKeyType);
                Duration duration = summary._1();
                int n = summary._2();
                double d = summary._3();
                Chunk<Object> chunk = summary._4();
                metricHook = this.getSummary(key, unsafe);
            }
            return metricHook;
        } else {
            void var3_3;
            metricHook = var3_3;
        }
        return metricHook;
    }

    /*
     * WARNING - void declaration
     */
    private MetricHook<Object, MetricState.Counter> getCounter(MetricKey<MetricKeyType$Counter$> key, Unsafe unsafe) {
        void var3_3;
        MetricHook<?, MetricState<Object>> value = this.map.get(key);
        if (value == null) {
            MetricHook<Object, MetricState.Counter> counter = ConcurrentMetricHooks$.MODULE$.counter(key);
            this.map.putIfAbsent(key, counter);
            value = this.map.get(key);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private MetricHook<Object, MetricState.Gauge> getGauge(MetricKey<MetricKeyType$Gauge$> key, Unsafe unsafe) {
        void var3_3;
        MetricHook<?, MetricState<Object>> value = this.map.get(key);
        if (value == null) {
            MetricHook<Object, MetricState.Gauge> gauge = ConcurrentMetricHooks$.MODULE$.gauge(key, 0.0);
            this.map.putIfAbsent(key, gauge);
            value = this.map.get(key);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private MetricHook<Object, MetricState.Histogram> getHistogram(MetricKey<MetricKeyType.Histogram> key, Unsafe unsafe) {
        void var3_3;
        MetricHook<?, MetricState<Object>> value = this.map.get(key);
        if (value == null) {
            MetricHook<Object, MetricState.Histogram> histogram = ConcurrentMetricHooks$.MODULE$.histogram(key);
            this.map.putIfAbsent(key, histogram);
            value = this.map.get(key);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private MetricHook<Tuple2<Object, Instant>, MetricState.Summary> getSummary(MetricKey<MetricKeyType.Summary> key, Unsafe unsafe) {
        void var3_3;
        MetricHook<?, MetricState<Object>> value = this.map.get(key);
        if (value == null) {
            MetricHook<Tuple2<Object, Instant>, MetricState.Summary> summary = ConcurrentMetricHooks$.MODULE$.summary(key);
            this.map.putIfAbsent(key, summary);
            value = this.map.get(key);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private MetricHook<String, MetricState.Frequency> getSetCount(MetricKey<MetricKeyType$Frequency$> key, Unsafe unsafe) {
        void var3_3;
        MetricHook<?, MetricState<Object>> value = this.map.get(key);
        if (value == null) {
            MetricHook<String, MetricState.Frequency> frequency = ConcurrentMetricHooks$.MODULE$.frequency(key);
            this.map.putIfAbsent(key, frequency);
            value = this.map.get(key);
        }
        return var3_3;
    }
}

