/*
 * Decompiled with CFR 0.152.
 */
package zio.stm;

import java.io.Serializable;
import java.util.HashMap;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.function.JProcedure3;
import zio.Scope;
import zio.Scope$;
import zio.ZIO;
import zio.ZIO$;
import zio.stm.TRef;
import zio.stm.TSemaphore$;
import zio.stm.ZSTM;
import zio.stm.ZSTM$;
import zio.stm.ZSTM$Acquire$;
import zio.stm.ZSTM$Effect$;
import zio.stm.ZSTM$RetryException$;

public final class TSemaphore
implements Serializable {
    private final TRef permits;

    public static ZSTM<Object, Nothing$, TSemaphore> make(Function0<Object> function0, Object object) {
        return TSemaphore$.MODULE$.make(function0, object);
    }

    public static ZIO<Object, Nothing$, TSemaphore> makeCommit(Function0<Object> function0, Object object) {
        return TSemaphore$.MODULE$.makeCommit(function0, object);
    }

    public TSemaphore(TRef<Object> permits) {
        this.permits = permits;
    }

    public TRef<Object> permits() {
        return this.permits;
    }

    public ZSTM<Object, Nothing$, BoxedUnit> acquire() {
        return this.acquireN(1L);
    }

    public ZSTM<Object, Nothing$, BoxedUnit> acquireN(long n) {
        return ZSTM$Effect$.MODULE$.apply((JProcedure3 & Serializable)(journal, _$1, _$2) -> {
            this.assertNonNegative(n);
            long value = BoxesRunTime.unboxToLong((Object)this.permits().unsafeGet((HashMap<TRef<?>, ZSTM.internal.Entry>)journal));
            if (value < n) {
                throw ZSTM$RetryException$.MODULE$;
            }
            this.permits().unsafeSet((HashMap<TRef<?>, ZSTM.internal.Entry>)journal, BoxesRunTime.boxToLong((long)(value - n)));
        });
    }

    public ZSTM<Object, Nothing$, Object> available() {
        return this.permits().get();
    }

    public ZSTM<Object, Nothing$, BoxedUnit> release() {
        return this.releaseN(1L);
    }

    public ZSTM<Object, Nothing$, BoxedUnit> releaseN(long n) {
        return ZSTM$Effect$.MODULE$.apply((JProcedure3 & Serializable)(journal, _$3, _$4) -> {
            this.assertNonNegative(n);
            long current = BoxesRunTime.unboxToLong((Object)this.permits().unsafeGet((HashMap<TRef<?>, ZSTM.internal.Entry>)journal));
            this.permits().unsafeSet((HashMap<TRef<?>, ZSTM.internal.Entry>)journal, BoxesRunTime.boxToLong((long)(current + n)));
        });
    }

    public <R, E, A> ZIO<R, E, A> withPermit(ZIO<R, E, A> zio, Object trace) {
        return this.withPermits(1L, zio, trace);
    }

    public ZIO<Scope, Nothing$, BoxedUnit> withPermitScoped(Object trace) {
        return this.withPermitsScoped(1L, trace);
    }

    public <R, E, A> ZIO<R, E, A> withPermits(long n, ZIO<R, E, A> zio, Object trace) {
        Function0 function0 = ZSTM$.MODULE$.acquireReleaseWith(this.acquireN(n));
        return ZSTM$Acquire$.MODULE$.apply$extension(function0, (Function1 & Serializable)_$5 -> this.releaseN(n).commit(trace)).apply((Function1 & Serializable)_$6 -> zio, trace);
    }

    public ZIO<Scope, Nothing$, BoxedUnit> withPermitsScoped(long n, Object trace) {
        Function0 function0 = ZSTM$.MODULE$.acquireReleaseWith(this.acquireN(n));
        return ZSTM$Acquire$.MODULE$.apply$extension(function0, (Function1 & Serializable)_$7 -> Scope$.MODULE$.addFinalizer((Function0<ZIO<Object, Nothing$, Object>>)((Function0 & Serializable)() -> this.withPermitsScoped$$anonfun$1$$anonfun$1(n, trace)), trace)).apply((Function1 & Serializable)_$8 -> ZIO$.MODULE$.unit(), trace);
    }

    private void assertNonNegative(long n) {
        Predef$.MODULE$.require(n >= 0L, () -> TSemaphore.assertNonNegative$$anonfun$1(n));
    }

    private final ZIO withPermitsScoped$$anonfun$1$$anonfun$1(long n$5, Object trace$3) {
        return this.releaseN(n$5).commit(trace$3);
    }

    private static final String assertNonNegative$$anonfun$1(long n$6) {
        return new StringBuilder(60).append("Unexpected negative value `").append(n$6).append("` passed to acquireN or releaseN.").toString();
    }
}

