/*
 * Decompiled with CFR 0.152.
 */
package zio.internal.metrics;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;
import scala.;
import scala.$less$colon$less$;
import scala.Double$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.StrictOptimizedSeqOps;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import zio.Chunk;
import zio.ChunkBuilder;
import zio.ChunkBuilder$;
import zio.ChunkLike;
import zio.Duration$;
import zio.internal.metrics.ConcurrentMetricHooks;
import zio.internal.metrics.ConcurrentMetricHooksPlatformSpecific$AtomicDouble$;
import zio.internal.metrics.MetricHook;
import zio.internal.metrics.MetricHook$;
import zio.internal.metrics.package$;
import zio.metrics.MetricKey;
import zio.metrics.MetricKeyType;
import zio.metrics.MetricKeyType$Counter$;
import zio.metrics.MetricKeyType$Frequency$;
import zio.metrics.MetricKeyType$Gauge$;
import zio.metrics.MetricState;
import zio.metrics.MetricState$Counter$;
import zio.metrics.MetricState$Frequency$;
import zio.metrics.MetricState$Gauge$;
import zio.metrics.MetricState$Histogram$;
import zio.metrics.MetricState$Summary$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ConcurrentMetricHooksPlatformSpecific
implements ConcurrentMetricHooks {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ConcurrentMetricHooksPlatformSpecific.class.getDeclaredField("0bitmap$1"));
    public long 0bitmap$1;
    private ConcurrentMetricHooksPlatformSpecific$AtomicDouble$ AtomicDouble$lzy1;

    @Override
    public MetricHook<Object, MetricState.Counter> counter(MetricKey<MetricKeyType$Counter$> key) {
        DoubleAdder adder = new DoubleAdder();
        return MetricHook$.MODULE$.apply((JFunction1.mcVD.sp & Serializable)v -> adder.add(v), (Function0 & Serializable)() -> MetricState$Counter$.MODULE$.apply(adder.sum()), (JFunction1.mcVD.sp & Serializable)v -> adder.add(v));
    }

    private void incrementBy(AtomicDouble atomic, double value) {
        boolean loop = true;
        while (loop) {
            double current = atomic.get();
            loop = !atomic.compareAndSet(current, current + value);
        }
    }

    @Override
    public MetricHook<Object, MetricState.Gauge> gauge(MetricKey<MetricKeyType$Gauge$> key, double startAt) {
        AtomicDouble ref = this.AtomicDouble().make(startAt);
        return MetricHook$.MODULE$.apply((JFunction1.mcVD.sp & Serializable)v -> ref.set(v), (Function0 & Serializable)() -> MetricState$Gauge$.MODULE$.apply(ref.get()), (JFunction1.mcVD.sp & Serializable)v -> this.incrementBy(ref, v));
    }

    private void updateMin(AtomicDouble atomic, double value) {
        boolean loop = true;
        while (loop) {
            double current = atomic.get();
            if (value < current) {
                loop = !atomic.compareAndSet(current, value);
                continue;
            }
            loop = false;
        }
    }

    private void updateMax(AtomicDouble atomic, double value) {
        boolean loop = true;
        while (loop) {
            double current = atomic.get();
            if (value > current) {
                loop = !atomic.compareAndSet(current, value);
                continue;
            }
            loop = false;
        }
    }

    @Override
    public MetricHook<Object, MetricState.Histogram> histogram(MetricKey<MetricKeyType.Histogram> key) {
        Chunk<Object> bounds = key.keyType().boundaries().values();
        AtomicLongArray values = new AtomicLongArray(bounds.length() + 1);
        double[] boundaries = new double[bounds.length()];
        LongAdder count = new LongAdder();
        DoubleAdder sum = new DoubleAdder();
        int size = bounds.length();
        AtomicDouble min = this.AtomicDouble().make(Double.MAX_VALUE);
        AtomicDouble max = this.AtomicDouble().make(Double$.MODULE$.MinValue());
        ((ChunkLike)bounds.sorted((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)).zipWithIndex().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                double n = tuple2._1$mcD$sp();
                int i = tuple2._2$mcI$sp();
                boundaries$1[i] = n;
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        JFunction1.mcVD.sp & Serializable update = (JFunction1.mcVD.sp & Serializable)value -> {
            int from = 0;
            int to = size;
            while (from != to) {
                int mid = from + (to - from) / 2;
                double boundary = boundaries[mid];
                if (value <= boundary) {
                    to = mid;
                } else {
                    from = mid;
                }
                if (to != from + 1) continue;
                if (value <= boundaries[from]) {
                    to = from;
                    continue;
                }
                from = to;
            }
            values.getAndIncrement(from);
            count.increment();
            sum.add(value);
            this.updateMin(min, value);
            this.updateMax(max, value);
        };
        return MetricHook$.MODULE$.apply(update, (Function0 & Serializable)() -> MetricState$Histogram$.MODULE$.apply(ConcurrentMetricHooksPlatformSpecific.getBuckets$1(values, boundaries, size), count.longValue(), min.get(), max.get(), sum.doubleValue()), update);
    }

    @Override
    public MetricHook<Tuple2<Object, Instant>, MetricState.Summary> summary(MetricKey<MetricKeyType.Summary> key) {
        AtomicReferenceArray values = new AtomicReferenceArray(key.keyType().maxSize());
        AtomicInteger head = new AtomicInteger(0);
        LongAdder count = new LongAdder();
        DoubleAdder sum = new DoubleAdder();
        AtomicDouble min = this.AtomicDouble().make(Double.MAX_VALUE);
        AtomicDouble max = this.AtomicDouble().make(Double$.MODULE$.MinValue());
        Chunk sortedQuantiles = (Chunk)key.keyType().quantiles().sorted(package$.MODULE$.DoubleOrdering());
        return MetricHook$.MODULE$.apply((JProcedure1 & Serializable)_$1 -> this.observe$1(key, values, head, count, sum, min, max, (Tuple2)_$1), (Function0 & Serializable)() -> MetricState$Summary$.MODULE$.apply(((MetricKeyType.Summary)key.keyType()).error(), ConcurrentMetricHooksPlatformSpecific.snapshot$1(key, values, sortedQuantiles, Instant.now()), ConcurrentMetricHooksPlatformSpecific.getCount$1(count), ConcurrentMetricHooksPlatformSpecific.getMin$1(min), ConcurrentMetricHooksPlatformSpecific.getMax$1(max), ConcurrentMetricHooksPlatformSpecific.getSum$1(sum)), (JProcedure1 & Serializable)_$2 -> this.observe$1(key, values, head, count, sum, min, max, (Tuple2)_$2));
    }

    @Override
    public MetricHook<String, MetricState.Frequency> frequency(MetricKey<MetricKeyType$Frequency$> key) {
        LongAdder count = new LongAdder();
        ConcurrentHashMap values = new ConcurrentHashMap();
        JProcedure1 & Serializable update = (JProcedure1 & Serializable)word -> {
            count.increment();
            LongAdder slot = (LongAdder)values.get(word);
            if (slot == null) {
                LongAdder cnt = new LongAdder();
                values.putIfAbsent(word, cnt);
                slot = (LongAdder)values.get(word);
            }
            slot.increment();
        };
        return MetricHook$.MODULE$.apply(update, (Function0 & Serializable)() -> MetricState$Frequency$.MODULE$.apply((Map<String, Object>)ConcurrentMetricHooksPlatformSpecific.snapshot$2(values)), update);
    }

    private final ConcurrentMetricHooksPlatformSpecific$AtomicDouble$ AtomicDouble() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                try {
                    ConcurrentMetricHooksPlatformSpecific$AtomicDouble$ concurrentMetricHooksPlatformSpecific$AtomicDouble$;
                    this.AtomicDouble$lzy1 = concurrentMetricHooksPlatformSpecific$AtomicDouble$ = new ConcurrentMetricHooksPlatformSpecific$AtomicDouble$(this);
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                    return concurrentMetricHooksPlatformSpecific$AtomicDouble$;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
        }
        return this.AtomicDouble$lzy1;
    }

    private static final Chunk getBuckets$1(AtomicLongArray values$2, double[] boundaries$3, int size$2) {
        ChunkBuilder builder = ChunkBuilder$.MODULE$.make();
        long cumulated = 0L;
        for (int i = 0; i != size$2; ++i) {
            double boundary = boundaries$3[i];
            long value = values$2.get(i);
            Double d = (Double)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)boundary));
            builder.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)d, (Object)BoxesRunTime.boxToLong((long)(cumulated += value))));
        }
        return (Chunk)builder.result();
    }

    private static final long getCount$1(LongAdder count$3) {
        return count$3.longValue();
    }

    private static final double getMin$1(AtomicDouble min$3) {
        return min$3.get();
    }

    private static final double getMax$1(AtomicDouble max$3) {
        return max$3.get();
    }

    private static final double getSum$1(DoubleAdder sum$3) {
        return sum$3.doubleValue();
    }

    private static final Chunk snapshot$1(MetricKey key$1, AtomicReferenceArray values$4, Chunk sortedQuantiles$1, Instant now) {
        ChunkBuilder builder = ChunkBuilder$.MODULE$.make();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), ((MetricKeyType.Summary)key$1.keyType()).maxSize()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)idx -> {
            Tuple2 item = (Tuple2)values$4.get(idx);
            if (item != null) {
                Tuple2 tuple2 = item;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                double v = BoxesRunTime.unboxToDouble((Object)tuple2._1());
                Instant t = (Instant)tuple2._2();
                Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)v), (Object)t);
                double v2 = BoxesRunTime.unboxToDouble((Object)tuple22._1());
                Instant t2 = (Instant)tuple22._2();
                Duration age = Duration$.MODULE$.fromInterval(t2, now);
                if (!age.isNegative() && age.compareTo(((MetricKeyType.Summary)key$1.keyType()).maxAge()) <= 0) {
                    builder.$plus$eq(BoxesRunTime.boxToDouble((double)v2));
                    return;
                }
                return;
            }
        });
        return package$.MODULE$.calculateQuantiles(((MetricKeyType.Summary)key$1.keyType()).error(), sortedQuantiles$1, (Chunk)((StrictOptimizedSeqOps)builder.result()).sorted(package$.MODULE$.DoubleOrdering()));
    }

    private final void observe$1(MetricKey key$3, AtomicReferenceArray values$6, AtomicInteger head$1, LongAdder count$4, DoubleAdder sum$4, AtomicDouble min$4, AtomicDouble max$4, Tuple2 tuple) {
        if (((MetricKeyType.Summary)key$3.keyType()).maxSize() > 0) {
            int target = head$1.incrementAndGet() % ((MetricKeyType.Summary)key$3.keyType()).maxSize();
            values$6.set(target, tuple);
        }
        double value = BoxesRunTime.unboxToDouble((Object)tuple._1());
        count$4.increment();
        sum$4.add(value);
        this.updateMin(min$4, value);
        this.updateMax(max$4, value);
    }

    private static final Map snapshot$2(ConcurrentHashMap values$9) {
        scala.collection.mutable.Map builder = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        for (Map.Entry e : values$9.entrySet()) {
            builder.update(e.getKey(), (Object)BoxesRunTime.boxToLong((long)((LongAdder)e.getValue()).longValue()));
        }
        return builder.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public final class AtomicDouble {
        private final AtomicLong ref;

        public AtomicDouble(AtomicLong ref) {
            this.ref = ref;
        }

        private AtomicLong ref() {
            return this.ref;
        }

        public double get() {
            return Double.longBitsToDouble(this.ref().get());
        }

        public void set(double newValue) {
            this.ref().set(Double.doubleToLongBits(newValue));
        }

        public boolean compareAndSet(double expected, double newValue) {
            return this.ref().compareAndSet(Double.doubleToLongBits(expected), Double.doubleToLongBits(newValue));
        }
    }
}

