/*
 * Decompiled with CFR 0.152.
 */
package zio.internal;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.HashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import zio.Chunk;
import zio.Executor;
import zio.Fiber$;
import zio.Trace$;
import zio.Unsafe;
import zio.internal.Blocking$;
import zio.internal.ExecutionMetrics;
import zio.internal.FiberRunnable;
import zio.internal.MutableConcurrentQueue;
import zio.internal.MutableConcurrentQueue$;

public final class ZScheduler
extends Executor {
    public final int zio$internal$ZScheduler$$poolSize = Runtime.getRuntime().availableProcessors();
    public final MutableConcurrentQueue<Worker> zio$internal$ZScheduler$$cache = MutableConcurrentQueue$.MODULE$.unbounded();
    public final MutableConcurrentQueue<Runnable> zio$internal$ZScheduler$$globalQueue = MutableConcurrentQueue$.MODULE$.unbounded();
    public final MutableConcurrentQueue<Worker> zio$internal$ZScheduler$$idle = MutableConcurrentQueue$.MODULE$.bounded(this.zio$internal$ZScheduler$$poolSize);
    public final AtomicInteger zio$internal$ZScheduler$$state = new AtomicInteger(this.zio$internal$ZScheduler$$poolSize << 16);
    public final Locations zio$internal$ZScheduler$$submittedLocations = this.zio$internal$ZScheduler$$makeLocations();
    public final Worker[] zio$internal$ZScheduler$$workers = new Worker[this.zio$internal$ZScheduler$$poolSize];
    public volatile Set<Object> zio$internal$ZScheduler$$blockingLocations = Predef$.MODULE$.Set().empty();

    public ZScheduler(boolean autoBlocking) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.zio$internal$ZScheduler$$poolSize).foreach((Function1)(JFunction1.mcVI.sp & Serializable)workerId -> {
            Worker worker = this.zio$internal$ZScheduler$$makeWorker();
            worker.setName(new StringBuilder(18).append("ZScheduler-Worker-").append(workerId).toString());
            worker.setDaemon(true);
            this.zio$internal$ZScheduler$$workers[workerId] = worker;
        });
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.zio$internal$ZScheduler$$workers);
        ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)_$1 -> _$1.start());
        if (autoBlocking) {
            Supervisor supervisor = this.makeSupervisor();
            supervisor.setName("ZScheduler-Supervisor");
            supervisor.setDaemon(true);
            supervisor.start();
        }
    }

    @Override
    public Option<ExecutionMetrics> metrics(Unsafe unsafe) {
        ExecutionMetrics metrics = new ExecutionMetrics(this){
            private final /* synthetic */ ZScheduler $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public int capacity() {
                return Integer.MAX_VALUE;
            }

            public int concurrency() {
                return this.$outer.zio$internal$ZScheduler$$poolSize;
            }

            public long dequeuedCount() {
                long dequeued = 0L;
                for (int i = 0; i != this.$outer.zio$internal$ZScheduler$$poolSize; ++i) {
                    Worker worker = this.$outer.zio$internal$ZScheduler$$workers[i];
                    dequeued += worker.opCount();
                }
                return dequeued;
            }

            public long enqueuedCount() {
                long enqueued = 0L;
                for (int i = 0; i != this.$outer.zio$internal$ZScheduler$$poolSize; ++i) {
                    Worker worker = this.$outer.zio$internal$ZScheduler$$workers[i];
                    enqueued += worker.opCount();
                    enqueued += (long)worker.localQueue().size();
                    if (worker.nextRunnable() == null) continue;
                    ++enqueued;
                }
                return enqueued += (long)this.$outer.zio$internal$ZScheduler$$globalQueue.size();
            }

            public int size() {
                int size = 0;
                for (int i = 0; i != this.$outer.zio$internal$ZScheduler$$poolSize; ++i) {
                    Worker worker = this.$outer.zio$internal$ZScheduler$$workers[i];
                    size += worker.localQueue().size();
                    if (worker.nextRunnable() == null) continue;
                    ++size;
                }
                return size += this.$outer.zio$internal$ZScheduler$$globalQueue.size();
            }

            public int workersCount() {
                int currentState = this.$outer.zio$internal$ZScheduler$$state.get();
                return (currentState & 0xFFFF0000) >> 16;
            }
        };
        return Some$.MODULE$.apply((Object)metrics);
    }

    @Override
    public boolean stealWork(int depth, Unsafe unsafe) {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof Worker) {
            Worker worker = (Worker)currentThread;
            Runnable runnable = null;
            if (worker.nextRunnable() != null) {
                runnable = worker.nextRunnable();
                worker.nextRunnable_$eq(null);
            } else {
                runnable = worker.localQueue().poll(null);
                if (runnable == null) {
                    runnable = this.zio$internal$ZScheduler$$globalQueue.poll(null);
                }
            }
            if (runnable != null) {
                if (runnable instanceof FiberRunnable) {
                    FiberRunnable fiberRunnable = (FiberRunnable)runnable;
                    worker.currentRunnable_$eq(fiberRunnable);
                    fiberRunnable.run(depth);
                } else {
                    runnable.run();
                }
                return true;
            }
            worker.nextRunnable_$eq(runnable);
            return false;
        }
        return false;
    }

    @Override
    public boolean submit(Runnable runnable, Unsafe unsafe) {
        Serializable serializable;
        if (this.isBlocking(runnable)) {
            return this.submitBlocking(runnable, unsafe);
        }
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof Worker) {
            Worker worker = (Worker)currentThread;
            if (worker.blocking()) {
                serializable = BoxesRunTime.boxToBoolean((boolean)this.zio$internal$ZScheduler$$globalQueue.offer(runnable));
            } else if (worker.localQueue().offer(runnable)) {
                if (worker.blocking()) {
                    Runnable runnable2 = worker.localQueue().poll(null);
                    if (runnable2 != null) {
                        this.zio$internal$ZScheduler$$globalQueue.offer(runnable2);
                        serializable = BoxedUnit.UNIT;
                    } else {
                        serializable = BoxedUnit.UNIT;
                    }
                } else {
                    serializable = BoxedUnit.UNIT;
                }
            } else {
                serializable = this.zio$internal$ZScheduler$$globalQueue.offerAll((Iterable)worker.localQueue().pollUpTo(128).$colon$plus(runnable));
            }
        } else {
            serializable = BoxesRunTime.boxToBoolean((boolean)this.zio$internal$ZScheduler$$globalQueue.offer(runnable));
        }
        int currentState = this.zio$internal$ZScheduler$$state.get();
        int currentActive = (currentState & 0xFFFF0000) >> 16;
        int currentSearching = currentState & 0xFFFF;
        if (currentActive != this.zio$internal$ZScheduler$$poolSize && currentSearching == 0) {
            boolean loop = true;
            while (loop) {
                Worker worker = this.zio$internal$ZScheduler$$idle.poll(null);
                if (worker == null) {
                    loop = false;
                    continue;
                }
                this.zio$internal$ZScheduler$$state.getAndAdd(65537);
                worker.active_$eq(true);
                LockSupport.unpark(worker);
                loop = false;
            }
        }
        return true;
    }

    @Override
    public boolean submitAndYield(Runnable runnable, Unsafe unsafe) {
        if (this.isBlocking(runnable)) {
            return this.submitBlocking(runnable, unsafe);
        }
        Thread currentThread = Thread.currentThread();
        boolean notify = false;
        if (currentThread instanceof Worker) {
            Worker worker = (Worker)currentThread;
            if (worker.blocking()) {
                this.zio$internal$ZScheduler$$globalQueue.offer(runnable);
                notify = true;
            } else if (worker.nextRunnable() == null && worker.localQueue().isEmpty()) {
                worker.nextRunnable_$eq(runnable);
            } else if (worker.localQueue().offer(runnable)) {
                Runnable runnable2;
                if (worker.blocking() && (runnable2 = (Runnable)worker.localQueue().poll(null)) != null) {
                    this.zio$internal$ZScheduler$$globalQueue.offer(runnable2);
                }
                notify = true;
            } else {
                this.zio$internal$ZScheduler$$globalQueue.offerAll((Iterable)worker.localQueue().pollUpTo(128).$colon$plus(runnable));
                notify = true;
            }
        } else {
            this.zio$internal$ZScheduler$$globalQueue.offer(runnable);
            notify = true;
        }
        if (notify) {
            int currentState = this.zio$internal$ZScheduler$$state.get();
            int currentActive = (currentState & 0xFFFF0000) >> 16;
            int currentSearching = currentState & 0xFFFF;
            if (currentActive != this.zio$internal$ZScheduler$$poolSize && currentSearching == 0) {
                boolean loop = true;
                while (loop) {
                    Worker worker = this.zio$internal$ZScheduler$$idle.poll(null);
                    if (worker == null) {
                        loop = false;
                        continue;
                    }
                    this.zio$internal$ZScheduler$$state.getAndAdd(65537);
                    worker.active_$eq(true);
                    LockSupport.unpark(worker);
                    loop = false;
                }
            }
        }
        return true;
    }

    private boolean isBlocking(Runnable runnable) {
        if (runnable instanceof FiberRunnable) {
            FiberRunnable fiberRunnable = (FiberRunnable)runnable;
            Object location = fiberRunnable.location();
            this.zio$internal$ZScheduler$$submittedLocations.put(location);
            return this.zio$internal$ZScheduler$$blockingLocations.contains(location);
        }
        return false;
    }

    public Locations zio$internal$ZScheduler$$makeLocations() {
        return new Locations(){
            private final HashMap locations;
            {
                this.locations = new HashMap<K, V>();
            }

            public long get(Object trace) {
                long[] array = (long[])this.locations.get(trace);
                if (array == null) {
                    return 0L;
                }
                return array[0];
            }

            public long put(Object trace) {
                long[] array = (long[])this.locations.get(trace);
                if (array == null) {
                    this.locations.put(trace, new long[]{1L});
                    return 0L;
                }
                long value = array[0];
                array[0] = array[0] + 1L;
                return value;
            }
        };
    }

    private Supervisor makeSupervisor() {
        return new Supervisor(this){
            private final /* synthetic */ ZScheduler $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void run() {
                long currentTime = System.currentTimeMillis();
                Locations identifiedLocations = this.$outer.zio$internal$ZScheduler$$makeLocations();
                long[] previousOpCounts = (long[])Array$.MODULE$.fill(this.$outer.zio$internal$ZScheduler$$poolSize, ZScheduler::zio$internal$ZScheduler$$anon$3$$_$_$$anonfun$1, ClassTag$.MODULE$.apply(Long.TYPE));
                while (!this.isInterrupted()) {
                    for (int workerId = 0; workerId != this.$outer.zio$internal$ZScheduler$$poolSize; ++workerId) {
                        Worker currentWorker = this.$outer.zio$internal$ZScheduler$$workers[workerId];
                        if (currentWorker.active()) {
                            long previousOpCount;
                            long currentOpCount = currentWorker.opCount();
                            if (currentOpCount == (previousOpCount = previousOpCounts[workerId])) {
                                FiberRunnable fiberRunnable;
                                Object location;
                                Runnable currentRunnable = currentWorker.currentRunnable();
                                if (currentRunnable instanceof FiberRunnable && (location = (fiberRunnable = (FiberRunnable)currentRunnable).location()) != Trace$.MODULE$.empty()) {
                                    long identifiedCount = identifiedLocations.put(location);
                                    long submittedCount = this.$outer.zio$internal$ZScheduler$$submittedLocations.get(location);
                                    if (submittedCount > 64L && identifiedCount >= submittedCount / 2L) {
                                        this.$outer.zio$internal$ZScheduler$$blockingLocations = (Set)this.$outer.zio$internal$ZScheduler$$blockingLocations.$plus(location);
                                    }
                                }
                                previousOpCounts[workerId] = -1L;
                                currentWorker.blocking_$eq(true);
                                Chunk<Runnable> runnables = currentWorker.localQueue().pollUpTo(256);
                                this.$outer.zio$internal$ZScheduler$$globalQueue.offerAll(runnables);
                                Worker worker = this.$outer.zio$internal$ZScheduler$$cache.poll(null);
                                if (worker == null) {
                                    Worker worker2 = this.$outer.zio$internal$ZScheduler$$makeWorker();
                                    worker2.setName(new StringBuilder(18).append("ZScheduler-Worker-").append(workerId).toString());
                                    worker2.setDaemon(true);
                                    this.$outer.zio$internal$ZScheduler$$workers[workerId] = worker2;
                                    worker2.start();
                                    continue;
                                }
                                this.$outer.zio$internal$ZScheduler$$state.getAndIncrement();
                                worker.setName(new StringBuilder(18).append("ZScheduler-Worker-").append(workerId).toString());
                                this.$outer.zio$internal$ZScheduler$$workers[workerId] = worker;
                                worker.blocking_$eq(false);
                                worker.active_$eq(true);
                                LockSupport.unpark(worker);
                                continue;
                            }
                            previousOpCounts[workerId] = currentOpCount;
                            continue;
                        }
                        previousOpCounts[workerId] = -1L;
                    }
                    long deadline = currentTime + 100L;
                    boolean loop = true;
                    while (loop) {
                        LockSupport.parkUntil(deadline);
                        currentTime = System.currentTimeMillis();
                        loop = currentTime < deadline;
                    }
                    Fiber$.MODULE$._roots().graduate();
                }
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{zio$internal$ZScheduler$$anon$3$$_$_$$anonfun$1()}, serializedLambda);
            }
        };
    }

    public Worker zio$internal$ZScheduler$$makeWorker() {
        return new Worker(this){
            private final /* synthetic */ ZScheduler $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void run() {
                boolean currentBlocking = false;
                long currentOpCount = 0L;
                ThreadLocalRandom random = ThreadLocalRandom.current();
                Runnable runnable = null;
                boolean searching = false;
                while (!this.isInterrupted()) {
                    currentBlocking = this.blocking();
                    if (currentBlocking) {
                        if (this.nextRunnable() != null) {
                            runnable = this.nextRunnable();
                            this.nextRunnable_$eq(null);
                        }
                    } else {
                        if ((currentOpCount & 0x3FL) == 0L) {
                            runnable = this.$outer.zio$internal$ZScheduler$$globalQueue.poll(null);
                            if (runnable == null) {
                                if (this.nextRunnable() != null) {
                                    runnable = this.nextRunnable();
                                    this.nextRunnable_$eq(null);
                                } else {
                                    runnable = this.localQueue().poll(null);
                                }
                            }
                        } else if (this.nextRunnable() != null) {
                            runnable = this.nextRunnable();
                            this.nextRunnable_$eq(null);
                        } else {
                            runnable = this.localQueue().poll(null);
                            if (runnable == null) {
                                runnable = this.$outer.zio$internal$ZScheduler$$globalQueue.poll(null);
                            }
                        }
                        if (runnable == null) {
                            int currentState;
                            int currentActive;
                            if (!searching && 2 * (currentActive = (currentState = this.$outer.zio$internal$ZScheduler$$state.get()) & 0xFFFF) < this.$outer.zio$internal$ZScheduler$$poolSize) {
                                this.$outer.zio$internal$ZScheduler$$state.getAndIncrement();
                                searching = true;
                            }
                            if (searching) {
                                boolean loop = true;
                                int offset = random.nextInt(this.$outer.zio$internal$ZScheduler$$poolSize);
                                for (int i = 0; i != this.$outer.zio$internal$ZScheduler$$poolSize && loop; ++i) {
                                    Chunk<Runnable> runnables;
                                    Chunk<Runnable> runnables2;
                                    int size;
                                    int index = (i + offset) % this.$outer.zio$internal$ZScheduler$$poolSize;
                                    Worker worker = this.$outer.zio$internal$ZScheduler$$workers[index];
                                    if (worker == this || worker.blocking() || (size = worker.localQueue().size()) <= 0 || !(runnables2 = worker.localQueue().pollUpTo(size - size / 2)).nonEmpty()) continue;
                                    runnable = runnables2.head();
                                    if (((IterableOnceOps)runnables2.tail()).nonEmpty()) {
                                        this.localQueue().offerAll((Iterable)runnables2.tail());
                                    }
                                    if ((currentBlocking = this.blocking()) && (runnables = this.localQueue().pollUpTo(256)).nonEmpty()) {
                                        this.$outer.zio$internal$ZScheduler$$globalQueue.offerAll(runnables);
                                    }
                                    loop = false;
                                }
                                if (runnable == null) {
                                    runnable = this.$outer.zio$internal$ZScheduler$$globalQueue.poll(null);
                                }
                            }
                        }
                    }
                    if (runnable == null) {
                        int currentState = currentBlocking && searching ? this.$outer.zio$internal$ZScheduler$$state.decrementAndGet() : (currentBlocking ? this.$outer.zio$internal$ZScheduler$$state.get() : (searching ? this.$outer.zio$internal$ZScheduler$$state.addAndGet(-65537) : this.$outer.zio$internal$ZScheduler$$state.addAndGet(-65536)));
                        int currentSearching = currentState & 0xFFFF;
                        this.active_$eq(false);
                        boolean bl = currentBlocking ? this.$outer.zio$internal$ZScheduler$$cache.offer(this) : this.$outer.zio$internal$ZScheduler$$idle.offer(this);
                        if (currentSearching == 0 && searching) {
                            boolean notify = false;
                            for (int i = 0; i != this.$outer.zio$internal$ZScheduler$$poolSize && !notify; ++i) {
                                Worker worker = this.$outer.zio$internal$ZScheduler$$workers[i];
                                notify = !worker.localQueue().isEmpty();
                            }
                            if (!notify) {
                                boolean bl2 = notify = !this.$outer.zio$internal$ZScheduler$$globalQueue.isEmpty();
                            }
                            if (notify) {
                                int currentState2 = this.$outer.zio$internal$ZScheduler$$state.get();
                                int currentActive = (currentState2 & 0xFFFF0000) >> 16;
                                int currentSearching2 = currentState2 & 0xFFFF;
                                if (currentActive != this.$outer.zio$internal$ZScheduler$$poolSize && currentSearching2 == 0) {
                                    boolean loop = true;
                                    while (loop) {
                                        Worker worker = this.$outer.zio$internal$ZScheduler$$idle.poll(null);
                                        if (worker == null) {
                                            loop = false;
                                            continue;
                                        }
                                        this.$outer.zio$internal$ZScheduler$$state.getAndAdd(65537);
                                        worker.active_$eq(true);
                                        LockSupport.unpark(worker);
                                        loop = false;
                                    }
                                }
                            }
                        }
                        while (!this.active() && !this.isInterrupted()) {
                            LockSupport.park();
                        }
                        searching = true;
                        continue;
                    }
                    if (searching) {
                        searching = false;
                        int currentState = this.$outer.zio$internal$ZScheduler$$state.decrementAndGet();
                        int currentSearching = currentState & 0xFFFF;
                        int currentActive = (currentState & 0xFFFF0000) >> 16;
                        if (currentActive != this.$outer.zio$internal$ZScheduler$$poolSize && currentSearching == 0) {
                            boolean loop = true;
                            while (loop) {
                                Worker worker = this.$outer.zio$internal$ZScheduler$$idle.poll(null);
                                if (worker == null) {
                                    loop = false;
                                    continue;
                                }
                                this.$outer.zio$internal$ZScheduler$$state.getAndAdd(65537);
                                worker.active_$eq(true);
                                LockSupport.unpark(worker);
                                loop = false;
                            }
                        }
                    }
                    this.currentRunnable_$eq(runnable);
                    runnable.run();
                    runnable = null;
                    this.currentRunnable_$eq(runnable);
                    this.opCount_$eq(++currentOpCount);
                }
            }
        };
    }

    private boolean submitBlocking(Runnable runnable, Unsafe unsafe) {
        return Blocking$.MODULE$.blockingExecutor().submit(runnable, unsafe);
    }

    public static final long zio$internal$ZScheduler$$anon$3$$_$_$$anonfun$1() {
        return -1L;
    }

    public static abstract class Locations {
        public abstract long get(Object var1);

        public abstract long put(Object var1);
    }

    public static abstract class Supervisor
    extends Thread {
    }

    public static abstract class Worker
    extends Thread {
        private volatile boolean active = true;
        private volatile boolean blocking = false;
        private volatile Runnable currentRunnable = null;
        private final MutableConcurrentQueue localQueue = MutableConcurrentQueue$.MODULE$.bounded(256);
        private Runnable nextRunnable = null;
        private volatile long opCount = 0L;

        public boolean active() {
            return this.active;
        }

        public void active_$eq(boolean x$1) {
            this.active = x$1;
        }

        public boolean blocking() {
            return this.blocking;
        }

        public void blocking_$eq(boolean x$1) {
            this.blocking = x$1;
        }

        public Runnable currentRunnable() {
            return this.currentRunnable;
        }

        public void currentRunnable_$eq(Runnable x$1) {
            this.currentRunnable = x$1;
        }

        public MutableConcurrentQueue<Runnable> localQueue() {
            return this.localQueue;
        }

        public Runnable nextRunnable() {
            return this.nextRunnable;
        }

        public void nextRunnable_$eq(Runnable x$1) {
            this.nextRunnable = x$1;
        }

        public long opCount() {
            return this.opCount;
        }

        public void opCount_$eq(long x$1) {
            this.opCount = x$1;
        }
    }
}

