/*
 * Decompiled with CFR 0.152.
 */
package zio.internal;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import zio.Fiber;
import zio.Fiber$Status$Done$;
import zio.Fiber$Status$Running$;
import zio.Fiber$Status$Suspended$;
import zio.FiberId;
import zio.FiberId$None$;
import zio.RuntimeFlags$;
import zio.Trace$;
import zio.ZIO;
import zio.ZIO$;

public final class FiberRenderer$
implements Serializable {
    public static final FiberRenderer$ MODULE$ = new FiberRenderer$();

    private FiberRenderer$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(FiberRenderer$.class);
    }

    public ZIO<Object, Nothing$, String> prettyPrint(Fiber.Dump dump, Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$1 -> this.unsafePrettyPrint(dump, System.currentTimeMillis()), trace);
    }

    private String unsafePrettyPrint(Fiber.Dump dump, long now) {
        String string;
        long totalMillis = now - dump.fiberId().startTimeMillis();
        long millis = totalMillis % 1000L;
        long seconds = totalMillis / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        String name = new StringBuilder(2).append("\"").append(dump.fiberId().threadName()).append("\"").toString();
        String lifeMsg = new StringBuilder(0).append(hours == 0L ? "" : new StringBuilder(2).append(hours).append("h ").toString()).append(hours == 0L && minutes == 0L ? "" : new StringBuilder(2).append(minutes).append("m ").toString()).append(hours == 0L && minutes == 0L && seconds == 0L ? "" : new StringBuilder(2).append(seconds).append("s ").toString()).append(new StringBuilder(2).append(millis).append("ms").toString()).toString();
        Fiber.Status status = dump.status();
        if (status instanceof Fiber.Status.Suspended) {
            Fiber.Status.Suspended suspended = Fiber$Status$Suspended$.MODULE$.unapply((Fiber.Status.Suspended)status);
            int n = suspended._1();
            Object object = suspended._2();
            FiberId fiberId = suspended._3();
            FiberId blockingOn = fiberId;
            string = blockingOn != FiberId$None$.MODULE$ ? new StringBuilder(11).append("waiting on ").append(new StringBuilder(1).append("#").append(blockingOn.ids().mkString(", ")).toString()).toString() : "";
        } else {
            string = "";
        }
        String waitMsg = string;
        String statMsg = this.renderStatus(dump.status());
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(49).append("\n       |").append(name).append(" (").append(lifeMsg).append(") ").append(waitMsg).append("\n       |\tStatus: ").append(statMsg).append("\n       |").append(dump.trace().prettyPrint()).append("\n       |").toString()));
    }

    private String renderFlags(int runtimeFlags) {
        return RuntimeFlags$.MODULE$.toSet(runtimeFlags).mkString("(", ", ", ")");
    }

    private String renderTrace(Object trace) {
        if (BoxesRunTime.equals((Object)trace, (Object)Trace$.MODULE$.empty())) {
            return "<no trace>";
        }
        return trace.toString();
    }

    private String renderStatus(Fiber.Status status) {
        Fiber.Status status2 = status;
        if (Fiber$Status$Done$.MODULE$.equals(status2)) {
            return "Done";
        }
        if (status2 instanceof Fiber.Status.Running) {
            Fiber.Status.Running running = Fiber$Status$Running$.MODULE$.unapply((Fiber.Status.Running)status2);
            int n = running._1();
            Object object = running._2();
            int runtimeFlags = n;
            Object trace0 = object;
            String flags = this.renderFlags(runtimeFlags);
            String trace = this.renderTrace(trace0);
            return new StringBuilder(11).append("Running(").append(flags).append(", ").append(trace).append(")").toString();
        }
        if (status2 instanceof Fiber.Status.Suspended) {
            Fiber.Status.Suspended suspended = Fiber$Status$Suspended$.MODULE$.unapply((Fiber.Status.Suspended)status2);
            int n = suspended._1();
            Object object = suspended._2();
            FiberId fiberId = suspended._3();
            int runtimeFlags = n;
            Object trace0 = object;
            FiberId blockingOn = fiberId;
            String flags = this.renderFlags(runtimeFlags);
            String trace = this.renderTrace(trace0);
            return new StringBuilder(13).append("Suspended(").append(flags).append(", ").append(trace).append(")").toString();
        }
        throw new MatchError((Object)status2);
    }
}

