/*
 * Decompiled with CFR 0.152.
 */
package zio.internal;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import scala.Product;
import scala.collection.Iterable;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import zio.Chunk;
import zio.Chunk$;
import zio.ChunkBuilder;
import zio.ChunkBuilder$;
import zio.internal.Hub;
import zio.internal.UnboundedHub$Pointer$;

public final class UnboundedHub<A>
extends Hub<A> {
    public final AtomicReference<Node<A>> zio$internal$UnboundedHub$$publisherHead;
    public final AtomicReference<Node<A>> zio$internal$UnboundedHub$$publisherTail;
    private final int capacity;

    public UnboundedHub() {
        Node<Object> empty = new Node<Object>(null, new AtomicReference(UnboundedHub$Pointer$.MODULE$.apply(null, 0)));
        this.zio$internal$UnboundedHub$$publisherHead = new AtomicReference<Node<Object>>(empty);
        this.zio$internal$UnboundedHub$$publisherTail = new AtomicReference<Node<Object>>(empty);
        this.capacity = Integer.MAX_VALUE;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public boolean isEmpty() {
        boolean empty = true;
        boolean loop = true;
        while (loop) {
            Node<A> currentPublisherHead = this.zio$internal$UnboundedHub$$publisherHead.get();
            Node<A> currentPublisherTail = this.zio$internal$UnboundedHub$$publisherTail.get();
            Node<A> currentNode = currentPublisherHead.pointer().get().node();
            if (currentPublisherHead != this.zio$internal$UnboundedHub$$publisherHead.get()) continue;
            if (currentPublisherHead == currentPublisherTail) {
                if (currentNode == null) {
                    loop = false;
                    continue;
                }
                this.zio$internal$UnboundedHub$$publisherTail.compareAndSet(currentPublisherTail, currentNode);
                continue;
            }
            if (currentNode.value() != null) {
                empty = false;
                loop = false;
                continue;
            }
            this.zio$internal$UnboundedHub$$publisherHead.compareAndSet(currentPublisherHead, currentNode);
        }
        return empty;
    }

    @Override
    public boolean isFull() {
        return false;
    }

    @Override
    public boolean publish(A a) {
        if (a == null) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        boolean loop = true;
        while (loop) {
            Node<A> currentPublisherTail = this.zio$internal$UnboundedHub$$publisherTail.get();
            Pointer<A> currentPointer = currentPublisherTail.pointer().get();
            Node<A> currentNode = currentPointer.node();
            int currentSubscribers = currentPointer.subscribers();
            if (currentPublisherTail != this.zio$internal$UnboundedHub$$publisherTail.get()) continue;
            if (currentNode == null) {
                if (currentSubscribers == 0) {
                    loop = false;
                    continue;
                }
                Node<A> updatedNode = new Node<A>(a, new AtomicReference(UnboundedHub$Pointer$.MODULE$.apply(null, currentSubscribers)));
                Pointer<A> updatedPointer = UnboundedHub$Pointer$.MODULE$.apply(updatedNode, currentSubscribers);
                if (!currentPublisherTail.pointer().compareAndSet(currentPointer, updatedPointer)) continue;
                this.zio$internal$UnboundedHub$$publisherTail.compareAndSet(currentPublisherTail, updatedNode);
                loop = false;
                continue;
            }
            this.zio$internal$UnboundedHub$$publisherTail.compareAndSet(currentPublisherTail, currentNode);
        }
        return true;
    }

    @Override
    public <A1 extends A> Chunk<A1> publishAll(Iterable<A1> as) {
        for (Object a : as) {
            this.publish(a);
        }
        return Chunk$.MODULE$.empty();
    }

    @Override
    public int size() {
        Node<A> currentNode = this.zio$internal$UnboundedHub$$publisherHead.get().pointer().get().node();
        boolean loop = true;
        int size = 0;
        while (currentNode != null) {
            if (currentNode.value() != null && ++size == Integer.MAX_VALUE) {
                loop = false;
            }
            currentNode = currentNode.pointer().get().node();
        }
        return size;
    }

    @Override
    public void slide() {
        boolean loop = true;
        while (loop) {
            Node<A> currentPublisherHead = this.zio$internal$UnboundedHub$$publisherHead.get();
            Node<A> currentPublisherTail = this.zio$internal$UnboundedHub$$publisherTail.get();
            Node<A> currentNode = currentPublisherHead.pointer().get().node();
            if (currentPublisherHead != this.zio$internal$UnboundedHub$$publisherHead.get()) continue;
            if (currentPublisherHead == currentPublisherTail) {
                if (currentNode == null) {
                    loop = false;
                    continue;
                }
                this.zio$internal$UnboundedHub$$publisherHead.compareAndSet(currentPublisherHead, currentNode);
                continue;
            }
            if (currentNode.value() != null) {
                if (!this.zio$internal$UnboundedHub$$publisherHead.compareAndSet(currentPublisherHead, currentNode)) continue;
                currentNode.value_$eq(null);
                loop = false;
                continue;
            }
            this.zio$internal$UnboundedHub$$publisherHead.compareAndSet(currentPublisherHead, currentNode);
        }
    }

    @Override
    public Hub.Subscription<A> subscribe() {
        return new Hub.Subscription<A>(this){
            private final AtomicReference subscriberHead;
            private final AtomicBoolean unsubscribed;
            private final /* synthetic */ UnboundedHub $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                Node<A> currentPublisherTail = null;
                boolean loop = true;
                while (loop) {
                    currentPublisherTail = $outer.zio$internal$UnboundedHub$$publisherTail.get();
                    Pointer<A> currentPointer = currentPublisherTail.pointer().get();
                    Node<A> currentNode = currentPointer.node();
                    if (currentPublisherTail != $outer.zio$internal$UnboundedHub$$publisherTail.get()) continue;
                    if (currentNode == null) {
                        int n = currentPointer.subscribers() + 1;
                        Node<A> node = currentPointer.copy$default$1();
                        Pointer<A> updatedPointer = currentPointer.copy(node, n);
                        if (!currentPublisherTail.pointer().compareAndSet(currentPointer, updatedPointer)) continue;
                        loop = false;
                        continue;
                    }
                    $outer.zio$internal$UnboundedHub$$publisherTail.compareAndSet(currentPublisherTail, currentNode);
                }
                this.subscriberHead = new AtomicReference<Node<A>>(currentPublisherTail);
                this.unsubscribed = new AtomicBoolean(false);
            }

            public boolean isEmpty() {
                boolean empty = true;
                boolean loop = true;
                while (loop) {
                    Node currentSubscriberHead = (Node)this.subscriberHead.get();
                    Node<A> currentPublisherTail = this.$outer.zio$internal$UnboundedHub$$publisherTail.get();
                    Node<A> currentNode = currentSubscriberHead.pointer().get().node();
                    if (currentSubscriberHead != this.subscriberHead.get()) continue;
                    if (currentSubscriberHead == currentPublisherTail) {
                        if (currentNode == null) {
                            loop = false;
                            continue;
                        }
                        this.$outer.zio$internal$UnboundedHub$$publisherTail.compareAndSet(currentPublisherTail, currentNode);
                        continue;
                    }
                    if (currentNode.value() != null) {
                        empty = false;
                        loop = false;
                        continue;
                    }
                    this.subscriberHead.compareAndSet(currentSubscriberHead, currentNode);
                }
                return empty;
            }

            public Object poll(Object object) {
                boolean loop = true;
                Object polled = object;
                while (loop && !this.unsubscribed.get()) {
                    Node currentSubscriberHead = (Node)this.subscriberHead.get();
                    Node<A> currentPublisherTail = this.$outer.zio$internal$UnboundedHub$$publisherTail.get();
                    Node<A> currentNode = currentSubscriberHead.pointer().get().node();
                    if (currentSubscriberHead != this.subscriberHead.get()) continue;
                    if (currentSubscriberHead == currentPublisherTail) {
                        if (currentNode == null) {
                            loop = false;
                            continue;
                        }
                        this.$outer.zio$internal$UnboundedHub$$publisherTail.compareAndSet(currentPublisherTail, currentNode);
                        continue;
                    }
                    A a = currentNode.value();
                    if (a != null) {
                        if (!this.subscriberHead.compareAndSet(currentSubscriberHead, currentNode)) continue;
                        Pointer<A> currentPointer = currentSubscriberHead.pointer().updateAndGet(UnboundedHub::zio$internal$UnboundedHub$$anon$1$$_$_$$anonfun$1);
                        int currentSubscribers = currentPointer.subscribers();
                        if (currentSubscribers == 0) {
                            currentNode.value_$eq(null);
                            this.$outer.zio$internal$UnboundedHub$$publisherHead.lazySet(currentNode);
                        }
                        loop = false;
                        polled = a;
                        continue;
                    }
                    this.subscriberHead.compareAndSet(currentSubscriberHead, currentNode);
                }
                return polled;
            }

            public Chunk pollUpTo(int n) {
                ChunkBuilder<A> builder = ChunkBuilder$.MODULE$.make();
                Object default_ = null;
                int i = 0;
                while (i != n) {
                    Object a = this.poll((Object)default_);
                    if (BoxesRunTime.equals((Object)a, default_)) {
                        i = n;
                        continue;
                    }
                    builder.$plus$eq(a);
                    ++i;
                }
                return (Chunk)builder.result();
            }

            public int size() {
                Node<A> currentNode = ((Node)this.subscriberHead.get()).pointer().get().node();
                boolean loop = true;
                int size = 0;
                while (currentNode != null) {
                    if (currentNode.value() != null && ++size == Integer.MAX_VALUE) {
                        loop = false;
                    }
                    currentNode = currentNode.pointer().get().node();
                }
                return size;
            }

            public void unsubscribe() {
                if (this.unsubscribed.compareAndSet(false, true)) {
                    Node<Object> currentSubscriberHead = (Node<Object>)this.subscriberHead.get();
                    Node<A> currentPublisherTail = null;
                    boolean loop = true;
                    while (loop) {
                        currentPublisherTail = this.$outer.zio$internal$UnboundedHub$$publisherTail.get();
                        Pointer<A> currentPointer = currentPublisherTail.pointer().get();
                        Node<A> currentNode = currentPointer.node();
                        if (currentPublisherTail != this.$outer.zio$internal$UnboundedHub$$publisherTail.get()) continue;
                        if (currentNode == null) {
                            int n = currentPointer.subscribers() - 1;
                            Node<A> node = currentPointer.copy$default$1();
                            Pointer<A> updatedPointer = currentPointer.copy(node, n);
                            if (!currentPublisherTail.pointer().compareAndSet(currentPointer, updatedPointer)) continue;
                            loop = false;
                            continue;
                        }
                        this.subscriberHead.compareAndSet(currentSubscriberHead, currentNode);
                    }
                    while (currentSubscriberHead != currentPublisherTail) {
                        Pointer<A> currentPointer = currentSubscriberHead.pointer().updateAndGet(UnboundedHub::zio$internal$UnboundedHub$$anon$1$$_$_$$anonfun$2);
                        Node<Object> currentNode = currentPointer.node();
                        int currentSubscribers = currentPointer.subscribers();
                        if (currentSubscribers == 0) {
                            currentNode.value_$eq(null);
                            this.$outer.zio$internal$UnboundedHub$$publisherHead.lazySet(currentNode);
                        }
                        currentSubscriberHead = currentNode;
                    }
                    return;
                }
            }
        };
    }

    public static final /* synthetic */ Pointer zio$internal$UnboundedHub$$anon$1$$_$_$$anonfun$1(Pointer pointer) {
        int n = pointer.subscribers() - 1;
        Node node = pointer.copy$default$1();
        return pointer.copy(node, n);
    }

    public static final /* synthetic */ Pointer zio$internal$UnboundedHub$$anon$1$$_$_$$anonfun$2(Pointer currentPointer) {
        int n = currentPointer.subscribers() - 1;
        Node node = currentPointer.copy$default$1();
        return currentPointer.copy(node, n);
    }

    public static final class Node<A> {
        private Object value;
        private final AtomicReference pointer;

        public Node(A value, AtomicReference<Pointer<A>> pointer) {
            this.value = value;
            this.pointer = pointer;
        }

        public A value() {
            return (A)this.value;
        }

        public void value_$eq(A x$1) {
            this.value = x$1;
        }

        public AtomicReference<Pointer<A>> pointer() {
            return this.pointer;
        }
    }

    public static final class Pointer<A>
    implements Product,
    Serializable {
        private final Node node;
        private final int subscribers;

        public static <A> Pointer<A> apply(Node<A> node, int n) {
            return UnboundedHub$Pointer$.MODULE$.apply(node, n);
        }

        public static Pointer<?> fromProduct(Product product) {
            return UnboundedHub$Pointer$.MODULE$.fromProduct(product);
        }

        public static <A> Pointer<A> unapply(Pointer<A> pointer) {
            return UnboundedHub$Pointer$.MODULE$.unapply(pointer);
        }

        public Pointer(Node<A> node, int subscribers) {
            this.node = node;
            this.subscribers = subscribers;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.node()));
            n = Statics.mix((int)n, (int)this.subscribers());
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Pointer)) return false;
            Pointer pointer = (Pointer)object;
            if (this.subscribers() != pointer.subscribers()) return false;
            Node<A> node = this.node();
            Node<A> node2 = pointer.node();
            if (node != null) {
                if (!node.equals(node2)) return false;
                return true;
            }
            if (node2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Pointer;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Pointer";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return BoxesRunTime.boxToInteger((int)this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "node";
            }
            if (1 == n2) {
                return "subscribers";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Node<A> node() {
            return this.node;
        }

        public int subscribers() {
            return this.subscribers;
        }

        public <A> Pointer<A> copy(Node<A> node, int subscribers) {
            return new Pointer<A>(node, subscribers);
        }

        public <A> Node<A> copy$default$1() {
            return this.node();
        }

        public int copy$default$2() {
            return this.subscribers();
        }

        public Node<A> _1() {
            return this.node();
        }

        public int _2() {
            return this.subscribers();
        }
    }
}

