/*
 * Copyright 2017-2023 John A. De Goes and the ZIO Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package zio

import scala.annotation.experimental
import scala.language.experimental.saferExceptions

@experimental
object Experimental {

  extension(zio: ZIO.type) {

    /**
     * Converts a value whose computation may throw exceptions into a `ZIO`
     * value.
     */
    def fromThrows[E <: Exception, A](a: => A throws E): IO[E, A] =
      ZIO.suspendSucceed {
        try {
          ZIO.succeedNow(a)
        } catch {
          case e: E => ZIO.fail(e)
        }
      }
  }
}
