/*
 * Decompiled with CFR 0.152.
 */
package zio.internal;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import scala.Option;
import scala.Some$;
import zio.Executor;
import zio.Unsafe;
import zio.internal.DefaultExecutors$;
import zio.internal.ExecutionMetrics;
import zio.internal.ZScheduler;

public abstract class DefaultExecutors {
    public final Executor makeDefault() {
        return this.makeDefault(true);
    }

    public final Executor makeDefault(boolean autoBlocking) {
        return new ZScheduler(autoBlocking);
    }

    public final Executor fromThreadPoolExecutor(ThreadPoolExecutor es) {
        return new Executor(es){
            public final ThreadPoolExecutor zio$internal$DefaultExecutors$$anon$1$$es$1;
            {
                this.zio$internal$DefaultExecutors$$anon$1$$es$1 = es$2;
            }

            private ExecutionMetrics metrics0() {
                return new ExecutionMetrics(this){
                    private final /* synthetic */ $anon$1 $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public int concurrency() {
                        return this.$outer.zio$internal$DefaultExecutors$$anon$1$$es$1.getMaximumPoolSize();
                    }

                    public int capacity() {
                        BlockingQueue<Runnable> queue = this.$outer.zio$internal$DefaultExecutors$$anon$1$$es$1.getQueue();
                        int remaining = queue.remainingCapacity();
                        if (remaining == Integer.MAX_VALUE) {
                            return remaining;
                        }
                        return remaining + queue.size();
                    }

                    public int size() {
                        return this.$outer.zio$internal$DefaultExecutors$$anon$1$$es$1.getQueue().size();
                    }

                    public int workersCount() {
                        return this.$outer.zio$internal$DefaultExecutors$$anon$1$$es$1.getPoolSize();
                    }

                    public long enqueuedCount() {
                        return this.$outer.zio$internal$DefaultExecutors$$anon$1$$es$1.getTaskCount();
                    }

                    public long dequeuedCount() {
                        return this.enqueuedCount() - (long)this.size();
                    }
                };
            }

            public Option metrics(Unsafe unsafe) {
                return Some$.MODULE$.apply((Object)this.metrics0());
            }

            public boolean submit(Runnable runnable, Unsafe unsafe) {
                boolean bl;
                try {
                    this.zio$internal$DefaultExecutors$$anon$1$$es$1.execute(runnable);
                    bl = true;
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    bl = false;
                }
                return bl;
            }
        };
    }
}

