/*
 * Decompiled with CFR 0.152.
 */
package zio.internal;

import java.io.Serializable;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Nothing$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.function.JProcedure2;
import zio.Cause;
import zio.Cause$;
import zio.Chunk;
import zio.Chunk$;
import zio.Executor;
import zio.Exit;
import zio.Exit$;
import zio.Exit$Failure$;
import zio.Exit$Success$;
import zio.Fiber;
import zio.Fiber$;
import zio.Fiber$Status$Done$;
import zio.Fiber$Status$Running$;
import zio.Fiber$Status$Suspended$;
import zio.FiberId;
import zio.FiberId$None$;
import zio.FiberRef;
import zio.FiberRef$;
import zio.FiberRefs;
import zio.LogLevel;
import zio.LogSpan;
import zio.Runtime$;
import zio.RuntimeFlag$WindDown$;
import zio.RuntimeFlags$;
import zio.RuntimeFlags$Patch$;
import zio.StackTrace;
import zio.StackTrace$;
import zio.Supervisor;
import zio.Supervisor$;
import zio.Trace$;
import zio.Unsafe;
import zio.Unsafe$;
import zio.ZIO;
import zio.ZIO$;
import zio.ZIO$Continuation$;
import zio.ZIO$UpdateRuntimeFlags$;
import zio.ZLogger;
import zio.internal.AsyncJump$;
import zio.internal.FiberMessage;
import zio.internal.FiberMessage$;
import zio.internal.FiberMessage$InterruptSignal$;
import zio.internal.FiberMessage$Resume$;
import zio.internal.FiberMessage$Stateful$;
import zio.internal.FiberMessage$YieldNow$;
import zio.internal.FiberRunnable;
import zio.internal.FiberRuntime$;
import zio.internal.FiberScope;
import zio.internal.FiberScope$;
import zio.internal.Platform$;
import zio.internal.StackTraceBuilder;
import zio.internal.StackTraceBuilder$;
import zio.internal.Sync$;
import zio.metrics.Metric$runtime$;
import zio.metrics.MetricLabel;

public final class FiberRuntime<E, A>
extends Fiber.Runtime.Internal<E, A>
implements FiberRunnable {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(FiberRuntime.class.getDeclaredField("scope$lzy1"));
    private final FiberId.Runtime fiberId;
    private Object _lastTrace;
    private FiberRefs _fiberRefs;
    private int _runtimeFlags;
    private Function0<FiberId> _blockingOn;
    private Function1<ZIO<Object, Object, Object>, Object> _asyncContWith;
    private final AtomicBoolean running;
    private final ConcurrentLinkedQueue<FiberMessage> inbox;
    private Set<Fiber.Runtime<?, ?>> _children;
    private List<Function1<Exit<E, A>, BoxedUnit>> observers;
    private Executor runningExecutor;
    private ZIO.Continuation[] _stack;
    private int _stackSize;
    private final Object emptyTrace;
    private int _forksSinceYield;
    private volatile Exit _exitValue;
    private volatile Object scope$lzy1;

    public static <E, A> FiberRuntime<E, A> apply(FiberId.Runtime runtime, FiberRefs fiberRefs, int n) {
        return FiberRuntime$.MODULE$.apply(runtime, fiberRefs, n);
    }

    public static AtomicBoolean catastrophicFailure() {
        return FiberRuntime$.MODULE$.catastrophicFailure();
    }

    public FiberRuntime(FiberId.Runtime fiberId, FiberRefs fiberRefs0, int runtimeFlags0) {
        this.fiberId = fiberId;
        this._lastTrace = fiberId.location();
        this._fiberRefs = fiberRefs0;
        this._runtimeFlags = runtimeFlags0;
        this._blockingOn = FiberRuntime$.zio$internal$FiberRuntime$$$notBlockingOn;
        this._asyncContWith = null;
        this.running = new AtomicBoolean(false);
        this.inbox = new ConcurrentLinkedQueue();
        this._children = null;
        this.observers = package$.MODULE$.Nil();
        this.runningExecutor = null;
        this._stack = null;
        this._stackSize = 0;
        this.emptyTrace = Trace$.MODULE$.empty();
        this._forksSinceYield = 0;
        if (RuntimeFlags$.MODULE$.runtimeMetrics(this._runtimeFlags)) {
            scala.collection.immutable.Set tags = (scala.collection.immutable.Set)this.getFiberRef(FiberRef$.MODULE$.currentTags());
            Metric$runtime$.MODULE$.fibersStarted().unsafe().update(BoxesRunTime.boxToLong((long)1L), (scala.collection.immutable.Set<MetricLabel>)tags, Unsafe$.MODULE$.unsafe());
            Metric$runtime$.MODULE$.fiberForkLocations().unsafe().update(fiberId.location().toString(), (scala.collection.immutable.Set<MetricLabel>)tags, Unsafe$.MODULE$.unsafe());
        }
        this._exitValue = null;
    }

    @Override
    public boolean shouldYieldBeforeFork() {
        ++this._forksSinceYield;
        return this._forksSinceYield >= 128;
    }

    private Exit<E, A> _exitValue() {
        return this._exitValue;
    }

    private void _exitValue_$eq(Exit<E, A> x$0) {
        this._exitValue = x$0;
    }

    @Override
    public ZIO<Object, Nothing$, Exit<E, A>> await(Object trace) {
        return ZIO$.MODULE$.suspendSucceed(() -> this.await$$anonfun$1(trace), trace);
    }

    @Override
    public ZIO<Object, Nothing$, Chunk<Fiber.Runtime<?, ?>>> children(Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$3 -> {
            Set<Fiber.Runtime<?, ?>> childs = this._children;
            if (childs == null) {
                return Chunk$.MODULE$.empty();
            }
            return (Chunk)Sync$.MODULE$.apply(childs, () -> FiberRuntime.children$$anonfun$1$$anonfun$1(childs));
        }, trace);
    }

    @Override
    public ZIO<Object, Nothing$, FiberRefs> fiberRefs(Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$4 -> this._fiberRefs, trace);
    }

    @Override
    public FiberId.Runtime id() {
        return this.fiberId;
    }

    @Override
    public ZIO<Object, Nothing$, BoxedUnit> inheritAll(Object trace) {
        return ZIO$.MODULE$.withFiberRuntime((Function2 & Serializable)(parentFiber, parentStatus) -> {
            FiberId.Runtime parentFiberId = parentFiber.id();
            FiberRefs parentFiberRefs = parentFiber.getFiberRefs();
            int parentRuntimeFlags = parentStatus.runtimeFlags();
            FiberRefs childFiberRefs = this.getFiberRefs();
            FiberRefs updatedFiberRefs = parentFiberRefs.joinAs(parentFiberId, childFiberRefs);
            parentFiber.setFiberRefs(updatedFiberRefs);
            int updatedRuntimeFlags = BoxesRunTime.unboxToInt(updatedFiberRefs.getOrDefault(FiberRef$.MODULE$.currentRuntimeFlags()));
            long patch = FiberRuntime$.MODULE$.zio$internal$FiberRuntime$$$patchExcludeNonInheritable(RuntimeFlags$.MODULE$.diff(parentRuntimeFlags, updatedRuntimeFlags));
            return ZIO$.MODULE$.updateRuntimeFlags(patch, trace);
        }, trace);
    }

    @Override
    public ZIO<Object, Nothing$, BoxedUnit> interruptAsFork(FiberId fiberId, Object trace) {
        return ZIO$.MODULE$.succeed((Function1)(JProcedure1 & Serializable)evidence$5 -> {
            Cause<Nothing$> cause = Cause$.MODULE$.interrupt(fiberId, Cause$.MODULE$.interrupt$default$2()).traced(StackTrace$.MODULE$.apply(this.fiberId, Chunk$.MODULE$.single(trace)));
            this.tell(FiberMessage$InterruptSignal$.MODULE$.apply(cause));
        }, trace);
    }

    @Override
    public Object location() {
        return this.fiberId.location();
    }

    @Override
    public ZIO<Object, Nothing$, Option<Exit<E, A>>> poll(Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$6 -> Option$.MODULE$.apply(this.exitValue()), trace);
    }

    @Override
    public void run() {
        this.drainQueueOnCurrentThread(0);
    }

    @Override
    public void run(int depth) {
        this.drainQueueOnCurrentThread(depth);
    }

    @Override
    public ZIO<Object, Nothing$, Object> runtimeFlags(Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$7 -> this._runtimeFlags, trace);
    }

    @Override
    public FiberScope scope() {
        Object object = this.scope$lzy1;
        if (object instanceof FiberScope) {
            return (FiberScope)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (FiberScope)this.scope$lzyINIT1();
    }

    private Object scope$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.scope$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    FiberScope fiberScope = null;
                    try {
                        fiberScope = FiberScope$.MODULE$.make(this);
                        object2 = fiberScope == null ? LazyVals.NullValue$.MODULE$ : fiberScope;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.scope$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return fiberScope;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public ZIO<Object, Nothing$, Fiber.Status> status(Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$8 -> this.getStatus(), trace);
    }

    @Override
    public ZIO<Object, Nothing$, StackTrace> trace(Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$9 -> this.generateStackTrace(), trace);
    }

    @Override
    public void addChild(Fiber.Runtime<?, ?> child) {
        if (this.isAlive()) {
            this.getChildren().add(child);
            if (this.isInterrupted()) {
                child.tellInterrupt(this.getInterruptedCause());
                return;
            }
            return;
        }
        child.tellInterrupt(this.getInterruptedCause());
    }

    private void addInterruptedCause(Cause<Nothing$> cause) {
        Cause<Nothing$> oldSC = this.getFiberRef(FiberRef$.MODULE$.interruptedCause());
        this.setFiberRef(FiberRef$.MODULE$.interruptedCause(), oldSC.$plus$plus(cause));
    }

    public void addObserver(Function1<Exit<E, A>, BoxedUnit> observer, Unsafe unsafe) {
        if (this._exitValue() != null) {
            observer.apply(this._exitValue());
            return;
        }
        this.observers = this.observers.$colon$colon(observer);
    }

    @Override
    public void deleteFiberRef(FiberRef<?> ref) {
        this._fiberRefs = this._fiberRefs.delete(ref);
    }

    private void drainQueueOnCurrentThread(int depth) {
        block8: {
            int evaluationSignal;
            do {
                if (!this.running.get()) {
                    throw Scala3RunTime$.MODULE$.assertFailed();
                }
                evaluationSignal = 1;
                try {
                    if (RuntimeFlags$.MODULE$.currentFiber(this._runtimeFlags)) {
                        Fiber$.MODULE$._currentFiber().set(this);
                    }
                    while (evaluationSignal == 1) {
                        FiberMessage message = this.inbox.poll();
                        evaluationSignal = message == null ? 3 : this.evaluateMessageWhileSuspended(depth, message);
                    }
                }
                finally {
                    this.running.set(false);
                }
                if (this.inbox.isEmpty() || !this.running.compareAndSet(false, true)) break block8;
            } while (evaluationSignal != 2);
            this.drainQueueLaterOnExecutor();
            return;
        }
    }

    private void drainQueueLaterOnExecutor() {
        if (!this.running.get()) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        this.runningExecutor = this.getCurrentExecutor();
        this.runningExecutor.submitOrThrow(this, Unsafe$.MODULE$.unsafe());
    }

    private ZIO<Object, Object, Object> drainQueueWhileRunning(ZIO<Object, Object, Object> cur0) {
        ZIO<Object, Object, Object> cur = cur0;
        FiberMessage message = this.inbox.poll();
        if (message != null) {
            this.updateLastTrace(cur.trace());
        }
        while (message != null) {
            FiberMessage fiberMessage = message;
            if (fiberMessage instanceof FiberMessage.InterruptSignal) {
                Cause<Nothing$> cause;
                FiberMessage.InterruptSignal interruptSignal = FiberMessage$InterruptSignal$.MODULE$.unapply((FiberMessage.InterruptSignal)fiberMessage);
                Cause<Nothing$> cause2 = cause = interruptSignal._1();
                this.processNewInterruptSignal(cause2);
                if (this.isInterruptible()) {
                    cur = Exit$Failure$.MODULE$.apply(cause2);
                }
            } else if (fiberMessage instanceof FiberMessage.Stateful) {
                Function2<FiberRuntime<?, ?>, Fiber.Status, BoxedUnit> function2;
                FiberMessage.Stateful stateful = FiberMessage$Stateful$.MODULE$.unapply((FiberMessage.Stateful)fiberMessage);
                Function2<FiberRuntime<?, ?>, Fiber.Status, BoxedUnit> onFiber = function2 = stateful._1();
                this.processStatefulMessage(onFiber);
            } else {
                if (fiberMessage instanceof FiberMessage.Resume) {
                    FiberMessage.Resume resume = FiberMessage$Resume$.MODULE$.unapply((FiberMessage.Resume)fiberMessage);
                    ZIO<?, ?, ?> zIO = resume._1();
                    throw new IllegalStateException("It is illegal to have multiple concurrent run loops in a single fiber");
                }
                if (!FiberMessage$YieldNow$.MODULE$.equals(fiberMessage)) {
                    throw new MatchError((Object)fiberMessage);
                }
            }
            message = this.inbox.poll();
        }
        return cur;
    }

    private ZIO<Object, Object, Object> drainQueueAfterAsync() {
        ZIO<?, ?, ?> resumption = null;
        FiberMessage message = this.inbox.poll();
        while (message != null) {
            FiberMessage fiberMessage = message;
            if (fiberMessage instanceof FiberMessage.InterruptSignal) {
                Cause<Nothing$> cause;
                FiberMessage.InterruptSignal interruptSignal = FiberMessage$InterruptSignal$.MODULE$.unapply((FiberMessage.InterruptSignal)fiberMessage);
                Cause<Nothing$> cause2 = cause = interruptSignal._1();
                this.processNewInterruptSignal(cause2);
            } else if (fiberMessage instanceof FiberMessage.Stateful) {
                Function2<FiberRuntime<?, ?>, Fiber.Status, BoxedUnit> function2;
                FiberMessage.Stateful stateful = FiberMessage$Stateful$.MODULE$.unapply((FiberMessage.Stateful)fiberMessage);
                Function2<FiberRuntime<?, ?>, Fiber.Status, BoxedUnit> onFiber = function2 = stateful._1();
                this.processStatefulMessage(onFiber);
            } else if (fiberMessage instanceof FiberMessage.Resume) {
                ZIO<?, ?, ?> zIO;
                FiberMessage.Resume resume = FiberMessage$Resume$.MODULE$.unapply((FiberMessage.Resume)fiberMessage);
                ZIO<?, ?, ?> nextEffect0 = zIO = resume._1();
                if (resumption != null) {
                    throw Scala3RunTime$.MODULE$.assertFailed();
                }
                resumption = nextEffect0;
            } else if (!FiberMessage$YieldNow$.MODULE$.equals(fiberMessage)) {
                throw new MatchError((Object)fiberMessage);
            }
            message = this.inbox.poll();
        }
        return resumption;
    }

    private void ensureStackCapacity(int size) {
        ZIO.Continuation[] stack = this._stack;
        int stackLength = stack.length;
        if (stackLength < size) {
            int newSize = (size & size - 1) == 0 ? size : Integer.highestOneBit(size) << 1;
            ZIO.Continuation[] newStack = new ZIO.Continuation[newSize];
            System.arraycopy(stack, 0, newStack, 0, stackLength);
            this._stack = newStack;
        }
    }

    private Exit<E, A> evaluateEffect(int initialDepth, ZIO<Object, Object, Object> effect0) {
        Exit<Object, Object> exit;
        if (!this.running.get()) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        this._asyncContWith = null;
        this._blockingOn = FiberRuntime$.zio$internal$FiberRuntime$$$notBlockingOn;
        this.updateLastTrace(effect0.trace());
        Supervisor<Object> supervisor = this.getSupervisor();
        if (supervisor != Supervisor$.MODULE$.none()) {
            supervisor.onResume(this, Unsafe$.MODULE$.unsafe());
        }
        if (this._stack == null) {
            this._stack = new ZIO.Continuation[16];
        }
        try {
            ZIO<Object, Object, Object> effect = effect0;
            Exit<Object, Object> finalExit = null;
            while (effect != null) {
                try {
                    if (this.shouldInterrupt()) {
                        effect = Exit$Failure$.MODULE$.apply(this.getInterruptedCause());
                    }
                    Exit<Object, Object> exit2 = this.runLoop(effect, 0, this._stackSize, initialDepth);
                    if (supervisor != Supervisor$.MODULE$.none()) {
                        supervisor.onEnd(exit2, this, Unsafe$.MODULE$.unsafe());
                    }
                    this._runtimeFlags = RuntimeFlags$.MODULE$.enable(this._runtimeFlags, RuntimeFlag$WindDown$.MODULE$);
                    ZIO<Object, Nothing$, Object> interruption = this.interruptAllChildren();
                    if (interruption == null) {
                        if (this.inbox.isEmpty()) {
                            finalExit = exit2;
                            this.setExitValue(exit2);
                        } else {
                            this.tell(FiberMessage$Resume$.MODULE$.apply(exit2));
                        }
                        effect = null;
                        continue;
                    }
                    effect = interruption.flatMap((Function1 & Serializable)_$3 -> exit2, this.id().location());
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (AsyncJump$.MODULE$.equals(throwable2)) {
                        this._forksSinceYield = 0;
                        effect = null;
                        continue;
                    }
                    if (throwable2 != null) {
                        Throwable throwable3 = throwable2;
                        if (this.isFatal(throwable3)) {
                            throw this.handleFatalError(throwable3);
                        }
                        effect = ZIO$.MODULE$.failCause(() -> FiberRuntime.evaluateEffect$$anonfun$2(throwable3), this._lastTrace);
                        continue;
                    }
                    throw throwable;
                }
            }
            exit = finalExit;
        }
        finally {
            this.gcStack();
            Supervisor<Object> supervisor2 = this.getSupervisor();
            if (supervisor2 != Supervisor$.MODULE$.none()) {
                supervisor2.onSuspend(this, Unsafe$.MODULE$.unsafe());
            }
        }
        return exit;
    }

    private int evaluateMessageWhileSuspended(int depth, FiberMessage fiberMessage) {
        if (!this.running.get()) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        FiberMessage fiberMessage2 = fiberMessage;
        if (fiberMessage2 instanceof FiberMessage.InterruptSignal) {
            Cause<Nothing$> cause;
            FiberMessage.InterruptSignal interruptSignal = FiberMessage$InterruptSignal$.MODULE$.unapply((FiberMessage.InterruptSignal)fiberMessage2);
            Cause<Nothing$> cause2 = cause = interruptSignal._1();
            this.processNewInterruptSignal(cause2);
            return 1;
        }
        if (fiberMessage2 instanceof FiberMessage.Stateful) {
            Function2<FiberRuntime<?, ?>, Fiber.Status, BoxedUnit> function2;
            FiberMessage.Stateful stateful = FiberMessage$Stateful$.MODULE$.unapply((FiberMessage.Stateful)fiberMessage2);
            Function2<FiberRuntime<?, ?>, Fiber.Status, BoxedUnit> onFiber = function2 = stateful._1();
            this.processStatefulMessage(onFiber);
            return 1;
        }
        if (fiberMessage2 instanceof FiberMessage.Resume) {
            ZIO<Object, Object, Object> zIO;
            ZIO<Object, Object, Object> nextEffect0;
            FiberMessage.Resume resume = FiberMessage$Resume$.MODULE$.unapply((FiberMessage.Resume)fiberMessage2);
            ZIO<Object, Object, Object> nextEffect = nextEffect0 = (zIO = resume._1());
            this.evaluateEffect(depth, nextEffect);
            return 1;
        }
        if (FiberMessage$YieldNow$.MODULE$.equals(fiberMessage2)) {
            return 2;
        }
        throw new MatchError((Object)fiberMessage2);
    }

    public Exit<E, A> exitValue() {
        return this._exitValue();
    }

    private StackTrace generateStackTrace() {
        StackTraceBuilder builder = StackTraceBuilder$.MODULE$.make(Unsafe$.MODULE$.unsafe());
        ZIO.Continuation[] stack = this._stack;
        int size = this._stackSize;
        if (stack != null) {
            int i = (stack.length < size ? stack.length : size) - 1;
            while (i >= 0) {
                ZIO.Continuation k = stack[i];
                if (k == null) continue;
                builder.$plus$eq(k.trace());
                --i;
            }
        }
        builder.$plus$eq(this.id().location());
        return StackTrace$.MODULE$.apply(this.fiberId, builder.result());
    }

    public Set<Fiber.Runtime<?, ?>> getChildren() {
        if (this._children == null) {
            this._children = Platform$.MODULE$.newConcurrentWeakSet(Unsafe$.MODULE$.unsafe());
        }
        return this._children;
    }

    @Override
    public Executor getCurrentExecutor() {
        Option<Executor> option = this.getFiberRef(FiberRef$.MODULE$.overrideExecutor());
        if (None$.MODULE$.equals(option)) {
            return Runtime$.MODULE$.defaultExecutor();
        }
        if (option instanceof Some) {
            Executor value = (Executor)((Some)option).value();
            return value;
        }
        throw new MatchError(option);
    }

    @Override
    public <A> A getFiberRef(FiberRef<A> fiberRef) {
        return this._fiberRefs.getOrDefault(fiberRef);
    }

    public <A> A getFiberRefOrElse(FiberRef<A> fiberRef, Function0<A> orElse) {
        A a = this._fiberRefs.getOrNull(fiberRef);
        if (a == null) {
            return (A)orElse.apply();
        }
        A a2 = a;
        return a2;
    }

    public <A> Option<A> getFiberRefOption(FiberRef<A> fiberRef) {
        return this._fiberRefs.get(fiberRef);
    }

    @Override
    public FiberRefs getFiberRefs() {
        int flags0 = FiberRuntime$.MODULE$.zio$internal$FiberRuntime$$$excludeNonInheritable(this._runtimeFlags);
        this.setFiberRef(FiberRef$.MODULE$.currentRuntimeFlags(), BoxesRunTime.boxToInteger((int)flags0));
        return this._fiberRefs;
    }

    public Cause<Nothing$> getInterruptedCause() {
        return this.getFiberRef(FiberRef$.MODULE$.interruptedCause());
    }

    public scala.collection.immutable.Set<ZLogger<String, Object>> getLoggers() {
        return (scala.collection.immutable.Set)this.getFiberRef(FiberRef$.MODULE$.currentLoggers());
    }

    public Function1<Throwable, Nothing$> getReportFatal() {
        return this.getFiberRef(FiberRef$.MODULE$.currentReportFatal());
    }

    @Override
    public Option<Executor> getRunningExecutor() {
        if (this.runningExecutor == null) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply((Object)this.runningExecutor);
    }

    public Fiber.Status getStatus() {
        if (this._exitValue() != null) {
            return Fiber$Status$Done$.MODULE$;
        }
        return this._asyncContWith != null ? Fiber$Status$Suspended$.MODULE$.apply(this._runtimeFlags, this._lastTrace, (FiberId)this._blockingOn.apply()) : Fiber$Status$Running$.MODULE$.apply(this._runtimeFlags, this._lastTrace);
    }

    public Supervisor<Object> getSupervisor() {
        return (Supervisor)this.getFiberRef(FiberRef$.MODULE$.currentSupervisor());
    }

    private Nothing$ handleFatalError(Throwable throwable) {
        FiberRuntime$.MODULE$.catastrophicFailure().set(true);
        Function1<Throwable, Nothing$> errorReporter = this.getReportFatal();
        return (Nothing$)errorReporter.apply((Object)throwable);
    }

    private ZIO<Object, Object, Object> initiateAsync(Function1<Function1<ZIO<Object, Object, Object>, BoxedUnit>, ZIO<Object, Object, Object>> asyncRegister) {
        ZIO zIO;
        block6: {
            AtomicBoolean alreadyCalled = new AtomicBoolean(false);
            Object callback = effect -> {
                if (alreadyCalled.compareAndSet(false, true)) {
                    this.tell(FiberMessage$Resume$.MODULE$.apply((ZIO<?, ?, ?>)effect));
                    return;
                }
            };
            this._asyncContWith = this.isInterruptible() ? callback : FiberRuntime$.zio$internal$FiberRuntime$$$IgnoreContinuation;
            try {
                ZIO sync = (ZIO)asyncRegister.apply(callback);
                if (sync != null) {
                    if (alreadyCalled.compareAndSet(false, true)) {
                        this._asyncContWith = null;
                        this._blockingOn = FiberRuntime$.zio$internal$FiberRuntime$$$notBlockingOn;
                        zIO = sync;
                    } else {
                        this.log((Function0<String>)(Function0 & Serializable)() -> "Async operation attempted synchronous resumption, but its callback was already invoked; synchronous value will be discarded", (Cause<Object>)Cause$.MODULE$.empty(), (Option<LogLevel>)ZIO$.MODULE$.someError(), this.id().location());
                        zIO = null;
                    }
                    break block6;
                }
                zIO = null;
            }
            catch (Throwable throwable) {
                if (this.isFatal(throwable)) {
                    throw this.handleFatalError(throwable);
                }
                callback.apply(Exit$Failure$.MODULE$.apply(Cause$.MODULE$.die(throwable, Cause$.MODULE$.die$default$2())));
                zIO = null;
            }
        }
        return zIO;
    }

    private ZIO<Object, Nothing$, Object> interruptAllChildren() {
        if (this.sendInterruptSignalToAllChildren(this._children)) {
            java.util.Iterator<Fiber.Runtime<?, ?>> iterator = this._children.iterator();
            this._children = null;
            Function0 & Serializable body = (Function0 & Serializable)() -> {
                Fiber.Runtime next = (Fiber.Runtime)iterator.next();
                if (next != null) {
                    return next.await(this.id().location());
                }
                return Exit$.MODULE$.unit();
            };
            return ZIO$.MODULE$.whileLoop((Function0<Object>)((Function0 & Serializable)() -> FiberRuntime.interruptAllChildren$$anonfun$1(iterator)), body, (Function1 & Serializable)_$4 -> BoxedUnit.UNIT, this.id().location());
        }
        return null;
    }

    @Override
    public boolean isAlive() {
        return this._exitValue() == null;
    }

    public boolean isDone() {
        return this._exitValue() != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isInterrupted() {
        Cause<Nothing$> interruptedCause = this.getFiberRef(FiberRef$.MODULE$.interruptedCause());
        if (interruptedCause.nonEmpty()) return true;
        if (!Thread.interrupted()) {
            if (!false) return false;
            return true;
        }
        this.addInterruptedCause(Cause$.MODULE$.interrupt(FiberId$None$.MODULE$, Cause$.MODULE$.interrupt$default$2()));
        if (true) return true;
        return false;
    }

    public boolean isInterruptible() {
        return RuntimeFlags$.MODULE$.interruptible(this._runtimeFlags);
    }

    @Override
    public void log(Function0<String> message, Cause<Object> cause, Option<LogLevel> overrideLogLevel, Object trace) {
        LogLevel logLevel = overrideLogLevel.isDefined() ? (LogLevel)overrideLogLevel.get() : this.getFiberRef(FiberRef$.MODULE$.currentLogLevel());
        List<LogSpan> spans = this.getFiberRef(FiberRef$.MODULE$.currentLogSpan());
        Map<String, String> annotations = this.getFiberRef(FiberRef$.MODULE$.currentLogAnnotations());
        scala.collection.immutable.Set<ZLogger<String, Object>> loggers = this.getLoggers();
        FiberRefs contextMap = this.getFiberRefs();
        loggers.foreach((Function1 & Serializable)logger -> logger.apply(trace, this.fiberId, logLevel, message, cause, contextMap, spans, annotations));
    }

    private void processStatefulMessage(Function2<FiberRuntime<?, ?>, Fiber.Status, BoxedUnit> onFiber) {
        try {
            onFiber.apply((Object)this, (Object)this.getStatus());
        }
        catch (Throwable throwable) {
            if (this.isFatal(throwable)) {
                throw this.handleFatalError(throwable);
            }
            this.log((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(90).append("An unexpected error was encountered while processing stateful fiber message with callback ").append(onFiber).toString(), (Cause<Object>)Cause$.MODULE$.die(throwable, Cause$.MODULE$.die$default$2()), (Option<LogLevel>)ZIO$.MODULE$.someError(), this.id().location());
        }
    }

    private <R, E, A> ZIO<R, E, A> patchRuntimeFlags(long patch, Cause<E> cause, ZIO<R, E, A> continueEffect) {
        int oldFlags = this._runtimeFlags;
        int newFlags = RuntimeFlags$.MODULE$.patch(patch, oldFlags);
        if (oldFlags == newFlags) {
            return continueEffect;
        }
        if (RuntimeFlags$Patch$.MODULE$.isEnabled(patch, 2)) {
            Fiber$.MODULE$._currentFiber().set(this);
        } else if (RuntimeFlags$Patch$.MODULE$.isDisabled(patch, 2)) {
            Fiber$.MODULE$._currentFiber().set(null);
        }
        this._runtimeFlags = newFlags;
        if (this.shouldInterrupt()) {
            if (cause != null) {
                return Exit$Failure$.MODULE$.apply(cause.$plus$plus(this.getInterruptedCause()));
            }
            return Exit$Failure$.MODULE$.apply(this.getInterruptedCause());
        }
        if (cause != null) {
            return Exit$Failure$.MODULE$.apply(cause);
        }
        return continueEffect;
    }

    private void popStackFrame(int nextStackIndex) {
        if (nextStackIndex >= 128) {
            this._stack[nextStackIndex] = null;
        }
        this._stackSize = nextStackIndex;
    }

    private void gcStack() {
        int from = this._stackSize;
        if (from == 0) {
            this._stack = null;
            return;
        }
        ZIO.Continuation[] stack = this._stack;
        int stackLength = stack.length;
        int nNulls = stackLength - from;
        if (nNulls > 0 && stack[from] != null) {
            ZIO.Continuation[] nullArray = new ZIO.Continuation[nNulls];
            System.arraycopy(nullArray, 0, stack, from, nNulls);
            return;
        }
    }

    private void processNewInterruptSignal(Cause<Nothing$> cause) {
        this.addInterruptedCause(cause);
        this.sendInterruptSignalToAllChildren(this._children);
        Function1<ZIO<Object, Object, Object>, Object> k = this._asyncContWith;
        if (k != null && k != FiberRuntime$.zio$internal$FiberRuntime$$$notBlockingOn) {
            k.apply(Exit$Failure$.MODULE$.apply(cause));
            return;
        }
    }

    private int pushStackFrame(ZIO.Continuation k, int stackIndex) {
        int newSize = stackIndex + 1;
        this.ensureStackCapacity(newSize);
        this._stack[stackIndex] = k;
        this._stackSize = newSize;
        return newSize;
    }

    public void removeChild(FiberRuntime<?, ?> child) {
        if (this._children != null) {
            this._children.remove(child);
            return;
        }
    }

    public void removeObserver(Function1<Exit<E, A>, BoxedUnit> observer) {
        this.observers = this.observers.filter((Function1 & Serializable)_$5 -> _$5 != observer);
    }

    private Exit<Object, Object> runLoop(ZIO<Object, Object, Object> effect, int minStackIndex, int startStackIndex, int currentDepth) {
        if (!this.running.get()) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        ZIO<Object, Object, Object> cur = effect;
        Exit<Nothing$, Object> done = null;
        int ops = 0;
        int stackIndex = startStackIndex;
        if (currentDepth >= 300) {
            this.inbox.add(FiberMessage$Resume$.MODULE$.apply(effect));
            throw AsyncJump$.MODULE$;
        }
        while (done == null) {
            if (RuntimeFlags$.MODULE$.opSupervision(this._runtimeFlags)) {
                this.getSupervisor().onEffect(this, cur, Unsafe$.MODULE$.unsafe());
            }
            cur = this.drainQueueWhileRunning(cur);
            if (++ops > 10240) {
                this.updateLastTrace(cur.trace());
                this.inbox.add(FiberMessage$YieldNow$.MODULE$);
                this.inbox.add(FiberMessage$Resume$.MODULE$.apply(cur));
                throw AsyncJump$.MODULE$;
            }
            try {
                ZIO<Object, Object, Object> zIO = cur;
                if (zIO instanceof ZIO.Sync) {
                    ZIO.Sync sync = (ZIO.Sync)zIO;
                    this.updateLastTrace(sync.trace());
                    Object value = sync.eval().apply();
                    cur = null;
                    while (cur == null && this.stackSegmentIsNonEmpty(stackIndex, minStackIndex)) {
                        ZIO.Continuation continuation = this._stack[--stackIndex];
                        this.popStackFrame(stackIndex);
                        ZIO.Continuation continuation2 = continuation;
                        if (continuation2 instanceof ZIO.FlatMap) {
                            ZIO.FlatMap flatMap = (ZIO.FlatMap)continuation2;
                            Function1 f = flatMap.successK();
                            cur = (ZIO)f.apply(value);
                            continue;
                        }
                        if (continuation2 instanceof ZIO.FoldZIO) {
                            ZIO.FoldZIO foldZIO = (ZIO.FoldZIO)continuation2;
                            Function1 f = foldZIO.successK();
                            cur = (ZIO)f.apply(value);
                            continue;
                        }
                        if (continuation2 instanceof ZIO.UpdateRuntimeFlags) {
                            ZIO.UpdateRuntimeFlags updateFlags = (ZIO.UpdateRuntimeFlags)continuation2;
                            cur = this.patchRuntimeFlags(updateFlags.update(), null, null);
                            continue;
                        }
                        throw new MatchError((Object)continuation2);
                    }
                    if (cur != null) continue;
                    done = Exit$.MODULE$.succeed(value);
                    continue;
                }
                if (zIO instanceof Exit.Success) {
                    Exit.Success success = (Exit.Success)zIO;
                    Object value = success.value();
                    cur = null;
                    while (cur == null && this.stackSegmentIsNonEmpty(stackIndex, minStackIndex)) {
                        ZIO.Continuation continuation = this._stack[--stackIndex];
                        this.popStackFrame(stackIndex);
                        ZIO.Continuation continuation3 = continuation;
                        if (continuation3 instanceof ZIO.FlatMap) {
                            ZIO.FlatMap flatMap = (ZIO.FlatMap)continuation3;
                            Function1 f = flatMap.successK();
                            cur = (Exit<Object, Object>)f.apply(value);
                            continue;
                        }
                        if (continuation3 instanceof ZIO.FoldZIO) {
                            ZIO.FoldZIO foldZIO = (ZIO.FoldZIO)continuation3;
                            Function1 f = foldZIO.successK();
                            cur = (ZIO)f.apply(value);
                            continue;
                        }
                        if (continuation3 instanceof ZIO.UpdateRuntimeFlags) {
                            ZIO.UpdateRuntimeFlags updateFlags = (ZIO.UpdateRuntimeFlags)continuation3;
                            cur = this.patchRuntimeFlags(updateFlags.update(), null, null);
                            continue;
                        }
                        throw new MatchError((Object)continuation3);
                    }
                    if (cur != null) continue;
                    done = success;
                    continue;
                }
                if (zIO instanceof ZIO.FlatMap) {
                    Exit<Object, Object> failure;
                    ZIO.FlatMap flatMap0 = (ZIO.FlatMap)zIO;
                    this.updateLastTrace(flatMap0.trace());
                    ZIO.FlatMap effect2 = flatMap0;
                    stackIndex = this.pushStackFrame(effect2, stackIndex);
                    Exit<Object, Object> result = this.runLoop(effect2.first(), stackIndex, stackIndex, currentDepth + 1);
                    this.popStackFrame(--stackIndex);
                    Exit<Object, Object> exit = result;
                    if (exit instanceof Exit.Success) {
                        Object a;
                        Exit.Success success = Exit$Success$.MODULE$.unapply((Exit.Success)exit);
                        Object value = a = success._1();
                        cur = (ZIO)effect2.successK().apply(value);
                        continue;
                    }
                    cur = failure = exit;
                    continue;
                }
                if (zIO instanceof ZIO.Stateful) {
                    ZIO.Stateful stateful0 = (ZIO.Stateful)zIO;
                    this.updateLastTrace(stateful0.trace());
                    ZIO.Stateful stateful = stateful0;
                    cur = (ZIO<Object, Object, Object>)stateful.onState().apply((Object)this, (Object)Fiber$Status$Running$.MODULE$.apply(this._runtimeFlags, this._lastTrace));
                    continue;
                }
                if (zIO instanceof ZIO.FoldZIO) {
                    ZIO.FoldZIO effect0 = (ZIO.FoldZIO)zIO;
                    this.updateLastTrace(effect0.trace());
                    ZIO.FoldZIO effect3 = effect0;
                    stackIndex = this.pushStackFrame(effect3, stackIndex);
                    Exit<Object, Object> result = this.runLoop(effect3.first(), stackIndex, stackIndex, currentDepth + 1);
                    this.popStackFrame(--stackIndex);
                    Exit<Object, Object> exit = result;
                    if (exit instanceof Exit.Success) {
                        Object a;
                        Exit.Success success = Exit$Success$.MODULE$.unapply((Exit.Success)exit);
                        Object value = a = success._1();
                        cur = (ZIO)effect3.successK().apply(value);
                        continue;
                    }
                    if (exit instanceof Exit.Failure) {
                        Cause cause;
                        Exit.Failure failure = Exit$Failure$.MODULE$.unapply((Exit.Failure)exit);
                        Cause cause2 = cause = failure._1();
                        if (this.shouldInterrupt()) {
                            cur = Exit$Failure$.MODULE$.apply(cause2.stripFailures());
                            continue;
                        }
                        Function1 f = effect3.failureK();
                        cur = (ZIO)f.apply(cause2);
                        continue;
                    }
                    throw new MatchError(exit);
                }
                if (zIO instanceof ZIO.Async) {
                    ZIO.Async effect4 = (ZIO.Async)zIO;
                    this.updateLastTrace(effect4.trace());
                    this._blockingOn = effect4.blockingOn();
                    cur = this.initiateAsync(effect4.registerCallback());
                    while (cur == null) {
                        cur = this.drainQueueAfterAsync();
                        if (cur != null || this.stealWork(currentDepth)) continue;
                        throw AsyncJump$.MODULE$;
                    }
                    if (!this.shouldInterrupt()) continue;
                    cur = Exit$.MODULE$.failCause(this.getInterruptedCause());
                    continue;
                }
                if (zIO instanceof ZIO.UpdateRuntimeFlagsWithin) {
                    ZIO.UpdateRuntimeFlagsWithin effect5 = (ZIO.UpdateRuntimeFlagsWithin)zIO;
                    this.updateLastTrace(effect5.trace());
                    long updateFlags = effect5.update();
                    int oldRuntimeFlags = this._runtimeFlags;
                    int newRuntimeFlags = RuntimeFlags$.MODULE$.patch(updateFlags, oldRuntimeFlags);
                    if (newRuntimeFlags == oldRuntimeFlags) {
                        cur = effect5.scope(oldRuntimeFlags);
                        continue;
                    }
                    if (RuntimeFlags$.MODULE$.interruptible(newRuntimeFlags) && this.isInterrupted()) {
                        cur = Exit$Failure$.MODULE$.apply(this.getInterruptedCause());
                        continue;
                    }
                    ZIO zIO2 = this.patchRuntimeFlags(updateFlags, null, null);
                    long revertFlags = RuntimeFlags$.MODULE$.diff(newRuntimeFlags, oldRuntimeFlags);
                    ZIO.UpdateRuntimeFlags k = ZIO$UpdateRuntimeFlags$.MODULE$.apply(effect5.trace(), revertFlags);
                    stackIndex = this.pushStackFrame(k, stackIndex);
                    Exit<Object, Object> exit = this.runLoop(effect5.scope(oldRuntimeFlags), stackIndex, stackIndex, currentDepth + 1);
                    this.popStackFrame(--stackIndex);
                    cur = this.patchRuntimeFlags(revertFlags, exit.causeOrNull(), exit);
                    continue;
                }
                if (zIO instanceof ZIO.GenerateStackTrace) {
                    ZIO.GenerateStackTrace gen0 = (ZIO.GenerateStackTrace)zIO;
                    this.updateLastTrace(gen0.trace());
                    cur = Exit$.MODULE$.succeed(this.generateStackTrace());
                    continue;
                }
                if (zIO instanceof Exit.Failure) {
                    Exit.Failure failure = (Exit.Failure)zIO;
                    Cause<Object> cause = failure.cause();
                    cur = null;
                    while (cur == null && this.stackSegmentIsNonEmpty(stackIndex, minStackIndex)) {
                        ZIO.Continuation continuation = this._stack[--stackIndex];
                        this.popStackFrame(stackIndex);
                        ZIO.Continuation continuation4 = continuation;
                        if (continuation4 instanceof ZIO.FlatMap) {
                            ZIO.FlatMap flatMap = (ZIO.FlatMap)continuation4;
                            continue;
                        }
                        if (continuation4 instanceof ZIO.FoldZIO) {
                            ZIO.FoldZIO foldZIO = (ZIO.FoldZIO)continuation4;
                            if (this.shouldInterrupt()) {
                                cause = cause.stripFailures();
                                continue;
                            }
                            Function1 f = foldZIO.failureK();
                            cur = (ZIO)f.apply(cause);
                            continue;
                        }
                        if (continuation4 instanceof ZIO.UpdateRuntimeFlags) {
                            ZIO.UpdateRuntimeFlags updateFlags = (ZIO.UpdateRuntimeFlags)continuation4;
                            cur = this.patchRuntimeFlags(updateFlags.update(), cause, null);
                            continue;
                        }
                        throw new MatchError((Object)continuation4);
                    }
                    if (cur != null) continue;
                    done = failure;
                    continue;
                }
                if (zIO instanceof ZIO.UpdateRuntimeFlags) {
                    ZIO.UpdateRuntimeFlags updateRuntimeFlags = (ZIO.UpdateRuntimeFlags)zIO;
                    this.updateLastTrace(updateRuntimeFlags.trace());
                    cur = this.patchRuntimeFlags(updateRuntimeFlags.update(), null, Exit$.MODULE$.unit());
                    continue;
                }
                if (zIO instanceof ZIO.WhileLoop) {
                    ZIO.WhileLoop iterate0 = (ZIO.WhileLoop)zIO;
                    this.updateLastTrace(iterate0.trace());
                    ZIO.WhileLoop iterate = iterate0;
                    Function0<Object> check = iterate.check();
                    ZIO.Continuation k = ZIO$Continuation$.MODULE$.apply((Function1 & Serializable)element -> {
                        iterate.process().apply(element);
                        return iterate;
                    }, iterate.trace());
                    stackIndex = this.pushStackFrame(k, stackIndex);
                    int nextDepth = currentDepth + 1;
                    cur = null;
                    while (cur == null && check.apply$mcZ$sp()) {
                        Exit<Object, Object> exit = this.runLoop((ZIO)iterate.body().apply(), stackIndex, stackIndex, nextDepth);
                        if (exit instanceof Exit.Success) {
                            Object a;
                            Exit.Success success = Exit$Success$.MODULE$.unapply((Exit.Success)exit);
                            Object value = a = success._1();
                            iterate.process().apply(value);
                            continue;
                        }
                        Exit<Object, Object> failure = exit;
                        cur = failure;
                    }
                    this.popStackFrame(--stackIndex);
                    if (cur != null) continue;
                    cur = Exit$.MODULE$.unit();
                    continue;
                }
                if (zIO instanceof ZIO.YieldNow) {
                    ZIO.YieldNow yieldNow = (ZIO.YieldNow)zIO;
                    this.updateLastTrace(yieldNow.trace());
                    if (yieldNow.forceAsync() || !this.stealWork(currentDepth)) {
                        this.inbox.add(FiberMessage$YieldNow$.MODULE$);
                        this.inbox.add(FiberMessage$.MODULE$.resumeUnit());
                        throw AsyncJump$.MODULE$;
                    }
                    cur = Exit$.MODULE$.unit();
                    continue;
                }
                throw new MatchError(zIO);
            }
            catch (InterruptedException interruptedException) {
                this.updateLastTrace(cur.trace());
                cur = this.drainQueueWhileRunning(Exit$Failure$.MODULE$.apply(Cause$.MODULE$.interrupt(FiberId$None$.MODULE$, Cause$.MODULE$.interrupt$default$2()).$plus$plus(Cause$.MODULE$.die(interruptedException, Cause$.MODULE$.die$default$2()))));
            }
        }
        return done;
    }

    private boolean sendInterruptSignalToAllChildrenConcurrently() {
        Set<Fiber.Runtime<?, ?>> childFibers = this._children;
        if (childFibers != null) {
            return BoxesRunTime.unboxToBoolean(Sync$.MODULE$.apply(childFibers, () -> this.sendInterruptSignalToAllChildrenConcurrently$$anonfun$1(childFibers)));
        }
        return false;
    }

    private boolean sendInterruptSignalToAllChildren(Set<Fiber.Runtime<?, ?>> children) {
        if (children == null || children.isEmpty()) {
            return false;
        }
        java.util.Iterator<Fiber.Runtime<?, ?>> iterator = children.iterator();
        boolean told = false;
        Cause<Nothing$> cause = Cause$.MODULE$.interrupt(this.fiberId, Cause$.MODULE$.interrupt$default$2());
        while (iterator.hasNext()) {
            Fiber.Runtime<?, ?> next = iterator.next();
            if (next == null || !next.isAlive()) continue;
            next.tellInterrupt(cause);
            told = true;
        }
        return told;
    }

    private void setExitValue(Exit<E, A> e) {
        this._exitValue_$eq(e);
        if (RuntimeFlags$.MODULE$.runtimeMetrics(this._runtimeFlags)) {
            long startTimeMillis = this.fiberId.startTimeMillis();
            long endTimeMillis = System.currentTimeMillis();
            double lifetime = (double)(endTimeMillis - startTimeMillis) / 1000.0;
            scala.collection.immutable.Set tags = (scala.collection.immutable.Set)this.getFiberRef(FiberRef$.MODULE$.currentTags());
            Metric$runtime$.MODULE$.fiberLifetimes().unsafe().update(BoxesRunTime.boxToDouble((double)lifetime), (scala.collection.immutable.Set<MetricLabel>)tags, Unsafe$.MODULE$.unsafe());
        }
        this.reportExitValue$1(e);
        Iterator iterator = this.observers.reverseIterator();
        while (iterator.hasNext()) {
            Function1 observer = (Function1)iterator.next();
            observer.apply(e);
        }
        this.observers = package$.MODULE$.Nil();
    }

    @Override
    public <A> void setFiberRef(FiberRef<A> fiberRef, A value) {
        this._fiberRefs = this._fiberRefs.updatedAs(this.fiberId, fiberRef, value);
    }

    @Override
    public void setFiberRefs(FiberRefs fiberRefs0) {
        this._fiberRefs = fiberRefs0;
    }

    public boolean shouldInterrupt() {
        return this.isInterruptible() && this.isInterrupted();
    }

    private boolean stackSegmentIsNonEmpty(int currentStackIndex, int segmentStackIndex) {
        return currentStackIndex > segmentStackIndex;
    }

    public <R> Exit<E, A> start(ZIO<R, E, A> effect) {
        if (this.running.compareAndSet(false, true)) {
            Exit<E, A> exit;
            Fiber.Runtime<?, ?> previousFiber = null;
            try {
                if (RuntimeFlags$.MODULE$.currentFiber(this._runtimeFlags)) {
                    previousFiber = Fiber$.MODULE$._currentFiber().get();
                    Fiber$.MODULE$._currentFiber().set(this);
                }
                exit = this.evaluateEffect(0, effect);
            }
            finally {
                if (previousFiber != null || RuntimeFlags$.MODULE$.currentFiber(this._runtimeFlags)) {
                    Fiber$.MODULE$._currentFiber().set(previousFiber);
                }
                this.running.set(false);
                if (!this.inbox.isEmpty() && this.running.compareAndSet(false, true)) {
                    this.drainQueueLaterOnExecutor();
                }
            }
            return exit;
        }
        this.tell(FiberMessage$Resume$.MODULE$.apply(effect));
        return null;
    }

    public void startConcurrently(ZIO<?, E, A> effect) {
        this.tell(FiberMessage$Resume$.MODULE$.apply(effect));
    }

    public Function1<ZIO<?, E, A>, Object> startSuspended(Unsafe unsafe) {
        JProcedure1 & Serializable callback;
        AtomicBoolean alreadyCalled = new AtomicBoolean(false);
        this._asyncContWith = callback = (JProcedure1 & Serializable)effect -> {
            if (alreadyCalled.compareAndSet(false, true)) {
                this.tell(FiberMessage$Resume$.MODULE$.apply((ZIO<?, ?, ?>)effect));
                return;
            }
        };
        this._blockingOn = FiberRuntime$.zio$internal$FiberRuntime$$$notBlockingOn;
        return callback;
    }

    private boolean stealWork(int depth) {
        return false;
    }

    private boolean stealWork(int depth0, int flags) {
        boolean stolen;
        int depth = depth0 + 50;
        boolean bl = stolen = RuntimeFlags$.MODULE$.workStealing(flags) && depth < 150 && this.getCurrentExecutor().stealWork(depth + 50);
        if (stolen && RuntimeFlags$.MODULE$.currentFiber(flags)) {
            Fiber$.MODULE$._currentFiber().set(this);
        }
        return stolen;
    }

    public void tell(FiberMessage message) {
        this.inbox.add(message);
        if (this.running.compareAndSet(false, true)) {
            this.drainQueueLaterOnExecutor();
            return;
        }
    }

    @Override
    public void tellAddChild(Fiber.Runtime<?, ?> child) {
        this.tell(FiberMessage$Stateful$.MODULE$.apply((Function2<FiberRuntime<?, ?>, Fiber.Status, BoxedUnit>)(JProcedure2 & Serializable)(parentFiber, _$6) -> parentFiber.addChild(child)));
    }

    @Override
    public void tellInterrupt(Cause<Nothing$> cause) {
        this.tell(FiberMessage$InterruptSignal$.MODULE$.apply(cause));
    }

    @Override
    public void transferChildren(FiberScope scope) {
        Set<Fiber.Runtime<?, ?>> children = this._children;
        if (children != null && !children.isEmpty()) {
            java.util.Iterator<Fiber.Runtime<?, ?>> iterator = children.iterator();
            int flags = this._runtimeFlags;
            while (iterator.hasNext()) {
                Fiber.Runtime<?, ?> next = iterator.next();
                if (next == null || !next.isAlive()) continue;
                scope.add(this, flags, next, this.location(), Unsafe$.MODULE$.unsafe());
                iterator.remove();
            }
            return;
        }
    }

    public <A> void updateFiberRef(FiberRef<A> fiberRef, Function1<A, A> f) {
        this.setFiberRef(fiberRef, f.apply(this.getFiberRef(fiberRef)));
    }

    private void updateLastTrace(Object newTrace) {
        if (newTrace != null && newTrace != this.emptyTrace && this._lastTrace != newTrace) {
            this._lastTrace = newTrace;
            return;
        }
    }

    @Override
    public Fiber.Runtime.UnsafeAPI unsafe() {
        return new Fiber.Runtime.UnsafeAPI(this){
            private final /* synthetic */ FiberRuntime $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void addObserver(Function1 observer, Unsafe unsafe) {
                this.$outer.addObserver(observer, unsafe);
            }

            public void deleteFiberRef(FiberRef ref, Unsafe unsafe) {
                this.$outer.deleteFiberRef(ref);
            }

            public FiberRefs getFiberRefs(Unsafe unsafe) {
                return this.$outer.getFiberRefs();
            }

            public void removeObserver(Function1 observer, Unsafe unsafe) {
                this.$outer.removeObserver(observer);
            }
        };
    }

    public int hashCode() {
        return this.fiberId.hashCode();
    }

    private static final /* synthetic */ void await$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(Function1 cb$1, FiberRuntime fiber, Fiber.Status _$1) {
        if (fiber._exitValue() != null) {
            cb$1.apply(fiber._exitValue());
            return;
        }
        fiber.addObserver(cb$1, Unsafe$.MODULE$.unsafe());
    }

    private final /* synthetic */ void await$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2(Function1 cb$2, Unsafe evidence$2) {
        this.tell(FiberMessage$Stateful$.MODULE$.apply((Function2<FiberRuntime<?, ?>, Fiber.Status, BoxedUnit>)(JProcedure2 & Serializable)(fiber, _$2) -> fiber.removeObserver(cb$2)));
    }

    private final FiberId await$$anonfun$1$$anonfun$2() {
        return this.id();
    }

    private final ZIO await$$anonfun$1(Object trace$1) {
        if (this._exitValue() != null) {
            return Exit$.MODULE$.succeed(this._exitValue());
        }
        return ZIO$.MODULE$.asyncInterrupt((Function1 & Serializable)evidence$1 -> (Function1 & Serializable)k -> {
            JProcedure1 & Serializable cb = (JProcedure1 & Serializable)exit -> k.apply(Exit$Success$.MODULE$.apply(exit));
            this.tell(FiberMessage$Stateful$.MODULE$.apply((Function2<FiberRuntime<?, ?>, Fiber.Status, BoxedUnit>)((JProcedure2 & Serializable)(arg_0, arg_1) -> FiberRuntime.await$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1((Function1)cb, arg_0, arg_1))));
            return package$.MODULE$.Left().apply((Object)ZIO$.MODULE$.succeed((Function1)((JProcedure1 & Serializable)arg_0 -> this.await$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2((Function1)cb, arg_0)), trace$1));
        }, this::await$$anonfun$1$$anonfun$2, trace$1);
    }

    private static final Chunk children$$anonfun$1$$anonfun$1(Set childs$1) {
        return Chunk$.MODULE$.fromJavaIterable(childs$1);
    }

    private static final Cause evaluateEffect$$anonfun$2(Throwable throwable$1) {
        return Cause$.MODULE$.die(throwable$1, Cause$.MODULE$.die$default$2());
    }

    private static final boolean interruptAllChildren$$anonfun$1(java.util.Iterator iterator$2) {
        return iterator$2.hasNext();
    }

    private final boolean sendInterruptSignalToAllChildrenConcurrently$$anonfun$1(Set childFibers$1) {
        return this.sendInterruptSignalToAllChildren(childFibers$1);
    }

    private final void reportExitValue$1(Exit v) {
        Exit exit = v;
        if (exit instanceof Exit.Failure) {
            Cause<Object> cause;
            Exit.Failure failure = Exit$Failure$.MODULE$.unapply((Exit.Failure)exit);
            Cause<Object> cause2 = cause = failure._1();
            try {
                if (!cause2.isInterruptedOnly()) {
                    this.log((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("Fiber ").append(this.fiberId.threadName()).append(" did not handle an error").toString(), cause2, this.getFiberRef(FiberRef$.MODULE$.unhandledErrorLogLevel()), this.id().location());
                }
                if (RuntimeFlags$.MODULE$.runtimeMetrics(this._runtimeFlags)) {
                    scala.collection.immutable.Set tags = (scala.collection.immutable.Set)this.getFiberRef(FiberRef$.MODULE$.currentTags());
                    Metric$runtime$.MODULE$.fiberFailures().unsafe().update(BoxesRunTime.boxToLong((long)1L), (scala.collection.immutable.Set<MetricLabel>)tags, Unsafe$.MODULE$.unsafe());
                    cause2.foldContext(tags, FiberRuntime$.zio$internal$FiberRuntime$$$fiberFailureTracker);
                }
            }
            catch (Throwable throwable) {
                if (this.isFatal(throwable)) {
                    throw this.handleFatalError(throwable);
                }
                Predef$.MODULE$.println((Object)"An exception was thrown by a logger:");
                throwable.printStackTrace();
            }
            return;
        }
        if (RuntimeFlags$.MODULE$.runtimeMetrics(this._runtimeFlags)) {
            scala.collection.immutable.Set tags = (scala.collection.immutable.Set)this.getFiberRef(FiberRef$.MODULE$.currentTags());
            Metric$runtime$.MODULE$.fiberSuccesses().unsafe().update(BoxesRunTime.boxToLong((long)1L), (scala.collection.immutable.Set<MetricLabel>)tags, Unsafe$.MODULE$.unsafe());
            return;
        }
    }
}

