/*
 * Decompiled with CFR 0.152.
 */
package zio.internal;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import scala.Function1;
import scala.Int$;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.math.package$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import zio.Chunk;
import zio.Chunk$;
import zio.ChunkBuilder;
import zio.ChunkBuilder$;
import zio.internal.HeadPadding;
import zio.internal.MutableQueueFieldsPadding;
import zio.internal.RingBuffer$;
import zio.internal.TailPadding;

public abstract class RingBuffer<A>
extends MutableQueueFieldsPadding<A> {
    private final int capacity;
    private final Object[] buf;
    private final AtomicLongArray seq;

    public static <A> RingBuffer<A> apply(int n) {
        return RingBuffer$.MODULE$.apply(n);
    }

    public static int nextPow2(int n) {
        return RingBuffer$.MODULE$.nextPow2(n);
    }

    public RingBuffer(int capacity) {
        this.capacity = capacity;
        this.buf = new Object[capacity];
        this.seq = new AtomicLongArray(capacity);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), capacity).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.seq.set(i, i));
    }

    @Override
    public final int capacity() {
        return this.capacity;
    }

    public abstract int posToIdx(long var1, int var3);

    @Override
    public final int size() {
        return (int)(MutableQueueFieldsPadding.tailUpdater.get(this) - MutableQueueFieldsPadding.headUpdater.get(this));
    }

    @Override
    public final long enqueuedCount() {
        return MutableQueueFieldsPadding.tailUpdater.get(this);
    }

    @Override
    public final long dequeuedCount() {
        return MutableQueueFieldsPadding.headUpdater.get(this);
    }

    @Override
    public final boolean offer(A a) {
        int aCapacity = this.capacity();
        AtomicLongArray aSeq = this.seq;
        long curSeq = 0L;
        AtomicLongFieldUpdater<HeadPadding> aHead = MutableQueueFieldsPadding.headUpdater;
        long curHead = 0L;
        AtomicLongFieldUpdater<TailPadding> aTail = MutableQueueFieldsPadding.tailUpdater;
        long curTail = aTail.get(this);
        int curIdx = 0;
        int state = 0;
        while (state == 0) {
            curIdx = this.posToIdx(curTail, aCapacity);
            curSeq = aSeq.get(curIdx);
            if (curSeq < curTail) {
                curHead = aHead.get(this);
                if (curTail >= curHead + (long)aCapacity) {
                    state = -2;
                    continue;
                }
                state = 0;
                continue;
            }
            if (curSeq == curTail) {
                if (aTail.compareAndSet(this, curTail, curTail + 1L)) {
                    state = 1;
                    continue;
                }
                ++curTail;
                state = 0;
                continue;
            }
            curTail = aTail.get(this);
            state = 0;
        }
        if (state == 1) {
            this.buf[curIdx] = a;
            aSeq.lazySet(curIdx, curTail + 1L);
            return true;
        }
        return false;
    }

    @Override
    public final <A1 extends A> Chunk<A1> offerAll(Iterable<A1> as) {
        return this.offerAll(as.iterator(), Int$.MODULE$.int2long(as.size()));
    }

    public final <A1 extends A> Chunk<A1> offerAll(Iterator<A1> as, long offers) {
        int aCapacity = this.capacity();
        AtomicLongArray aSeq = this.seq;
        long curSeq = 0L;
        AtomicLongFieldUpdater<HeadPadding> aHead = MutableQueueFieldsPadding.headUpdater;
        long curHead = 0L;
        AtomicLongFieldUpdater<TailPadding> aTail = MutableQueueFieldsPadding.tailUpdater;
        long curTail = 0L;
        int curIdx = 0;
        long enqHead = 0L;
        long enqTail = 0L;
        int state = 0;
        while (state == 0) {
            curHead = aHead.get(this);
            curTail = aTail.get(this);
            long size = curTail - curHead;
            long available = (long)aCapacity - size;
            long forQueue = package$.MODULE$.min(offers, available);
            if (forQueue == 0L) {
                state = -2;
                continue;
            }
            enqHead = curTail;
            enqTail = curTail + forQueue;
            boolean bl = true;
            while (bl & enqHead < enqTail) {
                curIdx = this.posToIdx(enqHead, aCapacity);
                curSeq = aSeq.get(curIdx);
                if (curSeq != enqHead) {
                    bl = false;
                }
                ++enqHead;
            }
            if (bl && aTail.compareAndSet(this, curTail, enqTail)) {
                enqHead = curTail;
                state = 1;
                continue;
            }
            state = 0;
        }
        if (state == 1) {
            while (enqHead < enqTail) {
                Object a = as.next();
                curIdx = this.posToIdx(enqHead, aCapacity);
                this.buf[curIdx] = a;
                aSeq.lazySet(curIdx, enqHead + 1L);
                ++enqHead;
            }
        }
        return Chunk$.MODULE$.fromIterator(as);
    }

    @Override
    public final A poll(A a) {
        int aCapacity = this.capacity();
        Object[] aBuf = this.buf;
        AtomicLongArray aSeq = this.seq;
        long curSeq = 0L;
        AtomicLongFieldUpdater<HeadPadding> aHead = MutableQueueFieldsPadding.headUpdater;
        long curHead = aHead.get(this);
        int curIdx = 0;
        AtomicLongFieldUpdater<TailPadding> aTail = MutableQueueFieldsPadding.tailUpdater;
        long curTail = 0L;
        int state = 0;
        while (state == 0) {
            curIdx = this.posToIdx(curHead, aCapacity);
            curSeq = aSeq.get(curIdx);
            if (curSeq <= curHead) {
                curTail = aTail.get(this);
                if (curHead >= curTail) {
                    state = -1;
                    continue;
                }
                state = 0;
                continue;
            }
            if (curSeq == curHead + 1L) {
                if (aHead.compareAndSet(this, curHead, curHead + 1L)) {
                    state = 1;
                    continue;
                }
                ++curHead;
                state = 0;
                continue;
            }
            curHead = aHead.get(this);
            state = 0;
        }
        if (state == 1) {
            Object deqElement = aBuf[curIdx];
            aBuf[curIdx] = null;
            aSeq.lazySet(curIdx, curHead + (long)aCapacity);
            return (A)deqElement;
        }
        return a;
    }

    @Override
    public final Chunk<A> pollUpTo(int n) {
        int aCapacity = this.capacity();
        AtomicLongArray aSeq = this.seq;
        long curSeq = 0L;
        AtomicLongFieldUpdater<HeadPadding> aHead = MutableQueueFieldsPadding.headUpdater;
        long curHead = 0L;
        int curIdx = 0;
        AtomicLongFieldUpdater<TailPadding> aTail = MutableQueueFieldsPadding.tailUpdater;
        long curTail = 0L;
        long takers = n;
        long deqHead = 0L;
        long deqTail = 0L;
        int state = 0;
        while (state == 0) {
            curHead = aHead.get(this);
            curTail = aTail.get(this);
            long size = curTail - curHead;
            long toTake = package$.MODULE$.min(takers, size);
            if (toTake <= 0L) {
                state = -1;
                continue;
            }
            deqTail = curHead + toTake;
            boolean bl = true;
            for (deqHead = curHead; bl && deqHead < deqTail; ++deqHead) {
                curIdx = this.posToIdx(deqHead, aCapacity);
                curSeq = aSeq.get(curIdx);
                if (curSeq == deqHead + 1L) continue;
                bl = false;
            }
            if (bl && aHead.compareAndSet(this, curHead, deqTail)) {
                deqHead = curHead;
                state = 1;
                continue;
            }
            state = 0;
        }
        if (state == 1) {
            ChunkBuilder builder = ChunkBuilder$.MODULE$.make((int)(deqTail - deqHead));
            while (deqHead < deqTail) {
                curIdx = this.posToIdx(deqHead, aCapacity);
                Object a = this.buf[curIdx];
                this.buf[curIdx] = null;
                aSeq.lazySet(curIdx, deqHead + (long)aCapacity);
                builder.addOne(a);
                ++deqHead;
            }
            return (Chunk)builder.result();
        }
        return Chunk$.MODULE$.empty();
    }

    @Override
    public final boolean isEmpty() {
        return MutableQueueFieldsPadding.tailUpdater.get(this) == MutableQueueFieldsPadding.headUpdater.get(this);
    }

    @Override
    public final boolean isFull() {
        return MutableQueueFieldsPadding.tailUpdater.get(this) == MutableQueueFieldsPadding.headUpdater.get(this) + (long)this.capacity();
    }
}

