/*
 * Decompiled with CFR 0.152.
 */
package zio.stm;

import java.io.Serializable;
import java.util.HashMap;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Predef$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichLong$;
import scala.runtime.function.JProcedure3;
import zio.Scope;
import zio.Scope$;
import zio.ZIO;
import zio.ZIO$;
import zio.stm.TRef;
import zio.stm.TSemaphore$;
import zio.stm.ZSTM;
import zio.stm.ZSTM$;
import zio.stm.ZSTM$Acquire$;
import zio.stm.ZSTM$Effect$;
import zio.stm.ZSTM$RetryException$;

public final class TSemaphore
implements Serializable {
    private final TRef permits;

    public static ZSTM<Object, Nothing$, TSemaphore> make(Function0<Object> function0, Object object) {
        return TSemaphore$.MODULE$.make(function0, object);
    }

    public static ZIO<Object, Nothing$, TSemaphore> makeCommit(Function0<Object> function0, Object object) {
        return TSemaphore$.MODULE$.makeCommit(function0, object);
    }

    public TSemaphore(TRef<Object> permits) {
        this.permits = permits;
    }

    public TRef<Object> permits() {
        return this.permits;
    }

    public ZSTM<Object, Nothing$, BoxedUnit> acquire() {
        return this.acquireBetween(1L, 1L).unit();
    }

    public ZSTM<Object, Nothing$, BoxedUnit> acquireN(long n) {
        return this.acquireBetween(n, n).unit();
    }

    public ZSTM<Object, Nothing$, Object> acquireBetween(long min, long max) {
        return ZSTM$Effect$.MODULE$.apply((Function3 & Serializable)(journal, _$1, _$2) -> {
            Predef$.MODULE$.require(min <= max, () -> TSemaphore.acquireBetween$$anonfun$1$$anonfun$1(min, max));
            this.assertNonNegative(min);
            this.assertNonNegative(max);
            long available = BoxesRunTime.unboxToLong((Object)this.permits().unsafeGet((HashMap<TRef<?>, ZSTM.internal.Entry>)journal));
            if (available < min) {
                throw ZSTM$RetryException$.MODULE$;
            }
            long requested = RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(available), max);
            this.permits().unsafeSet((HashMap<TRef<?>, ZSTM.internal.Entry>)journal, BoxesRunTime.boxToLong((long)(available - requested)));
            return requested;
        });
    }

    public ZSTM<Object, Nothing$, Object> acquireUpTo(long max) {
        return this.acquireBetween(0L, max);
    }

    public ZSTM<Object, Nothing$, Object> available() {
        return this.permits().get();
    }

    public ZSTM<Object, Nothing$, BoxedUnit> release() {
        return this.releaseN(1L);
    }

    public ZSTM<Object, Nothing$, BoxedUnit> releaseN(long n) {
        return ZSTM$Effect$.MODULE$.apply((JProcedure3 & Serializable)(journal, _$3, _$4) -> {
            this.assertNonNegative(n);
            long current = BoxesRunTime.unboxToLong((Object)this.permits().unsafeGet((HashMap<TRef<?>, ZSTM.internal.Entry>)journal));
            this.permits().unsafeSet((HashMap<TRef<?>, ZSTM.internal.Entry>)journal, BoxesRunTime.boxToLong((long)(current + n)));
        });
    }

    public <R, E, A> ZIO<R, E, A> withPermit(ZIO<R, E, A> zio, Object trace) {
        return this.withPermits(1L, zio, trace);
    }

    public ZIO<Scope, Nothing$, BoxedUnit> withPermitScoped(Object trace) {
        return this.withPermitsScoped(1L, trace);
    }

    public <R, E, A> ZIO<R, E, A> withPermits(long n, ZIO<R, E, A> zio, Object trace) {
        Function0 function0 = ZSTM$.MODULE$.acquireReleaseWith(this.acquireN(n));
        return ZSTM$Acquire$.MODULE$.apply$extension(function0, (Function1 & Serializable)_$5 -> this.releaseN(n).commit(trace)).apply((Function1 & Serializable)_$6 -> zio, trace);
    }

    public <R, E, A> ZIO<R, E, A> withPermitsBetween(long min, long max, Function1<Object, ZIO<R, E, A>> zio, Object trace) {
        Function0 function0 = ZSTM$.MODULE$.acquireReleaseWith(this.acquireBetween(min, max));
        return ZSTM$Acquire$.MODULE$.apply$extension(function0, (Function1 & Serializable)actualN -> this.withPermitsBetween$$anonfun$1(trace, BoxesRunTime.unboxToLong((Object)actualN))).apply(zio, trace);
    }

    public <R, E, A> ZIO<R, E, A> withPermitsUpTo(long max, Function1<Object, ZIO<R, E, A>> zio, Object trace) {
        Function0 function0 = ZSTM$.MODULE$.acquireReleaseWith(this.acquireUpTo(max));
        return ZSTM$Acquire$.MODULE$.apply$extension(function0, (Function1 & Serializable)actualN -> this.withPermitsUpTo$$anonfun$1(trace, BoxesRunTime.unboxToLong((Object)actualN))).apply(zio, trace);
    }

    public ZIO<Scope, Nothing$, BoxedUnit> withPermitsScoped(long n, Object trace) {
        Function0 function0 = ZSTM$.MODULE$.acquireReleaseWith(this.acquireN(n));
        return ZSTM$Acquire$.MODULE$.apply$extension(function0, (Function1 & Serializable)_$7 -> Scope$.MODULE$.addFinalizer((Function0<ZIO<Object, Nothing$, Object>>)((Function0 & Serializable)() -> this.withPermitsScoped$$anonfun$1$$anonfun$1(n, trace)), trace)).apply((Function1 & Serializable)_$8 -> ZIO$.MODULE$.unit(), trace);
    }

    public ZIO<Scope, Nothing$, Object> withPermitsBetweenScoped(long min, long max, Object trace) {
        Function0 function0 = ZSTM$.MODULE$.acquireReleaseWith(this.acquireBetween(min, max));
        return ZSTM$Acquire$.MODULE$.apply$extension(function0, (Function1 & Serializable)actualN -> this.withPermitsBetweenScoped$$anonfun$1(trace, BoxesRunTime.unboxToLong((Object)actualN))).apply((Function1 & Serializable)_$9 -> ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$1 -> _$9, trace), trace);
    }

    public ZIO<Scope, Nothing$, Object> withPermitsUpToScoped(long max, Object trace) {
        Function0 function0 = ZSTM$.MODULE$.acquireReleaseWith(this.acquireUpTo(max));
        return ZSTM$Acquire$.MODULE$.apply$extension(function0, (Function1 & Serializable)actualN -> this.withPermitsUpToScoped$$anonfun$1(trace, BoxesRunTime.unboxToLong((Object)actualN))).apply((Function1 & Serializable)_$10 -> ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$2 -> _$10, trace), trace);
    }

    private void assertNonNegative(long n) {
        Predef$.MODULE$.require(n >= 0L, () -> TSemaphore.assertNonNegative$$anonfun$1(n));
    }

    private static final Object acquireBetween$$anonfun$1$$anonfun$1(long min$2, long max$2) {
        return new StringBuilder(42).append("Unexpected `").append(min$2).append("` > `").append(max$2).append("` passed to acquireRange.").toString();
    }

    private final /* synthetic */ ZIO withPermitsBetween$$anonfun$1(Object trace$2, long actualN) {
        return this.releaseN(actualN).commit(trace$2);
    }

    private final /* synthetic */ ZIO withPermitsUpTo$$anonfun$1(Object trace$3, long actualN) {
        return this.releaseN(actualN).commit(trace$3);
    }

    private final ZIO withPermitsScoped$$anonfun$1$$anonfun$1(long n$4, Object trace$5) {
        return this.releaseN(n$4).commit(trace$5);
    }

    private final ZIO withPermitsBetweenScoped$$anonfun$1$$anonfun$1(long actualN$1, Object trace$6) {
        return this.releaseN(actualN$1).commit(trace$6);
    }

    private final /* synthetic */ ZIO withPermitsBetweenScoped$$anonfun$1(Object trace$7, long actualN) {
        return Scope$.MODULE$.addFinalizer((Function0<ZIO<Object, Nothing$, Object>>)((Function0 & Serializable)() -> this.withPermitsBetweenScoped$$anonfun$1$$anonfun$1(actualN, trace$7)), trace$7);
    }

    private final ZIO withPermitsUpToScoped$$anonfun$1$$anonfun$1(long actualN$2, Object trace$9) {
        return this.releaseN(actualN$2).commit(trace$9);
    }

    private final /* synthetic */ ZIO withPermitsUpToScoped$$anonfun$1(Object trace$10, long actualN) {
        return Scope$.MODULE$.addFinalizer((Function0<ZIO<Object, Nothing$, Object>>)((Function0 & Serializable)() -> this.withPermitsUpToScoped$$anonfun$1$$anonfun$1(actualN, trace$10)), trace$10);
    }

    private static final Object assertNonNegative$$anonfun$1(long n$5) {
        return new StringBuilder(41).append("Unexpected negative `").append(n$5).append("` permits requested.").toString();
    }
}

