/*
 * Decompiled with CFR 0.152.
 */
package zio.internal;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.Builder;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import zio.Cause;
import zio.Cause$;
import zio.Chunk;
import zio.Chunk$;
import zio.ChunkBuilder;
import zio.Executor;
import zio.Exit;
import zio.Exit$;
import zio.Exit$Failure$;
import zio.Exit$Success$;
import zio.Fiber;
import zio.Fiber$;
import zio.Fiber$Status$Done$;
import zio.Fiber$Status$Running$;
import zio.Fiber$Status$Suspended$;
import zio.FiberId;
import zio.FiberId$None$;
import zio.FiberRef;
import zio.FiberRef$;
import zio.FiberRefs;
import zio.LogLevel;
import zio.LogSpan;
import zio.Runtime$;
import zio.RuntimeFlag$WindDown$;
import zio.RuntimeFlags$;
import zio.RuntimeFlags$Patch$;
import zio.StackTrace;
import zio.StackTrace$;
import zio.Supervisor;
import zio.Supervisor$;
import zio.Unsafe;
import zio.Unsafe$;
import zio.ZIO;
import zio.ZIO$;
import zio.ZIO$Continuation$;
import zio.ZIO$UpdateRuntimeFlags$;
import zio.ZIO$UpdateRuntimeFlagsWithin$DynamicNoBox$;
import zio.ZLogger;
import zio.internal.FiberMessage;
import zio.internal.FiberMessage$;
import zio.internal.FiberMessage$InterruptSignal$;
import zio.internal.FiberMessage$Resume$;
import zio.internal.FiberMessage$Stateful$;
import zio.internal.FiberMessage$YieldNow$;
import zio.internal.FiberRunnable;
import zio.internal.FiberRuntime$;
import zio.internal.FiberScope;
import zio.internal.FiberScope$;
import zio.internal.Platform$;
import zio.internal.StackTraceBuilder;
import zio.metrics.Metric$runtime$;
import zio.metrics.MetricLabel;

public final class FiberRuntime<E, A>
extends Fiber.Runtime.Internal<E, A>
implements FiberRunnable {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(FiberRuntime.class.getDeclaredField("scope$lzy1"));
    private final FiberId.Runtime fiberId;
    private Object _lastTrace;
    private FiberRefs _fiberRefs;
    private int _runtimeFlags;
    private Function0<FiberId> _blockingOn;
    private Function1<ZIO<Object, Object, Object>, Object> _asyncContWith;
    private final AtomicBoolean running;
    private final ConcurrentLinkedQueue<FiberMessage> inbox;
    private Set<Fiber.Runtime<?, ?>> _children;
    private List<Function1<Exit<E, A>, BoxedUnit>> observers;
    private Executor runningExecutor;
    private ZIO.Continuation[] _stack;
    private int _stackSize;
    private boolean _isInterrupted;
    private int _forksSinceYield;
    public volatile Exit<E, A> zio$internal$FiberRuntime$$_exitValue;
    private volatile Object scope$lzy1;
    private final int _hashCode;

    public static <E, A> FiberRuntime<E, A> apply(FiberId.Runtime runtime, FiberRefs fiberRefs, int n) {
        return FiberRuntime$.MODULE$.apply(runtime, fiberRefs, n);
    }

    public static AtomicBoolean catastrophicFailure() {
        return FiberRuntime$.MODULE$.catastrophicFailure();
    }

    public FiberRuntime(FiberId.Runtime fiberId, FiberRefs fiberRefs0, int runtimeFlags0) {
        this.fiberId = fiberId;
        this._lastTrace = fiberId.location();
        this._fiberRefs = fiberRefs0;
        this._runtimeFlags = runtimeFlags0;
        this._blockingOn = FiberRuntime$.zio$internal$FiberRuntime$$$notBlockingOn;
        this._asyncContWith = null;
        this.running = new AtomicBoolean(false);
        this.inbox = new ConcurrentLinkedQueue();
        this._children = null;
        this.observers = scala.package$.MODULE$.Nil();
        this.runningExecutor = null;
        this._stack = null;
        this._stackSize = 0;
        this._isInterrupted = false;
        this._forksSinceYield = 0;
        if (RuntimeFlags$.MODULE$.runtimeMetrics(this._runtimeFlags)) {
            scala.collection.immutable.Set tags = (scala.collection.immutable.Set)this.getFiberRef(FiberRef$.MODULE$.currentTags());
            Metric$runtime$.MODULE$.fibersStarted().unsafe().update(BoxesRunTime.boxToLong((long)1L), (scala.collection.immutable.Set<MetricLabel>)tags, Unsafe$.MODULE$);
            Metric$runtime$.MODULE$.fiberForkLocations().unsafe().update(fiberId.location().toString(), (scala.collection.immutable.Set<MetricLabel>)tags, Unsafe$.MODULE$);
        }
        this.zio$internal$FiberRuntime$$_exitValue = null;
        this._hashCode = fiberId.hashCode();
    }

    @Override
    public boolean shouldYieldBeforeFork() {
        if (RuntimeFlags$.MODULE$.cooperativeYielding(this._runtimeFlags)) {
            ++this._forksSinceYield;
            return this._forksSinceYield >= 128;
        }
        return false;
    }

    @Override
    public ZIO<Object, Nothing$, Exit<E, A>> await(Object trace) {
        return ZIO$.MODULE$.suspendSucceed(() -> this.await$$anonfun$1(trace), trace);
    }

    private Chunk<Fiber.Runtime<?, ?>> childrenChunk(Set<Fiber.Runtime<?, ?>> children) {
        if (children == null) {
            return Chunk$.MODULE$.empty();
        }
        Builder bldr = Chunk$.MODULE$.newBuilder();
        children.forEach(arg_0 -> FiberRuntime.childrenChunk$$anonfun$1((ChunkBuilder)bldr, arg_0));
        return (Chunk)bldr.result();
    }

    @Override
    public ZIO<Object, Nothing$, Chunk<Fiber.Runtime<?, ?>>> children(Object trace) {
        ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
        return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply(trace, (Function0 & Serializable)() -> {
            Unsafe$ unsafe$ = Unsafe$.MODULE$;
            return this.childrenChunk(this._children);
        });
    }

    @Override
    public ZIO<Object, Nothing$, FiberRefs> fiberRefs(Object trace) {
        ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
        return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply(trace, (Function0 & Serializable)() -> {
            Unsafe$ unsafe$ = Unsafe$.MODULE$;
            return this._fiberRefs;
        });
    }

    @Override
    public FiberId.Runtime id() {
        return this.fiberId;
    }

    @Override
    public ZIO<Object, Nothing$, BoxedUnit> inheritAll(Object trace) {
        return ZIO$.MODULE$.withFiberRuntime((Function2 & Serializable)(parentFiber, parentStatus) -> {
            FiberId.Runtime parentFiberId = parentFiber.id();
            FiberRefs parentFiberRefs = parentFiber.getFiberRefs();
            int parentRuntimeFlags = parentStatus.runtimeFlags();
            FiberRefs childFiberRefs = this.getFiberRefs();
            FiberRefs updatedFiberRefs = parentFiberRefs.joinAs(parentFiberId, childFiberRefs);
            if (updatedFiberRefs != parentFiberRefs) {
                parentFiber.setFiberRefs(updatedFiberRefs);
                int updatedRuntimeFlags = updatedFiberRefs.getRuntimeFlags(Unsafe$.MODULE$);
                long patch = FiberRuntime$.MODULE$.zio$internal$FiberRuntime$$$patchExcludeNonInheritable(RuntimeFlags$.MODULE$.diff(parentRuntimeFlags, updatedRuntimeFlags));
                return ZIO$.MODULE$.updateRuntimeFlags(patch, trace);
            }
            return Exit$.MODULE$.unit();
        }, trace);
    }

    @Override
    public ZIO<Object, Nothing$, BoxedUnit> interruptAsFork(FiberId fiberId, Object trace) {
        ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
        return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply(trace, (JFunction0.mcV.sp & Serializable)() -> {
            Unsafe$ unsafe$ = Unsafe$.MODULE$;
            Cause<Nothing$> cause = Cause$.MODULE$.interrupt(fiberId, StackTrace$.MODULE$.apply(this.fiberId, Chunk$.MODULE$.single(trace)));
            this.tell(FiberMessage$InterruptSignal$.MODULE$.apply(cause));
        });
    }

    @Override
    public Object location() {
        return this.fiberId.location();
    }

    @Override
    public ZIO<Object, Nothing$, Option<Exit<E, A>>> poll(Object trace) {
        ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
        return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply(trace, (Function0 & Serializable)() -> {
            Unsafe$ unsafe$ = Unsafe$.MODULE$;
            return Option$.MODULE$.apply(this.exitValue());
        });
    }

    @Override
    public void run() {
        this.drainQueueOnCurrentThread(0);
    }

    @Override
    public void run(int depth) {
        this.drainQueueOnCurrentThread(depth);
    }

    @Override
    public ZIO<Object, Nothing$, Object> runtimeFlags(Object trace) {
        ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
        return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply(trace, (Function0 & Serializable)() -> {
            Unsafe$ unsafe$ = Unsafe$.MODULE$;
            return this._runtimeFlags;
        });
    }

    @Override
    public FiberScope scope() {
        Object object = this.scope$lzy1;
        if (object instanceof FiberScope) {
            return (FiberScope)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (FiberScope)this.scope$lzyINIT1();
    }

    private Object scope$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.scope$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    FiberScope fiberScope = null;
                    try {
                        fiberScope = FiberScope$.MODULE$.make(this);
                        object2 = fiberScope == null ? LazyVals.NullValue$.MODULE$ : fiberScope;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.scope$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return fiberScope;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public ZIO<Object, Nothing$, Fiber.Status> status(Object trace) {
        ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
        return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply(trace, (Function0 & Serializable)() -> {
            Unsafe$ unsafe$ = Unsafe$.MODULE$;
            return this.getStatus();
        });
    }

    @Override
    public ZIO<Object, Nothing$, StackTrace> trace(Object trace) {
        ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
        return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply(trace, (Function0 & Serializable)() -> {
            Unsafe$ unsafe$ = Unsafe$.MODULE$;
            return this.generateStackTrace();
        });
    }

    @Override
    public void addChild(Fiber.Runtime<?, ?> child) {
        if (child.isAlive()) {
            if (this.isAlive()) {
                this.getChildren().add(child);
                if (this.isInterrupted()) {
                    child.tellInterrupt(this.getInterruptedCause());
                    return;
                }
                return;
            }
            child.tellInterrupt(this.getInterruptedCause());
            return;
        }
    }

    @Override
    public void addChildren(Iterable<Fiber.Runtime<?, ?>> children) {
        Iterator iter = children.iterator();
        if (this.isAlive()) {
            Set<Fiber.Runtime<?, ?>> childs = this.getChildren();
            if (this.isInterrupted()) {
                Cause<Nothing$> cause = this.getInterruptedCause();
                while (iter.hasNext()) {
                    Fiber.Runtime child = (Fiber.Runtime)iter.next();
                    if (!child.isAlive()) continue;
                    childs.add(child);
                    child.tellInterrupt(cause);
                }
                return;
            }
            while (iter.hasNext()) {
                Fiber.Runtime child = (Fiber.Runtime)iter.next();
                if (!child.isAlive()) continue;
                childs.add(child);
            }
            return;
        }
        Cause<Nothing$> cause = this.getInterruptedCause();
        while (iter.hasNext()) {
            Fiber.Runtime child = (Fiber.Runtime)iter.next();
            if (!child.isAlive()) continue;
            child.tellInterrupt(cause);
        }
    }

    private void addInterruptedCause(Cause<Nothing$> cause) {
        Cause<Nothing$> oldSC = this.getFiberRef(FiberRef$.MODULE$.interruptedCause());
        this._isInterrupted = true;
        this.setFiberRef(FiberRef$.MODULE$.interruptedCause(), oldSC.$plus$plus(cause));
    }

    public void addObserver(Function1<Exit<E, A>, BoxedUnit> observer, Unsafe unsafe) {
        Exit<E, A> exitValue = this.zio$internal$FiberRuntime$$_exitValue;
        if (exitValue != null) {
            observer.apply(exitValue);
            return;
        }
        this.observers = this.observers.$colon$colon(observer);
    }

    @Override
    public void deleteFiberRef(FiberRef<?> ref) {
        this._fiberRefs = this._fiberRefs.delete(ref);
    }

    private void drainQueueOnCurrentThread(int depth) {
        block7: {
            int evaluationSignal;
            do {
                evaluationSignal = 1;
                try {
                    if (RuntimeFlags$.MODULE$.currentFiber(this._runtimeFlags)) {
                        Fiber$.MODULE$._currentFiber().set(this);
                    }
                    while (evaluationSignal == 1) {
                        FiberMessage message = this.inbox.poll();
                        evaluationSignal = message == null ? 3 : this.evaluateMessageWhileSuspended(depth, message);
                    }
                }
                finally {
                    this.running.set(false);
                }
                if (this.inbox.isEmpty() || !this.running.compareAndSet(false, true)) break block7;
            } while (evaluationSignal != 2);
            this.drainQueueLaterOnExecutor(true);
            return;
        }
    }

    private void drainQueueLaterOnExecutor(boolean attemptResumptionOnSameThread) {
        this.runningExecutor = this.getCurrentExecutor();
        if (attemptResumptionOnSameThread) {
            this.runningExecutor.submitAndYieldOrThrow(this, Unsafe$.MODULE$);
            return;
        }
        this.runningExecutor.submitOrThrow(this, Unsafe$.MODULE$);
    }

    private ZIO<Object, Object, Object> drainQueueWhileRunning(ZIO<Object, Object, Object> cur0) {
        ZIO<Object, Object, Object> cur = cur0;
        FiberMessage message = this.inbox.poll();
        while (message != null) {
            FiberMessage fiberMessage = message;
            if (fiberMessage instanceof FiberMessage.Stateful) {
                Function1<FiberRuntime<?, ?>, BoxedUnit> function1;
                FiberMessage.Stateful stateful = FiberMessage$Stateful$.MODULE$.unapply((FiberMessage.Stateful)fiberMessage);
                Function1<FiberRuntime<?, ?>, BoxedUnit> onFiber = function1 = stateful._1();
                this.processStatefulMessage(onFiber);
            } else if (fiberMessage instanceof FiberMessage.InterruptSignal) {
                Cause<Nothing$> cause;
                FiberMessage.InterruptSignal interruptSignal = FiberMessage$InterruptSignal$.MODULE$.unapply((FiberMessage.InterruptSignal)fiberMessage);
                Cause<Nothing$> cause2 = cause = interruptSignal._1();
                this.updateLastTrace(cur.trace());
                this.processNewInterruptSignal(cause2);
                if (this.isInterruptible()) {
                    cur = Exit$Failure$.MODULE$.apply(cause2);
                }
            } else if (fiberMessage instanceof FiberMessage.Resume) {
                FiberMessage.Resume resume = FiberMessage$Resume$.MODULE$.unapply((FiberMessage.Resume)fiberMessage);
                ZIO<?, ?, ?> zIO = resume._1();
            } else if (!FiberMessage$YieldNow$.MODULE$.equals(fiberMessage)) {
                throw new MatchError((Object)fiberMessage);
            }
            message = this.inbox.poll();
        }
        return cur;
    }

    private ZIO<Object, Object, Object> drainQueueAfterAsync() {
        ZIO<?, ?, ?> resumption = null;
        FiberMessage message = this.inbox.poll();
        while (message != null) {
            FiberMessage fiberMessage = message;
            if (fiberMessage instanceof FiberMessage.InterruptSignal) {
                Cause<Nothing$> cause;
                FiberMessage.InterruptSignal interruptSignal = FiberMessage$InterruptSignal$.MODULE$.unapply((FiberMessage.InterruptSignal)fiberMessage);
                Cause<Nothing$> cause2 = cause = interruptSignal._1();
                this.processNewInterruptSignal(cause2);
            } else if (fiberMessage instanceof FiberMessage.Stateful) {
                Function1<FiberRuntime<?, ?>, BoxedUnit> function1;
                FiberMessage.Stateful stateful = FiberMessage$Stateful$.MODULE$.unapply((FiberMessage.Stateful)fiberMessage);
                Function1<FiberRuntime<?, ?>, BoxedUnit> onFiber = function1 = stateful._1();
                this.processStatefulMessage(onFiber);
            } else if (fiberMessage instanceof FiberMessage.Resume) {
                ZIO<?, ?, ?> zIO;
                ZIO<?, ?, ?> nextEffect0;
                FiberMessage.Resume resume = FiberMessage$Resume$.MODULE$.unapply((FiberMessage.Resume)fiberMessage);
                resumption = nextEffect0 = (zIO = resume._1());
            } else if (!FiberMessage$YieldNow$.MODULE$.equals(fiberMessage)) {
                throw new MatchError((Object)fiberMessage);
            }
            message = this.inbox.poll();
        }
        return resumption;
    }

    private void ensureStackCapacity(int size) {
        ZIO.Continuation[] stack = this._stack;
        int stackLength = stack.length;
        if (stackLength < size) {
            int newSize = (size & size - 1) == 0 ? size : Integer.highestOneBit(size) << 1;
            ZIO.Continuation[] newStack = new ZIO.Continuation[newSize];
            System.arraycopy(stack, 0, newStack, 0, stackLength);
            this._stack = newStack;
        }
    }

    private Exit<E, A> evaluateEffect(int initialDepth, ZIO<Object, Object, Object> effect0) {
        Exit<Object, Object> exit;
        this._asyncContWith = null;
        this._blockingOn = FiberRuntime$.zio$internal$FiberRuntime$$$notBlockingOn;
        this.updateLastTrace(effect0.trace());
        Supervisor<Object> supervisor = this.getSupervisor();
        if (supervisor != Supervisor$.MODULE$.none()) {
            supervisor.onResume(this, Unsafe$.MODULE$);
        }
        if (this._stack == null) {
            this._stack = new ZIO.Continuation[16];
        }
        try {
            ZIO<Object, Object, Object> effect = effect0;
            Exit<Object, Object> finalExit = null;
            while (effect != null) {
                try {
                    Exit<Object, Object> exit2;
                    if (this.shouldInterrupt()) {
                        effect = Exit$Failure$.MODULE$.apply(this.getInterruptedCause());
                    }
                    if ((exit2 = this.runLoop(effect, 0, this._stackSize, initialDepth)) == null) {
                        this._forksSinceYield = 0;
                        effect = null;
                        continue;
                    }
                    if (supervisor != Supervisor$.MODULE$.none()) {
                        supervisor.onEnd(exit2, this, Unsafe$.MODULE$);
                    }
                    this._runtimeFlags = RuntimeFlags$.MODULE$.enable(this._runtimeFlags, RuntimeFlag$WindDown$.MODULE$);
                    ZIO<Object, Nothing$, Object> interruption = this.interruptAllChildren();
                    if (interruption == null) {
                        if (this.inbox.isEmpty()) {
                            finalExit = exit2;
                            this.setExitValue(exit2);
                        } else {
                            this.tell(FiberMessage$Resume$.MODULE$.apply(exit2));
                        }
                        effect = null;
                        continue;
                    }
                    effect = interruption.flatMap((Function1 & Serializable)_$1 -> exit2, this.id().location());
                }
                catch (Throwable throwable) {
                    if (this.isFatal(throwable)) {
                        throw this.handleFatalError(throwable);
                    }
                    effect = ZIO$.MODULE$.failCause(() -> FiberRuntime.evaluateEffect$$anonfun$2(throwable), this._lastTrace);
                }
            }
            exit = finalExit;
        }
        finally {
            this.gcStack();
            Supervisor<Object> supervisor2 = this.getSupervisor();
            if (supervisor2 != Supervisor$.MODULE$.none()) {
                supervisor2.onSuspend(this, Unsafe$.MODULE$);
            }
        }
        return exit;
    }

    private int evaluateMessageWhileSuspended(int depth, FiberMessage fiberMessage) {
        FiberMessage fiberMessage2 = fiberMessage;
        if (fiberMessage2 instanceof FiberMessage.InterruptSignal) {
            Cause<Nothing$> cause;
            FiberMessage.InterruptSignal interruptSignal = FiberMessage$InterruptSignal$.MODULE$.unapply((FiberMessage.InterruptSignal)fiberMessage2);
            Cause<Nothing$> cause2 = cause = interruptSignal._1();
            this.processNewInterruptSignal(cause2);
            return 1;
        }
        if (fiberMessage2 instanceof FiberMessage.Stateful) {
            Function1<FiberRuntime<?, ?>, BoxedUnit> function1;
            FiberMessage.Stateful stateful = FiberMessage$Stateful$.MODULE$.unapply((FiberMessage.Stateful)fiberMessage2);
            Function1<FiberRuntime<?, ?>, BoxedUnit> onFiber = function1 = stateful._1();
            this.processStatefulMessage(onFiber);
            return 1;
        }
        if (fiberMessage2 instanceof FiberMessage.Resume) {
            FiberMessage.Resume resume = FiberMessage$Resume$.MODULE$.unapply((FiberMessage.Resume)fiberMessage2);
            ZIO<Object, Object, Object> zIO = resume._1();
            ZIO<Object, Object, Object> nextEffect0 = zIO;
            ZIO<Object, Object, Object> nextEffect = nextEffect0;
            Exit<E, A> exit = this.evaluateEffect(depth, nextEffect);
            if (exit == null) {
                return 2;
            }
            return 1;
        }
        if (FiberMessage$YieldNow$.MODULE$.equals(fiberMessage2)) {
            return 2;
        }
        throw new MatchError((Object)fiberMessage2);
    }

    public Exit<E, A> exitValue() {
        return this.zio$internal$FiberRuntime$$_exitValue;
    }

    private StackTrace generateStackTrace() {
        StackTrace stackTrace;
        StackTraceBuilder builder = FiberRuntime$.zio$internal$FiberRuntime$$$stackTraceBuilderPool.get();
        ZIO.Continuation[] stack = this._stack;
        int size = this._stackSize;
        try {
            if (stack != null) {
                int i = (stack.length < size ? stack.length : size) - 1;
                while (i >= 0) {
                    ZIO.Continuation k = stack[i];
                    if (k == null) continue;
                    builder.$plus$eq(k.trace());
                    --i;
                }
            }
            builder.$plus$eq(this.id().location());
            stackTrace = StackTrace$.MODULE$.apply(this.fiberId, builder.result());
        }
        finally {
            builder.clear();
        }
        return stackTrace;
    }

    private Set<Fiber.Runtime<?, ?>> getChildren() {
        Set children = this._children;
        if (children == null) {
            this._children = children = Platform$.MODULE$.newConcurrentWeakSet(Unsafe$.MODULE$);
        }
        return children;
    }

    @Override
    public Executor getCurrentExecutor() {
        Option<Executor> option = this.getFiberRef(FiberRef$.MODULE$.overrideExecutor());
        if (None$.MODULE$.equals(option)) {
            return Runtime$.MODULE$.defaultExecutor();
        }
        if (option instanceof Some) {
            Executor value = (Executor)((Some)option).value();
            return value;
        }
        throw new MatchError(option);
    }

    @Override
    public <A> A getFiberRef(FiberRef<A> fiberRef) {
        return this._fiberRefs.getOrDefault(fiberRef);
    }

    @Override
    public <A> A getFiberRefOrNull(FiberRef<A> fiberRef) {
        return this._fiberRefs.getOrNull(fiberRef);
    }

    public <A> A getFiberRefOrElse(FiberRef<A> fiberRef, Function0<A> orElse) {
        A a = this._fiberRefs.getOrNull(fiberRef);
        if (a == null) {
            return (A)orElse.apply();
        }
        A a2 = a;
        return a2;
    }

    public <A> Option<A> getFiberRefOption(FiberRef<A> fiberRef) {
        return this._fiberRefs.get(fiberRef);
    }

    @Override
    public FiberRefs getFiberRefs(boolean updateRuntimeFlagsWithin) {
        FiberRefs refs = this._fiberRefs;
        if (updateRuntimeFlagsWithin) {
            int flags0 = FiberRuntime$.MODULE$.zio$internal$FiberRuntime$$$excludeNonInheritable(this._runtimeFlags);
            FiberRefs newRefs = this._fiberRefs.updateRuntimeFlags(this.fiberId, flags0);
            if (newRefs != refs) {
                this._fiberRefs = newRefs;
            }
            return newRefs;
        }
        return refs;
    }

    public Cause<Nothing$> getInterruptedCause() {
        return this.getFiberRef(FiberRef$.MODULE$.interruptedCause());
    }

    public scala.collection.immutable.Set<ZLogger<String, Object>> getLoggers() {
        return (scala.collection.immutable.Set)this.getFiberRef(FiberRef$.MODULE$.currentLoggers());
    }

    public Function1<Throwable, Nothing$> getReportFatal() {
        return this.getFiberRef(FiberRef$.MODULE$.currentReportFatal());
    }

    @Override
    public Option<Executor> getRunningExecutor() {
        if (this.runningExecutor == null) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply((Object)this.runningExecutor);
    }

    public Fiber.Status getStatus() {
        if (this.zio$internal$FiberRuntime$$_exitValue != null) {
            return Fiber$Status$Done$.MODULE$;
        }
        return this._asyncContWith != null ? Fiber$Status$Suspended$.MODULE$.apply(this._runtimeFlags, this._lastTrace, (FiberId)this._blockingOn.apply()) : Fiber$Status$Running$.MODULE$.apply(this._runtimeFlags, this._lastTrace);
    }

    public Supervisor<Object> getSupervisor() {
        return (Supervisor)this.getFiberRef(FiberRef$.MODULE$.currentSupervisor());
    }

    private Nothing$ handleFatalError(Throwable throwable) {
        FiberRuntime$.MODULE$.catastrophicFailure().set(true);
        Function1<Throwable, Nothing$> errorReporter = this.getReportFatal();
        return (Nothing$)errorReporter.apply((Object)throwable);
    }

    private ZIO<Object, Object, Object> initiateAsync(Function1<Function1<ZIO<Object, Object, Object>, BoxedUnit>, ZIO<Object, Object, Object>> asyncRegister) {
        ZIO zIO;
        block6: {
            AtomicBoolean alreadyCalled = new AtomicBoolean(false);
            Object callback = effect -> {
                if (alreadyCalled.compareAndSet(false, true)) {
                    this.tell(FiberMessage$Resume$.MODULE$.apply((ZIO<?, ?, ?>)effect));
                    return;
                }
            };
            this._asyncContWith = this.isInterruptible() ? callback : FiberRuntime$.zio$internal$FiberRuntime$$$IgnoreContinuation;
            try {
                ZIO sync = (ZIO)asyncRegister.apply(callback);
                if (sync != null) {
                    if (alreadyCalled.compareAndSet(false, true)) {
                        this._asyncContWith = null;
                        this._blockingOn = FiberRuntime$.zio$internal$FiberRuntime$$$notBlockingOn;
                        zIO = sync;
                    } else {
                        this.log((Function0<String>)(Function0 & Serializable)() -> "Async operation attempted synchronous resumption, but its callback was already invoked; synchronous value will be discarded", (Cause<Object>)Cause$.MODULE$.empty(), (Option<LogLevel>)ZIO$.MODULE$.someError(), this.id().location());
                        zIO = null;
                    }
                    break block6;
                }
                zIO = null;
            }
            catch (Throwable throwable) {
                if (this.isFatal(throwable)) {
                    throw this.handleFatalError(throwable);
                }
                callback.apply(Exit$Failure$.MODULE$.apply(Cause$.MODULE$.die(throwable, Cause$.MODULE$.die$default$2())));
                zIO = null;
            }
        }
        return zIO;
    }

    private ZIO<Object, Nothing$, Object> interruptAllChildren() {
        if (this.sendInterruptSignalToAllChildren(this._children)) {
            java.util.Iterator<Fiber.Runtime<?, ?>> iterator = this._children.iterator();
            this._children = null;
            ObjectRef curr = ObjectRef.create(null);
            FiberRuntime.skip$1(iterator, curr);
            if ((Fiber.Runtime)curr.elem != null) {
                return ZIO$.MODULE$.whileLoop((Function0<Object>)((Function0 & Serializable)() -> FiberRuntime.interruptAllChildren$$anonfun$1(curr)), () -> this.interruptAllChildren$$anonfun$2(curr), (Function1 & Serializable)_$2 -> {
                    FiberRuntime.skip$1(iterator, curr);
                    return BoxedUnit.UNIT;
                }, this.id().location());
            }
            return null;
        }
        return null;
    }

    @Override
    public boolean isAlive() {
        return this.zio$internal$FiberRuntime$$_exitValue == null;
    }

    public boolean isDone() {
        return this.zio$internal$FiberRuntime$$_exitValue != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isInterrupted() {
        if (this._isInterrupted) return true;
        if (!Thread.interrupted()) {
            if (!false) return false;
            return true;
        }
        this.addInterruptedCause(Cause$.MODULE$.interrupt(FiberId$None$.MODULE$, Cause$.MODULE$.interrupt$default$2()));
        if (true) return true;
        return false;
    }

    public boolean isInterruptible() {
        return RuntimeFlags$.MODULE$.interruptible(this._runtimeFlags);
    }

    @Override
    public void log(Function0<String> message, Cause<Object> cause, Option<LogLevel> overrideLogLevel, Object trace) {
        LogLevel logLevel = overrideLogLevel.isDefined() ? (LogLevel)overrideLogLevel.get() : this.getFiberRef(FiberRef$.MODULE$.currentLogLevel());
        List<LogSpan> spans = this.getFiberRef(FiberRef$.MODULE$.currentLogSpan());
        Map<String, String> annotations = this.getFiberRef(FiberRef$.MODULE$.currentLogAnnotations());
        scala.collection.immutable.Set<ZLogger<String, Object>> loggers = this.getLoggers();
        FiberRefs contextMap = this.getFiberRefs();
        loggers.foreach((Function1 & Serializable)logger -> logger.apply(trace, this.fiberId, logLevel, message, cause, contextMap, spans, annotations));
    }

    private void processStatefulMessage(Function1<FiberRuntime<?, ?>, BoxedUnit> onFiber) {
        try {
            onFiber.apply((Object)this);
        }
        catch (Throwable throwable) {
            if (this.isFatal(throwable)) {
                throw this.handleFatalError(throwable);
            }
            this.log((Function0<String>)(Function0 & Serializable)() -> "An unexpected error was encountered while processing stateful fiber message with callback " + onFiber, (Cause<Object>)Cause$.MODULE$.die(throwable, Cause$.MODULE$.die$default$2()), (Option<LogLevel>)ZIO$.MODULE$.someError(), this.id().location());
        }
    }

    private <R, E, A> ZIO<R, E, A> patchRuntimeFlags(long patch, Cause<E> cause, ZIO<R, E, A> continueEffect) {
        boolean changed = this.patchRuntimeFlagsOnly(patch);
        boolean interruptEnabled = RuntimeFlags$Patch$.MODULE$.isEnabled(patch, 1);
        if (changed && interruptEnabled && this.shouldInterrupt()) {
            if (cause != null) {
                return Exit$Failure$.MODULE$.apply(cause.$plus$plus(this.getInterruptedCause()));
            }
            return Exit$Failure$.MODULE$.apply(this.getInterruptedCause());
        }
        if (cause != null) {
            return Exit$Failure$.MODULE$.apply(cause);
        }
        return continueEffect;
    }

    private boolean patchRuntimeFlagsOnly(long patch) {
        boolean changed;
        int oldFlags = this._runtimeFlags;
        int newFlags = RuntimeFlags$.MODULE$.patch(patch, oldFlags);
        boolean bl = changed = oldFlags != newFlags;
        if (changed) {
            if (RuntimeFlags$Patch$.MODULE$.isEnabled(patch, 2)) {
                Fiber$.MODULE$._currentFiber().set(this);
            } else if (RuntimeFlags$Patch$.MODULE$.isDisabled(patch, 2)) {
                Fiber$.MODULE$._currentFiber().set(null);
            }
            this._runtimeFlags = newFlags;
        }
        return changed;
    }

    private void popStackFrame(int nextStackIndex) {
        if (nextStackIndex >= 128) {
            this._stack[nextStackIndex] = null;
        }
        this._stackSize = nextStackIndex;
    }

    private void gcStack() {
        int fromIndex = this._stackSize;
        if (fromIndex == 0) {
            this._stack = null;
            return;
        }
        Object[] stack = this._stack;
        int toIndex = package$.MODULE$.min(128, stack.length);
        if (fromIndex < toIndex && stack[fromIndex] != null) {
            Arrays.fill(stack, fromIndex, toIndex, null);
            return;
        }
    }

    private void processNewInterruptSignal(Cause<Nothing$> cause) {
        this.addInterruptedCause(cause);
        this.sendInterruptSignalToAllChildren(this._children);
        Function1<ZIO<Object, Object, Object>, Object> k = this._asyncContWith;
        if (k != null) {
            k.apply(Exit$Failure$.MODULE$.apply(cause));
            return;
        }
    }

    private int pushStackFrame(ZIO.Continuation k, int stackIndex) {
        int newSize = stackIndex + 1;
        this.ensureStackCapacity(newSize);
        this._stack[stackIndex] = k;
        this._stackSize = newSize;
        return newSize;
    }

    private void removeChild(FiberRuntime<?, ?> child) {
        Set<Fiber.Runtime<?, ?>> children = this._children;
        if (children != null) {
            children.remove(child);
            return;
        }
    }

    public void removeObserver(Function1<Exit<E, A>, BoxedUnit> observer) {
        this.observers = this.observers.filter((Function1 & Serializable)_$3 -> _$3 != observer);
    }

    private Exit<Object, Object> runLoop(ZIO<Object, Object, Object> effect, int minStackIndex, int startStackIndex, int currentDepth) {
        ZIO cur = effect;
        int ops = 0;
        int stackIndex = startStackIndex;
        if (currentDepth >= 300) {
            this.inbox.add(FiberMessage$Resume$.MODULE$.apply(effect));
            return null;
        }
        while (true) {
            if (RuntimeFlags$.MODULE$.opSupervision(this._runtimeFlags)) {
                this.getSupervisor().onEffect(this, cur, Unsafe$.MODULE$);
            }
            cur = this.drainQueueWhileRunning(cur);
            if (++ops > 10240 && RuntimeFlags$.MODULE$.cooperativeYielding(this._runtimeFlags)) {
                this.updateLastTrace(cur.trace());
                this.inbox.add(FiberMessage$Resume$.MODULE$.apply(cur));
                return null;
            }
            try {
                Exit<Nothing$, StackTrace> exit = cur;
                if (exit instanceof ZIO.Sync) {
                    ZIO.Sync sync = (ZIO.Sync)((Object)exit);
                    this.updateLastTrace(sync.trace());
                    Object value = sync.eval().apply();
                    cur = null;
                    while (cur == null && stackIndex > minStackIndex) {
                        ZIO.Continuation continuation = this._stack[--stackIndex];
                        this.popStackFrame(stackIndex);
                        ZIO.Continuation continuation2 = continuation;
                        if (continuation2 instanceof ZIO.FlatMap) {
                            ZIO.FlatMap flatMap = (ZIO.FlatMap)continuation2;
                            Function1 f = flatMap.successK();
                            cur = (ZIO)f.apply(value);
                            continue;
                        }
                        if (continuation2 instanceof ZIO.FoldZIO) {
                            ZIO.FoldZIO foldZIO = (ZIO.FoldZIO)continuation2;
                            Function1 f = foldZIO.successK();
                            cur = (ZIO)f.apply(value);
                            continue;
                        }
                        if (continuation2 instanceof ZIO.UpdateRuntimeFlags) {
                            ZIO.UpdateRuntimeFlags updateFlags = (ZIO.UpdateRuntimeFlags)continuation2;
                            cur = this.patchRuntimeFlags(updateFlags.update(), null, null);
                            continue;
                        }
                        throw new MatchError((Object)continuation2);
                    }
                    if (cur != null) continue;
                    return Exit$.MODULE$.succeed(value);
                }
                if (exit instanceof Exit.Success) {
                    Exit.Success success = (Exit.Success)exit;
                    Object value = success.value();
                    cur = null;
                    while (cur == null && stackIndex > minStackIndex) {
                        ZIO.Continuation continuation = this._stack[--stackIndex];
                        this.popStackFrame(stackIndex);
                        ZIO.Continuation continuation3 = continuation;
                        if (continuation3 instanceof ZIO.FlatMap) {
                            ZIO.FlatMap flatMap = (ZIO.FlatMap)continuation3;
                            Function1 f = flatMap.successK();
                            cur = (Exit<Nothing$, StackTrace>)f.apply(value);
                            continue;
                        }
                        if (continuation3 instanceof ZIO.FoldZIO) {
                            ZIO.FoldZIO foldZIO = (ZIO.FoldZIO)continuation3;
                            Function1 f = foldZIO.successK();
                            cur = (ZIO)f.apply(value);
                            continue;
                        }
                        if (continuation3 instanceof ZIO.UpdateRuntimeFlags) {
                            ZIO.UpdateRuntimeFlags updateFlags = (ZIO.UpdateRuntimeFlags)continuation3;
                            cur = this.patchRuntimeFlags(updateFlags.update(), null, null);
                            continue;
                        }
                        throw new MatchError((Object)continuation3);
                    }
                    if (cur != null) continue;
                    return success;
                }
                if (exit instanceof ZIO.FlatMap) {
                    ZIO.FlatMap flatmap = (ZIO.FlatMap)((Object)exit);
                    this.updateLastTrace(flatmap.trace());
                    stackIndex = this.pushStackFrame(flatmap, stackIndex);
                    Exit<Object, Object> result = this.runLoop(flatmap.first(), stackIndex, stackIndex, currentDepth + 1);
                    if (result == null) {
                        return null;
                    }
                    this.popStackFrame(--stackIndex);
                    Exit<Object, Object> exit2 = result;
                    if (exit2 instanceof Exit.Success) {
                        Exit.Success s = (Exit.Success)exit2;
                        cur = (ZIO)flatmap.successK().apply(s.value());
                        continue;
                    }
                    Exit<Object, Object> failure = exit2;
                    cur = failure;
                    continue;
                }
                if (exit instanceof ZIO.Stateful) {
                    ZIO.Stateful stateful = (ZIO.Stateful)((Object)exit);
                    Object trace = stateful.trace();
                    this.updateLastTrace(trace);
                    cur = (Exit<Nothing$, StackTrace>)stateful.onState().apply((Object)this, (Object)Fiber$Status$Running$.MODULE$.apply(this._runtimeFlags, trace));
                    continue;
                }
                if (exit instanceof ZIO.FoldZIO) {
                    ZIO.FoldZIO fold = (ZIO.FoldZIO)((Object)exit);
                    this.updateLastTrace(fold.trace());
                    stackIndex = this.pushStackFrame(fold, stackIndex);
                    Exit<Object, Object> result = this.runLoop(fold.first(), stackIndex, stackIndex, currentDepth + 1);
                    if (result == null) {
                        return null;
                    }
                    this.popStackFrame(--stackIndex);
                    Exit<Object, Object> exit3 = result;
                    if (exit3 instanceof Exit.Success) {
                        Exit.Success s = (Exit.Success)exit3;
                        cur = (ZIO)fold.successK().apply(s.value());
                        continue;
                    }
                    if (exit3 instanceof Exit.Failure) {
                        Exit.Failure f = (Exit.Failure)exit3;
                        Cause cause = f.cause();
                        if (this.shouldInterrupt()) {
                            cur = Exit$Failure$.MODULE$.apply(cause.stripFailures());
                            continue;
                        }
                        Function1 f2 = fold.failureK();
                        cur = (ZIO)f2.apply(cause);
                        continue;
                    }
                    throw new MatchError(exit3);
                }
                if (exit instanceof ZIO.Async) {
                    ZIO.Async async = (ZIO.Async)((Object)exit);
                    this.updateLastTrace(async.trace());
                    this._blockingOn = async.blockingOn();
                    cur = this.initiateAsync(async.registerCallback());
                    if (cur == null) {
                        cur = this.drainQueueAfterAsync();
                    }
                    if (cur == null) {
                        return null;
                    }
                    if (!this.shouldInterrupt()) continue;
                    cur = Exit$.MODULE$.failCause(this.getInterruptedCause());
                    continue;
                }
                if (exit instanceof ZIO.UpdateRuntimeFlagsWithin.DynamicNoBox) {
                    ZIO.UpdateRuntimeFlagsWithin.DynamicNoBox update0 = (ZIO.UpdateRuntimeFlagsWithin.DynamicNoBox)((Object)exit);
                    this.updateLastTrace(update0.trace());
                    long updateFlags = update0.update();
                    int oldRuntimeFlags = this._runtimeFlags;
                    int newRuntimeFlags = RuntimeFlags$.MODULE$.patch(updateFlags, oldRuntimeFlags);
                    if (oldRuntimeFlags == newRuntimeFlags) {
                        cur = update0.f().apply(oldRuntimeFlags);
                        continue;
                    }
                    if (RuntimeFlags$.MODULE$.interruptible(newRuntimeFlags) && this.isInterrupted()) {
                        cur = Exit$Failure$.MODULE$.apply(this.getInterruptedCause());
                        continue;
                    }
                    boolean bl = this.patchRuntimeFlagsOnly(updateFlags);
                    long revertFlags = RuntimeFlags$.MODULE$.diff(newRuntimeFlags, oldRuntimeFlags);
                    ZIO.UpdateRuntimeFlags k = ZIO$UpdateRuntimeFlags$.MODULE$.apply(update0.trace(), revertFlags);
                    stackIndex = this.pushStackFrame(k, stackIndex);
                    Exit<Object, Object> exit4 = this.runLoop(update0.f().apply(oldRuntimeFlags), stackIndex, stackIndex, currentDepth + 1);
                    if (exit4 == null) {
                        return null;
                    }
                    this.popStackFrame(--stackIndex);
                    cur = this.patchRuntimeFlags(revertFlags, exit4.causeOrNull(), exit4);
                    continue;
                }
                if (exit instanceof ZIO.WhileLoop) {
                    ZIO.WhileLoop iterate = (ZIO.WhileLoop)((Object)exit);
                    this.updateLastTrace(iterate.trace());
                    Function0<Object> check = iterate.check();
                    ZIO.Continuation k = ZIO$Continuation$.MODULE$.apply((Function1 & Serializable)element -> {
                        iterate.process().apply(element);
                        return iterate;
                    }, iterate.trace());
                    stackIndex = this.pushStackFrame(k, stackIndex);
                    int nextDepth = currentDepth + 1;
                    cur = null;
                    while (cur == null && check.apply$mcZ$sp()) {
                        Exit<Object, Object> exit5 = this.runLoop((ZIO)iterate.body().apply(), stackIndex, stackIndex, nextDepth);
                        if (exit5 instanceof Exit.Success) {
                            Exit.Success s = (Exit.Success)exit5;
                            iterate.process().apply(s.value());
                            continue;
                        }
                        if (exit5 == null) {
                            return null;
                        }
                        Exit<Object, Object> failure = exit5;
                        cur = failure;
                    }
                    this.popStackFrame(--stackIndex);
                    if (cur != null) continue;
                    cur = Exit$.MODULE$.unit();
                    continue;
                }
                if (exit instanceof ZIO.YieldNow) {
                    ZIO.YieldNow yieldNow = (ZIO.YieldNow)((Object)exit);
                    this.updateLastTrace(yieldNow.trace());
                    this.inbox.add(FiberMessage$.MODULE$.resumeUnit());
                    return null;
                }
                if (exit instanceof Exit.Failure) {
                    Exit.Failure failure = (Exit.Failure)exit;
                    Cause<Object> cause = failure.cause();
                    cur = null;
                    while (cur == null && stackIndex > minStackIndex) {
                        ZIO.Continuation continuation = this._stack[--stackIndex];
                        this.popStackFrame(stackIndex);
                        ZIO.Continuation continuation4 = continuation;
                        if (continuation4 instanceof ZIO.FlatMap) continue;
                        if (continuation4 instanceof ZIO.FoldZIO) {
                            ZIO.FoldZIO foldZIO = (ZIO.FoldZIO)continuation4;
                            if (this.shouldInterrupt()) {
                                cause = cause.stripFailures();
                                continue;
                            }
                            Function1 f = foldZIO.failureK();
                            cur = (ZIO)f.apply(cause);
                            continue;
                        }
                        if (continuation4 instanceof ZIO.UpdateRuntimeFlags) {
                            ZIO.UpdateRuntimeFlags updateFlags = (ZIO.UpdateRuntimeFlags)continuation4;
                            cur = this.patchRuntimeFlags(updateFlags.update(), cause, null);
                            continue;
                        }
                        throw new MatchError((Object)continuation4);
                    }
                    if (cur != null) continue;
                    return failure;
                }
                if (exit instanceof ZIO.GenerateStackTrace) {
                    ZIO.GenerateStackTrace gen0 = (ZIO.GenerateStackTrace)((Object)exit);
                    this.updateLastTrace(gen0.trace());
                    cur = Exit$.MODULE$.succeed(this.generateStackTrace());
                    continue;
                }
                if (exit instanceof ZIO.UpdateRuntimeFlags) {
                    ZIO.UpdateRuntimeFlags updateRuntimeFlags = (ZIO.UpdateRuntimeFlags)((Object)exit);
                    this.updateLastTrace(updateRuntimeFlags.trace());
                    cur = this.patchRuntimeFlags(updateRuntimeFlags.update(), null, Exit$.MODULE$.unit());
                    continue;
                }
                if (exit instanceof ZIO.UpdateRuntimeFlagsWithin) {
                    ZIO.UpdateRuntimeFlagsWithin update0 = (ZIO.UpdateRuntimeFlagsWithin)((Object)exit);
                    cur = ZIO$UpdateRuntimeFlagsWithin$DynamicNoBox$.MODULE$.apply(update0.trace(), update0.update(), _$4 -> update0.scope(_$4));
                    continue;
                }
                throw new MatchError(exit);
            }
            catch (InterruptedException interruptedException) {
                this.updateLastTrace(cur.trace());
                cur = this.drainQueueWhileRunning(Exit$Failure$.MODULE$.apply(Cause$.MODULE$.interrupt(FiberId$None$.MODULE$, Cause$.MODULE$.interrupt$default$2()).$plus$plus(Cause$.MODULE$.die(interruptedException, Cause$.MODULE$.die$default$2()))));
            }
        }
        return null;
    }

    private boolean sendInterruptSignalToAllChildren(Set<Fiber.Runtime<?, ?>> children) {
        if (children == null || children.isEmpty()) {
            return false;
        }
        java.util.Iterator<Fiber.Runtime<?, ?>> iterator = children.iterator();
        boolean told = false;
        Cause<Nothing$> cause = Cause$.MODULE$.interrupt(this.fiberId, Cause$.MODULE$.interrupt$default$2());
        while (iterator.hasNext()) {
            Fiber.Runtime<?, ?> next = iterator.next();
            if (next == null || !next.isAlive()) continue;
            next.tellInterrupt(cause);
            told = true;
        }
        return told;
    }

    private void setExitValue(Exit<E, A> e) {
        this.zio$internal$FiberRuntime$$_exitValue = e;
        if (RuntimeFlags$.MODULE$.runtimeMetrics(this._runtimeFlags)) {
            long startTimeMillis = this.fiberId.startTimeMillis();
            long endTimeMillis = System.currentTimeMillis();
            double lifetime = (double)(endTimeMillis - startTimeMillis) / 1000.0;
            scala.collection.immutable.Set tags = (scala.collection.immutable.Set)this.getFiberRef(FiberRef$.MODULE$.currentTags());
            Metric$runtime$.MODULE$.fiberLifetimes().unsafe().update(BoxesRunTime.boxToDouble((double)lifetime), (scala.collection.immutable.Set<MetricLabel>)tags, Unsafe$.MODULE$);
        }
        this.reportExitValue$1(e);
        Iterator iterator = this.observers.reverseIterator();
        while (iterator.hasNext()) {
            Function1 observer = (Function1)iterator.next();
            observer.apply(e);
        }
        this.observers = scala.package$.MODULE$.Nil();
    }

    @Override
    public <A> void setFiberRef(FiberRef<A> fiberRef, A value) {
        this._fiberRefs = this._fiberRefs.updatedAs(this.fiberId, fiberRef, value);
    }

    @Override
    public void resetFiberRef(FiberRef<?> fiberRef) {
        this._fiberRefs = this._fiberRefs.delete(fiberRef);
    }

    @Override
    public void setFiberRefs(FiberRefs fiberRefs0) {
        this._fiberRefs = fiberRefs0;
    }

    public boolean shouldInterrupt() {
        return this.isInterruptible() && this.isInterrupted();
    }

    public <R> Exit<E, A> start(ZIO<R, E, A> effect) {
        Exit<E, A> result = null;
        if (this.running.compareAndSet(false, true)) {
            Fiber.Runtime<?, ?> previousFiber = null;
            try {
                if (RuntimeFlags$.MODULE$.currentFiber(this._runtimeFlags)) {
                    previousFiber = Fiber$.MODULE$._currentFiber().get();
                    Fiber$.MODULE$._currentFiber().set(this);
                }
                result = this.evaluateEffect(0, effect);
            }
            catch (Throwable throwable) {
                if (previousFiber != null || RuntimeFlags$.MODULE$.currentFiber(this._runtimeFlags)) {
                    Fiber$.MODULE$._currentFiber().set(previousFiber);
                }
                this.running.set(false);
                if (!this.inbox.isEmpty() && this.running.compareAndSet(false, true)) {
                    this.drainQueueLaterOnExecutor(result == null);
                }
                throw throwable;
            }
            if (previousFiber != null || RuntimeFlags$.MODULE$.currentFiber(this._runtimeFlags)) {
                Fiber$.MODULE$._currentFiber().set(previousFiber);
            }
            this.running.set(false);
            if (!this.inbox.isEmpty() && this.running.compareAndSet(false, true)) {
                this.drainQueueLaterOnExecutor(result == null);
            }
        } else {
            this.tell(FiberMessage$Resume$.MODULE$.apply(effect));
        }
        return result;
    }

    public void startConcurrently(ZIO<?, E, A> effect) {
        this.tell(FiberMessage$Resume$.MODULE$.apply(effect));
    }

    public Function1<ZIO<?, E, A>, Object> startSuspended(Unsafe unsafe) {
        JProcedure1 & Serializable callback;
        AtomicBoolean alreadyCalled = new AtomicBoolean(false);
        this._asyncContWith = callback = (JProcedure1 & Serializable)effect -> {
            if (alreadyCalled.compareAndSet(false, true)) {
                this.tell(FiberMessage$Resume$.MODULE$.apply((ZIO<?, ?, ?>)effect));
                return;
            }
        };
        this._blockingOn = FiberRuntime$.zio$internal$FiberRuntime$$$notBlockingOn;
        return callback;
    }

    public void tell(FiberMessage message) {
        this.inbox.add(message);
        if (this.running.compareAndSet(false, true)) {
            this.drainQueueLaterOnExecutor(false);
            return;
        }
    }

    @Override
    public void tellAddChild(Fiber.Runtime<?, ?> child) {
        this.tell(FiberMessage$Stateful$.MODULE$.apply((Function1<FiberRuntime<?, ?>, BoxedUnit>)(JProcedure1 & Serializable)parentFiber -> parentFiber.addChild(child)));
    }

    @Override
    public void tellAddChildren(Iterable<Fiber.Runtime<?, ?>> children) {
        this.tell(FiberMessage$Stateful$.MODULE$.apply((Function1<FiberRuntime<?, ?>, BoxedUnit>)(JProcedure1 & Serializable)parentFiber -> parentFiber.addChildren(children)));
    }

    @Override
    public void tellInterrupt(Cause<Nothing$> cause) {
        this.tell(FiberMessage$InterruptSignal$.MODULE$.apply(cause));
    }

    @Override
    public void transferChildren(FiberScope scope) {
        Set<Fiber.Runtime<?, ?>> children = this._children;
        if (children != null && !children.isEmpty()) {
            Chunk<Fiber.Runtime<?, ?>> childs = this.childrenChunk(children);
            this._children = null;
            if (!childs.isEmpty()) {
                int flags = this._runtimeFlags;
                scope.addAll(this, flags, (Iterable<Fiber.Runtime<?, ?>>)childs, this.location(), Unsafe$.MODULE$);
                return;
            }
            return;
        }
    }

    public <A> void updateFiberRef(FiberRef<A> fiberRef, Function1<A, A> f) {
        this.setFiberRef(fiberRef, f.apply(this.getFiberRef(fiberRef)));
    }

    private void updateLastTrace(Object newTrace) {
        if (newTrace != null && newTrace != FiberRuntime$.zio$internal$FiberRuntime$$$emptyTrace && this._lastTrace != newTrace) {
            this._lastTrace = newTrace;
            return;
        }
    }

    @Override
    public Fiber.Runtime.UnsafeAPI unsafe() {
        return new Fiber.Runtime.UnsafeAPI(this){
            private final /* synthetic */ FiberRuntime $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void addObserver(Function1 observer, Unsafe unsafe) {
                Exit<E, A> exitValue = this.$outer.zio$internal$FiberRuntime$$_exitValue;
                if (exitValue != null) {
                    observer.apply(exitValue);
                    return;
                }
                this.$outer.tell(FiberMessage$Stateful$.MODULE$.apply((Function1<FiberRuntime<?, ?>, BoxedUnit>)((JProcedure1 & Serializable)arg_0 -> FiberRuntime.zio$internal$FiberRuntime$$anon$1$$_$addObserver$$anonfun$1(observer, unsafe, arg_0))));
            }

            public void deleteFiberRef(FiberRef ref, Unsafe unsafe) {
                this.$outer.tell(FiberMessage$Stateful$.MODULE$.apply((Function1<FiberRuntime<?, ?>, BoxedUnit>)((JProcedure1 & Serializable)arg_0 -> FiberRuntime.zio$internal$FiberRuntime$$anon$1$$_$deleteFiberRef$$anonfun$1(ref, arg_0))));
            }

            public FiberRefs getFiberRefs(Unsafe unsafe) {
                return this.$outer.getFiberRefs();
            }

            public void removeObserver(Function1 observer, Unsafe unsafe) {
                this.$outer.tell(FiberMessage$Stateful$.MODULE$.apply((Function1<FiberRuntime<?, ?>, BoxedUnit>)((JProcedure1 & Serializable)arg_0 -> FiberRuntime.zio$internal$FiberRuntime$$anon$1$$_$removeObserver$$anonfun$2(observer, arg_0))));
            }

            public Option poll(Unsafe unsafe) {
                return Option$.MODULE$.apply(this.$outer.exitValue());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{zio$internal$FiberRuntime$$anon$1$$_$addObserver$$anonfun$1(scala.Function1 zio.Unsafe zio.internal.FiberRuntime ), zio$internal$FiberRuntime$$anon$1$$_$deleteFiberRef$$anonfun$1(zio.FiberRef zio.internal.FiberRuntime ), zio$internal$FiberRuntime$$anon$1$$_$removeObserver$$anonfun$2(scala.Function1 zio.internal.FiberRuntime )}, serializedLambda);
            }
        };
    }

    public int hashCode() {
        return this._hashCode;
    }

    private final /* synthetic */ void await$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(Function1 cb$1) {
        Unsafe$ unsafe$ = Unsafe$.MODULE$;
        this.unsafe().removeObserver(cb$1, Unsafe$.MODULE$);
    }

    private final FiberId await$$anonfun$1$$anonfun$2() {
        return this.id();
    }

    private final ZIO await$$anonfun$1(Object trace$1) {
        Exit<E, A> exitValue = this.zio$internal$FiberRuntime$$_exitValue;
        if (exitValue != null) {
            return Exit$.MODULE$.succeed(exitValue);
        }
        return ZIO$.MODULE$.asyncInterrupt((Function1 & Serializable)evidence$1 -> (Function1 & Serializable)k -> {
            JProcedure1 & Serializable cb = (JProcedure1 & Serializable)exit -> k.apply(Exit$Success$.MODULE$.apply(exit));
            this.unsafe().addObserver(cb, Unsafe$.MODULE$);
            ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
            return scala.package$.MODULE$.Left().apply(ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply(trace$1, () -> this.await$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1((Function1)cb)));
        }, this::await$$anonfun$1$$anonfun$2, trace$1);
    }

    private static final /* synthetic */ void childrenChunk$$anonfun$1(ChunkBuilder bldr$1, Fiber.Runtime child) {
        if (child != null && child.isAlive()) {
            bldr$1.addOne(child);
            return;
        }
    }

    private static final Cause evaluateEffect$$anonfun$2(Throwable throwable$1) {
        return Cause$.MODULE$.die(throwable$1, Cause$.MODULE$.die$default$2());
    }

    private static final void skip$1(java.util.Iterator iterator$1, ObjectRef curr$1) {
        Fiber.Runtime next = null;
        while (iterator$1.hasNext() && next == null) {
            next = (Fiber.Runtime)iterator$1.next();
            if (next == null || next.isAlive()) continue;
            next = null;
        }
        Fiber.Runtime runtime = next;
        curr$1.elem = runtime;
        runtime = null;
    }

    private static final boolean interruptAllChildren$$anonfun$1(ObjectRef curr$2) {
        return (Fiber.Runtime)curr$2.elem != null;
    }

    private final ZIO interruptAllChildren$$anonfun$2(ObjectRef curr$3) {
        return ((Fiber.Runtime)curr$3.elem).await(this.id().location());
    }

    private final void reportExitValue$1(Exit v) {
        Exit exit = v;
        if (exit instanceof Exit.Failure) {
            Exit.Failure f = (Exit.Failure)exit;
            try {
                Cause<Object> cause = f.cause();
                if (!cause.isInterruptedOnly()) {
                    this.log((Function0<String>)(Function0 & Serializable)() -> "Fiber " + this.fiberId.threadName() + " did not handle an error", cause, this.getFiberRef(FiberRef$.MODULE$.unhandledErrorLogLevel()), this.id().location());
                }
                if (RuntimeFlags$.MODULE$.runtimeMetrics(this._runtimeFlags)) {
                    scala.collection.immutable.Set tags = (scala.collection.immutable.Set)this.getFiberRef(FiberRef$.MODULE$.currentTags());
                    Metric$runtime$.MODULE$.fiberFailures().unsafe().update(BoxesRunTime.boxToLong((long)1L), (scala.collection.immutable.Set<MetricLabel>)tags, Unsafe$.MODULE$);
                    cause.foldContext(tags, FiberRuntime$.zio$internal$FiberRuntime$$$fiberFailureTracker);
                }
            }
            catch (Throwable throwable) {
                if (this.isFatal(throwable)) {
                    throw this.handleFatalError(throwable);
                }
                Predef$.MODULE$.println((Object)"An exception was thrown by a logger:");
                throwable.printStackTrace();
            }
            return;
        }
        if (RuntimeFlags$.MODULE$.runtimeMetrics(this._runtimeFlags)) {
            scala.collection.immutable.Set tags = (scala.collection.immutable.Set)this.getFiberRef(FiberRef$.MODULE$.currentTags());
            Metric$runtime$.MODULE$.fiberSuccesses().unsafe().update(BoxesRunTime.boxToLong((long)1L), (scala.collection.immutable.Set<MetricLabel>)tags, Unsafe$.MODULE$);
            return;
        }
    }

    public static final /* synthetic */ void zio$internal$FiberRuntime$$anon$1$$_$addObserver$$anonfun$1(Function1 observer$2, Unsafe unsafe$1, FiberRuntime _$5) {
        _$5.addObserver(observer$2, unsafe$1);
    }

    public static final /* synthetic */ void zio$internal$FiberRuntime$$anon$1$$_$deleteFiberRef$$anonfun$1(FiberRef ref$1, FiberRuntime _$6) {
        _$6.deleteFiberRef(ref$1);
    }

    public static final /* synthetic */ void zio$internal$FiberRuntime$$anon$1$$_$removeObserver$$anonfun$2(Function1 observer$3, FiberRuntime _$7) {
        _$7.removeObserver(observer$3);
    }
}

