/*
 * Decompiled with CFR 0.152.
 */
package zio.internal;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import scala.runtime.Scala3RunTime$;
import zio.internal.MutableConcurrentQueue;

public final class OneElementConcurrentQueue<A>
extends MutableConcurrentQueue<A>
implements Serializable {
    private final AtomicReference<Object> ref = new AtomicReference();
    private final LongAdder deqAdder = new LongAdder();

    @Override
    public final int capacity() {
        return 1;
    }

    @Override
    public long dequeuedCount() {
        return this.deqAdder.sum();
    }

    @Override
    public long enqueuedCount() {
        if (this.isEmpty()) {
            return this.dequeuedCount();
        }
        return this.dequeuedCount() + 1L;
    }

    @Override
    public boolean isEmpty() {
        return this.ref.get() == null;
    }

    @Override
    public boolean isFull() {
        return !this.isEmpty();
    }

    @Override
    public boolean offer(A a) {
        if (a == null) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        AtomicReference<Object> aRef = this.ref;
        boolean ret = false;
        boolean looping = true;
        while (looping) {
            if (aRef.get() != null) {
                looping = false;
                continue;
            }
            if (!aRef.compareAndSet(null, a)) continue;
            ret = true;
            looping = false;
        }
        return ret;
    }

    @Override
    public A poll(A a) {
        Object ret = a;
        boolean looping = true;
        AtomicReference<Object> aRef = this.ref;
        Object el = null;
        while (looping) {
            el = aRef.get();
            if (el == null) {
                looping = false;
                continue;
            }
            if (!aRef.compareAndSet(el, null)) continue;
            ret = el;
            this.deqAdder.increment();
            looping = false;
        }
        return ret;
    }

    @Override
    public int size() {
        if (this.isEmpty()) {
            return 0;
        }
        return 1;
    }
}

