/*
 * Decompiled with CFR 0.152.
 */
package zio.internal;

import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableFactoryDefaults;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Set;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Cloneable;
import scala.collection.mutable.Growable;
import scala.collection.mutable.SetOps;
import scala.collection.mutable.Shrinkable;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import zio.internal.ConcurrentWeakHashSet$;
import zio.internal.ConcurrentWeakHashSet$AccessOption$;
import zio.internal.ConcurrentWeakHashSet$AccessOption$Resize$;
import zio.internal.ConcurrentWeakHashSet$AccessOption$RestructureAfter$;
import zio.internal.ConcurrentWeakHashSet$AccessOption$RestructureBefore$;
import zio.internal.ConcurrentWeakHashSet$AccessOption$SkipIfEmpty$;
import zio.internal.ConcurrentWeakHashSet$UpdateOperation$;
import zio.internal.ConcurrentWeakHashSet$UpdateOperation$AddElement$;
import zio.internal.ConcurrentWeakHashSet$UpdateOperation$None$;
import zio.internal.ConcurrentWeakHashSet$UpdateOperation$RemoveElement$;
import zio.internal.MutableSetCompat;

public class ConcurrentWeakHashSet<V>
implements MutableSetCompat<V> {
    private final int shift;
    public final Segment[] zio$internal$ConcurrentWeakHashSet$$segments;

    public static int DefaultConcurrencyLevel() {
        return ConcurrentWeakHashSet$.MODULE$.DefaultConcurrencyLevel();
    }

    public static int DefaultInitialCapacity() {
        return ConcurrentWeakHashSet$.MODULE$.DefaultInitialCapacity();
    }

    public static float DefaultLoadFactor() {
        return ConcurrentWeakHashSet$.MODULE$.DefaultLoadFactor();
    }

    public static int MaxConcurrencyLevel() {
        return ConcurrentWeakHashSet$.MODULE$.MaxConcurrencyLevel();
    }

    public static int MaxSegmentSize() {
        return ConcurrentWeakHashSet$.MODULE$.MaxSegmentSize();
    }

    public static int calculateShift(int n, int n2) {
        return ConcurrentWeakHashSet$.MODULE$.calculateShift(n, n2);
    }

    public static <V> int $lessinit$greater$default$1() {
        return ConcurrentWeakHashSet$.MODULE$.$lessinit$greater$default$1();
    }

    public ConcurrentWeakHashSet(int initialCapacity) {
        IterableOnce.$init$((IterableOnce)this);
        IterableOnceOps.$init$((IterableOnceOps)this);
        IterableOps.$init$((IterableOps)this);
        IterableFactoryDefaults.$init$((IterableFactoryDefaults)this);
        Iterable.$init$((Iterable)this);
        scala.collection.mutable.Iterable.$init$((scala.collection.mutable.Iterable)this);
        scala.collection.SetOps.$init$((scala.collection.SetOps)this);
        Set.$init$((Set)this);
        Cloneable.$init$((Cloneable)this);
        Growable.$init$((Growable)this);
        Builder.$init$((Builder)this);
        Shrinkable.$init$((Shrinkable)this);
        SetOps.$init$((SetOps)this);
        scala.collection.mutable.Set.$init$((scala.collection.mutable.Set)this);
        this.shift = ConcurrentWeakHashSet$.MODULE$.calculateShift(this.concurrencyLevel(), ConcurrentWeakHashSet$.MODULE$.MaxConcurrencyLevel());
        int size = 1 << this.shift;
        int roundedUpSegmentCapacity = (int)(((long)(initialCapacity + size) - 1L) / (long)size);
        int initialSize = 1 << ConcurrentWeakHashSet$.MODULE$.calculateShift(roundedUpSegmentCapacity, ConcurrentWeakHashSet$.MODULE$.MaxSegmentSize());
        Segment[] segments = new Segment[size];
        int resizeThreshold = (int)((float)initialSize * this.loadFactor());
        for (int idx = 0; idx < segments.length; ++idx) {
            segments[idx] = new Segment(this, initialSize, resizeThreshold);
        }
        this.zio$internal$ConcurrentWeakHashSet$$segments = segments;
    }

    public Object scala$collection$mutable$Cloneable$$super$clone() {
        return super.clone();
    }

    public float loadFactor() {
        return ConcurrentWeakHashSet$.MODULE$.DefaultLoadFactor();
    }

    public int concurrencyLevel() {
        return ConcurrentWeakHashSet$.MODULE$.DefaultConcurrencyLevel();
    }

    public void gc() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.zio$internal$ConcurrentWeakHashSet$$segments);
        Iterator iterator = ArrayOps$.MODULE$.iterator$extension(object);
        while (iterator.hasNext()) {
            ((Segment)iterator.next()).restructureIfNecessary(false);
        }
    }

    public int size() {
        int sum = 0;
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.zio$internal$ConcurrentWeakHashSet$$segments);
        Iterator iterator = ArrayOps$.MODULE$.iterator$extension(object);
        while (iterator.hasNext()) {
            sum += ((Segment)iterator.next()).size();
        }
        return sum;
    }

    public boolean isEmpty() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.zio$internal$ConcurrentWeakHashSet$$segments);
        Iterator iterator = ArrayOps$.MODULE$.iterator$extension(object);
        while (iterator.hasNext()) {
            if (((Segment)iterator.next()).size() <= 0) continue;
            return false;
        }
        return true;
    }

    public Iterator<V> iterator() {
        return new ConcurrentWeakHashSetIterator();
    }

    public boolean contains(V element) {
        if (element == null) {
            return false;
        }
        RefNode<V> reference = this.getReference(element);
        Object storedElement = reference != null ? reference.get() : null;
        return storedElement != null;
    }

    public void addAll(Iterable<V> elements) {
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
    }

    public boolean add(V element) {
        if (element == null) {
            throw new IllegalArgumentException("ConcurrentWeakHashSet does not support null elements.");
        }
        return this.update(element, ConcurrentWeakHashSet$UpdateOperation$AddElement$.MODULE$, (Seq<AccessOption>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessOption[]{ConcurrentWeakHashSet$AccessOption$RestructureBefore$.MODULE$, ConcurrentWeakHashSet$AccessOption$Resize$.MODULE$}));
    }

    public boolean remove(V element) {
        return this.update(element, ConcurrentWeakHashSet$UpdateOperation$RemoveElement$.MODULE$, (Seq<AccessOption>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessOption[]{ConcurrentWeakHashSet$AccessOption$RestructureAfter$.MODULE$, ConcurrentWeakHashSet$AccessOption$SkipIfEmpty$.MODULE$}));
    }

    public void clear() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.zio$internal$ConcurrentWeakHashSet$$segments);
        Iterator iterator = ArrayOps$.MODULE$.iterator$extension(object);
        while (iterator.hasNext()) {
            ((Segment)iterator.next()).clear();
        }
    }

    private int getHash(V element) {
        int hash = element != null ? element.hashCode() : 0;
        hash += hash << 15 ^ 0xFFFFCD7D;
        hash ^= hash >>> 10;
        hash += hash << 3;
        hash ^= hash >>> 6;
        hash += (hash << 2) + (hash << 14);
        hash ^= hash >>> 16;
        return hash;
    }

    private Segment getSegment(int hash) {
        return this.zio$internal$ConcurrentWeakHashSet$$segments[hash >>> 32 - this.shift & this.zio$internal$ConcurrentWeakHashSet$$segments.length - 1];
    }

    private RefNode<V> getReference(V element) {
        int hash = this.getHash(element);
        Segment segment = this.getSegment(hash);
        return segment.getReference(element, hash);
    }

    private boolean update(V element, UpdateOperation operation, Seq<AccessOption> accessOptions) {
        int hash = this.getHash(element);
        Segment segment = this.getSegment(hash);
        return segment.update(hash, element, operation, accessOptions);
    }

    public static interface AccessOption {
        public static int ordinal(AccessOption accessOption) {
            return ConcurrentWeakHashSet$AccessOption$.MODULE$.ordinal(accessOption);
        }
    }

    public class ConcurrentWeakHashSetIterator
    implements Iterator<V> {
        private int segmentIndex;
        private int referenceIndex;
        private RefNode<V>[] references;
        private RefNode<V> reference;
        private V nextElement;
        private V lastElement;

        public ConcurrentWeakHashSetIterator() {
            if (ConcurrentWeakHashSet.this == null) {
                throw new NullPointerException();
            }
            IterableOnce.$init$((IterableOnce)this);
            IterableOnceOps.$init$((IterableOnceOps)this);
            Iterator.$init$((Iterator)this);
            this.segmentIndex = 0;
            this.referenceIndex = 0;
            this.nextElement = null;
            this.lastElement = null;
            this.moveToNextSegment();
        }

        public boolean hasNext() {
            this.moveToNextReferenceIfNecessary();
            return this.nextElement != null;
        }

        public V next() {
            this.moveToNextReferenceIfNecessary();
            if (this.nextElement == null) {
                throw new NoSuchElementException();
            }
            this.lastElement = this.nextElement;
            this.nextElement = null;
            return this.lastElement;
        }

        private void moveToNextReferenceIfNecessary() {
            while (this.nextElement == null) {
                this.moveToNextReference();
                if (this.reference == null) {
                    return;
                }
                this.nextElement = this.reference.get();
            }
        }

        private void moveToNextReference() {
            if (this.reference != null) {
                this.reference = this.reference.nextRefNode();
            }
            while (this.reference == null && this.references != null) {
                if (this.referenceIndex >= this.references.length) {
                    this.moveToNextSegment();
                    this.referenceIndex = 0;
                    continue;
                }
                this.reference = this.references[this.referenceIndex];
                ++this.referenceIndex;
            }
        }

        private void moveToNextSegment() {
            this.reference = null;
            this.references = null;
            if (this.segmentIndex < ConcurrentWeakHashSet.this.zio$internal$ConcurrentWeakHashSet$$segments.length) {
                this.references = ConcurrentWeakHashSet.this.zio$internal$ConcurrentWeakHashSet$$segments[this.segmentIndex].references();
                ++this.segmentIndex;
                return;
            }
        }

        public final /* synthetic */ ConcurrentWeakHashSet zio$internal$ConcurrentWeakHashSet$ConcurrentWeakHashSetIterator$$$outer() {
            return ConcurrentWeakHashSet.this;
        }
    }

    public static class RefNode<V>
    extends WeakReference<V> {
        private final V element;
        private final int hash;
        private boolean active;
        private RefNode nextRefNode;

        public RefNode(V element, int hash, boolean active, ReferenceQueue<V> refQueue, RefNode<V> nextRefNode) {
            this.element = element;
            this.hash = hash;
            this.active = active;
            this.nextRefNode = nextRefNode;
            super(element, refQueue);
        }

        public int hash() {
            return this.hash;
        }

        public boolean active() {
            return this.active;
        }

        public void active_$eq(boolean x$1) {
            this.active = x$1;
        }

        public RefNode<V> nextRefNode() {
            return this.nextRefNode;
        }

        public void nextRefNode_$eq(RefNode<V> x$1) {
            this.nextRefNode = x$1;
        }

        public String toString() {
            return "(" + this.hash() + ", " + this.element + ") -> " + this.nextRefNode();
        }
    }

    public class Segment
    extends ReentrantLock {
        private final int initialSize;
        private int resizeThreshold;
        private final ReferenceQueue<V> queue;
        private final AtomicInteger counter;
        private volatile RefNode[] references;
        private final /* synthetic */ ConcurrentWeakHashSet $outer;

        public Segment(ConcurrentWeakHashSet $outer, int initialSize, int resizeThreshold) {
            this.initialSize = initialSize;
            this.resizeThreshold = resizeThreshold;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.queue = new ReferenceQueue();
            this.counter = new AtomicInteger(0);
            this.references = new RefNode[initialSize];
        }

        public int resizeThreshold() {
            return this.resizeThreshold;
        }

        public void resizeThreshold_$eq(int x$1) {
            this.resizeThreshold = x$1;
        }

        public RefNode<V>[] references() {
            return this.references;
        }

        public void references_$eq(RefNode<V>[] x$1) {
            this.references = x$1;
        }

        public RefNode<V> getReference(V element, int hash) {
            if (this.counter.get() == 0) {
                return null;
            }
            RefNode<V>[] localReferences = this.references();
            int index = this.getIndex(localReferences, hash);
            RefNode head = localReferences[index];
            return this.findInChain(head, element, hash);
        }

        private int getIndex(Object refs, int hash) {
            return hash & ScalaRunTime$.MODULE$.array_length(refs) - 1;
        }

        private RefNode<V> findInChain(RefNode<V> headReference, V element, int hash) {
            for (RefNode currentReference = headReference; currentReference != null; currentReference = currentReference.nextRefNode()) {
                Object value = currentReference.get();
                if (value == null || currentReference.hash() != hash || !BoxesRunTime.equals(value, element)) continue;
                return currentReference;
            }
            return null;
        }

        public boolean update(int hash, V element, UpdateOperation operation, Seq<AccessOption> accessOptions) {
            boolean bl;
            boolean resize = accessOptions.contains((Object)ConcurrentWeakHashSet$AccessOption$Resize$.MODULE$);
            if (accessOptions.contains((Object)ConcurrentWeakHashSet$AccessOption$RestructureBefore$.MODULE$)) {
                this.restructureIfNecessary(resize);
            }
            if (accessOptions.contains((Object)ConcurrentWeakHashSet$AccessOption$SkipIfEmpty$.MODULE$) && this.counter.get() == 0) {
                return this.handleOperation(operation, element, hash, this.handleOperation$default$4(), this.handleOperation$default$5(), this.handleOperation$default$6());
            }
            this.lock();
            try {
                int index = this.getIndex(this.references(), hash);
                RefNode head = this.references()[index];
                RefNode matchedRef = this.findInChain(head, element, hash);
                bl = this.handleOperation(operation, element, hash, matchedRef, head, index);
            }
            finally {
                this.unlock();
                if (accessOptions.contains((Object)ConcurrentWeakHashSet$AccessOption$RestructureAfter$.MODULE$)) {
                    this.restructureIfNecessary(resize);
                }
            }
            return bl;
        }

        private boolean handleOperation(UpdateOperation operation, V element, int hash, RefNode<V> matchedRef, RefNode<V> head, int index) {
            UpdateOperation updateOperation = operation;
            if (ConcurrentWeakHashSet$UpdateOperation$None$.MODULE$.equals(updateOperation)) {
                return false;
            }
            if (ConcurrentWeakHashSet$UpdateOperation$AddElement$.MODULE$.equals(updateOperation)) {
                if (matchedRef == null) {
                    RefNode newRef = new RefNode(element, hash, true, this.queue, head);
                    this.references()[index] = newRef;
                    this.counter.incrementAndGet();
                    return true;
                }
                return false;
            }
            if (ConcurrentWeakHashSet$UpdateOperation$RemoveElement$.MODULE$.equals(updateOperation)) {
                if (matchedRef != null) {
                    RefNode previousRef = null;
                    RefNode currentRef = head;
                    while (currentRef != null) {
                        RefNode refNode = currentRef;
                        RefNode refNode2 = matchedRef;
                        if (!(refNode != null ? !refNode.equals(refNode2) : refNode2 != null)) {
                            if (previousRef == null) {
                                this.references()[index] = currentRef.nextRefNode();
                            } else {
                                previousRef.nextRefNode_$eq(currentRef.nextRefNode());
                            }
                            this.counter.decrementAndGet();
                            currentRef = null;
                            continue;
                        }
                        previousRef = currentRef;
                        currentRef = currentRef.nextRefNode();
                    }
                    return true;
                }
                return false;
            }
            throw new MatchError((Object)updateOperation);
        }

        private RefNode<V> handleOperation$default$4() {
            return null;
        }

        private RefNode<V> handleOperation$default$5() {
            return null;
        }

        private int handleOperation$default$6() {
            return -1;
        }

        public void restructureIfNecessary(boolean allowResize) {
            int currentCount = this.counter.get();
            boolean needsResize = allowResize && currentCount > 0 && currentCount >= this.resizeThreshold();
            RefNode ref = (RefNode)this.queue.poll();
            if (ref != null || needsResize) {
                this.restructure(allowResize, ref);
                return;
            }
        }

        private void restructure(boolean allowResize, RefNode<V> polledRef) {
            this.lock();
            try {
                boolean resizing;
                int purgeSize = 0;
                RefNode refToPurge = polledRef;
                while (refToPurge != null) {
                    if (!refToPurge.active()) continue;
                    ++purgeSize;
                    refToPurge.active_$eq(false);
                    refToPurge = (RefNode)this.queue.poll();
                }
                int countAfterRestructure = this.counter.get() - purgeSize;
                boolean needsResize = countAfterRestructure > 0 && countAfterRestructure >= this.resizeThreshold();
                int restructureSize = this.references().length;
                boolean bl = resizing = allowResize && needsResize && restructureSize < ConcurrentWeakHashSet$.MODULE$.MaxSegmentSize();
                if (resizing) {
                    restructureSize <<= 1;
                }
                RefNode[] restructured = resizing ? new RefNode[restructureSize] : this.references();
                Object object = Predef$.MODULE$.refArrayOps((Object[])this.references());
                ArrayOps$.MODULE$.indices$extension(object).foreach((Function1)(JFunction1.mcVI.sp & Serializable)idx -> {
                    RefNode currentRef = this.references()[idx];
                    if (!resizing) {
                        restructured$1[idx] = null;
                    }
                    while (currentRef != null) {
                        if (currentRef.active() && currentRef.get() != null) {
                            int currentRefIndex = this.getIndex(restructured, currentRef.hash());
                            RefNode previousRef = restructured[currentRefIndex];
                            restructured$1[currentRefIndex] = new RefNode(currentRef.get(), currentRef.hash(), true, this.queue, previousRef);
                        }
                        currentRef = currentRef.nextRefNode();
                    }
                });
                if (resizing) {
                    this.references_$eq(restructured);
                    this.resizeThreshold_$eq((int)((float)restructured.length * this.$outer.loadFactor()));
                }
                this.counter.set(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(0), countAfterRestructure));
            }
            finally {
                this.unlock();
            }
        }

        public void clear() {
            if (this.counter.get() == 0) {
                return;
            }
            this.lock();
            try {
                this.references_$eq(new RefNode[this.initialSize]);
                this.resizeThreshold_$eq((int)((float)this.references().length * this.$outer.loadFactor()));
                this.counter.set(0);
            }
            finally {
                this.unlock();
            }
        }

        public int size() {
            return this.counter.get();
        }

        public final /* synthetic */ ConcurrentWeakHashSet zio$internal$ConcurrentWeakHashSet$Segment$$$outer() {
            return this.$outer;
        }
    }

    public static interface UpdateOperation {
        public static int ordinal(UpdateOperation updateOperation) {
            return ConcurrentWeakHashSet$UpdateOperation$.MODULE$.ordinal(updateOperation);
        }
    }
}

