/*
 * Decompiled with CFR 0.152.
 */
package zio;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import zio.Ref$;
import zio.Ref$Synchronized$;
import zio.Unsafe;
import zio.Unsafe$;
import zio.ZIO;
import zio.ZIO$;

public abstract class Ref<A>
implements Serializable {
    public static <A> ZIO<Object, Nothing$, Ref<A>> make(Function0<A> function0, Object object) {
        return Ref$.MODULE$.make(function0, object);
    }

    public abstract ZIO<Object, Nothing$, A> get(Object var1);

    public abstract <B> ZIO<Object, Nothing$, B> modify(Function1<A, Tuple2<B, A>> var1, Object var2);

    public abstract ZIO<Object, Nothing$, BoxedUnit> set(A var1, Object var2);

    public abstract ZIO<Object, Nothing$, BoxedUnit> setAsync(A var1, Object var2);

    public ZIO<Object, Nothing$, A> getAndSet(A a, Object trace) {
        return this.modify((Function1 & Serializable)v -> Tuple2$.MODULE$.apply(v, a), trace);
    }

    public ZIO<Object, Nothing$, A> getAndUpdate(Function1<A, A> f, Object trace) {
        return this.modify((Function1 & Serializable)v -> Tuple2$.MODULE$.apply(v, f.apply(v)), trace);
    }

    public ZIO<Object, Nothing$, A> getAndUpdateSome(PartialFunction<A, A> pf, Object trace) {
        return this.modify((Function1 & Serializable)v -> {
            Object result = pf.applyOrElse(v, (Function1 & Serializable)x -> Predef$.MODULE$.identity(x));
            return Tuple2$.MODULE$.apply(v, result);
        }, trace);
    }

    public <B> ZIO<Object, Nothing$, B> modifySome(B b, PartialFunction<A, Tuple2<B, A>> pf, Object trace) {
        return this.modify((Function1 & Serializable)v -> (Tuple2)pf.applyOrElse(v, (Function1 & Serializable)_$1 -> Tuple2$.MODULE$.apply(b, v)), trace);
    }

    public ZIO<Object, Nothing$, BoxedUnit> update(Function1<A, A> f, Object trace) {
        return this.modify((Function1 & Serializable)v -> Tuple2$.MODULE$.apply((Object)BoxedUnit.UNIT, f.apply(v)), trace);
    }

    public ZIO<Object, Nothing$, A> updateAndGet(Function1<A, A> f, Object trace) {
        return this.modify((Function1 & Serializable)v -> {
            Object result = f.apply(v);
            return Tuple2$.MODULE$.apply(result, result);
        }, trace);
    }

    public ZIO<Object, Nothing$, BoxedUnit> updateSome(PartialFunction<A, A> pf, Object trace) {
        return this.modify((Function1 & Serializable)v -> {
            Object result = pf.applyOrElse(v, (Function1 & Serializable)x -> Predef$.MODULE$.identity(x));
            return Tuple2$.MODULE$.apply((Object)BoxedUnit.UNIT, result);
        }, trace);
    }

    public ZIO<Object, Nothing$, A> updateSomeAndGet(PartialFunction<A, A> pf, Object trace) {
        return this.modify((Function1 & Serializable)v -> {
            Object result = pf.applyOrElse(v, (Function1 & Serializable)x -> Predef$.MODULE$.identity(x));
            return Tuple2$.MODULE$.apply(result, result);
        }, trace);
    }

    public final ZIO<Object, Nothing$, A> getAndIncrement(Numeric<A> num, Object trace) {
        return this.getAndUpdate((Function1 & Serializable)v -> num.plus(v, num.one()), trace);
    }

    public final ZIO<Object, Nothing$, A> getAndDecrement(Numeric<A> num, Object trace) {
        return this.getAndUpdate((Function1 & Serializable)v -> num.minus(v, num.one()), trace);
    }

    public final ZIO<Object, Nothing$, A> getAndAdd(A delta, Numeric<A> num, Object trace) {
        return this.getAndUpdate((Function1 & Serializable)v -> num.plus(v, delta), trace);
    }

    public final ZIO<Object, Nothing$, A> incrementAndGet(Numeric<A> num, Object trace) {
        return this.updateAndGet((Function1 & Serializable)v -> num.plus(v, num.one()), trace);
    }

    public final ZIO<Object, Nothing$, A> decrementAndGet(Numeric<A> num, Object trace) {
        return this.updateAndGet((Function1 & Serializable)v -> num.minus(v, num.one()), trace);
    }

    public final ZIO<Object, Nothing$, A> addAndGet(A delta, Numeric<A> num, Object trace) {
        return this.updateAndGet((Function1 & Serializable)v -> num.plus(v, delta), trace);
    }

    public static final class Atomic<A>
    extends Ref<A> {
        public final A zio$Ref$Atomic$$initial;
        private final UnsafeAPI unsafe;

        public Atomic(A initial) {
            this.zio$Ref$Atomic$$initial = initial;
            this.unsafe = new UnsafeAPI(this){
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    super($outer.zio$Ref$Atomic$$initial);
                }

                public Object get(Unsafe unsafe2) {
                    return this.get();
                }

                public Object getAndSet(Object a, Unsafe unsafe2) {
                    return this.getAndSet(a);
                }

                public Object getAndUpdate(Function1 f, Unsafe unsafe2) {
                    return this.getAndUpdate(arg_0 -> Ref$.zio$Ref$Atomic$$anon$2$$_$getAndUpdate$$anonfun$2(f, arg_0));
                }

                public Object getAndUpdateSome(PartialFunction pf, Unsafe unsafe2) {
                    return this.getAndUpdate(arg_0 -> Ref$.zio$Ref$Atomic$$anon$2$$_$getAndUpdateSome$$anonfun$2(pf, arg_0));
                }

                public Object modify(Function1 f, Unsafe unsafe2) {
                    boolean loop = true;
                    Object b = null;
                    while (loop) {
                        V current = this.get();
                        Tuple2 tuple = (Tuple2)f.apply(current);
                        b = tuple._1();
                        loop = !this.compareAndSet(current, tuple._2());
                    }
                    return b;
                }

                public Object modifySome(Object object, PartialFunction pf, Unsafe unsafe2) {
                    boolean loop = true;
                    Object b = null;
                    while (loop) {
                        V current = this.get();
                        Tuple2 tuple = (Tuple2)pf.applyOrElse(current, arg_0 -> Ref$.zio$Ref$Atomic$$anon$2$$_$_$$anonfun$4(object, current, arg_0));
                        b = tuple._1();
                        loop = !this.compareAndSet(current, tuple._2());
                    }
                    return b;
                }

                public void set(Object a, Unsafe unsafe2) {
                    this.set(a);
                }

                public void setAsync(Object a, Unsafe unsafe2) {
                    this.lazySet(a);
                }

                public void update(Function1 f, Unsafe unsafe2) {
                    this.updateAndGet(arg_0 -> Ref$.zio$Ref$Atomic$$anon$2$$_$update$$anonfun$2(f, arg_0));
                }

                public Object updateAndGet(Function1 f, Unsafe unsafe2) {
                    return this.updateAndGet(arg_0 -> Ref$.zio$Ref$Atomic$$anon$2$$_$updateAndGet$$anonfun$2(f, arg_0));
                }

                public void updateSome(PartialFunction pf, Unsafe unsafe2) {
                    this.updateAndGet(arg_0 -> Ref$.zio$Ref$Atomic$$anon$2$$_$updateSome$$anonfun$2(pf, arg_0));
                }

                public Object updateSomeAndGet(PartialFunction pf, Unsafe unsafe2) {
                    return this.updateAndGet(arg_0 -> Ref$.zio$Ref$Atomic$$anon$2$$_$updateSomeAndGet$$anonfun$2(pf, arg_0));
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{zio$Ref$Atomic$$anon$2$$_$_$$anonfun$4(java.lang.Object java.lang.Object java.lang.Object )}, serializedLambda);
                }
            };
        }

        @Override
        public ZIO<Object, Nothing$, A> get(Object trace) {
            ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
            return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply(trace, (Function0 & Serializable)() -> {
                Unsafe$ unsafe$ = Unsafe$.MODULE$;
                return this.unsafe().get(Unsafe$.MODULE$);
            });
        }

        @Override
        public ZIO<Object, Nothing$, A> getAndSet(A a, Object trace) {
            ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
            return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply(trace, (Function0 & Serializable)() -> {
                Unsafe$ unsafe$ = Unsafe$.MODULE$;
                return this.unsafe().getAndSet(a, Unsafe$.MODULE$);
            });
        }

        @Override
        public ZIO<Object, Nothing$, A> getAndUpdate(Function1<A, A> f, Object trace) {
            ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
            return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply(trace, (Function0 & Serializable)() -> {
                Unsafe$ unsafe$ = Unsafe$.MODULE$;
                return this.unsafe().getAndUpdate(f, Unsafe$.MODULE$);
            });
        }

        @Override
        public ZIO<Object, Nothing$, A> getAndUpdateSome(PartialFunction<A, A> pf, Object trace) {
            ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
            return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply(trace, (Function0 & Serializable)() -> {
                Unsafe$ unsafe$ = Unsafe$.MODULE$;
                return this.unsafe().getAndUpdateSome(pf, Unsafe$.MODULE$);
            });
        }

        @Override
        public <B> ZIO<Object, Nothing$, B> modify(Function1<A, Tuple2<B, A>> f, Object trace) {
            ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
            return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply(trace, (Function0 & Serializable)() -> {
                Unsafe$ unsafe$ = Unsafe$.MODULE$;
                return this.unsafe().modify(f, Unsafe$.MODULE$);
            });
        }

        @Override
        public <B> ZIO<Object, Nothing$, B> modifySome(B b, PartialFunction<A, Tuple2<B, A>> pf, Object trace) {
            ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
            return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply(trace, (Function0 & Serializable)() -> {
                Unsafe$ unsafe$ = Unsafe$.MODULE$;
                return this.unsafe().modifySome(b, pf, Unsafe$.MODULE$);
            });
        }

        @Override
        public ZIO<Object, Nothing$, BoxedUnit> set(A a, Object trace) {
            ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
            return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply(trace, (JFunction0.mcV.sp & Serializable)() -> {
                Unsafe$ unsafe$ = Unsafe$.MODULE$;
                this.unsafe().set(a, Unsafe$.MODULE$);
            });
        }

        @Override
        public ZIO<Object, Nothing$, BoxedUnit> setAsync(A a, Object trace) {
            ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
            return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply(trace, (JFunction0.mcV.sp & Serializable)() -> {
                Unsafe$ unsafe$ = Unsafe$.MODULE$;
                this.unsafe().setAsync(a, Unsafe$.MODULE$);
            });
        }

        @Override
        public ZIO<Object, Nothing$, BoxedUnit> update(Function1<A, A> f, Object trace) {
            ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
            return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply(trace, (JFunction0.mcV.sp & Serializable)() -> {
                Unsafe$ unsafe$ = Unsafe$.MODULE$;
                this.unsafe().update(f, Unsafe$.MODULE$);
            });
        }

        @Override
        public ZIO<Object, Nothing$, A> updateAndGet(Function1<A, A> f, Object trace) {
            ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
            return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply(trace, (Function0 & Serializable)() -> {
                Unsafe$ unsafe$ = Unsafe$.MODULE$;
                return this.unsafe().updateAndGet(f, Unsafe$.MODULE$);
            });
        }

        @Override
        public ZIO<Object, Nothing$, BoxedUnit> updateSome(PartialFunction<A, A> pf, Object trace) {
            ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
            return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply(trace, (JFunction0.mcV.sp & Serializable)() -> {
                Unsafe$ unsafe$ = Unsafe$.MODULE$;
                this.unsafe().updateSome(pf, Unsafe$.MODULE$);
            });
        }

        @Override
        public ZIO<Object, Nothing$, A> updateSomeAndGet(PartialFunction<A, A> pf, Object trace) {
            ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
            return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply(trace, (Function0 & Serializable)() -> {
                Unsafe$ unsafe$ = Unsafe$.MODULE$;
                return this.unsafe().updateSomeAndGet(pf, Unsafe$.MODULE$);
            });
        }

        public String toString() {
            return "Ref.Atomic(initial = " + this.zio$Ref$Atomic$$initial + ")";
        }

        public UnsafeAPI unsafe() {
            return this.unsafe;
        }

        public AtomicReference<A> value() {
            return (AtomicReference)((Object)this.unsafe());
        }

        public interface UnsafeAPI
        extends Serializable {
            public A get(Unsafe var1);

            public A getAndSet(A var1, Unsafe var2);

            public A getAndUpdate(Function1<A, A> var1, Unsafe var2);

            public A getAndUpdateSome(PartialFunction<A, A> var1, Unsafe var2);

            public <B> B modify(Function1<A, Tuple2<B, A>> var1, Unsafe var2);

            public <B> B modifySome(B var1, PartialFunction<A, Tuple2<B, A>> var2, Unsafe var3);

            public void set(A var1, Unsafe var2);

            public void setAsync(A var1, Unsafe var2);

            public void update(Function1<A, A> var1, Unsafe var2);

            public A updateAndGet(Function1<A, A> var1, Unsafe var2);

            public void updateSome(PartialFunction<A, A> var1, Unsafe var2);

            public A updateSomeAndGet(PartialFunction<A, A> var1, Unsafe var2);
        }
    }

    public static abstract class Synchronized<A>
    extends Ref<A> {
        public static <A> ZIO<Object, Nothing$, Synchronized<A>> make(Function0<A> function0, Object object) {
            return Ref$Synchronized$.MODULE$.make(function0, object);
        }

        @Override
        public abstract ZIO<Object, Nothing$, A> get(Object var1);

        public abstract <R, E, B> ZIO<R, E, B> modifyZIO(Function1<A, ZIO<R, E, Tuple2<B, A>>> var1, Object var2);

        @Override
        public abstract ZIO<Object, Nothing$, BoxedUnit> set(A var1, Object var2);

        @Override
        public abstract ZIO<Object, Nothing$, BoxedUnit> setAsync(A var1, Object var2);

        public <R, E> ZIO<R, E, A> getAndUpdateZIO(Function1<A, ZIO<R, E, A>> f, Object trace) {
            return this.modifyZIO(arg_0 -> Ref$.zio$Ref$Synchronized$$_$getAndUpdateZIO$$anonfun$1(f, trace, arg_0), trace);
        }

        public <R, E> ZIO<R, E, A> getAndUpdateSomeZIO(PartialFunction<A, ZIO<R, E, A>> pf, Object trace) {
            return this.modifyZIO(arg_0 -> Ref$.zio$Ref$Synchronized$$_$getAndUpdateSomeZIO$$anonfun$1(pf, trace, arg_0), trace);
        }

        @Override
        public final <B> ZIO<Object, Nothing$, B> modify(Function1<A, Tuple2<B, A>> f, Object trace) {
            return this.modifyZIO(arg_0 -> Ref$.zio$Ref$Synchronized$$_$modify$$anonfun$1(trace, f, arg_0), trace);
        }

        public <R, E, B> ZIO<R, E, B> modifySomeZIO(B b, PartialFunction<A, ZIO<R, E, Tuple2<B, A>>> pf, Object trace) {
            return this.modifyZIO(arg_0 -> Ref$.zio$Ref$Synchronized$$_$modifySomeZIO$$anonfun$1(pf, trace, b, arg_0), trace);
        }

        public <R, E> ZIO<R, E, BoxedUnit> updateZIO(Function1<A, ZIO<R, E, A>> f, Object trace) {
            return this.modifyZIO(arg_0 -> Ref$.zio$Ref$Synchronized$$_$updateZIO$$anonfun$1(f, trace, arg_0), trace);
        }

        public <R, E> ZIO<R, E, A> updateAndGetZIO(Function1<A, ZIO<R, E, A>> f, Object trace) {
            return this.modifyZIO(arg_0 -> Ref$.zio$Ref$Synchronized$$_$updateAndGetZIO$$anonfun$1(f, trace, arg_0), trace);
        }

        public <R, E> ZIO<R, E, BoxedUnit> updateSomeZIO(PartialFunction<A, ZIO<R, E, A>> pf, Object trace) {
            return this.modifyZIO(arg_0 -> Ref$.zio$Ref$Synchronized$$_$updateSomeZIO$$anonfun$1(pf, trace, arg_0), trace);
        }

        public <R, E> ZIO<R, E, A> updateSomeAndGetZIO(PartialFunction<A, ZIO<R, E, A>> pf, Object trace) {
            return this.modifyZIO(arg_0 -> Ref$.zio$Ref$Synchronized$$_$updateSomeAndGetZIO$$anonfun$1(pf, trace, arg_0), trace);
        }
    }
}

