/*
 * Decompiled with CFR 0.152.
 */
package zio.internal;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import zio.internal.OneShot$;

public final class OneShot<A>
extends ReentrantLock {
    private volatile A value = null;
    private final Condition isSetCondition = this.newCondition();

    public static <A> OneShot<A> make() {
        return OneShot$.MODULE$.make();
    }

    public OneShot() {
        super(false);
    }

    public void set(A v) {
        if (v == null) {
            throw new Error("Defect: OneShot variable cannot be set to null value");
        }
        this.lock();
        try {
            if (this.value != null) {
                throw new Error("Defect: OneShot variable being set twice");
            }
            this.value = v;
            this.isSetCondition.signalAll();
        }
        finally {
            this.unlock();
        }
    }

    public boolean isSet() {
        return this.value != null;
    }

    public A get(long timeout) {
        if (this.value != null) {
            return this.value;
        }
        this.lock();
        try {
            if (this.value == null) {
                this.isSetCondition.await(timeout, TimeUnit.MILLISECONDS);
            }
        }
        finally {
            this.unlock();
        }
        if (this.value == null) {
            throw new Error("Timed out waiting for variable to be set");
        }
        return this.value;
    }

    public A get() {
        if (this.value != null) {
            return this.value;
        }
        this.lock();
        try {
            while (this.value == null) {
                this.isSetCondition.await();
            }
        }
        finally {
            this.unlock();
        }
        return this.value;
    }
}

