/*
 * Decompiled with CFR 0.152.
 */
package zio.internal;

import java.io.Serializable;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import zio.Fiber;
import zio.Fiber$Status$Done$;
import zio.Fiber$Status$Running$;
import zio.Fiber$Status$Suspended$;
import zio.FiberId;
import zio.FiberId$None$;
import zio.RuntimeFlags$;
import zio.Trace$;
import zio.Unsafe$;
import zio.ZIO;
import zio.ZIO$;

public final class FiberRenderer$
implements Serializable {
    public static final FiberRenderer$ MODULE$ = new FiberRenderer$();

    private FiberRenderer$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(FiberRenderer$.class);
    }

    public ZIO<Object, Nothing$, String> prettyPrint(Fiber.Dump dump, Object trace) {
        ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
        return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply(trace, (Function0 & Serializable)() -> {
            Unsafe$ unsafe$ = Unsafe$.MODULE$;
            return MODULE$.unsafePrettyPrint(dump, System.currentTimeMillis());
        });
    }

    private String unsafePrettyPrint(Fiber.Dump dump, long now) {
        Object object;
        long totalMillis = now - dump.fiberId().startTimeMillis();
        long millis = totalMillis % 1000L;
        long seconds = totalMillis / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        String name = "\"" + dump.fiberId().threadName() + "\"";
        String lifeMsg = (String)(hours == 0L ? "" : hours + "h ") + (String)(hours == 0L && minutes == 0L ? "" : minutes + "m ") + (String)(hours == 0L && minutes == 0L && seconds == 0L ? "" : seconds + "s ") + (millis + "ms");
        Fiber.Status status = dump.status();
        if (status instanceof Fiber.Status.Suspended) {
            Fiber.Status.Suspended suspended = Fiber$Status$Suspended$.MODULE$.unapply((Fiber.Status.Suspended)status);
            int n = suspended._1();
            Object object2 = suspended._2();
            FiberId fiberId = suspended._3();
            FiberId blockingOn = fiberId;
            object = blockingOn != FiberId$None$.MODULE$ ? "waiting on " + ("#" + blockingOn.ids().mkString(", ")) : "";
        } else {
            object = "";
        }
        String waitMsg = object;
        String statMsg = this.renderStatus(dump.status());
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       |" + name + " (" + lifeMsg + ") " + waitMsg + "\n       |\tStatus: " + statMsg + "\n       |" + dump.trace().prettyPrint() + "\n       |"));
    }

    private String renderFlags(int runtimeFlags) {
        return RuntimeFlags$.MODULE$.toSet(runtimeFlags).mkString("(", ", ", ")");
    }

    private String renderTrace(Object trace) {
        if (BoxesRunTime.equals((Object)trace, (Object)Trace$.MODULE$.empty())) {
            return "<no trace>";
        }
        return trace.toString();
    }

    private String renderStatus(Fiber.Status status) {
        Fiber.Status status2 = status;
        if (Fiber$Status$Done$.MODULE$.equals(status2)) {
            return "Done";
        }
        if (status2 instanceof Fiber.Status.Running) {
            Fiber.Status.Running running = Fiber$Status$Running$.MODULE$.unapply((Fiber.Status.Running)status2);
            int n = running._1();
            Object object = running._2();
            int runtimeFlags = n;
            Object trace0 = object;
            String flags = this.renderFlags(runtimeFlags);
            String trace = this.renderTrace(trace0);
            return "Running(" + flags + ", " + trace + ")";
        }
        if (status2 instanceof Fiber.Status.Suspended) {
            Fiber.Status.Suspended suspended = Fiber$Status$Suspended$.MODULE$.unapply((Fiber.Status.Suspended)status2);
            int n = suspended._1();
            Object object = suspended._2();
            FiberId fiberId = suspended._3();
            int runtimeFlags = n;
            Object trace0 = object;
            FiberId blockingOn = fiberId;
            String flags = this.renderFlags(runtimeFlags);
            String trace = this.renderTrace(trace0);
            return "Suspended(" + flags + ", " + trace + ")";
        }
        throw new MatchError((Object)status2);
    }
}

