/*
 * Decompiled with CFR 0.152.
 */
package zio.internal;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import scala.Array$;
import scala.Function1;
import scala.Int$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import zio.Chunk;
import zio.Executor;
import zio.Trace$;
import zio.Unsafe;
import zio.internal.Blocking$;
import zio.internal.ExecutionMetrics;
import zio.internal.FiberRunnable;
import zio.internal.PartitionedLinkedQueue;
import zio.internal.RingBufferPow2;
import zio.internal.RingBufferPow2$;
import zio.internal.ZScheduler;
import zio.internal.ZScheduler$;
import zio.internal.ZScheduler$Locations$Disabled$;
import zio.internal.ZScheduler$Locations$Enabled$;

public final class ZScheduler
extends Executor {
    private final boolean autoBlocking;
    public final PartitionedLinkedQueue<Runnable> zio$internal$ZScheduler$$globalQueue;
    public final ConcurrentLinkedQueue<Worker> zio$internal$ZScheduler$$cache;
    public final ConcurrentLinkedQueue<Worker> zio$internal$ZScheduler$$idle;
    public final Locations zio$internal$ZScheduler$$globalLocations;
    public final AtomicInteger zio$internal$ZScheduler$$state;
    public final Worker[] zio$internal$ZScheduler$$workers;
    public volatile Set<Object> zio$internal$ZScheduler$$blockingLocations;

    public static void markCurrentWorkerAsBlocking() {
        ZScheduler$.MODULE$.markCurrentWorkerAsBlocking();
    }

    public ZScheduler(boolean autoBlocking) {
        this.autoBlocking = autoBlocking;
        this.zio$internal$ZScheduler$$globalQueue = new PartitionedLinkedQueue(ZScheduler$.zio$internal$ZScheduler$$$poolSize * 4);
        this.zio$internal$ZScheduler$$cache = new ConcurrentLinkedQueue();
        this.zio$internal$ZScheduler$$idle = new ConcurrentLinkedQueue();
        this.zio$internal$ZScheduler$$globalLocations = this.zio$internal$ZScheduler$$makeLocations();
        this.zio$internal$ZScheduler$$state = new AtomicInteger(ZScheduler$.zio$internal$ZScheduler$$$poolSize << 16);
        this.zio$internal$ZScheduler$$workers = new Worker[ZScheduler$.zio$internal$ZScheduler$$$poolSize];
        this.zio$internal$ZScheduler$$blockingLocations = Predef$.MODULE$.Set().empty();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), ZScheduler$.zio$internal$ZScheduler$$$poolSize).foreach((Function1)(JFunction1.mcVI.sp & Serializable)workerId -> {
            Worker worker = this.zio$internal$ZScheduler$$makeWorker();
            worker.setName(workerId);
            worker.setDaemon(true);
            this.zio$internal$ZScheduler$$workers[workerId] = worker;
        });
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.zio$internal$ZScheduler$$workers);
        ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)_$1 -> _$1.start());
        if (autoBlocking) {
            Supervisor supervisor = this.makeSupervisor();
            supervisor.setName("ZScheduler-Supervisor");
            supervisor.setDaemon(true);
            supervisor.start();
        }
    }

    @Override
    public Option<ExecutionMetrics> metrics(Unsafe unsafe2) {
        ExecutionMetrics metrics = new ExecutionMetrics(this){
            private final /* synthetic */ ZScheduler $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public int capacity() {
                return Integer.MAX_VALUE;
            }

            public int concurrency() {
                return ZScheduler$.zio$internal$ZScheduler$$$poolSize;
            }

            public long dequeuedCount() {
                long dequeued = 0L;
                for (int i = 0; i != ZScheduler$.zio$internal$ZScheduler$$$poolSize; ++i) {
                    Worker worker = this.$outer.zio$internal$ZScheduler$$workers[i];
                    dequeued += worker.opCount();
                }
                return dequeued;
            }

            public long enqueuedCount() {
                long enqueued = 0L;
                for (int i = 0; i != ZScheduler$.zio$internal$ZScheduler$$$poolSize; ++i) {
                    Worker worker = this.$outer.zio$internal$ZScheduler$$workers[i];
                    enqueued += worker.opCount();
                    enqueued += (long)worker.localQueue().size();
                    if (worker.nextRunnable() == null) continue;
                    ++enqueued;
                }
                return enqueued += (long)this.$outer.zio$internal$ZScheduler$$globalQueue.size();
            }

            public int size() {
                int size = 0;
                for (int i = 0; i != ZScheduler$.zio$internal$ZScheduler$$$poolSize; ++i) {
                    Worker worker = this.$outer.zio$internal$ZScheduler$$workers[i];
                    size += worker.localQueue().size();
                    if (worker.nextRunnable() == null) continue;
                    ++size;
                }
                return size += this.$outer.zio$internal$ZScheduler$$globalQueue.size();
            }

            public int workersCount() {
                int currentState = this.$outer.zio$internal$ZScheduler$$state.get();
                return (currentState & 0xFFFF0000) >> 16;
            }
        };
        return Some$.MODULE$.apply((Object)metrics);
    }

    @Override
    public boolean stealWork(int depth) {
        Worker worker = ZScheduler$.MODULE$.zio$internal$ZScheduler$$$workerOrNull();
        if (worker != null) {
            Runnable runnable = null;
            if (worker.nextRunnable() != null) {
                runnable = worker.nextRunnable();
                worker.nextRunnable_$eq(null);
            } else {
                runnable = worker.localQueue().poll(null);
                if (runnable == null) {
                    runnable = this.zio$internal$ZScheduler$$globalQueue.poll();
                }
            }
            if (runnable != null) {
                if (runnable instanceof FiberRunnable) {
                    FiberRunnable fiberRunnable = (FiberRunnable)runnable;
                    worker.currentRunnable_$eq(fiberRunnable);
                    fiberRunnable.run(depth);
                } else {
                    runnable.run();
                }
                return true;
            }
            worker.nextRunnable_$eq(runnable);
            return false;
        }
        return false;
    }

    @Override
    public boolean submit(Runnable runnable, Unsafe unsafe2) {
        Boolean bl;
        Worker worker = ZScheduler$.MODULE$.zio$internal$ZScheduler$$$workerOrNull();
        if (this.isBlocking(worker, runnable)) {
            return this.submitBlocking(runnable, unsafe2);
        }
        if (worker == null || worker.blocking()) {
            bl = BoxesRunTime.boxToBoolean((boolean)this.zio$internal$ZScheduler$$globalQueue.offer(runnable));
        } else if (!worker.localQueue().offer(runnable)) {
            this.handleFullWorkerQueue(worker, runnable);
            bl = BoxedUnit.UNIT;
        } else {
            bl = BoxedUnit.UNIT;
        }
        int currentState = this.zio$internal$ZScheduler$$state.get();
        this.zio$internal$ZScheduler$$maybeUnparkWorker(currentState);
        return true;
    }

    @Override
    public boolean submitAndYield(Runnable runnable, Unsafe unsafe2) {
        Worker worker = ZScheduler$.MODULE$.zio$internal$ZScheduler$$$workerOrNull();
        if (this.isBlocking(worker, runnable)) {
            return this.submitBlocking(runnable, unsafe2);
        }
        boolean notify = false;
        if (worker == null || worker.blocking()) {
            this.zio$internal$ZScheduler$$globalQueue.offer(runnable);
            notify = true;
        } else if (worker.nextRunnable() == null && worker.localQueue().isEmpty()) {
            worker.nextRunnable_$eq(runnable);
        } else if (worker.localQueue().offer(runnable)) {
            notify = true;
        } else {
            this.handleFullWorkerQueue(worker, runnable);
            notify = true;
        }
        if (notify) {
            int currentState = this.zio$internal$ZScheduler$$state.get();
            this.zio$internal$ZScheduler$$maybeUnparkWorker(currentState);
        }
        return true;
    }

    private void handleFullWorkerQueue(Worker worker, Runnable runnable) {
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        Chunk polled = worker.localQueue().pollUpTo(128);
        this.zio$internal$ZScheduler$$globalQueue.offerAll(polled, rnd);
        boolean accepted = worker.localQueue().offer(runnable);
        if (!accepted) {
            this.zio$internal$ZScheduler$$globalQueue.offer(runnable, rnd);
            return;
        }
    }

    private boolean isBlocking(Worker worker, Runnable runnable) {
        if (this.autoBlocking && runnable instanceof FiberRunnable) {
            FiberRunnable fiberRunnable = (FiberRunnable)runnable;
            Object location = fiberRunnable.location();
            if (location != null && location != Trace$.MODULE$.empty()) {
                long l = worker == null ? this.zio$internal$ZScheduler$$globalLocations.put(location) : worker.submittedLocations().put(location);
                return this.zio$internal$ZScheduler$$blockingLocations.contains(location);
            }
            return false;
        }
        return false;
    }

    public Locations zio$internal$ZScheduler$$makeLocations() {
        if (this.autoBlocking) {
            return new Locations.Enabled(ZScheduler$Locations$Enabled$.MODULE$.$lessinit$greater$default$1());
        }
        return ZScheduler$Locations$Disabled$.MODULE$;
    }

    private Supervisor makeSupervisor() {
        return new Supervisor(this){
            private final /* synthetic */ ZScheduler $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            private long countSubmittedAt(Object location) {
                long count = this.$outer.zio$internal$ZScheduler$$globalLocations.get(location);
                for (int i = 0; i < ZScheduler$.zio$internal$ZScheduler$$$poolSize; ++i) {
                    long workerCount = this.$outer.zio$internal$ZScheduler$$workers[i].submittedLocations().get(location);
                    count += workerCount;
                }
                return count;
            }

            public void run() {
                Locations identifiedLocations = this.$outer.zio$internal$ZScheduler$$makeLocations();
                long[] previousOpCounts = (long[])Array$.MODULE$.fill(ZScheduler$.zio$internal$ZScheduler$$$poolSize, ZScheduler::zio$internal$ZScheduler$$anon$2$$_$_$$anonfun$1, ClassTag$.MODULE$.apply(Long.TYPE));
                while (!this.isInterrupted()) {
                    for (int workerId = 0; workerId < ZScheduler$.zio$internal$ZScheduler$$$poolSize; ++workerId) {
                        Worker currentWorker = this.$outer.zio$internal$ZScheduler$$workers[workerId];
                        if (currentWorker.active()) {
                            long previousOpCount;
                            long currentOpCount = currentWorker.opCount();
                            if (currentOpCount == (previousOpCount = previousOpCounts[workerId])) {
                                FiberRunnable fiberRunnable;
                                Object location;
                                Runnable currentRunnable = currentWorker.currentRunnable();
                                if (currentRunnable instanceof FiberRunnable && (location = (fiberRunnable = (FiberRunnable)currentRunnable).location()) != Trace$.MODULE$.empty()) {
                                    long identifiedCount = identifiedLocations.put(location);
                                    long submittedCount = this.countSubmittedAt(location);
                                    if (submittedCount > 64L && identifiedCount >= submittedCount / 2L) {
                                        this.$outer.zio$internal$ZScheduler$$blockingLocations = (Set)this.$outer.zio$internal$ZScheduler$$blockingLocations.$plus(location);
                                    }
                                }
                                previousOpCounts[workerId] = -1L;
                                currentWorker.markAsBlocking();
                                continue;
                            }
                            previousOpCounts[workerId] = currentOpCount;
                            continue;
                        }
                        previousOpCounts[workerId] = -1L;
                    }
                    long deadline = System.currentTimeMillis() + 100L;
                    boolean loop = true;
                    while (loop) {
                        LockSupport.parkUntil(deadline);
                        loop = System.currentTimeMillis() < deadline;
                    }
                }
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{zio$internal$ZScheduler$$anon$2$$_$_$$anonfun$1()}, serializedLambda);
            }
        };
    }

    public Worker zio$internal$ZScheduler$$makeWorker() {
        return new Worker(this){
            private final Locations submittedLocations;
            private final /* synthetic */ ZScheduler $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.submittedLocations = $outer.zio$internal$ZScheduler$$makeLocations();
            }

            public Locations submittedLocations() {
                return this.submittedLocations;
            }

            public void run() {
                boolean currentBlocking = false;
                long currentOpCount = 0L;
                ThreadLocalRandom random = ThreadLocalRandom.current();
                Runnable runnable = null;
                boolean searching = false;
                while (!this.isInterrupted()) {
                    currentBlocking = this.blocking();
                    Runnable currentNextRunnable = this.nextRunnable();
                    if (!currentBlocking) {
                        if (currentNextRunnable != null) {
                            runnable = currentNextRunnable;
                            this.nextRunnable_$eq(null);
                        } else {
                            if ((currentOpCount & 0x3FL) == 0L) {
                                runnable = this.$outer.zio$internal$ZScheduler$$globalQueue.poll(random);
                                if (runnable == null) {
                                    runnable = this.localQueue().poll(null);
                                }
                            } else {
                                runnable = this.localQueue().poll(null);
                                if (runnable == null) {
                                    runnable = this.$outer.zio$internal$ZScheduler$$globalQueue.poll(random);
                                }
                            }
                            if (runnable == null) {
                                int currentState;
                                int currentActive;
                                if (!searching && 2 * (currentActive = (currentState = this.$outer.zio$internal$ZScheduler$$state.get()) & 0xFFFF) < ZScheduler$.zio$internal$ZScheduler$$$poolSize) {
                                    this.$outer.zio$internal$ZScheduler$$state.getAndIncrement();
                                    searching = true;
                                }
                                if (searching) {
                                    boolean loop = true;
                                    int offset = random.nextInt(ZScheduler$.zio$internal$ZScheduler$$$poolSize);
                                    for (int i = 0; i != ZScheduler$.zio$internal$ZScheduler$$$poolSize && loop; ++i) {
                                        Chunk<A> runnables;
                                        Chunk<A> runnables2;
                                        int nRunnables;
                                        int size;
                                        int index = (i + offset) % ZScheduler$.zio$internal$ZScheduler$$$poolSize;
                                        Worker worker = this.$outer.zio$internal$ZScheduler$$workers[index];
                                        if (worker == this || worker.blocking() || (size = worker.localQueue().size()) <= 0 || (nRunnables = (runnables2 = worker.localQueue().pollUpTo(size - size / 2)).size()) <= 0) continue;
                                        Iterator iter = runnables2.iterator();
                                        runnable = (Runnable)iter.next();
                                        if (nRunnables > 1) {
                                            this.localQueue().offerAll(iter, Int$.MODULE$.int2long(nRunnables - 1));
                                        }
                                        if ((currentBlocking = this.blocking()) && (runnables = this.localQueue().pollUpTo(256)).nonEmpty()) {
                                            this.$outer.zio$internal$ZScheduler$$globalQueue.offerAll(runnables, random);
                                        }
                                        loop = false;
                                    }
                                    if (runnable == null) {
                                        runnable = this.$outer.zio$internal$ZScheduler$$globalQueue.poll(random);
                                    }
                                }
                            }
                        }
                    }
                    if (runnable == null) {
                        int currentState = currentBlocking && searching ? this.$outer.zio$internal$ZScheduler$$state.decrementAndGet() : (currentBlocking ? this.$outer.zio$internal$ZScheduler$$state.get() : (searching ? this.$outer.zio$internal$ZScheduler$$state.addAndGet(-65537) : this.$outer.zio$internal$ZScheduler$$state.addAndGet(-65536)));
                        int currentSearching = currentState & 0xFFFF;
                        this.active_$eq(false);
                        boolean bl = currentBlocking ? this.$outer.zio$internal$ZScheduler$$cache.offer(this) : this.$outer.zio$internal$ZScheduler$$idle.offer(this);
                        if (currentSearching == 0 && searching) {
                            boolean notify = false;
                            for (int i = 0; i != ZScheduler$.zio$internal$ZScheduler$$$poolSize && !notify; ++i) {
                                Worker worker = this.$outer.zio$internal$ZScheduler$$workers[i];
                                notify = !worker.localQueue().isEmpty();
                            }
                            if (!notify) {
                                boolean bl2 = notify = !this.$outer.zio$internal$ZScheduler$$globalQueue.isEmpty();
                            }
                            if (notify) {
                                int currentState2 = this.$outer.zio$internal$ZScheduler$$state.get();
                                this.$outer.zio$internal$ZScheduler$$maybeUnparkWorker(currentState2);
                            }
                        }
                        while (!this.active() && !this.isInterrupted()) {
                            LockSupport.park();
                        }
                        searching = true;
                        continue;
                    }
                    if (searching) {
                        searching = false;
                        int currentState = this.$outer.zio$internal$ZScheduler$$state.decrementAndGet();
                        this.$outer.zio$internal$ZScheduler$$maybeUnparkWorker(currentState);
                    }
                    this.currentRunnable_$eq(runnable);
                    runnable.run();
                    runnable = null;
                    this.currentRunnable_$eq(runnable);
                    this.opCount_$eq(++currentOpCount);
                }
            }

            public void markAsBlocking() {
                $anon$3 var1_1 = this;
                synchronized (var1_1) {
                    BoxedUnit boxedUnit;
                    if (this.blocking()) {
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        this.blocking_$eq(true);
                        Object object = Predef$.MODULE$.refArrayOps((Object[])this.$outer.zio$internal$ZScheduler$$workers);
                        int idx = ArrayOps$.MODULE$.indexOf$extension(object, (Object)this, ArrayOps$.MODULE$.indexOf$default$2$extension(object));
                        if (idx >= 0) {
                            Chunk<A> runnables = this.localQueue().pollUpTo(256);
                            if (this.nextRunnable() != null) {
                                this.$outer.zio$internal$ZScheduler$$globalQueue.offer(this.nextRunnable());
                                this.nextRunnable_$eq(null);
                            }
                            this.$outer.zio$internal$ZScheduler$$globalQueue.offerAll(runnables);
                            Worker worker = this.$outer.zio$internal$ZScheduler$$cache.poll();
                            if (worker == null) {
                                Worker worker2 = this.$outer.zio$internal$ZScheduler$$makeWorker();
                                worker2.setName(idx);
                                worker2.setDaemon(true);
                                this.$outer.zio$internal$ZScheduler$$workers[idx] = worker2;
                                worker2.start();
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                this.$outer.zio$internal$ZScheduler$$state.getAndIncrement();
                                worker.setName(idx);
                                this.$outer.zio$internal$ZScheduler$$workers[idx] = worker;
                                worker.blocking_$eq(false);
                                worker.active_$eq(true);
                                LockSupport.unpark(worker);
                                boxedUnit = BoxedUnit.UNIT;
                            }
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    }
                }
            }
        };
    }

    public void zio$internal$ZScheduler$$maybeUnparkWorker(int currentState) {
        int currentSearching = currentState & 0xFFFF;
        int currentActive = (currentState & 0xFFFF0000) >> 16;
        if (currentActive != ZScheduler$.zio$internal$ZScheduler$$$poolSize && currentSearching == 0) {
            Worker worker = this.zio$internal$ZScheduler$$idle.poll();
            if (worker != null) {
                this.zio$internal$ZScheduler$$state.getAndAdd(65537);
                worker.active_$eq(true);
                LockSupport.unpark(worker);
                return;
            }
            return;
        }
    }

    private boolean submitBlocking(Runnable runnable, Unsafe unsafe2) {
        return Blocking$.MODULE$.blockingExecutor().submit(runnable, unsafe2);
    }

    public static final long zio$internal$ZScheduler$$anon$2$$_$_$$anonfun$1() {
        return -1L;
    }

    public static abstract class Locations {
        public abstract long get(Object var1);

        public abstract long put(Object var1);
    }

    public static abstract class Supervisor
    extends Thread {
    }

    public static abstract class Worker
    extends Thread {
        private volatile boolean active = true;
        private volatile boolean blocking = false;
        private volatile Runnable currentRunnable = null;
        private final RingBufferPow2 localQueue = RingBufferPow2$.MODULE$.apply(256);
        private Runnable nextRunnable = null;
        private volatile long opCount = 0L;

        public abstract Locations submittedLocations();

        public boolean active() {
            return this.active;
        }

        public void active_$eq(boolean x$1) {
            this.active = x$1;
        }

        public boolean blocking() {
            return this.blocking;
        }

        public void blocking_$eq(boolean x$1) {
            this.blocking = x$1;
        }

        public Runnable currentRunnable() {
            return this.currentRunnable;
        }

        public void currentRunnable_$eq(Runnable x$1) {
            this.currentRunnable = x$1;
        }

        public RingBufferPow2<Runnable> localQueue() {
            return this.localQueue;
        }

        public Runnable nextRunnable() {
            return this.nextRunnable;
        }

        public void nextRunnable_$eq(Runnable x$1) {
            this.nextRunnable = x$1;
        }

        public long opCount() {
            return this.opCount;
        }

        public void opCount_$eq(long x$1) {
            this.opCount = x$1;
        }

        public abstract void markAsBlocking();

        public final void setName(int i) {
            this.setName("ZScheduler-Worker-" + i);
        }
    }
}

